/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app.reversesave.qcrequest;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.batchaction.ActionCommonException;
import com.kingdee.eas.qm.basedata.QCBizBillTypeFactory;
import com.kingdee.eas.qm.basedata.QCBizBillTypeInfo;
import com.kingdee.eas.qm.basedata.QCBizTypeEnum;
import com.kingdee.eas.qm.basedata.QCDisManuBizEnum;
import com.kingdee.eas.qm.basedata.QCFlowManuBizEnum;
import com.kingdee.eas.qm.basedata.QCPurBizEnum;
import com.kingdee.eas.qm.common.util.QMEqualsUtils;
import com.kingdee.eas.qm.common.util.QMResourceUtils;
import com.kingdee.eas.qm.qc.QCReturnResultCollection;
import com.kingdee.eas.qm.qc.QCReturnResultInfo;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public abstract class QCRequestReverseSaveUtils {
    public static QCBizBillTypeInfo getDefaultBillType(Context ctx, QCBizTypeEnum qcBizType) throws BOSException, ActionCommonException {
        EntityViewInfo env = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("QCBizType", (Object)new Integer(qcBizType.getValue()), CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("checkedStatus", (Object)new Integer(2), CompareType.EQUALS));
        env.setFilter(filterInfo);
        CoreBaseCollection qmBillColl = QCBizBillTypeFactory.getLocalInstance((Context)ctx).getCollection(env);
        QCBizBillTypeInfo qcBillType = null;
        if (qmBillColl.size() <= 0) {
            ActionCommonException bizExp = new ActionCommonException(null);
            bizExp.setMessage(QMResourceUtils.getMessage((String)"com.kingdee.eas.qm.qc.QCRequestResource", (String)"HasnotApprovedBillType", (String[])new String[]{qcBizType.getAlias()}));
            throw bizExp;
        }
        qcBillType = (QCBizBillTypeInfo)qmBillColl.get(0);
        return qcBillType;
    }

    public static BigDecimal[] getDisManuQty(Context ctx, MaterialInfo materialInfo, MeasureUnitInfo bizmeasureUnitInfo, QCReturnResultCollection rsList) throws BOSException, EASBizException {
        BigDecimal passQty = new BigDecimal("0.00");
        BigDecimal repairQty = new BigDecimal("0.00");
        BigDecimal scrapQty = new BigDecimal("0.00");
        BigDecimal yieldQty = new BigDecimal("0.00");
        BigDecimal workScrapQty = new BigDecimal("0.00");
        BigDecimal materialQty = new BigDecimal("0.00");
        BigDecimal basepassQty = new BigDecimal("0.00");
        BigDecimal baserepairQty = new BigDecimal("0.00");
        BigDecimal basescrapQty = new BigDecimal("0.00");
        BigDecimal baseyieldQty = new BigDecimal("0.00");
        BigDecimal baseworkScrapQty = new BigDecimal("0.00");
        BigDecimal basematerialQty = new BigDecimal("0.00");
        if (rsList == null || rsList.size() <= 0) {
            throw new BOSException("Error Interface Data!!!");
        }
        HashMap cache = new HashMap();
        for (int i = 0; i < rsList.size(); ++i) {
            QCDisManuBizEnum biz;
            QCReturnResultInfo rs = rsList.get(i);
            BigDecimal qty = rs.getQty();
            MeasureUnitInfo unit = rs.getUnit();
            BigDecimal baseQty = rs.getBaseQty();
            if (baseQty == null) {
                baseQty = qty;
            }
            if (!QMEqualsUtils.equals((Object)unit, (Object)bizmeasureUnitInfo)) {
                qty = QCRequestReverseSaveUtils.getQtyByBaseQty(ctx, materialInfo, cache, bizmeasureUnitInfo, baseQty);
            }
            if ((biz = rs.getDPProcessMode().getQCDisManuBiz()) == QCDisManuBizEnum.BIZ_Qualified) {
                passQty = passQty.add(qty);
                basepassQty = basepassQty.add(baseQty);
                continue;
            }
            if (biz == QCDisManuBizEnum.BIZ_BackMakeOrBackRepair) {
                repairQty = repairQty.add(qty);
                baserepairQty = baserepairQty.add(baseQty);
                continue;
            }
            if (biz == QCDisManuBizEnum.BIZ_Unusable) {
                scrapQty = scrapQty.add(qty);
                basescrapQty = basescrapQty.add(baseQty);
                continue;
            }
            if (biz == QCDisManuBizEnum.BIZ_Back) {
                yieldQty = yieldQty.add(qty);
                baseyieldQty = baseyieldQty.add(baseQty);
                continue;
            }
            if (biz == QCDisManuBizEnum.BIZ_WorkerScrap) {
                workScrapQty = workScrapQty.add(qty);
                baseworkScrapQty = baseworkScrapQty.add(baseQty);
                continue;
            }
            if (biz != QCDisManuBizEnum.BIZ_MaterialScrap) continue;
            materialQty = materialQty.add(qty);
            basematerialQty = basematerialQty.add(baseQty);
        }
        BigDecimal[] qtyAry = new BigDecimal[12];
        int i = 0;
        qtyAry[i++] = passQty;
        qtyAry[i++] = basepassQty;
        qtyAry[i++] = repairQty;
        qtyAry[i++] = baserepairQty;
        qtyAry[i++] = scrapQty;
        qtyAry[i++] = basescrapQty;
        qtyAry[i++] = yieldQty;
        qtyAry[i++] = baseyieldQty;
        qtyAry[i++] = workScrapQty;
        qtyAry[i++] = baseworkScrapQty;
        qtyAry[i++] = materialQty;
        qtyAry[i++] = basematerialQty;
        return qtyAry;
    }

    public static BigDecimal[] getProcseesDisManuQty(Context ctx, MaterialInfo materialInfo, MeasureUnitInfo bizmeasureUnitInfo, QCReturnResultCollection rsList) throws BOSException, EASBizException {
        BigDecimal passQty = new BigDecimal("0.00");
        BigDecimal repairQty = new BigDecimal("0.00");
        BigDecimal scrapQty = new BigDecimal("0.00");
        BigDecimal reworkQty = new BigDecimal("0.00");
        BigDecimal basepassQty = new BigDecimal("0.00");
        BigDecimal baserepairQty = new BigDecimal("0.00");
        BigDecimal basereworkQty = new BigDecimal("0.00");
        BigDecimal basescrapQty = new BigDecimal("0.00");
        if (rsList == null || rsList.size() <= 0) {
            throw new BOSException("Error Interface Data!!!");
        }
        HashMap cache = new HashMap();
        for (int i = 0; i < rsList.size(); ++i) {
            QCFlowManuBizEnum biz;
            QCReturnResultInfo rs = rsList.get(i);
            BigDecimal qty = rs.getQty();
            MeasureUnitInfo unit = rs.getUnit();
            BigDecimal baseQty = rs.getBaseQty();
            if (baseQty == null) {
                baseQty = qty;
            }
            if (!QMEqualsUtils.equals((Object)unit, (Object)bizmeasureUnitInfo)) {
                qty = QCRequestReverseSaveUtils.getQtyByBaseQty(ctx, materialInfo, cache, bizmeasureUnitInfo, baseQty);
            }
            if ((biz = rs.getDPProcessMode().getQCFlowManuBiz()) == QCFlowManuBizEnum.BIZ_Qualified) {
                passQty = passQty.add(qty);
                basepassQty = basepassQty.add(baseQty);
                continue;
            }
            if (biz == QCFlowManuBizEnum.BIZ_BackRepair) {
                repairQty = repairQty.add(qty);
                baserepairQty = baserepairQty.add(baseQty);
                continue;
            }
            if (biz == QCFlowManuBizEnum.BIZ_BackMake) {
                reworkQty = reworkQty.add(qty);
                basereworkQty = basereworkQty.add(baseQty);
                continue;
            }
            if (biz != QCFlowManuBizEnum.BIZ_Unusable) continue;
            scrapQty = scrapQty.add(qty);
            basescrapQty = basescrapQty.add(baseQty);
        }
        BigDecimal[] qtyAry = new BigDecimal[8];
        int i = 0;
        qtyAry[i++] = passQty;
        qtyAry[i++] = basepassQty;
        qtyAry[i++] = scrapQty;
        qtyAry[i++] = basescrapQty;
        qtyAry[i++] = reworkQty;
        qtyAry[i++] = basereworkQty;
        qtyAry[i++] = repairQty;
        qtyAry[i++] = baserepairQty;
        return qtyAry;
    }

    public static BigDecimal[] getPurManuQty(Context ctx, MaterialInfo materialInfo, MeasureUnitInfo bizmeasureUnitInfo, QCReturnResultCollection rsList) throws BOSException, EASBizException {
        BigDecimal passQty = new BigDecimal("0.00");
        BigDecimal unPassQty = new BigDecimal("0.00");
        BigDecimal backQty = new BigDecimal("0.00");
        BigDecimal basepassQty = new BigDecimal("0.00");
        BigDecimal baseUnPassQty = new BigDecimal("0.00");
        BigDecimal basesBack = new BigDecimal("0.00");
        if (rsList == null || rsList.size() <= 0) {
            throw new BOSException("Error Interface Data!!!");
        }
        HashMap cache = new HashMap();
        for (int i = 0; i < rsList.size(); ++i) {
            QCPurBizEnum biz;
            QCReturnResultInfo rs = rsList.get(i);
            BigDecimal qty = rs.getQty();
            MeasureUnitInfo qmunit = rs.getUnit();
            BigDecimal baseQty = rs.getBaseQty();
            if (baseQty == null) {
                baseQty = qty;
            }
            if (!QMEqualsUtils.equals((Object)qmunit, (Object)bizmeasureUnitInfo)) {
                qty = QCRequestReverseSaveUtils.getQtyByBaseQty(ctx, materialInfo, cache, bizmeasureUnitInfo, baseQty);
            }
            if ((biz = rs.getDPProcessMode().getQCPurBiz()) == QCPurBizEnum.BIZ_Qualified) {
                passQty = passQty.add(qty);
                basepassQty = basepassQty.add(baseQty);
                continue;
            }
            if (biz == QCPurBizEnum.BIZ_Unqualified) {
                unPassQty = unPassQty.add(qty);
                baseUnPassQty = baseUnPassQty.add(baseQty);
                continue;
            }
            if (biz != QCPurBizEnum.BIZ_Back) continue;
            backQty = backQty.add(qty);
            basesBack = basesBack.add(baseQty);
        }
        BigDecimal[] qtyAry = new BigDecimal[6];
        int i = 0;
        qtyAry[i++] = passQty;
        qtyAry[i++] = basepassQty;
        qtyAry[i++] = unPassQty;
        qtyAry[i++] = baseUnPassQty;
        qtyAry[i++] = backQty;
        qtyAry[i++] = basesBack;
        return qtyAry;
    }

    private static BigDecimal getQtyByBaseQty(Context ctx, MaterialInfo materialInfo, Map cache, MeasureUnitInfo bizUnit, BigDecimal baseQty) throws BOSException, EASBizException {
        MultiMeasureUnitInfo multiUnit = null;
        String key = materialInfo.getId().toString() + bizUnit.getId().toString();
        if (QMEqualsUtils.equals((Object)materialInfo.getBaseUnit(), (Object)bizUnit)) {
            return baseQty;
        }
        if (cache.get(key) != null) {
            multiUnit = (MultiMeasureUnitInfo)cache.get(key);
        } else {
            multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiUnit(materialInfo.getId().toString(), bizUnit.getId().toString());
            cache.put(key, multiUnit);
        }
        int qtyPrecision = multiUnit.getQtyPrecision();
        BigDecimal rate = multiUnit.getBaseConvsRate();
        BigDecimal qty = baseQty.divide(rate, qtyPrecision, 4);
        return qty;
    }
}

