/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app.reversesave.qcrequest;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.app.action.ServerEvent;
import com.kingdee.eas.qm.common.app.reversesave.ReverseServerAction;
import com.kingdee.eas.qm.qc.QCRequestEntryInfo;
import com.kingdee.eas.qm.qc.QCRequestInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class QCSample4QCRequestAction
extends ReverseServerAction {
    public void handler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        super.handler(ctx, event);
    }

    public String getSrcBillEntryTbl() {
        return "T_QM_QCSampleItemEntry";
    }

    private void addFlag(Context ctx, QCRequestInfo info) throws BOSException, EASBizException {
        HashSet<String> newEntrySet = new HashSet<String>();
        HashSet<String> newSRCEntrySet = new HashSet<String>();
        BOSUuid pk = info.getId();
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            QCRequestEntryInfo requestEntryInfo = info.getEntrys().get(i);
            if (requestEntryInfo.getSourceBillEntryID() == null) continue;
            newEntrySet.add(requestEntryInfo.getId().toString());
            newSRCEntrySet.add(requestEntryInfo.getSourceBillEntryID());
        }
        this.updateDeliverQty(ctx, this.getSrcBillEntryTbl(), newEntrySet, "+");
    }

    public void afterAddnewHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        super.afterAddnewHandler(ctx, event);
        QCRequestInfo info = (QCRequestInfo)event.getSrcObject();
        this.addFlag(ctx, info);
    }

    public void afterUpdateHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        QCRequestInfo info = (QCRequestInfo)event.getSrcObject();
        if (info == null) {
            return;
        }
        if (info.getAuditor() != null) {
            return;
        }
        this.addFlag(ctx, info);
    }

    public void beforeDeleteHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        super.beforeDeleteHandler(ctx, event);
        QCRequestInfo info = (QCRequestInfo)event.getSrcObject();
        this.deleteFlag(ctx, info);
    }

    public void beforeUpdateHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        QCRequestInfo info = (QCRequestInfo)event.getSrcObject();
        if (info == null) {
            return;
        }
        if (info.getAuditor() != null) {
            return;
        }
        this.deleteFlag(ctx, info);
    }

    private void deleteFlag(Context ctx, QCRequestInfo info) throws BOSException {
        String getOldSourceBillEntrySql = "select fid from T_QM_QCRequestEntry where fparentid=? and fsourcebillentryid is not null";
        HashSet<String> oldentrySet = new HashSet<String>();
        BOSUuid pk = info.getId();
        if (pk != null) {
            try {
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)getOldSourceBillEntrySql, (Object[])new String[]{pk.toString()});
                while (rs.next()) {
                    oldentrySet.add(rs.getString(1));
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            this.updateDeliverQty(ctx, this.getSrcBillEntryTbl(), oldentrySet, "-");
        }
    }

    String getQtyFieldName() {
        return "FQenDownQty";
    }

    private void updateDeliverQty(Context ctx, String srcBillEntryTbl, Set entryIdSet, String flag) throws BOSException {
        if (entryIdSet.size() == 0) {
            return;
        }
        int qenDownQty = 0;
        if (flag.equals("+")) {
            qenDownQty = 1;
        }
        StringBuffer entryIDParam = new StringBuffer();
        Iterator it = entryIdSet.iterator();
        int count = 0;
        while (it.hasNext()) {
            String entryId = it.next().toString();
            if (count == 0) {
                entryIDParam.append("'" + entryId + "'");
            } else {
                entryIDParam.append(",'" + entryId + "'");
            }
            ++count;
        }
        StringBuffer sbSql = new StringBuffer();
        sbSql.append("update " + srcBillEntryTbl + "  set FQenDownQty = " + qenDownQty);
        sbSql.append(" where fid in (");
        sbSql.append("select fSourceBillEntryID from T_QM_QCRequestQcItemEntry where FEntryID in(");
        sbSql.append(entryIDParam.toString());
        sbSql.append(")");
        sbSql.append(")");
        DbUtil.execute((Context)ctx, (String)sbSql.toString());
    }
}

