/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app.reversesave.qcsample;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.app.action.ServerEvent;
import com.kingdee.eas.qm.common.app.reversesave.ReverseServerAction;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.qm.qc.QCBizStateEnum;
import com.kingdee.eas.qm.qc.QCRequestEntryInfo;
import com.kingdee.eas.qm.qc.QCSampleEntryInfo;
import com.kingdee.eas.qm.qc.QCSampleInfo;
import com.kingdee.eas.util.app.DbUtil;

public class QCRequest4QCSampleAction
extends ReverseServerAction {
    public void afterAddnewHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        super.afterAddnewHandler(ctx, event);
        QCSampleInfo info = (QCSampleInfo)event.getSrcObject();
        if (info.getQcSequence() == 1) {
            QCRequestEntryInfo requestEntryInfo = new QCRequestEntryInfo();
            requestEntryInfo.setIsGenDestBill(true);
            requestEntryInfo.setSampleState(QCBizStateEnum.start);
            this.reverseQCRequest(ctx, info.getRequestEntryID(), 10, 1);
        }
    }

    public void beforeAddnewHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        super.afterAddnewHandler(ctx, event);
        QCSampleInfo info = (QCSampleInfo)event.getSrcObject();
        this.initSampleNumber(info);
    }

    private void initSampleNumber(QCSampleInfo info) {
        for (int i = 0; i < info.getEntrys().size(); ++i) {
            QCSampleEntryInfo entry = info.getEntrys().get(i);
            if (entry.getNumber() != null && entry.getNumber().trim().length() != 0) continue;
            String c = QMStringUtils.leftPadString((char)'0', (String)String.valueOf(i + 1), (int)3);
            entry.setNumber(info.getNumber() + "-" + c);
        }
    }

    public void beforeAuditHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        super.beforeAuditHandler(ctx, event);
        QCSampleInfo info = (QCSampleInfo)event.getSrcObject();
        if (info.getQcSequence() == 1) {
            this.reverseQCRequest(ctx, info.getRequestEntryID(), 20, -1);
        }
    }

    public void beforeUnAuditHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        super.beforeUnAuditHandler(ctx, event);
        QCSampleInfo info = (QCSampleInfo)event.getSrcObject();
        if (info.getQcSequence() == 1) {
            this.reverseQCRequest(ctx, info.getRequestEntryID(), 10, -1);
        }
    }

    public void beforeDeleteHandler(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        super.beforeDeleteHandler(ctx, event);
        QCSampleInfo info = (QCSampleInfo)event.getSrcObject();
        if (info.getQcSequence() == 1) {
            this.reverseQCRequest(ctx, info.getRequestEntryID(), 0, 0);
        }
    }

    protected void reverseQCRequest(Context ctx, String pk, int sampleState, int isGenDestBill) throws EASBizException, BOSException {
        StringBuffer sql = new StringBuffer("update t_qm_qcrequestentry set fsampleState=?");
        if (isGenDestBill != -1) {
            sql.append(",fisGenDestBill=").append(isGenDestBill).append("");
            sql.append(",FDestBillID='").append(pk).append("'");
        }
        sql.append(" where fid='").append(pk).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{new Integer(sampleState)});
    }
}

