/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app.util.qcreport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.basedata.QCLowerLimitEnum;
import com.kingdee.eas.qm.basedata.QCUpperLimitEnum;
import com.kingdee.eas.qm.qc.app.util.qcreport.QCReportServerHelper;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public abstract class QCPurReportCalBalPriceHelper {
    private static Logger logger = Logger.getLogger((String)QCPurReportCalBalPriceHelper.class.getName());

    public static boolean isMatchPurContractFilterRange(Context ctx, Object checkValue, QCLowerLimitEnum lowerLimit, BigDecimal lowerValue, QCUpperLimitEnum upperLimit, BigDecimal upperValue) throws BOSException, EASBizException {
        if (!(checkValue instanceof BigDecimal)) {
            return false;
        }
        BigDecimal tempCheckValue = (BigDecimal)checkValue;
        if (lowerLimit == QCLowerLimitEnum.isNull) {
            lowerLimit = null;
        }
        if (upperLimit == QCUpperLimitEnum.isNull) {
            upperLimit = null;
        }
        boolean ispass = true;
        if (upperValue != null && upperLimit != null && lowerValue != null && lowerLimit != null) {
            BigDecimal temp1 = new BigDecimal(lowerValue.toString());
            BigDecimal temp2 = new BigDecimal(upperValue.toString());
            if (lowerLimit == QCLowerLimitEnum.equal) {
                ispass = tempCheckValue.compareTo(temp1) == 0;
            } else if (lowerLimit == QCLowerLimitEnum.graterAndEqual) {
                ispass = tempCheckValue.compareTo(temp1) != -1;
            } else if (lowerLimit == QCLowerLimitEnum.greater) {
                ispass = tempCheckValue.compareTo(temp1) == 1;
            }
            if (upperLimit == QCUpperLimitEnum.equal) {
                if (ispass && tempCheckValue.compareTo(temp2) == 0) {
                    ispass = true;
                } else if (ispass) {
                    ispass = false;
                }
            } else if (upperLimit == QCUpperLimitEnum.lessAndEqual) {
                if (ispass && tempCheckValue.compareTo(temp2) != 1) {
                    ispass = true;
                } else if (ispass) {
                    ispass = false;
                }
            }
            if (upperLimit == QCUpperLimitEnum.less) {
                if (ispass && tempCheckValue.compareTo(temp2) == -1) {
                    ispass = true;
                } else if (ispass) {
                    ispass = false;
                }
            }
        } else if (upperValue != null && upperLimit != null) {
            BigDecimal temp2 = new BigDecimal(upperValue.toString());
            if (upperLimit == QCUpperLimitEnum.equal) {
                if (ispass && tempCheckValue.compareTo(temp2) == 0) {
                    ispass = true;
                } else if (ispass) {
                    ispass = false;
                }
            } else if (upperLimit == QCUpperLimitEnum.lessAndEqual) {
                if (ispass && tempCheckValue.compareTo(temp2) != 1) {
                    ispass = true;
                } else if (ispass) {
                    ispass = false;
                }
            }
            if (upperLimit == QCUpperLimitEnum.less) {
                if (ispass && tempCheckValue.compareTo(temp2) == -1) {
                    ispass = true;
                } else if (ispass) {
                    ispass = false;
                }
            }
        } else if (lowerValue != null && lowerLimit != null) {
            BigDecimal temp2 = new BigDecimal(lowerValue.toString());
            if (lowerLimit == QCLowerLimitEnum.equal) {
                ispass = tempCheckValue.compareTo(temp2) == 0;
            } else if (lowerLimit == QCLowerLimitEnum.graterAndEqual) {
                ispass = tempCheckValue.compareTo(temp2) != -1;
            } else if (lowerLimit == QCLowerLimitEnum.greater) {
                ispass = tempCheckValue.compareTo(temp2) == 1;
            }
        }
        return ispass;
    }

    public static String buildDataSql(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT REPORT.FNUMBER, \n");
        sql.append("REPORT.FID AS FREPORTID, \n");
        sql.append("REPORTENTRY.FID AS FREPORTENTRYID, \n");
        sql.append("CONTRACTENTRY.FTAXPRICE AS FTAXPRICE, \n");
        sql.append("CONTRACTENTRY.FPROTECTPRICE AS PROTECTPRICE, \n");
        sql.append("REPORTENTRY.FQCITEMID AS FITEMID, \n");
        sql.append("ITEM.FNUMBER AS FITEMNUMBER, \n");
        String f_itemname = QCReportServerHelper.getFieldByLanguage("ITEM.FNAME");
        sql.append("" + f_itemname + " AS FITEMNAME, \n");
        sql.append("AVG(TO_NUMBER(ISNULL(REPORTENTRY.FCHECKVALUE,'0'))) AS FCHECKVALUE, \n");
        sql.append("CTS.FSETTLEMENTPRICETYPE AS FBALPRICETYPE, \n");
        sql.append("CASE CTS.FSETTLEMENTPRICETYPE \n");
        sql.append("  WHEN 2 THEN 0  \n");
        sql.append("  WHEN 0 THEN 1  \n");
        sql.append("  WHEN 1 THEN 2  \n");
        sql.append("  ELSE 3 END AS TYPESORT, \n");
        sql.append("CTS.FCOMPARATOR1 AS FLOWERLIMIT, \n");
        sql.append("CTS.FLOWRANGE    AS FLOWERVALUE, \n");
        sql.append("CTS.FCOMPARATOR2 AS FUPPERLIMIT, \n");
        sql.append("CTS.FUPPERRANGE  AS FUPPERVALUE, \n");
        sql.append("CTS.FBASEVALUE   AS FBASEVALUE, \n");
        sql.append("CTS.FBASEPRICE   AS FADDPRICE, \n");
        sql.append("CTS.FFLOATVALUE  AS FFLOATVALUE, \n");
        sql.append("CTS.FFLOATPRICE  AS FFLOATPRICE \n");
        sql.append("FROM T_QM_QCREPORT REPORT  \n");
        sql.append("INNER JOIN T_QM_QCREPORTENTRY REPORTENTRY  \n");
        sql.append("ON REPORT.FID = REPORTENTRY.FPARENTID \n");
        sql.append("INNER JOIN T_QM_QCREQUESTENTRY REQUESTENTRY \n");
        sql.append("ON REPORT.FREQUESTENTRYID = REQUESTENTRY.FID \n");
        sql.append("INNER JOIN T_QM_QCREQUEST REQUEST  \n");
        sql.append("ON REQUESTENTRY.FPARENTID = REQUEST.FID \n");
        sql.append("INNER JOIN T_IM_PURRECEIVALENTRY PURREC  \n");
        sql.append("ON REQUESTENTRY.FSOURCEBILLENTRYID =PURREC.FID \n");
        sql.append("INNER JOIN T_SM_PURORDERENTRY ORDERENTRY  \n");
        sql.append("ON PURREC.FSOURCEBILLENTRYID =ORDERENTRY.FID \n");
        sql.append("INNER JOIN T_SM_PURCONTRACTENTRY CONTRACTENTRY  \n");
        sql.append("ON ORDERENTRY.FSOURCEBILLENTRYID =CONTRACTENTRY.FID \n");
        sql.append("INNER JOIN T_SM_PURCONTRACTSETTLETERMSNOR CTS  \n");
        sql.append("ON CONTRACTENTRY.FID = CTS.FPARENTID \n");
        sql.append("AND CTS.FQCITEM =REPORTENTRY.FQCITEMID \n");
        sql.append("INNER JOIN T_QM_QCITEM ITEM  \n");
        sql.append("ON REPORTENTRY.FQCITEMID = ITEM.FID \n");
        sql.append("WHERE \n");
        sql.append("ITEM.FQCVALUETYPE IN (10, 40) \n");
        sql.append("AND REPORTENTRY.FISBALANCEITEM = 1 \n");
        sql.append("AND REPORT.FID = '" + pk.toString() + "'  \n");
        sql.append("GROUP BY  \n");
        sql.append("REPORT.FNUMBER,REPORT.FID,REPORTENTRY.FID, \n");
        sql.append("CONTRACTENTRY.FTAXPRICE,CONTRACTENTRY.FPROTECTPRICE, \n");
        sql.append("REPORTENTRY.FQCITEMID,ITEM.FNUMBER, \n");
        sql.append("" + f_itemname + ", \n");
        sql.append("CTS.FSETTLEMENTPRICETYPE, \n");
        sql.append("CTS.FCOMPARATOR1,CTS.FLOWRANGE,CTS.FCOMPARATOR2, \n");
        sql.append("CTS.FUPPERRANGE,CTS.FBASEVALUE,CTS.FBASEPRICE, \n");
        sql.append("CTS.FFLOATVALUE,CTS.FFLOATPRICE \n");
        sql.append(" ORDER BY TYPESORT,CTS.FLOWRANGE \n");
        sql.append(" \n");
        logger.debug((Object)sql.toString());
        return sql.toString();
    }
}

