/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app.util.qcreport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.basedata.util.QCModifyModeHelper;
import com.kingdee.eas.qm.qc.QCReportException;
import com.kingdee.eas.qm.qc.QCReportFactory;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.eas.qm.qc.QCRequestEntryFactory;
import com.kingdee.eas.qm.qc.QCRequestEntryInfo;
import com.kingdee.eas.qm.qc.util.QMUnitConvertHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;

public class QCReportServerBatchHelper {
    public static void submitQtyToQCRequest(Context ctx, IObjectPK pk, boolean isAudit) throws BOSException, EASBizException {
        QCReportInfo reportInfo = QCReportServerBatchHelper._getValue(ctx, pk);
        if (reportInfo.isQCReportFromQCBill()) {
            return;
        }
        String requestEntryID = reportInfo.getRequestEntryID();
        QCRequestEntryInfo reqeustEntryInfo = QCRequestEntryFactory.getLocalInstance(ctx).getQCRequestEntryInfo((IObjectPK)new ObjectStringPK(requestEntryID));
        MeasureUnitInfo srcUnit = reportInfo.getUnit();
        MeasureUnitInfo destUnit = reqeustEntryInfo.getBaseUnit();
        MeasureUnitInfo destUnit1 = reqeustEntryInfo.getUnit();
        String materialID = "";
        if (reportInfo.getJudgeMaterial() != null) {
            materialID = reportInfo.getJudgeMaterial().getId().toString();
        }
        String srcUnitID = srcUnit != null ? srcUnit.getId().toString() : "";
        String destUnitID = destUnit != null ? destUnit.getId().toString() : "";
        String destUnitID1 = destUnit1 != null ? destUnit1.getId().toString() : "";
        BigDecimal passQty = reportInfo.getPassQty();
        passQty = QMUnitConvertHelper.convertQtyByUnit(ctx, materialID, srcUnitID, destUnitID1, passQty);
        BigDecimal passBaseQty = QMUnitConvertHelper.convertQtyByUnit(ctx, materialID, srcUnitID, destUnitID, passQty);
        BigDecimal unpassQty = reportInfo.getUnPassQty();
        unpassQty = QMUnitConvertHelper.convertQtyByUnit(ctx, materialID, srcUnitID, destUnitID1, unpassQty);
        BigDecimal unpassBaseQty = QMUnitConvertHelper.convertQtyByUnit(ctx, materialID, srcUnitID, destUnitID, unpassQty);
        String flag = isAudit ? "+" : "-";
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_QM_QCREQUESTENTRY  \n");
        sql.append("SET FQualifiedQty = FQualifiedQty" + flag + QCModifyModeHelper.toPlainString((BigDecimal)passQty) + ", \n");
        sql.append("FUnQualifiedQty = FUnQualifiedQty" + flag + QCModifyModeHelper.toPlainString((BigDecimal)unpassQty) + ", \n");
        sql.append("FBaseQualifiedQty =FBaseQualifiedQty" + flag + QCModifyModeHelper.toPlainString((BigDecimal)passBaseQty) + ", \n");
        sql.append("FBaseUnQualifiedQty = FBaseUnQualifiedQty" + flag + QCModifyModeHelper.toPlainString((BigDecimal)unpassBaseQty) + " \n");
        sql.append("WHERE FID = '" + requestEntryID + "' \n");
        sql.append(" \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        if (isAudit) {
            QCReportServerBatchHelper.checkQtyFromQCRequest(ctx, pk);
        }
    }

    private static QCReportInfo _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("unit.*");
        QCReportInfo reportInfo = QCReportFactory.getLocalInstance(ctx).getQCReportInfo(pk, sic);
        return reportInfo;
    }

    public static void checkQtyFromQCRequest(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        QCReportInfo reportInfo = QCReportServerBatchHelper._getValue(ctx, pk);
        BigDecimal curPassQty = reportInfo.getPassQty();
        BigDecimal curUnpassQty = reportInfo.getUnPassQty();
        String curUnitName = reportInfo.getUnit().getName();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT RE.FUNITID,RE.FDELIVERQTY, \n");
        sql.append("RE.FQUALIFIEDQTY, \n");
        sql.append("RE.FUNQUALIFIEDQTY  \n");
        sql.append("FROM T_QM_QCREQUESTENTRY RE \n");
        sql.append("WHERE RE.FID  \n");
        sql.append("IN( \n");
        sql.append("SELECT T.FREQUESTENTRYID  \n");
        sql.append("FROM T_QM_QCREPORT T  \n");
        sql.append("WHERE FID = '" + pk.toString() + "') \n");
        sql.append(" \n");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            rs.next();
            BigDecimal sendQty = rs.getBigDecimal("FDELIVERQTY");
            BigDecimal passQty = rs.getBigDecimal("FQUALIFIEDQTY");
            BigDecimal unPassQty = rs.getBigDecimal("FUNQUALIFIEDQTY");
            BigDecimal totalQty = passQty.add(unPassQty);
            if (totalQty.compareTo(sendQty) == 1) {
                String checkBatchUnitID = rs.getString("FUNITID");
                MeasureUnitInfo checkBatchUnit = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitInfo((IObjectPK)new ObjectStringPK(checkBatchUnitID));
                String checkBatchUnitName = checkBatchUnit.getName();
                throw new QCReportException(QCReportException.SUBMITQTY_ERROR, new Object[]{curUnitName + "\n", curPassQty, curUnpassQty, "\n", checkBatchUnitName, "\n", passQty, unPassQty, "\n", totalQty, sendQty});
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }

    public static void setReportIsUsed(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        StringBuffer clearSql = new StringBuffer();
        clearSql.append("UPDATE T_QM_QCREPORT SET FISUSEDREPORT =0 \n");
        clearSql.append("WHERE FREQUESTENTRYID in \n");
        clearSql.append("( \n");
        clearSql.append("SELECT REPORT.FREQUESTENTRYID \n");
        clearSql.append("FROM T_QM_QCREPORT REPORT \n");
        clearSql.append("WHERE REPORT.FID = '" + pk.toString() + "' \n");
        clearSql.append(") \n");
        clearSql.append(" \n");
        DbUtil.execute((Context)ctx, (String)clearSql.toString());
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE T_QM_QCREPORT  \n");
        sql.append("SET FISUSEDREPORT = 1 \n");
        sql.append("WHERE FREQUESTENTRYID IN \n");
        sql.append("(SELECT REPORT.FREQUESTENTRYID \n");
        sql.append("FROM T_QM_QCREPORT REPORT \n");
        sql.append("WHERE REPORT.FID = '" + pk.toString() + "') \n");
        sql.append("AND FREPORTDATE IN \n");
        sql.append("( \n");
        sql.append("SELECT MAX(TT.FREPORTDATE) \n");
        sql.append("FROM T_QM_QCREPORT TT \n");
        sql.append("INNER JOIN T_QM_QCREPORT OT \n");
        sql.append("ON TT.FREQUESTENTRYID = OT.FREQUESTENTRYID \n");
        sql.append("WHERE OT.FID = '" + pk.toString() + "' \n");
        sql.append("AND TT.FBILLSTATUS = 30 \n");
        sql.append(") \n");
        sql.append(" AND FBILLSTATUS = 30 \n");
        sql.append(" \n");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }
}

