/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.app.util.qcreport;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.basedata.QCBizBillTypeFactory;
import com.kingdee.eas.qm.basedata.QCBizTypeEnum;
import com.kingdee.eas.qm.basedata.QCSourceBillTypeFactory;
import com.kingdee.eas.qm.basedata.QCSourceBillTypeInfo;
import com.kingdee.eas.qm.common.QMException;
import com.kingdee.eas.qm.common.app.action.ServerEvent;
import com.kingdee.eas.qm.common.codingrule.ISuportCodingRule;
import com.kingdee.eas.qm.common.codingrule.ISuportCodingRuleInfo;
import com.kingdee.eas.qm.common.codingrule.ServerCodingRuleStrategy;
import com.kingdee.eas.qm.qc.QCReportEntryInfo;
import com.kingdee.eas.qm.qc.QCReportInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Locale;
import org.apache.log4j.Logger;

public abstract class QCReportServerHelper {
    private static Logger logger = Logger.getLogger((String)QCReportServerHelper.class.getName());
    public static final String Key_Split_Char = "<#>";
    public static final String SampleKey_Split_Char = "@";
    public static final String CreateReportTable = "CreateReportTable";
    public static final String CTX_ISCreateFrom = "ISCreateFrom";
    public static final String unAuditStatusList = "0,10,20";
    public static final String auditStatusList = "30";

    public QCReportServerHelper() {
        logger.debug((Object)"");
    }

    public static String buildReuqestKey(Context ctx, String requestNumber, String requestEntryNumber) throws BOSException, EASBizException {
        StringBuffer key = new StringBuffer();
        key.append(requestNumber);
        key.append(Key_Split_Char);
        key.append(requestEntryNumber);
        return key.toString();
    }

    public static QualityOrgUnitInfo getCurrentQualityOrgUnit(Context ctx) throws BOSException, EASBizException {
        QualityOrgUnitInfo qyOrg = ContextUtil.getCurrentQualityUnit((Context)ctx);
        if (qyOrg == null) {
            throw new QMException(QMException.BLANK, (Object[])new String[]{"Error QualityOrgUnit!!!"});
        }
        return qyOrg;
    }

    public static String getCurrentQualityOrgUnitID(Context ctx) throws BOSException, EASBizException {
        return QCReportServerHelper.getCurrentQualityOrgUnit(ctx).getId().toString();
    }

    public static String buildSampleNumberAndSeqKey(Context ctx, QCReportEntryInfo entryInfo) throws BOSException, EASBizException {
        StringBuffer key = new StringBuffer();
        String sampleNumber = "NULL";
        String sampleSeq = "NULL";
        if (!StringUtil.isEmptyString((String)entryInfo.getSampleNumber())) {
            sampleNumber = entryInfo.getSampleNumber();
        }
        key.append(sampleNumber);
        key.append(SampleKey_Split_Char);
        key.append(sampleSeq);
        return key.toString();
    }

    public static boolean isQCReportCreateFromInCtx(Context ctx) throws BOSException, EASBizException {
        return ctx.get((Object)CTX_ISCreateFrom) != null && (Boolean)ctx.get((Object)CTX_ISCreateFrom) != false;
    }

    public static String getFieldByLanguage(String field) {
        String name = null;
        Locale locale = ContextUtils.getLocaleFromEnv();
        if ("l1".equalsIgnoreCase(locale.getLanguage())) {
            name = field + "_L1 ";
        } else if ("l3".equalsIgnoreCase(locale.getLanguage())) {
            name = field + "_L3 ";
        } else if ("l2".equalsIgnoreCase(locale.getLanguage())) {
            name = field + "_L2 ";
        }
        return name;
    }

    public static void loadUserInfoToDataObject(Context ctx, QCReportInfo reportInfo) throws BOSException, EASBizException {
        String requestID = reportInfo.getRequestID();
        String sql = "SELECT T.Fsourcebilltypeid AS SBID FROM T_QM_QCREQUEST T WHERE T.FID = '" + requestID + "' ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
        String sourceTypeID = null;
        try {
            if (!rs.next()) {
                return;
            }
            sourceTypeID = rs.getString("SBID");
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (!StringUtil.isEmptyString((String)sourceTypeID)) {
            QCSourceBillTypeInfo sbInfo = QCSourceBillTypeFactory.getLocalInstance((Context)ctx).getQCSourceBillTypeInfo((IObjectPK)new ObjectStringPK(sourceTypeID));
            reportInfo.setIsQCReportFromQCBill(sbInfo.isQCBill());
            reportInfo.setIsQCReportFromOtherSubSystem(sbInfo.isFromOtherSubSystem());
        }
    }

    public static void initNumberByCodeingRule(Context ctx, ServerCodingRuleStrategy codeingRuleStrategy, ISuportCodingRule codeingBean, QCReportInfo reportInfo) throws BOSException, EASBizException {
        if (codeingRuleStrategy == null) {
            throw new BOSException("Error ServerCodingRuleStrategy!");
        }
        if (codeingBean == null) {
            throw new BOSException("Error ISuportCodingRule!");
        }
        codeingRuleStrategy.initNumber(codeingBean, ctx, (ISuportCodingRuleInfo)reportInfo);
        if (StringUtil.isEmptyString((String)reportInfo.getNumber())) {
            throw new QMException(QMException.BLANK, (Object[])new String[]{ResourceBase.getString((String)"com.kingdee.eas.qm.qc.QCAutoGenerateResource", (String)"15_QCReportServerHelper", (Locale)ctx.getLocale())});
        }
    }

    public static void doStmToRelWeighEntry(Context ctx, ServerEvent event) throws BOSException, EASBizException {
        QCReportInfo info = (QCReportInfo)event.getSrcObject();
        QCBizTypeEnum bizType = info.getBillType().getQCBizType();
        if (null == info.getBillType().getQCBizType()) {
            bizType = QCBizBillTypeFactory.getLocalInstance((Context)ctx).getQCBizBillTypeInfo((IObjectPK)new ObjectUuidPK(info.getBillType().getId())).getQCBizType();
        }
        if (!bizType.equals((Object)QCBizTypeEnum.purCheck)) {
            return;
        }
    }

    public static void dealRelWeigh(Context ctx, QCReportInfo info) throws BOSException, EASBizException {
    }
}

