/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.util;

import com.kingdee.eas.qm.qc.DeductCalFomulaEnum;
import com.kingdee.eas.qm.qc.HQHPCalBillInfo;
import com.kingdee.eas.qm.qc.util.HQHPUtil;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

public class HQHPDeductCalWithFomula {
    private BigDecimal netWeightPerReport;
    private List deductList;
    private HQHPCalBillInfo info;

    public HQHPDeductCalWithFomula(BigDecimal netWeightPerReport, List deductList, HQHPCalBillInfo info) {
        this.netWeightPerReport = netWeightPerReport;
        this.deductList = deductList;
        this.info = info;
    }

    public BigDecimal subtractDeductValue() {
        if (this.deductList.size() == 0) {
            return this.netWeightPerReport;
        }
        DeductCalFomulaEnum deductCalFomula = this.info.getDeductCalFomula();
        if (DeductCalFomulaEnum.SUBITEMA.equals((Object)deductCalFomula)) {
            return this.calWithFA();
        }
        if (DeductCalFomulaEnum.SUBITEMB.equals((Object)deductCalFomula)) {
            return this.calWithFB();
        }
        if (DeductCalFomulaEnum.TOTALA.equals((Object)deductCalFomula)) {
            return this.calWithLA();
        }
        return this.netWeightPerReport;
    }

    public BigDecimal calWithFA() {
        BigDecimal deduct = HQHPUtil.BigDecimal_Zero;
        for (int i = 0; i < this.deductList.size(); ++i) {
            Map qcValue = (Map)this.deductList.get(i);
            BigDecimal checkValue = (BigDecimal)qcValue.get("checkValue");
            BigDecimal baseValue = (BigDecimal)qcValue.get("baseValue");
            if (checkValue == null || baseValue == null) continue;
            deduct = deduct.add(checkValue.subtract(baseValue));
        }
        return HQHPUtil.multiply(this.netWeightPerReport, new BigDecimal("1").subtract(deduct), 10);
    }

    public BigDecimal calWithFB() {
        BigDecimal deduct = HQHPUtil.BigDecimal_Zero;
        for (int i = 0; i < this.deductList.size(); ++i) {
            Map qcValue = (Map)this.deductList.get(i);
            BigDecimal checkValue = (BigDecimal)qcValue.get("checkValue");
            BigDecimal baseValue = (BigDecimal)qcValue.get("baseValue");
            if (checkValue == null || baseValue == null) continue;
            BigDecimal c = new BigDecimal("1").subtract(checkValue);
            BigDecimal b = new BigDecimal("1").subtract(baseValue);
            if (!HQHPUtil.notZero(b)) continue;
            deduct = deduct.add(new BigDecimal("1").subtract(c.divide(b, 10, 4)));
        }
        return HQHPUtil.multiply(this.netWeightPerReport, new BigDecimal("1").subtract(deduct), 10);
    }

    public BigDecimal calWithLA() {
        BigDecimal dryPercent = new BigDecimal("1");
        for (int i = 0; i < this.deductList.size(); ++i) {
            Map qcValue = (Map)this.deductList.get(i);
            BigDecimal checkValue = (BigDecimal)qcValue.get("checkValue");
            BigDecimal baseValue = (BigDecimal)qcValue.get("baseValue");
            if (checkValue == null || baseValue == null) continue;
            dryPercent = dryPercent.multiply(new BigDecimal("1").subtract(checkValue.subtract(baseValue)));
        }
        return this.netWeightPerReport.multiply(dryPercent);
    }
}

