/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSLocaleUtil;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.util.CtrlFormatUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.basedata.QCLowerLimitEnum;
import com.kingdee.eas.qm.basedata.QCUpperLimitEnum;
import com.kingdee.eas.qm.common.util.QMParamNumberConstant;
import com.kingdee.eas.qm.common.util.QMParamUtil;
import com.kingdee.eas.qm.qc.HQHPCalBillInfo;
import com.kingdee.eas.qm.qc.HQHPCalBillQcReportEntryCollection;
import com.kingdee.eas.qm.qc.HQHPCalBillQcReportEntryInfo;
import com.kingdee.eas.qm.qc.util.HQHPMsg;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import com.kingdee.util.TypeConversionUtils;
import com.kingdee.util.db.SQLUtils;
import java.awt.Color;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class HQHPUtil {
    public static final String Para_PurOrg = "purOrgID";
    public static final String Para_CalPattern = "calPattern";
    public static final String Para_ReportDateBegin = "reportDateBegin";
    public static final String Para_ReportDateEnd = "reportDateEnd";
    public static final String Para_RecBillDateBegin = "recBillDateBegin";
    public static final String Para_RecBillDateEnd = "recBillDateEnd";
    public static final String Para_PurDateBegin = "purDateBegin";
    public static final String Para_PurDateEnd = "purDateEnd";
    public static final String Para_Supplier = "supplierID";
    public static final String Para_PurContract = "purContractID";
    public static final String Para_Material = "paraMaterialID";
    public static final String Para_IsWeigh = "Para_IsWeigh";
    public static final String Para_WeighDateBegin = "Para_WeighDateBegin";
    public static final String Para_WeighDateEnd = "Para_WeighDateEnd";
    public static final String Choose_PurIDs = "purIDs";
    public static final String Choose_PurEntryIDs = "purEntryIDs";
    public static final String Choose_PurInfos = "Choose_PurInfos";
    public static final String Choose_SelectedReports = "selectedReports";
    public static final String Choose_FilterParas = "filterParas";
    public static final String Choose_UnSelectedWBs = "Choose_UnSelectedWBs";
    public static final String Add_Paras = "Add_Paras";
    public static final String Add_Para_ReportDateBegin = "Add_Para_ReportDateBegin";
    public static final String Add_Para_ReportDateEnd = "Add_Para_ReportDateEnd";
    public static final String Add_Para_RecDateBegin = "Add_Para_RecDateBegin";
    public static final String Add_Para_RecDateEnd = "Add_Para_RecDateEnd";
    public static final String Add_Para_PurEntryID = "Add_Para_PurEntryID";
    public static final String Add_Para_ExcludeReports = "Add_Para_ExcludeReports";
    public static final String Add_Para_Info = "Add_Para_Info";
    public static final String Add_Confirm_Info = "Add_Confirm_Info";
    public static final String Add_Confirm_RelReportIdSet = "Add_Confirm_RelReportIdSet";
    public static final String Add_Confirm_RelCalBillIdSet = "Add_Confirm_RelCalBillIdSet";
    public static final String ADD_SelectResult_CanAddList = "ADD_SelectResult_CanAddList";
    public static final String ADD_SelectResult_CanNotAddList = "ADD_SelectResult_CanNotAddList";
    public static final String Update_Report_Action = "Update_Report_Action";
    public static final String Update_Report_Action_Audit = "Update_Report_Action_Audit";
    public static final String Update_Report_Action_UnAudit = "Update_Report_Action_UnAudit";
    public static final String Update_Report_CalPrice = "Update_Report_CalPrice";
    public static final String Update_Report_IDs = "Update_Report_IDs";
    public static final String Update_Report_IsFromListUI = "Update_Report_IsFromListUI";
    public static final String Update_Report_CalBillIds = "Update_Report_CalBillIds";
    public static final String Cancel_IDS = "Cancel_IDS";
    public static final String Cancel_Bill_Count = "Cancel_Bill_Count";
    public static final String Result_BillIDs = "resultBillIDs";
    public static final String Result_CalCount = "resultCalCount";
    public static final String Result_Error = "resultError";
    public static final String Result_ClearAdjustBills = "clearAdjustBills";
    public static final String Result_SubmitErrorMsg = "submitErrorMsg";
    public static final String Result_SubmitBills = "Result_SubmitBills";
    public static final String UICTX_OwnerCtx = "UICTX_OwnerCtx";
    public static final String UICTX_HQHPBILLS = "UICTX_HQHPBills";
    public static final String UICTX_HqhpBillInfo_Adjust = "UICTX_hqhpBillInfo_Adjust";
    public static final String UICTX_Adjust_IsReturn = "UICTX_Adjust_IsReturn";
    public static final String UICTX_AddReport_IsCancel = "UICTX_AddReport_IsCancel";
    public static final int QTY_DEFAULT_SCALE = 2;
    public static final int PRICE_DEFAULT_SCALE = 4;
    public static final int MONEY_SCALE = 2;
    public static final int PERCENT_SCALE = 4;
    public static final int DIVIDE_SCALE = 10;
    public static final int RoundingMode = 4;
    public static final String RESOURCE_FILE = "com.kingdee.eas.qm.qc.HQualityHPriceCalResource";
    public static final Color SumRowBGColor = new Color(246, 246, 191);
    public static final String COL_Pur_purOrgUnit = "purOrgUnit";
    public static final String COL_Pur_supplier = "supplier";
    public static final String COL_Pur_material = "material";
    public static final String COL_Pur_purConNumber = "purConNumber";
    public static final String COL_Pur_contractDate = "contractDate";
    public static final String COL_Pur_conExpireDate = "conExpireDate";
    public static final String COL_Pur_contractType = "contractType";
    public static final String COL_Pur_price = "price";
    public static final String COL_Pur_protectivePrice = "protectivePrice";
    public static final String COL_Pur_ID = "id";
    public static final String COL_Pur_ENTRYID = "entryId";
    private static final String[] PurCols = new String[]{"purOrgUnit", "supplier", "material", "purConNumber", "contractDate", "conExpireDate", "contractType", "price", "protectivePrice", "id", "entryId"};
    public static final String COL_QC_ReportID = "reportID";
    public static final String COL_QC_qualityOrgUnit = "qualityOrgUnit";
    public static final String COL_QC_number = "number";
    public static final String COL_QC_material = "materialID";
    public static final String COL_QC_billStatus = "billStatus";
    public static final String COL_QC_qCStandard = "qCStandard";
    public static final String COL_QC_sampleSolution = "sampleSolution";
    public static final String COL_QC_reportDate = "reportDate";
    public static final String COL_QC_checkResult = "checkResult";
    public static final String COL_QC_deliverQty = "deliverQty";
    public static final String COL_QC_passQty = "passQty";
    public static final String COL_QC_unPassQty = "unPassQty";
    public static final String COL_QC_unit = "unit";
    public static final String COL_QC_isCalBalPrice = "isCalBalPrice";
    public static final String COL_QC_isSubmitBalPrice = "isSubmitBalPrice";
    public static final String COL_QC_isMRB = "isMRB";
    public static final String COL_QC_submitResult = "submitResult";
    public static final String COL_QC_description = "description";
    public static final String COL_QC_recBillID = "recBillID";
    public static final String COL_QC_recBillNumber = "recBillNumber";
    public static final String COL_QC_recBillBizDate = "recBillBizDate";
    public static final String COL_QC_recBillDesc = "recBillDesc";
    public static final String COL_QC_calBillID = "calBillID";
    public static final String COL_QC_calBillNumber = "calBillNumber";
    public static final String COL_QC_calQuantity = "calQuantity";
    public static final String COL_QC_calUnitPrice = "calUnitPrice";
    public static final String COL_QC_calMoney = "calMoney";
    public static final String COL_QC_conPriceRec = "conPriceRec";
    public static final String COL_QC_settleQuanS = "settleQuanS";
    public static final String COL_QC_moneyAvg = "moneyAvg";
    private static final String[] QCCols = new String[]{"reportID", "qualityOrgUnit", "number", "billStatus", "qCStandard", "sampleSolution", "reportDate", "checkResult", "deliverQty", "passQty", "unPassQty", "unit", "isCalBalPrice", "isSubmitBalPrice", "isMRB", "submitResult", "description", "recBillID", "recBillNumber", "recBillBizDate", "recBillDesc", "calBillID", "calBillNumber", "calQuantity", "calUnitPrice", "calMoney", "conPriceRec"};
    public static final String SQL_QC_RequestID = "requestID";
    public static final String SQL_QC_MaterialID = "materialID";
    public static final String SQL_QC_RecEntryID = "recEntryID";
    public static final String SQL_WM_netWeight = "netWeight";
    public static final String SQL_WM_incidental = "incidental";
    public static final String SQL_WM_unit = "unit";
    public static final String SQL_IM_SupplierQTY = "SUPPLIERQTY";
    public static final String SQL_IM_Unit = "unit";
    public static final String COL_Weigh_noticeBillNumber = "noticeBillNumber";
    public static final String COL_Weigh_carNumber = "carNumber";
    public static final String COL_Weigh_materialNumber = "materialNumber";
    public static final String COL_Weigh_materialName = "materialName";
    public static final String COL_Weigh_number = "number";
    public static final String COL_Weigh_grossUnit = "grossUnit";
    public static final String COL_Weigh_tareUnit = "tareUnit";
    public static final String COL_Weigh_grossWeight = "grossWeight";
    public static final String COL_Weigh_tareWeight = "tareWeight";
    public static final String COL_Weigh_incidental = "incidental";
    public static final String COL_Weigh_netWeight = "netWeight";
    public static final String COL_Weigh_deductWeight = "deductWeight";
    public static final String COL_Weigh_dryWeight = "dryWeight";
    public static final String COL_Weigh_unit = "unit";
    public static final String COL_Weigh_billType = "billType";
    public static final String COL_Weigh_weighStatus = "weighStatus";
    public static final String COL_Weigh_billStatus = "billStatus";
    public static final String COL_Weigh_auditTime = "auditTime";
    public static final String COL_Weigh_isContinuousCar = "isContinuousCar";
    public static final String COL_Weigh_isMuchCarry = "isMuchCarry";
    public static final String COL_Weigh_deliveryWarehouse = "deliveryWarehouse";
    public static final String COL_Weigh_unloadWareHouse = "unloadWareHouse";
    public static final String COL_Weigh_grossAdminOrg = "grossAdminOrg";
    public static final String COL_Weigh_tareAdminOrg = "tareAdminOrg";
    public static final String COL_Weigh_grossPoundor = "grossPoundor";
    public static final String COL_Weigh_tarePoundor = "tarePoundor";
    public static final String COL_Weigh_grossPoundTime = "grossPoundTime";
    public static final String COL_Weigh_tarePoundTime = "tarePoundTime";
    public static final String COL_Weigh_id = "id";
    private static final String[] SQL_WM_COLS = new String[]{"noticeBillNumber", "carNumber", "materialNumber", "materialName", "number", "grossUnit", "grossWeight", "tareUnit", "tareWeight", "incidental", "netWeight", "unit", "billType", "weighStatus", "billStatus", "auditTime", "isContinuousCar", "isMuchCarry", "deliveryWarehouse", "unloadWareHouse", "grossAdminOrg", "tareAdminOrg", "grossPoundor", "tarePoundor", "grossPoundTime", "tarePoundTime", "id"};
    public static final int Dyna_F7Number_QSP_DryWeight = 10;
    public static final int Dyna_F7Number_QSP_NetWeight = 20;
    public static final int Dyna_F7Number_QSP_SupplierQty = 30;
    public static final int Dyna_F7Number_QSP_SupplierDryQty = 40;
    public static final int Dyna_F7Number_QSP_IsNull = 50;
    public static final int Dyna_F7Number_CP_ByCase = 10;
    public static final int Dyna_F7Number_CP_ByAverage = 20;
    public static final int Dyna_F7Number_PP_ConPrice = 10;
    public static final int Dyna_F7Number_PP_HQHP = 20;
    public static final int Dyna_F7Number_DCF_FA = 10;
    public static final int Dyna_F7Number_DCF_FB = 20;
    public static final int Dyna_F7Number_DCF_LA = 30;
    public static final DateFormat simpleDateFormatter = BOSLocaleUtil.getDateFormat();
    public static final BigDecimal BigDecimal_Zero = new BigDecimal("0");
    public static final BigDecimal BigDecimal_MaxValue = new BigDecimal("10000000000000");

    public static List getPurCols() {
        return new AbstractList(){

            @Override
            public Object get(int index) {
                return PurCols[index];
            }

            @Override
            public int size() {
                return PurCols.length;
            }
        };
    }

    public static List getQCCols() {
        return new AbstractList(){

            @Override
            public Object get(int index) {
                return QCCols[index];
            }

            @Override
            public int size() {
                return QCCols.length;
            }
        };
    }

    public static List getSQL_WM_COLS() {
        return new AbstractList(){

            @Override
            public Object get(int index) {
                return SQL_WM_COLS[index];
            }

            @Override
            public int size() {
                return SQL_WM_COLS.length;
            }
        };
    }

    public static String getMsg(String key) {
        return HQHPUtil.getMsg(key, null);
    }

    public static String getMsg(String key, Object[] args) {
        String msg = EASResource.getString((String)RESOURCE_FILE, (String)key);
        if (args != null && args.length > 0) {
            msg = MessageFormat.format(msg, args);
        }
        return msg;
    }

    public static boolean isNotNullString(String str) {
        return str != null && !str.equals("");
    }

    public static boolean isNullString(String str) {
        return str == null || str.equals("");
    }

    public static boolean isNullList(List list) {
        return list == null || list.size() == 0;
    }

    public static void fillTableWithList(KDTable table, List list) {
        table.removeRows();
        for (int i = 0; i < list.size(); ++i) {
            IRow row = table.addRow();
            Map rowMap = (Map)list.get(i);
            for (int j = 0; j < table.getColumnCount(); ++j) {
                String key = table.getColumnKey(j);
                row.getCell(key).setValue(rowMap.get(key));
            }
        }
    }

    public static String formatStartDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        return df.format(date);
    }

    public static String formatEndDate(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd 23:59:59");
        return df.format(date);
    }

    public static boolean isZero(BigDecimal d) {
        return BigDecimal_Zero.compareTo(d) == 0;
    }

    public static boolean notZero(BigDecimal d) {
        return !HQHPUtil.isZero(d);
    }

    public static String getVerifyAndCalMsg(Map genResult) {
        if (genResult == null) {
            return "";
        }
        List errorMsgs = (List)genResult.get(Result_Error);
        if (errorMsgs == null) {
            return "";
        }
        int size = errorMsgs.size();
        if (size == 0) {
            return "";
        }
        StringBuffer errorStr = new StringBuffer();
        errorStr.append(HQHPUtil.getMsg("Msg_Error") + "\n");
        for (int i = 0; i < size; ++i) {
            HQHPMsg errorMsg = (HQHPMsg)errorMsgs.get(i);
            String key = errorMsg.getKey();
            Object[] args = errorMsg.getArgs();
            errorStr.append(HQHPUtil.getMsg(key, args));
            if (i == size - 1) continue;
            errorStr.append("\n");
        }
        return errorStr.toString();
    }

    public static void clearAdjustInfo(HQHPCalBillInfo info) {
        if (info.getAdjustDate() == null) {
            return;
        }
        info.setSettleUnitPriceSA(null);
        info.setSettleQuantitySA(null);
        info.setSettleMoneyA(null);
        info.setSettleUnitPriceIA(null);
        info.setAdjustReason(null);
        info.setUniPriceDiffS(null);
        info.setUniPriceDiffI(null);
        info.setQuantityDiffS(null);
        info.setMoneyDiff(null);
        info.setAdjustPerson(null);
        info.setAdjustDate(null);
    }

    public static IObjectPK[] converListToPK(List ids) {
        if (ids.size() == 0) {
            return null;
        }
        Object[] idStrs = ids.toArray();
        int len = idStrs.length;
        ObjectUuidPK[] pks = new ObjectUuidPK[len];
        for (int i = 0; i < len; ++i) {
            pks[i] = new ObjectUuidPK((String)idStrs[i]);
        }
        return pks;
    }

    public static String getInSQLFromSet(Set args) {
        if (args.size() == 0) {
            return "";
        }
        StringBuffer inSql = new StringBuffer();
        Iterator iterator = args.iterator();
        while (iterator.hasNext()) {
            inSql.append("'" + iterator.next() + "',");
        }
        String inSqlStr = inSql.toString();
        return inSqlStr.substring(0, inSqlStr.length() - 1);
    }

    public static void executeBatch(Context ctx, List sqls) throws BOSException {
        if (sqls == null || sqls.size() == 0) {
            return;
        }
        Connection conn = null;
        Statement stmt = null;
        StringBuffer src = new StringBuffer();
        try {
            conn = HQHPUtil.getConnection(ctx);
            stmt = conn.createStatement();
            for (String sql : sqls) {
                stmt.addBatch(sql);
                src.append(sql + ";\n");
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException("Sql1 execute exception : " + src.toString(), (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
    }

    private static Connection getConnection(Context ctx) throws SQLException {
        return EJBFactory.getConnection((Context)ctx);
    }

    public static boolean compareToLowRange(BigDecimal averQcValue, QCLowerLimitEnum lowerComp, BigDecimal lowRange) {
        if (QCLowerLimitEnum.equal.equals((Object)lowerComp)) {
            return averQcValue.equals(lowRange);
        }
        if (QCLowerLimitEnum.graterAndEqual.equals((Object)lowerComp)) {
            return averQcValue.compareTo(lowRange) >= 0;
        }
        if (QCLowerLimitEnum.greater.equals((Object)lowerComp)) {
            return averQcValue.compareTo(lowRange) > 0;
        }
        return QCLowerLimitEnum.isNull.equals((Object)lowerComp);
    }

    public static boolean compareToUpperRange(BigDecimal averQcValue, QCUpperLimitEnum upperComp, BigDecimal upperRange) {
        if (QCUpperLimitEnum.equal.equals((Object)upperComp)) {
            return averQcValue.equals(upperRange);
        }
        if (QCUpperLimitEnum.lessAndEqual.equals((Object)upperComp)) {
            return averQcValue.compareTo(upperRange) <= 0;
        }
        if (QCUpperLimitEnum.less.equals((Object)upperComp)) {
            return averQcValue.compareTo(upperRange) < 0;
        }
        return QCUpperLimitEnum.isNull.equals((Object)upperComp);
    }

    public static void appendFootRow(KDTable table, String[] sumFields, String format) {
        if (sumFields.length == 0) {
            return;
        }
        IRow footRow = null;
        KDTFootManager footRowManager = table.getFootManager();
        if (footRowManager == null) {
            String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
            footRowManager = new KDTFootManager(table);
            footRowManager.addFootView();
            table.setFootManager(footRowManager);
            footRow = footRowManager.addFootRow(0);
            footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
            table.getIndexColumn().setWidthAdjustMode((short)1);
            table.getIndexColumn().setWidth(30);
            footRowManager.addIndexText(0, total);
        } else {
            footRow = footRowManager.getFootRow(0);
            if (footRow == null) {
                footRow = footRowManager.addFootRow(0);
                footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
            }
        }
        Map sumValues = HQHPUtil.getSumValues(table, sumFields);
        int columnCount = table.getColumnCount();
        block0: for (int c = 0; c < columnCount; ++c) {
            String fieldName = table.getColumn(c).getKey();
            for (int i = 0; i < sumFields.length; ++i) {
                if (!sumFields[i].equalsIgnoreCase(fieldName)) continue;
                ICell cell = footRow.getCell(c);
                if (format != null) {
                    cell.getStyleAttributes().setNumberFormat(format);
                }
                cell.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                cell.getStyleAttributes().setFontColor(Color.BLACK);
                cell.setValue(sumValues.get(sumFields[i]));
                continue block0;
            }
        }
        footRow.getStyleAttributes().setBackground(SumRowBGColor);
    }

    public static void appendFootRow(KDTable table, String[] sumFields) {
        HQHPUtil.appendFootRow(table, sumFields, CtrlFormatUtilities.getDecimalFormatString());
    }

    private static Map getSumValues(KDTable table, String[] sumFields) {
        int rowCount = table.getRowCount();
        HashMap<String, BigDecimal> sumValues = new HashMap<String, BigDecimal>();
        for (int i = 0; i < sumFields.length; ++i) {
            BigDecimal tmpSum = new BigDecimal("0");
            for (int j = 0; j < rowCount; ++j) {
                Object value = table.getCell(j, sumFields[i]).getValue();
                if (value == null) continue;
                tmpSum = tmpSum.add(new BigDecimal(value.toString()));
            }
            sumValues.put(sumFields[i], tmpSum);
        }
        return sumValues;
    }

    public static void calcPercentWeight(Context ctx, HQHPCalBillInfo info) throws EASBizException, BOSException {
        HQHPCalBillQcReportEntryCollection qcReportEntry = info.getQcReportEntry();
        int size = qcReportEntry.size();
        if (size == 0) {
            return;
        }
        int priceScale = 4;
        String paramValue = HQHPUtil.getPriceParamValue(ctx, "HQHP002", info.getPurOrgUnit().getId().toString());
        if (!StringUtils.isEmpty((String)paramValue) && !"DEFAULT".equals(paramValue)) {
            priceScale = Integer.parseInt(paramValue);
        }
        BigDecimal sumSettleQuanS = BigDecimal_Zero;
        BigDecimal sumMoneyNoAvg = BigDecimal_Zero;
        for (int i = 0; i < size; ++i) {
            HQHPCalBillQcReportEntryInfo reportEntry = qcReportEntry.get(i);
            BigDecimal conPriceRec = reportEntry.getConPriceRec();
            BigDecimal settleQuanS = reportEntry.getSettleQuanS();
            if (settleQuanS == null) continue;
            sumSettleQuanS = sumSettleQuanS.add(settleQuanS);
            if (conPriceRec == null) continue;
            sumMoneyNoAvg = sumMoneyNoAvg.add(settleQuanS.multiply(conPriceRec)).setScale(2, 4);
        }
        BigDecimal sumMoneyTillLastRow = BigDecimal_Zero;
        BigDecimal percentTillLastRow = BigDecimal_Zero;
        for (int i = 0; i < size; ++i) {
            HQHPCalBillQcReportEntryInfo reportEntry = qcReportEntry.get(i);
            BigDecimal conPriceRec = reportEntry.getConPriceRec();
            BigDecimal settleQuanS = reportEntry.getSettleQuanS();
            BigDecimal percent = BigDecimal_Zero;
            if (settleQuanS != null && HQHPUtil.notZero(sumSettleQuanS)) {
                if (i != size - 1) {
                    percent = settleQuanS.divide(sumSettleQuanS, 4, 4);
                    reportEntry.setPercent(percent);
                    percentTillLastRow = percentTillLastRow.add(percent);
                } else {
                    percent = new BigDecimal("1.00").subtract(percentTillLastRow).setScale(4, 4);
                    reportEntry.setPercent(percent);
                }
            }
            if (i != size - 1) {
                if (conPriceRec == null) continue;
                BigDecimal conPriceAvg = HQHPUtil.multiply(conPriceRec, percent, priceScale);
                reportEntry.setConPriceAvg(conPriceAvg);
                BigDecimal moneyAvg = HQHPUtil.multiply(conPriceAvg, sumSettleQuanS, 2);
                sumMoneyTillLastRow = sumMoneyTillLastRow.add(moneyAvg);
                reportEntry.setMoneyAvg(moneyAvg);
                continue;
            }
            BigDecimal moneyAvg = sumMoneyNoAvg.subtract(sumMoneyTillLastRow);
            reportEntry.setMoneyAvg(moneyAvg);
            BigDecimal conPriceAvg = BigDecimal_Zero;
            if (HQHPUtil.notZero(sumSettleQuanS)) {
                conPriceAvg = moneyAvg.divide(sumSettleQuanS, priceScale, 4);
            }
            reportEntry.setConPriceAvg(conPriceAvg);
        }
    }

    public static int getInt(Object rsObj) {
        return TypeConversionUtils.objToInt((Object)rsObj);
    }

    public static Boolean getBoolean(Object rsObj) {
        return TypeConversionUtils.objToBoolean((Object)rsObj);
    }

    public static BigDecimal multiply(BigDecimal a, BigDecimal b, int scale) {
        if (a == null || b == null) {
            return null;
        }
        BigDecimal r = a.multiply(b);
        r = r.setScale(scale, 4);
        return r;
    }

    public static BigDecimal getPriceInScale(BigDecimal price, int scale) {
        if (price == null) {
            return null;
        }
        return price.setScale(scale, 4);
    }

    public static String getQtyParamValue(Context ctx, String paramNumber, String orgID) throws EASBizException, BOSException {
        String paramValue = QMParamUtil.getParamValue((Context)ctx, (String)paramNumber, (String)orgID);
        return (String)QMParamNumberConstant.QTY_PRECESIONS.get(paramValue);
    }

    public static String getPriceParamValue(Context ctx, String paramNumber, String orgID) throws EASBizException, BOSException {
        String paramValue = QMParamUtil.getParamValue((Context)ctx, (String)paramNumber, (String)orgID);
        return (String)QMParamNumberConstant.PRICE_PRECESIONS.get(paramValue);
    }
}

