/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.common.QMException;
import com.kingdee.eas.qm.common.util.QMPrecisionUtil;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Locale;

public abstract class QMDataRigthCheckHelper {
    private static final String resourceDir = "com.kingdee.eas.qm.qc.QCAutoGenerateResource";

    public static void checkBigDecimalNumberRight(Context ctx, BOSObjectType bosType, IObjectValue value, String[] pros) throws EASBizException, BOSException {
        for (int i = 0; i < pros.length; ++i) {
            Object o = value.get(pros[i]);
            if (!(o instanceof BigDecimal)) continue;
            try {
                QMDataRigthCheckHelper.checkBigDecimalNumberRight((BigDecimal)o);
                continue;
            }
            catch (QMException ex) {
                String msg = QMDataRigthCheckHelper.getWaringMsgTitle(ctx, bosType, pros[i]) + ex.getMessage();
                throw new QMException(QMException.BLANK, (Object[])new String[]{msg});
            }
        }
    }

    public static void checkBigDecimalNumberRight(BigDecimal num) throws EASBizException, BOSException {
        if (num.compareTo(QMPrecisionUtil.BigDecimal_MaxValue) == 1 || num.compareTo(QMPrecisionUtil.BigDecimal_MinValue) == -1) {
            String msg = ResourceBase.getString((String)resourceDir, (String)"35_QMDataRigthCheckHelper", (Locale)ContextUtils.getLocaleFromEnv());
            MessageFormat mf = new MessageFormat(msg);
            String result = mf.format(new String[]{"" + num, "" + QMPrecisionUtil.BigDecimal_MaxValue, "" + QMPrecisionUtil.BigDecimal_MinValue});
            throw new QMException(QMException.BLANK, (Object[])new String[]{result});
        }
    }

    public static void checkObjectNotNullRight(Context ctx, BOSObjectType bosType, IObjectValue value, String[] pros) throws EASBizException, BOSException {
        for (int i = 0; i < pros.length; ++i) {
            Object o = value.get(pros[i]);
            try {
                QMDataRigthCheckHelper.checkObjectNotNullRight(o);
                continue;
            }
            catch (QMException ex) {
                String msg = QMDataRigthCheckHelper.getWaringMsgTitle(ctx, bosType, pros[i]) + ex.getMessage();
                throw new QMException(QMException.BLANK, (Object[])new String[]{msg});
            }
        }
    }

    public static void checkObjectNotNullRight(Object obj) throws EASBizException, BOSException {
        if (obj == null) {
            String msg = ResourceBase.getString((String)resourceDir, (String)"40_QMDataRigthCheckHelper", (Locale)ContextUtils.getLocaleFromEnv());
            throw new QMException(QMException.BLANK, (Object[])new String[]{msg});
        }
    }

    public static String getWaringMsgTitle(Context ctx, BOSObjectType bosType, String proField) throws EASBizException, BOSException {
        IMetaDataLoader loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entityObjectInfo = loader.getEntity(bosType);
        String entityName = entityObjectInfo.getAlias();
        String proName = entityObjectInfo.getPropertyByName(proField).getAlias();
        String msg = ResourceBase.getString((String)resourceDir, (String)"41_QMDataRigthCheckHelper", (Locale)ContextUtils.getLocaleFromEnv());
        MessageFormat mf = new MessageFormat(msg);
        String result = mf.format(new String[]{entityName, proName});
        return result;
    }
}

