/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.qc.verify;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.eas.basedata.framework.util.FMQuerySqlBuilder;
import com.kingdee.eas.basedata.org.QualityOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.qm.basedata.QCItemInfo;
import com.kingdee.eas.qm.basedata.QCStandardInfo;
import com.kingdee.eas.qm.common.util.QMEqualsUtils;
import com.kingdee.eas.qm.common.verify.AbstractVerifyItem;
import com.kingdee.eas.qm.common.verify.IVerifyItem;
import com.kingdee.eas.qm.qc.QCRequestEntryInfo;
import com.kingdee.eas.qm.qc.QCRequestException;
import com.kingdee.eas.qm.qc.QCRequestInfo;
import com.kingdee.eas.qm.qc.QCRequestQcItemEntryInfo;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;

public class QCStandardDelegOrgUnitVerifyItem
extends AbstractVerifyItem
implements IVerifyItem {
    private QCRequestInfo editData;
    private Context ctx;

    public QCStandardDelegOrgUnitVerifyItem(Context ctx, QCRequestInfo info) {
        this.ctx = ctx;
        this.editData = info;
    }

    public boolean verify() throws EASBizException, BOSException {
        for (int i = 0; i < this.editData.getEntrys().size(); ++i) {
            QCRequestEntryInfo entry = this.editData.getEntrys().get(i);
            QCStandardInfo qcStandard = entry.getQcStandard();
            if (qcStandard == null) continue;
            for (int j = 0; j < entry.getQcItemEntrys().size(); ++j) {
                QCRequestQcItemEntryInfo itementry = entry.getQcItemEntrys().get(j);
                if (itementry.getDelegOrgUnit() == null || QMEqualsUtils.equals((Object)this.editData.getQualityOrgUnit(), (Object)itementry.getDelegOrgUnit())) continue;
                this.isAssignedDeleOrg(qcStandard, itementry);
                this.isAssignedQCItem(itementry.getQCItem(), itementry);
                this.isAuditAssignedItem(qcStandard, itementry);
            }
        }
        return true;
    }

    private void isAuditAssignedItem(QCStandardInfo qcStandard, QCRequestQcItemEntryInfo itementry) throws BOSException, EASBizException {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        Locale local = this.ctx.getLocale();
        sb.appendSql("select  st.fnumber, st.fname_" + local + " from T_QM_QCStandardExtendAttr a, T_QM_QCStandard st" + " where a.FCheckedStatus<>2 and a.fparentid = st.fid and  a.FParentID = ");
        sb.appendParam((Object)qcStandard.getId().toString());
        sb.appendSql(" and a.fQualityOrgUnitid=");
        sb.appendParam((Object)itementry.getDelegOrgUnit().getId().toString());
        ResultSet rs = sb.exeQuery(this.ctx);
        try {
            if (rs.next()) {
                throw new QCRequestException(QCRequestException.QCSTANDARDHASNOTAUDIT, new Object[]{itementry.getDelegOrgUnit().getName(), rs.getString(2), rs.getString(1)});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void isAssignedDeleOrg(QCStandardInfo qcStandard, QCRequestQcItemEntryInfo itementry) throws BOSException, EASBizException {
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("select FDATABASEDID   from  T_QM_DataBaseDAssign ");
        sb.appendSql(" where FBOSOBJECTTYPE='C8666A62' and FDATABASEDID in (");
        sb.appendParam((Object)qcStandard.getId().toString());
        sb.appendSql(") and FASSIGNORGUNITID in (");
        sb.appendParam((Object)itementry.getDelegOrgUnit().getId().toString());
        sb.appendSql(")");
        ResultSet rs = sb.exeQuery(this.ctx);
        try {
            if (!rs.next()) {
                throw new QCRequestException(QCRequestException.QCSTANDARDHASNOTASSIGNEDDELORG, new Object[]{qcStandard.getName(), qcStandard.getNumber(), itementry.getDelegOrgUnit().getName()});
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void isAssignedQCItem(QCItemInfo qcItem, QCRequestQcItemEntryInfo itemEntry) throws BOSException, EASBizException {
        if (null == qcItem) {
            return;
        }
        QualityOrgUnitInfo delOrg = itemEntry.getDelegOrgUnit();
        FMQuerySqlBuilder sb = new FMQuerySqlBuilder();
        sb.appendSql("select FDATABASEDID   from  T_QM_DataBaseDAssign ");
        sb.appendSql(" where FBOSOBJECTTYPE='A0346138' and FDATABASEDID in (");
        sb.appendParam((Object)qcItem.getId().toString());
        sb.appendSql(") and FASSIGNORGUNITID in (");
        sb.appendParam((Object)delOrg.getId().toString());
        sb.appendSql(")");
        ResultSet rs = sb.exeQuery(this.ctx);
        try {
            if (!rs.next()) {
                Object[] params = new Object[]{qcItem.getNumber(), qcItem.getName(), delOrg.getName()};
                throw new QCRequestException(QCRequestException.QCITEMHASNOTASSIGNEDDELORG, params);
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
    }
}

