/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.mm.report.util.reportUtil;
import com.kingdee.eas.qm.common.app.QMReportServerBase;
import com.kingdee.eas.qm.common.app.util.QMReportServerUtils;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class QCMMPatrolReportStatisticsServerClass
extends QMReportServerBase {
    private static final String DB_COL_ProductDeptName = "FProductDeptName";
    private static final String DB_COL_DeviceName = "FDeviceName";
    private static final String DB_COL_ClassGroupName = "FClassGroupName";
    private static final String DB_COL_PersonName = "FPersonName";
    private static final String DB_COL_NOTSHOW_STRING = "Others";
    private static final String DB_COL_ProductDeptAlias = "admin";
    private static final String DB_COL_DeviceAlias = "device";
    private static final String DB_COL_ClassGroupAlias = "classGroup";
    private static final String DB_COL_PersonAlias = "person";

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        String prmtQualityOrgUnitnumber = "";
        if (filter.getString("prmtQualityOrgUnit") != null && !"".equals(filter.getString("prmtQualityOrgUnit"))) {
            prmtQualityOrgUnitnumber = reportUtil.StringUtil((String)filter.getString("prmtQualityOrgUnit"));
            StringBuffer sql = new StringBuffer();
            sql.append("select quality.").append(this.getLocalName()).append("  from t_org_quality  quality where quality.Fid in (" + prmtQualityOrgUnitnumber + ") ");
            prmtQualityOrgUnitnumber = QMReportServerUtils.getName((StringBuffer)sql, (Context)this.getContext());
        }
        String dateBizDateFrom = "";
        if (filter.getString("dateBizDateFrom") != null && filter.getString("dateBizDateFrom").length() > 0) {
            dateBizDateFrom = filter.getString("dateBizDateFrom").substring(0, 10);
        }
        String dateBizDateTo = "";
        if (filter.getString("dateBizDateTo") != null && filter.getString("dateBizDateTo").length() > 0) {
            dateBizDateTo = filter.getString("dateBizDateTo").substring(0, 10);
        }
        ReportTitles titles = new ReportTitles();
        titles.AddTitle(0, QMReportServerUtils.getResourceString((String)"com.kingdee.eas.qm.report.QCMMPatrolReportStatisticsResource", (String)"QualityOrgUnitName") + "\uff1a" + prmtQualityOrgUnitnumber);
        titles.AddTitle(1, QMReportServerUtils.getResourceString((String)"com.kingdee.eas.qm.report.QCMMPatrolReportStatisticsResource", (String)"BeginReportDate") + "\uff1a" + dateBizDateFrom);
        titles.AddTitle(2, QMReportServerUtils.getResourceString((String)"com.kingdee.eas.qm.report.QCMMPatrolReportStatisticsResource", (String)"EndReportDate") + "\uff1a" + dateBizDateTo);
        return titles;
    }

    protected String getQCReportTempTable() throws BOSException {
        String tempTableName;
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table QCMMPatrolReportStatistics(");
        createTable.append("FStorageOrgUnitName NVARCHAR(255) DEFAULT('')");
        createTable.append(",FMaterialName NVARCHAR(255) DEFAULT('')");
        createTable.append(",FProductDeptName NVARCHAR(255) DEFAULT('')");
        createTable.append(",FDeviceName NVARCHAR(255) DEFAULT('')");
        createTable.append(",FClassGroupName NVARCHAR(255) DEFAULT('')");
        createTable.append(",FPersonName NVARCHAR(255) DEFAULT('')");
        createTable.append(",FDeliverBaseQty decimal(21,8) DEFAULT(0)");
        createTable.append(",FBaseUnit NVARCHAR(255) DEFAULT('')");
        createTable.append(",FPassBaseQty decimal(21,8) DEFAULT(0)");
        createTable.append(",FUnPassBaseQty decimal(21,8) DEFAULT(0)");
        createTable.append(" ) ");
        try {
            tempTableName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    private String buildWhereFilters(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        String wherefilter = "";
        if (filter.getString("prmtQualityOrgUnit") != null && !"".equals(filter.getString("prmtQualityOrgUnit"))) {
            sb.append(" and patrolReport.fQualityOrgUnitid in(").append(QMReportServerUtils.StringToSql((String)filter.getString("prmtQualityOrgUnit"))).append(" ) ");
        }
        if (filter.getString("comboBillstatus") != null && !"".equals(filter.getString("comboBillstatus")) && !"1000".equals(filter.getString("comboBillstatus"))) {
            sb.append(" and patrolReport.fBillStatus =").append(filter.getString("comboBillstatus"));
        }
        if (filter.getString("prmtqCGroup") != null && !"".equals(filter.getString("prmtqCGroup"))) {
            sb.append(" and patrolReport.FQCGroupID in(").append(QMReportServerUtils.StringToSql((String)filter.getString("prmtqCGroup"))).append(" ) ");
        }
        if (filter.getString("prmtchecker") != null && !"".equals(filter.getString("prmtchecker"))) {
            sb.append(" and patrolReport.FCheckerID in(").append(QMReportServerUtils.StringToSql((String)filter.getString("prmtchecker"))).append(" ) ");
        }
        if (filter.getString("dateBizDateFrom") != null && !"".equals(filter.getString("dateBizDateFrom"))) {
            sb.append(" and patrolReport.freportDate >= to_date('" + filter.getString("dateBizDateFrom") + "')");
        }
        if (filter.getString("dateBizDateTo") != null && !"".equals(filter.getString("dateBizDateTo"))) {
            String date = filter.getString("dateBizDateTo");
            date = date.substring(0, 10);
            date = date.concat(" 23:59:59.999");
            sb.append(" and patrolReport.freportDate <= to_date('" + date + "')");
        }
        if (filter.getString("txtNumberFrom") != null && !"".equals(filter.getString("txtNumberFrom"))) {
            sb.append(" and patrolReport.FNumber >= '" + filter.getString("txtNumberFrom") + "'");
        }
        if (filter.getString("txtNumberTo") != null && !"".equals(filter.getString("txtNumberTo"))) {
            sb.append(" and patrolReport.FNumber <= '" + filter.getString("txtNumberTo") + "'");
        }
        if (filter.getString("prmtMaterial") != null && !"".equals(filter.getString("prmtMaterial"))) {
            sb.append(" and patrolReport.FMaterialID in(").append(QMReportServerUtils.StringToSql((String)filter.getString("prmtMaterial"))).append(" ) ");
        }
        if (filter.getString("prmtPatrolPlan") != null && !"".equals(filter.getString("prmtPatrolPlan"))) {
            sb.append(" and patrolReport.FRoutingInspectionPlanID in(").append(QMReportServerUtils.StringToSql((String)filter.getString("prmtPatrolPlan"))).append(" ) ");
        }
        if (filter.getString("prmtTechLine") != null && !"".equals(filter.getString("prmtTechLine"))) {
            sb.append(" and patrolReport.FStandardRootingID in(").append(QMReportServerUtils.StringToSql((String)filter.getString("prmtTechLine"))).append(" ) ");
        }
        if (filter.getString("prmtWPPhase") != null && !"".equals(filter.getString("prmtWPPhase"))) {
            if (filter.getString("prmtTechLine") != null && !"".equals(filter.getString("prmtTechLine"))) {
                sb.append(" and patrolReport.FOperationID in(").append(this.getOperationId(filter.getString("prmtWPPhase"))).append(" ) ");
            } else if (filter.getString("prmtProductLine") != null && !"".equals(filter.getString("prmtProductLine"))) {
                sb.append(" and patrolReport.FProductLineWPID in(").append(QMReportServerUtils.StringToSql((String)filter.getString("prmtWPPhase"))).append(" ) ");
            }
        }
        if (filter.getString("prmtProductLine") != null && !"".equals(filter.getString("prmtProductLine"))) {
            sb.append(" and patrolReport.FProductLineID in(").append(QMReportServerUtils.StringToSql((String)filter.getString("prmtProductLine"))).append(" ) ");
        }
        if (filter.getString("txtOrderNumber") != null && !"".equals(filter.getString("txtOrderNumber"))) {
            sb.append(" and patrolReport.FSourceBillNumber like '%" + filter.getString("txtOrderNumber") + "%'");
        }
        wherefilter = sb.toString();
        return wherefilter;
    }

    private String getOperationId(String MRWorkProcessEntryID) {
        if (QMStringUtils.isEmpty((String)MRWorkProcessEntryID)) {
            return null;
        }
        String operationId = null;
        String sql = "SELECT FOperationID AS id FROM T_MM_MaterialRWP WHERE fid = '" + MRWorkProcessEntryID + "'";
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
            if (rs != null && rs.next()) {
                operationId = rs.getString("id");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        return QMReportServerUtils.StringToSql(operationId);
    }

    protected String getReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String whereFilters = this.buildWhereFilters(filter);
        String rptTempTableName = this.getQCReportTempTable();
        DbUtil.execute((Context)this.getContext(), (String)this.insertSql(rptTempTableName, whereFilters, filter).toString());
        return rptTempTableName;
    }

    protected String insertSql(String rptTempTableName, String whereFilters, RptParams filter) throws BOSException, EASBizException {
        int i;
        StringBuffer sb = new StringBuffer();
        List dbColNameList = this.getSumAccordingToArray(filter, true);
        List aliasList = this.getSumAccordingToArray(filter, false);
        sb.append("insert into ").append(rptTempTableName);
        sb.append("(FStorageOrgUnitName,FMaterialName");
        for (i = 0; i < dbColNameList.size() && !((String)dbColNameList.get(i)).equals(DB_COL_NOTSHOW_STRING); ++i) {
            sb.append(",");
            sb.append(dbColNameList.get(i));
        }
        sb.append(",FDeliverBaseQty,FBaseUnit,FPassBaseQty,FUnPassBaseQty");
        sb.append(")");
        sb.append(" select ");
        sb.append(" storage.");
        sb.append(this.getLocalName());
        sb.append(" as FStorageOrgUnitName");
        sb.append(", material.");
        sb.append(this.getLocalName());
        sb.append(" as FMaterialName");
        for (i = 0; i < aliasList.size() && !((String)aliasList.get(i)).equals(DB_COL_NOTSHOW_STRING); ++i) {
            sb.append(",");
            sb.append(aliasList.get(i));
            sb.append(".");
            sb.append(this.getLocalName());
            sb.append(" as ");
            sb.append(dbColNameList.get(i));
        }
        sb.append(",sum(ISNULL(patrolReport.FDeliverBaseQty,0)) as FDeliverBaseQty");
        sb.append(",unit.");
        sb.append(this.getLocalName());
        sb.append(" as FBaseUnit");
        sb.append(",sum(ISNULL(patrolReport.FPassBaseQty,0)) as FPassBaseQty");
        sb.append(",sum(ISNULL(patrolReport.FUnPassBaseQty,0)) as FUnPassBaseQty");
        sb.append(" from T_QM_QCMMPatrolReport patrolReport ");
        sb.append(" left join t_bd_material material");
        sb.append(" on patrolReport.fmaterialid = material.fid ");
        sb.append(" left join T_ORG_Admin admin");
        sb.append(" on patrolReport.FProductDeptID = admin.fid ");
        sb.append(" left join T_MM_ClassGroup classGroup");
        sb.append(" on patrolReport.FClassGroupID = classGroup.fid ");
        sb.append(" left join T_MM_Resource device");
        sb.append(" on patrolReport.FDeviceID = device.fid ");
        sb.append(" left join T_BD_Person person");
        sb.append(" on patrolReport.FPersonID = person.fid ");
        sb.append(" left join t_org_storage storage");
        sb.append(" on patrolReport.FStorageOrgUnitID = storage.fid ");
        sb.append(" left join T_BD_MeasureUnit unit");
        sb.append(" on patrolReport.FBaseUnitID = unit.fid ");
        sb.append("  where 1=1  ");
        sb.append(this.buildWhereFilters(filter));
        sb.append(" group by ");
        sb.append(" storage.fid");
        sb.append(", material.fid");
        sb.append(", storage.");
        sb.append(this.getLocalName());
        sb.append(", material.");
        sb.append(this.getLocalName());
        for (i = 0; i < aliasList.size() && !((String)aliasList.get(i)).equals(DB_COL_NOTSHOW_STRING); ++i) {
            sb.append(",");
            sb.append(aliasList.get(i));
            sb.append(".fid");
            sb.append(",");
            sb.append(aliasList.get(i));
            sb.append(".");
            sb.append(this.getLocalName());
        }
        sb.append(",unit.fid");
        sb.append(",unit.");
        sb.append(this.getLocalName());
        sb.append(" order by  ");
        sb.append(" storage.fid");
        sb.append(", material.fid");
        sb.append(", storage.");
        sb.append(this.getLocalName());
        sb.append(", material.");
        sb.append(this.getLocalName());
        for (i = 0; i < aliasList.size() && !((String)aliasList.get(i)).equals(DB_COL_NOTSHOW_STRING); ++i) {
            sb.append(",");
            sb.append(aliasList.get(i));
            sb.append(".fid");
            sb.append(",");
            sb.append(aliasList.get(i));
            sb.append(".");
            sb.append(this.getLocalName());
        }
        sb.append(",unit.fid");
        sb.append(",unit.");
        sb.append(this.getLocalName());
        return sb.toString();
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BaseException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT * ");
        sql.append(" FROM " + tableName + " \n");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString(), (int)start, (int)rows);
        return rs;
    }

    private String getAccordingTo(String accordingToStr, RptParams filter, boolean isColumnName) {
        String selectAccordingTo = null;
        if (filter.getString(accordingToStr) != null && !"".equals(filter.getString(accordingToStr)) && !filter.getString(accordingToStr).equals(Integer.toString(0))) {
            selectAccordingTo = filter.getString(accordingToStr);
            if (isColumnName) {
                if (!"".equals(selectAccordingTo) && selectAccordingTo.equals(Integer.toString(10))) {
                    selectAccordingTo = DB_COL_ProductDeptName;
                }
                if (!"".equals(selectAccordingTo) && selectAccordingTo.equals(Integer.toString(20))) {
                    selectAccordingTo = DB_COL_DeviceName;
                }
                if (!"".equals(selectAccordingTo) && selectAccordingTo.equals(Integer.toString(30))) {
                    selectAccordingTo = DB_COL_ClassGroupName;
                }
                if (!"".equals(selectAccordingTo) && selectAccordingTo.equals(Integer.toString(40))) {
                    selectAccordingTo = DB_COL_PersonName;
                }
            } else {
                if (!"".equals(selectAccordingTo) && selectAccordingTo.equals(Integer.toString(10))) {
                    selectAccordingTo = DB_COL_ProductDeptAlias;
                }
                if (!"".equals(selectAccordingTo) && selectAccordingTo.equals(Integer.toString(20))) {
                    selectAccordingTo = DB_COL_DeviceAlias;
                }
                if (!"".equals(selectAccordingTo) && selectAccordingTo.equals(Integer.toString(30))) {
                    selectAccordingTo = DB_COL_ClassGroupAlias;
                }
                if (!"".equals(selectAccordingTo) && selectAccordingTo.equals(Integer.toString(40))) {
                    selectAccordingTo = DB_COL_PersonAlias;
                }
            }
        }
        return selectAccordingTo;
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader header = super.getReportHeader(reportID, filter);
        String[] dbColNames = new String[]{DB_COL_ProductDeptName, DB_COL_DeviceName, DB_COL_ClassGroupName, DB_COL_PersonName};
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(dbColNames));
        List sumAccordingToNameList = this.getSumAccordingToArray(filter, true);
        for (int i = 0; i < sumAccordingToNameList.size(); ++i) {
            String statisColumn = (String)sumAccordingToNameList.get(i);
            if (!statisColumn.equals(DB_COL_NOTSHOW_STRING)) {
                ArrayList childList = header.getChilds();
                ReportHeader child = null;
                for (int j = 0; j < childList.size(); ++j) {
                    child = (ReportHeader)childList.get(j);
                    if (!statisColumn.equalsIgnoreCase(child.getFieldName())) continue;
                    childList.remove(j);
                    break;
                }
                childList.add(i + 2, child);
                child.setMergeable(true);
                set.remove(sumAccordingToNameList.get(i));
                continue;
            }
            block2: for (String e : set) {
                ArrayList childList = header.getChilds();
                ReportHeader child = null;
                for (int j = 0; j < childList.size(); ++j) {
                    child = (ReportHeader)childList.get(j);
                    if (!e.equalsIgnoreCase(child.getFieldName())) continue;
                    childList.remove(j);
                    continue block2;
                }
            }
            break;
        }
        return header;
    }

    private List getSumAccordingToArray(RptParams filter, boolean isShowColumnName) {
        int i;
        String[] sumAccordingTos = new String[]{"comboSumAccordingToOne", "comboSumAccordingToTwo", "comboSumAccordingToThree", "comboSumAccordingToFour"};
        ArrayList<String> list = new ArrayList<String>(sumAccordingTos.length);
        for (i = 0; i < sumAccordingTos.length; ++i) {
            list.add(i, DB_COL_NOTSHOW_STRING);
        }
        for (i = 0; i < sumAccordingTos.length && filter.getString(sumAccordingTos[i]) != null && !"".equals(filter.getString(sumAccordingTos[i])) && !filter.getString(sumAccordingTos[i]).equals(Integer.toString(0)); ++i) {
            String columnName = this.getAccordingTo(sumAccordingTos[i], filter, isShowColumnName);
            list.set(i, columnName);
        }
        return list;
    }
}

