/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.qm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.report.ReportHeader;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.qm.common.app.QMReportServerBase;
import com.kingdee.eas.qm.common.app.util.QMReportServerUtils;
import com.kingdee.eas.qm.common.util.QMStringUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class QCPurSupplierReport
extends QMReportServerBase {
    protected static final String COL_DpprocessMode = "FDpprocessMode";
    protected Map dpprocessModeMap;

    protected IRowSet getReportData(String reportID, RptParams filter) throws Exception {
        return null;
    }

    protected ReportTitles getReportTitles(String reportID, RptParams filter) throws BaseException {
        String ReqDateTo;
        ReportTitles titles = new ReportTitles();
        StringBuffer sql = new StringBuffer();
        String all = QMReportServerUtils.getResourceString((String)"com.kingdee.eas.qm.report.QCPurSupplierReportResource", (String)"All");
        String QualityOrgUnit = filter.getString("QualityOrgUnit");
        if (!QMStringUtils.isEmpty((String)QualityOrgUnit)) {
            sql.setLength(0);
            sql.append("select ").append(this.getLocalName()).append(" from t_org_quality where fid in(").append(QMReportServerUtils.StringToSql((String)QualityOrgUnit)).append(")");
            QualityOrgUnit = QMReportServerUtils.getName((StringBuffer)sql, (Context)this.getContext());
        } else {
            QualityOrgUnit = all;
        }
        String PurOrgUnit = filter.getString("PurOrgUnit");
        if (!QMStringUtils.isEmpty((String)PurOrgUnit)) {
            sql.setLength(0);
            sql.append("select ").append(this.getLocalName()).append(" from T_ORG_BaseUnit where fid ='").append(PurOrgUnit).append("'");
            PurOrgUnit = QMReportServerUtils.getName((StringBuffer)sql, (Context)this.getContext());
        } else {
            PurOrgUnit = all;
        }
        String Supplier = filter.getString("Supplier");
        if (!QMStringUtils.isEmpty((String)Supplier)) {
            sql.setLength(0);
            sql.append("select ").append(this.getLocalName()).append(" from T_BD_Supplier where fid ='").append(Supplier).append("'");
            Supplier = QMReportServerUtils.getName((StringBuffer)sql, (Context)this.getContext());
        } else {
            Supplier = all;
        }
        String Material = filter.getString("Material");
        if (!QMStringUtils.isEmpty((String)Material)) {
            sql.setLength(0);
            sql.append("select ").append(this.getLocalName()).append(" from T_BD_Material where fid ='").append(Material).append("'");
            Material = QMReportServerUtils.getName((StringBuffer)sql, (Context)this.getContext());
        } else {
            Material = all;
        }
        String ReqDateFrom = filter.getString("ReqDateFrom");
        if (!QMStringUtils.isEmpty((String)ReqDateFrom)) {
            ReqDateFrom = ReqDateFrom.substring(0, 10);
        }
        if (!QMStringUtils.isEmpty((String)(ReqDateTo = filter.getString("ReqDateTo")))) {
            ReqDateTo = ReqDateTo.substring(0, 10);
        }
        titles.AddTitle(0, QMReportServerUtils.getResourceString((String)"com.kingdee.eas.qm.report.QCPurSupplierReportResource", (String)"QualityOrgUnit") + QualityOrgUnit);
        titles.AddTitle(1, QMReportServerUtils.getResourceString((String)"com.kingdee.eas.qm.report.QCPurSupplierReportResource", (String)"PurOrgUnit") + PurOrgUnit);
        titles.AddTitle(2, QMReportServerUtils.getResourceString((String)"com.kingdee.eas.qm.report.QCPurSupplierReportResource", (String)"Supplier") + Supplier);
        titles.AddTitle(3, QMReportServerUtils.getResourceString((String)"com.kingdee.eas.qm.report.QCPurSupplierReportResource", (String)"Material") + Material);
        titles.AddTitle(4, QMReportServerUtils.getResourceString((String)"com.kingdee.eas.qm.report.QCPurSupplierReportResource", (String)"ReqDateFrom") + ReqDateFrom);
        titles.AddTitle(5, QMReportServerUtils.getResourceString((String)"com.kingdee.eas.qm.report.QCPurSupplierReportResource", (String)"ReqDateTo") + ReqDateTo);
        return titles;
    }

    protected String getReportDataForVirtual(String reportID, RptParams filter) throws BaseException {
        String whereFilters = this.buildWhereFilters(filter);
        this.getDpprocessMode(whereFilters);
        String rptTempTableName = this.getMainTempTable();
        DbUtil.execute((Context)this.getContext(), (String)this.insertSql(rptTempTableName, whereFilters));
        this.calculateRate(rptTempTableName);
        this.setTotalRowCount(new Integer(0));
        this.setSort(Boolean.TRUE);
        return rptTempTableName;
    }

    protected void calculateRate(String rptTempTableName) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(rptTempTableName).append(" set FCheckedInTimeRate=(case FDeliverLotCount when 0 ").append("then 0 else (FCheckedInTimeRate*100/FDeliverLotCount) end)").append(",FLotPassRate=(case FCompleteLotCount when 0 ").append("then 0 else (FPassLotCount*100/FCompleteLotCount) end)").append(",FQtyPassRate=(case FCompleteQty when 0 ").append("then 0 else (FPassQty*100/FCompleteQty) end)");
        DbUtil.execute((Context)this.getContext(), (String)sql.toString());
    }

    protected String insertSql(String rptTempTableName, String whereFilters) throws BOSException {
        String qCReportTempTableName = this.getQCReportTempTable();
        DbUtil.execute((Context)this.getContext(), (String)this.insertQCReportSql(qCReportTempTableName, whereFilters));
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(rptTempTableName).append(" select (select q.").append(this.getLocalName()).append(" from t_org_quality q where q.fid = ").append("req.fqualityorgunitid) as FQualityOrgUnit").append(",(select r.").append(this.getLocalName()).append(" from T_ORG_BaseUnit r where r.fid = ").append("req.freqorgunitid) as FReqOrgUnit").append(",(select s.").append(this.getLocalName()).append(" from T_BD_Supplier s where s.fid = ").append("req.fsupplierid) as FSupplier").append(",(select m.fnumber from T_BD_Material m where m.fid = ").append("reqEntry.Fmaterialid) as FMaterialNumber").append(",(select m.").append(this.getLocalName()).append(" from T_BD_Material m where m.fid = ").append("reqEntry.Fmaterialid) as FMaterialName").append(",(select u.").append(this.getLocalName()).append(" from T_BD_MeasureUnit u, T_BD_Material m ").append("where m.fid = reqEntry.Fmaterialid ").append("and m.fbaseunit = u.fid) as FBaseUnit").append(",count(case when (rpt.freportdate < reqEntry.Freqfinishdate ").append("or reqEntry.Freqfinishdate >= getdate()) then 1 else ").append("null end) as FCheckedInTimeLotCount").append(",count(reqEntry.Fid) as FDeliverLotCount").append(",count(rpt.fid) as FCompleteLotCount").append(",count(case rpt.fcheckresult when 10 then 1 else ").append("null end) as FPassLotCount").append(",0 as FLotPassRate").append(",isnull(sum(reqEntry.Fbasedeliverqty),0) as FDeliverQty").append(",sum(case when rpt.fid is null then 0 else ").append("reqEntry.Fbasedeliverqty end) as FCompleteQty").append(",isnull(sum(rpt.fpassqty),0) as FPassQty").append(",0 as FQtyPassRate").append(",isnull(sum(FCompleteItemCount),0) as FCompleteItemCount").append(",isnull(sum(FPassItemCount),0) as FPassItemCount").append(",isnull(sum(FUnpassItemCount),0) as FUnpassItemCount");
        int size = this.dpprocessModeMap.size();
        for (int i = 0; i < size; ++i) {
            sql.append(",isnull(sum(").append(COL_DpprocessMode).append(i).append("),0) as ").append(COL_DpprocessMode).append(i);
        }
        sql.append(" from t_qm_qcrequestentry reqEntry ").append("inner join t_qm_qcrequest req on req.fid=reqEntry.Fparentid ").append("left outer join ").append(qCReportTempTableName).append(" rpt on reqEntry.Fid=rpt.frequestentryid ").append("where 1=1 ").append(whereFilters).append(" group by req.fqualityorgunitid,req.freqorgunitid,").append("req.fsupplierid,reqEntry.Fmaterialid ");
        return sql.toString();
    }

    protected String buildWhereFilters(RptParams filter) {
        StringBuffer sb = new StringBuffer();
        if (filter.getString("QualityOrgUnit") != null && !"".equals(filter.getString("QualityOrgUnit"))) {
            sb.append(" and req.fqualityorgunitid in(").append(QMReportServerUtils.StringToSql((String)filter.getString("QualityOrgUnit"))).append(" ) ");
        }
        if (filter.getString("PurOrgUnit") != null && !"".equals(filter.getString("PurOrgUnit"))) {
            sb.append(" and req.freqorgunitid ='").append(filter.getString("PurOrgUnit")).append("'");
        } else {
            sb.append(" and req.freqorgunitid in(").append("select ur.ffromunitid from ").append("T_ORG_TypeRelation tr, T_ORG_UnitRelation ur ").append("where tr.fid = ur.ftyperelationid ").append("and tr.ffromtype = ").append(3).append(" and tr.ftotype = ").append(32);
            String strQOid = QMReportServerUtils.StringToSql((String)filter.getString("QualityOrgUnit"));
            if (strQOid != null) {
                sb.append(" and ur.ftounitid in(").append(strQOid).append(")");
            }
            sb.append(")");
        }
        if (filter.getString("Supplier") != null && !"".equals(filter.getString("Supplier"))) {
            sb.append(" and req.fsupplierid ='").append(filter.getString("Supplier")).append("'");
        }
        if (filter.getString("Material") != null && !"".equals(filter.getString("Material"))) {
            sb.append(" and reqEntry.fmaterialid ='").append(filter.getString("Material")).append("'");
        }
        if (filter.getString("ReqDateFrom") != null && !"".equals(filter.getString("ReqDateFrom"))) {
            sb.append(" and req.FReqDate >= to_date('" + filter.getString("ReqDateFrom") + "')");
        }
        if (filter.getString("ReqDateTo") != null && !"".equals(filter.getString("ReqDateTo"))) {
            sb.append(" and req.FReqDate <= to_date('" + filter.getString("ReqDateTo").substring(0, 10) + " 23:59:59.999')");
        }
        return sb.toString();
    }

    protected String insertQCReportSql(String qCReportTempTable, String whereFilters) {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into ").append(qCReportTempTable);
        StringBuffer sqlRpt = new StringBuffer(1000);
        sqlRpt.append(" select rpt.fid,rpt.frequestid,rpt.frequestentryid").append(",rpt.freportdate,rpt.fcheckresult ").append(",rpt.fpassbaseqty as fpassqty").append(",(select count(rptEntry.Fqcitemid) from ").append("t_qm_qcreportentry rptEntry where rpt.fid = ").append("rptEntry.Fparentid) as FCompleteItemCount").append(",(select sum(case when rptEntry.Fcheckresult = 10 ").append("then 1 else 0 end) from t_qm_qcreportentry rptEntry ").append("where rpt.fid = rptEntry.Fparentid) as FPassItemCount").append(",(select sum(case when rptEntry.Fcheckresult = 20 then ").append("1 else 0 end) from t_qm_qcreportentry rptEntry ").append("where rpt.fid = rptEntry.Fparentid) as FUnpassItemCount");
        StringBuffer sqlDCP = new StringBuffer(1000);
        sqlDCP.append("select rpt.fid,rpt.frequestid,rpt.frequestentryid").append(" ,rpt.freportdate,rpt.fcheckresult ").append(",rpt.fpassbaseqty as fpassqty").append(",(select count(rptEntry.Fqcitemid) from ").append("t_qm_qcreportentry rptEntry where rpt.fid = ").append("rptEntry.Fparentid) as FCompleteItemCount").append(",(select sum(case when rptEntry.Fcheckresult = 10 ").append("then 1 else 0 end) from t_qm_qcreportentry rptEntry ").append("where rpt.fid = rptEntry.Fparentid) as FPassItemCount").append(",(select sum(case when rptEntry.Fcheckresult = 20 then ").append("1 else 0 end) from t_qm_qcreportentry rptEntry ").append("where rpt.fid = rptEntry.Fparentid) as FUnpassItemCount");
        Iterator it = this.dpprocessModeMap.entrySet().iterator();
        int i = 1;
        while (it.hasNext()) {
            Map.Entry m = it.next();
            sqlRpt.append(",(select sum(rptNcpp.fbaseqty ) from t_qm_qcreportncpprentry rptNcpp ").append("where rpt.fid = rptNcpp.Fparentid ").append("and rptNcpp.Fdpprocessmodeid = '").append((String)m.getKey()).append("' ").append(") as ").append(COL_DpprocessMode).append(i);
            sqlDCP.append(",( select sum(rEntry.fbaseqty) from t_qm_qcrejectprocess r,T_QM_QCRejectRstEntry rEntry").append(" where r.frequestid=req.fid and r.frequestentryid=reqEntry.fid and r.fid=rEntry.fparentid ").append(" and rpt.fid= r.fsourcebillid ").append(" and r.fbillstatus=30 and rEntry.Fdpprocessmodeid = '").append((String)m.getKey()).append("' ").append(") as ").append(COL_DpprocessMode).append(i);
            ++i;
        }
        sqlRpt.append(" from t_qm_qcreport rpt, t_qm_qcrequest req,t_qm_qcrequestentry reqEntry ").append("where rpt.frequestid = req.fid and rpt.fbillstatus=30 ").append("and rpt.FIsUsedReport=1 and req.fbillstatus=30 and rpt.frejectprocessmode=10 ").append("and reqEntry.fid=rpt.frequestentryid ").append(whereFilters);
        sqlDCP.append(" from t_qm_qcreport rpt, t_qm_qcrequest req,t_qm_qcrequestentry reqEntry ").append("where rpt.frequestid = req.fid and rpt.fbillstatus=30 ").append("and rpt.FIsUsedReport=1 and req.fbillstatus=30 and rpt.frejectprocessmode=20 ").append("and reqEntry.fid=rpt.frequestentryid ").append(whereFilters);
        sql.append(sqlRpt.toString()).append(" union ").append(sqlDCP);
        return sql.toString();
    }

    protected String getQCReportTempTable() throws BOSException {
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table  newQCReport ( ");
        createTable.append("fid varchar(44)");
        createTable.append(",frequestid varchar(44)");
        createTable.append(",frequestentryid varchar(44)");
        createTable.append(",freportdate DATETIME");
        createTable.append(",fcheckresult int");
        createTable.append(",fpassqty decimal(21,8) DEFAULT(0)");
        createTable.append(",FCompleteItemCount int DEFAULT(0)");
        createTable.append(",FPassItemCount int DEFAULT(0)");
        createTable.append(",FUnpassItemCount int DEFAULT(0)");
        createTable.append(this.createDpprocessModeColum());
        createTable.append(" ) ");
        String tempTableName = super.buildUserTempTable(createTable.toString());
        this.tempTables.add(tempTableName);
        return tempTableName;
    }

    protected void getDpprocessMode(String whereFilters) throws BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("select distinct temptable.Fdpprocessmodeid, temptable.").append(this.getLocalName()).append(" from (select distinct rptNcpp.Fdpprocessmodeid, dp.").append(this.getLocalName()).append(" from t_qm_qcreport rpt,t_qm_qcreportncpprentry rptNcpp,").append("t_qm_qcrequest req,t_qm_dpprocessmode dp,t_qm_qcrequestentry reqEntry ").append("where rpt.frequestid = req.fid and rpt.fid = rptNcpp.Fparentid ").append("and reqEntry.fid=rpt.frequestentryid and rpt.fbillstatus=30 and rpt.FIsUsedReport = 1").append("and rptNcpp.Fdpprocessmodeid = dp.fid and req.fid=reqEntry.Fparentid ").append(whereFilters);
        sb.append(" union select distinct rpe.Fdpprocessmodeid, dp.").append(this.getLocalName()).append(" from t_qm_qcrejectprocess rp, T_QM_QCRejectRstEntry rpe, t_qm_qcreport rpt, ").append(" t_qm_qcrequest req,t_qm_dpprocessmode dp,t_qm_qcrequestentry reqEntry ").append(" where rp.frequestid = req.fid and rp.fid = rpe.Fparentid and rpt.fid= rp.fsourcebillid ").append(" and reqEntry.fid=rp.frequestentryid and rp.fbillstatus=30 and rpt.FIsUsedReport = 1 ").append(" and rpe.Fdpprocessmodeid = dp.fid and req.fid=reqEntry.Fparentid ").append(whereFilters).append(")").append(" as temptable ");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sb.toString());
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        try {
            while (rs.next()) {
                map.put(rs.getString("Fdpprocessmodeid"), rs.getString(this.getLocalName()));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        this.dpprocessModeMap = map;
    }

    protected String getMainTempTable() throws BOSException {
        String tempTableName;
        StringBuffer createTable = new StringBuffer();
        createTable.append("create table  QCPurSupplierReport ( ");
        createTable.append("FQualityOrgUnit NVARCHAR(255) DEFAULT(' ')");
        createTable.append(",FReqOrgUnit NVARCHAR(255) DEFAULT(' ')");
        createTable.append(",FSupplier  NVARCHAR(255) DEFAULT(' ')");
        createTable.append(",FMaterialNumber NVARCHAR(80) default(' ')");
        createTable.append(",FMaterialName NVARCHAR(255) default(' ')");
        createTable.append(",FBaseUnit NVARCHAR(255) default(' ')");
        createTable.append(",FCheckedInTimeRate decimal(21,8) DEFAULT(0)");
        createTable.append(",FDeliverLotCount int default(0) ");
        createTable.append(",FCompleteLotCount int default(0) ");
        createTable.append(",FPassLotCount int default(0) ");
        createTable.append(",FLotPassRate decimal(21,8) DEFAULT(0)");
        createTable.append(",FDeliverQty decimal(21,8) DEFAULT(0)");
        createTable.append(",FCompleteQty decimal(21,8) DEFAULT(0)");
        createTable.append(",FPassQty decimal(21,8) DEFAULT(0)");
        createTable.append(",FQtyPassRate decimal(21,8) DEFAULT(0)");
        createTable.append(",FCompleteItemCount int DEFAULT(0)");
        createTable.append(",FPassItemCount int DEFAULT(0)");
        createTable.append(",FUnpassItemCount int DEFAULT(0)");
        createTable.append(this.createDpprocessModeColum());
        createTable.append(" ) ");
        try {
            tempTableName = TempTablePool.getInstance((Context)this.getContext()).createTempTable(createTable.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    protected String createDpprocessModeColum() {
        StringBuffer dpprocessMode = new StringBuffer();
        int size = this.dpprocessModeMap.size();
        for (int i = 0; i < size; ++i) {
            dpprocessMode.append(",").append(COL_DpprocessMode).append(i).append(" decimal(21,8) DEFAULT(0)");
        }
        return dpprocessMode.toString();
    }

    protected ReportHeader getReportHeader(String reportID, RptParams filter) throws Exception {
        ReportHeader header = super.getReportHeader(reportID, filter);
        if (this.dpprocessModeMap.size() > 0) {
            String dpprocessModeHead = QMReportServerUtils.getResourceString((String)"com.kingdee.eas.qm.report.QCPurSupplierReportResource", (String)"DpprocessMode");
            String QTY = QMReportServerUtils.getResourceString((String)"com.kingdee.eas.qm.report.QCPurSupplierReportResource", (String)"QTY");
            ReportHeader dpprocessMode = header.addChild("dpprocessMode", dpprocessModeHead);
            dpprocessMode.setCaption(dpprocessModeHead);
            dpprocessMode.setFieldName("dpprocessMode");
            dpprocessMode.setIndex(110);
            dpprocessMode.setLevel(1);
            dpprocessMode.setType(1);
            dpprocessMode.setWidth(75);
            dpprocessMode.setAlign(3);
            Iterator it = this.dpprocessModeMap.entrySet().iterator();
            if (this.dpprocessModeMap.size() == 1) {
                Map.Entry m = it.next();
                dpprocessMode.setCaption(dpprocessModeHead + ":\n" + (String)m.getValue() + QTY);
                dpprocessMode.setWidth(100);
                dpprocessMode.setFieldName("FDpprocessMode0");
            } else {
                int i = 0;
                while (it.hasNext()) {
                    Map.Entry m = it.next();
                    ReportHeader child = dpprocessMode.addChild(COL_DpprocessMode + i, (String)m.getValue() + QTY);
                    child.setIndex(110 + ++i * 5);
                    child.setLevel(2);
                    child.setType(1);
                    child.setAlign(3);
                    child.setWidth(100);
                    child.setType(2);
                }
            }
        }
        for (ReportHeader rh : header.getChilds()) {
            if (rh.getChilds() != null && rh.getChilds().size() > 0) {
                for (ReportHeader rhChild : rh.getChilds()) {
                    if (!rhChild.getFieldName().equals("FQtyPassRate") && !rhChild.getFieldName().equals("FLotPassRate") && !rhChild.getFieldName().equals("FDeliverQty") && !rhChild.getFieldName().equals("FCompleteQty") && !rhChild.getFieldName().equals("FPassQty") && !rhChild.getFieldName().equals("FQtyPassRate") && !rhChild.getFieldName().equals("FCompleteItemCount") && !rhChild.getFieldName().equals("FPassItemCount") && !rhChild.getFieldName().equals("FUnpassItemCount")) continue;
                    rhChild.setType(2);
                }
                continue;
            }
            if (!rh.getFieldName().equals("FCheckedInTimeRate")) continue;
            rh.setType(2);
        }
        return header;
    }

    public IRowSet getDataForOnePage(String reportID, RptParams filter, String tableName, int start, int rows) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM ").append(tableName).append(" ORDER BY FQualityOrgUnit asc,FReqOrgUnit asc").append(",FSupplier asc,FMaterialNumber asc");
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString(), (int)start, (int)rows);
        return rs;
    }
}

