/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bot.BOTMappingCollection;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.app.BOTMappingHelper;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTPException;
import com.kingdee.eas.base.btp.BTPException;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseFactory;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseInfo;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceProvider;
import com.kingdee.eas.basedata.scm.sd.sale.PriceCondition;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PriceProviderFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillEntryCollection;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillFactory;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillInfo;
import com.kingdee.eas.scm.sd.channel.ChannelSaleIssueBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.ChannelSaleIssueBillFactory;
import com.kingdee.eas.scm.sd.channel.ChannelSaleIssueBillInfo;
import com.kingdee.eas.scm.sd.channel.app.AbstractAutoBillProcessor;
import com.kingdee.eas.scm.sd.channel.app.IAutoBillProcessor;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryCollection;
import com.kingdee.eas.scm.sd.sale.SaleReturnsEntryInfo;
import com.kingdee.eas.scm.sd.sale.SaleReturnsFactory;
import com.kingdee.eas.scm.sd.sale.SaleReturnsInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class AutoInWarehsProcessor
extends AbstractAutoBillProcessor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.channel.app.AutoInWarehsProcessor");
    private static final BigDecimal Hundred = new BigDecimal("100.0");
    private static final BigDecimal ONE = new BigDecimal("1.00");
    private static final BigDecimal DONE = new BigDecimal("-1");
    private static final String BOSTYPE_SALERETURNS = new SaleReturnsInfo().getBOSType().toString();
    private PriceParamInfo priceParamInfo = null;

    private AutoInWarehsProcessor() {
    }

    public static IAutoBillProcessor getInstance() {
        return new AutoInWarehsProcessor();
    }

    @Override
    public void _autoCreate(Context ctx, SCMBillBaseInfo billInfo) throws EASBizException, BOSException {
        ChannelInWarehsBillInfo tempBillInfo = (ChannelInWarehsBillInfo)billInfo;
        if (tempBillInfo.getInWarehsType() != null && tempBillInfo.getInWarehsType().getValue() == 3) {
            ChannelInWarehsBillEntryCollection collection = tempBillInfo.getEntries();
            ChannelInWarehsBillInfo tempReturnBill = new ChannelInWarehsBillInfo();
            tempReturnBill = (ChannelInWarehsBillInfo)tempBillInfo.clone();
            tempReturnBill.getEntries().clear();
            ChannelInWarehsBillInfo tempSaleIssueBill = new ChannelInWarehsBillInfo();
            tempSaleIssueBill = (ChannelInWarehsBillInfo)tempBillInfo.clone();
            tempSaleIssueBill.getEntries().clear();
            int size = collection.size();
            for (int i = 0; i < size; ++i) {
                ChannelInWarehsBillEntryInfo entryInfo = collection.get(i);
                if (entryInfo.getProvideType() != null && entryInfo.getProvideType().getValue() == 1) {
                    tempReturnBill.getEntries().add(entryInfo);
                }
                if (entryInfo.getProvideType() == null || entryInfo.getProvideType().getValue() != 2) continue;
                tempSaleIssueBill.getEntries().add(entryInfo);
            }
            if (tempReturnBill.getEntries().size() > 0) {
                this.createSaleReturnBill(ctx, this.updateQtyByBillType(tempReturnBill, false));
            }
            if (tempSaleIssueBill.getEntries().size() > 0) {
                this.createChannelSaleIssueBill(ctx, tempSaleIssueBill);
            }
        }
    }

    private ChannelInWarehsBillInfo updateQtyByBillType(ChannelInWarehsBillInfo billInfo, boolean flag) {
        if (billInfo == null || billInfo != null && billInfo.getInWarehsType() == null) {
            return null;
        }
        if (billInfo.getInWarehsType().getValue() == 3) {
            ChannelInWarehsBillEntryCollection entries = billInfo.getEntries();
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                ChannelInWarehsBillEntryInfo entryInfo = entries.get(i);
                entryInfo.setAssistQty(this.dealNegativeQty(entryInfo.getAssistQty(), flag));
                entryInfo.setAssociateQty(this.dealNegativeQty(entryInfo.getAssociateQty(), flag));
                entryInfo.setBaseQty(this.dealNegativeQty(entryInfo.getBaseQty(), flag));
                entryInfo.setQty(this.dealNegativeQty(entryInfo.getQty(), flag));
                entryInfo.setAmount(this.dealNegativeQty(entryInfo.getAmount(), flag));
                entryInfo.setLocalAmount(this.dealNegativeQty(entryInfo.getAmount(), flag));
            }
        }
        return billInfo;
    }

    private BigDecimal dealNegativeQty(BigDecimal qty, boolean flag) {
        if (flag) {
            if (qty != null && qty.compareTo(ZERO) > 0) {
                qty = qty.multiply(DONE);
            }
        } else if (qty != null && qty.compareTo(ZERO) < 0) {
            qty = qty.multiply(DONE);
        }
        return qty;
    }

    private void createChannelSaleIssueBill(Context ctx, ChannelInWarehsBillInfo siInfo) throws BOSException, EASBizException {
        try {
            BTPTransformResult result = this.createBillByBotp(ctx, siInfo);
            this.updateBillInfo(ctx, siInfo, result);
            this.saveBotpBill(result, ctx);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void createSaleReturnBill(Context ctx, ChannelInWarehsBillInfo siInfo) throws BOSException, EASBizException {
        try {
            BTPTransformResult result = this.createSaleReturnsBillByBotp(ctx, siInfo);
            this.saveBotpBill(result, ctx);
            this.updateSaleReturnBillInfo(ctx, siInfo, result);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected IObjectPK[] saveBotpBill(BTPTransformResult result, Context ctx) throws BOSException, EASBizException {
        if (result == null) {
            return null;
        }
        IBTPManager iBtpManager = BTPManagerFactory.getLocalInstance((Context)ctx);
        IObjectCollection destBillCols = result.getBills();
        BOTRelationCollection botRelationCols = result.getBOTRelationCollection();
        IObjectPK[] pks = new IObjectPK[destBillCols.size()];
        int count = destBillCols.size();
        for (int i = 0; i < count; ++i) {
            CoreBillBaseInfo destBillInfo = (CoreBillBaseInfo)destBillCols.getObject(i);
            pks[i] = iBtpManager.saveRelations(destBillInfo, botRelationCols);
        }
        return pks;
    }

    private void updateBillInfo(Context ctx, ChannelInWarehsBillInfo siInfo, BTPTransformResult result) throws EASBizException, BOSException {
        if (result == null) {
            return;
        }
        this.setHeadInfo(ctx, siInfo, result);
        this.setEntryPrecision(ctx, result);
    }

    private void updateSaleReturnBillInfo(Context ctx, ChannelInWarehsBillInfo siInfo, BTPTransformResult result) throws EASBizException, BOSException {
        if (result == null) {
            return;
        }
        try {
            CoreBaseCollection coreBaseColl = this.setSaleReturnHeadInfo(ctx, siInfo, result);
            if (coreBaseColl != null) {
                SaleReturnsFactory.getLocalInstance((Context)ctx).update(coreBaseColl);
            }
            siInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
            int j = siInfo.getEntries().size();
            for (int i = 0; i < j; ++i) {
                siInfo.getEntries().get(i).setBaseStatus(EntryBaseStatusEnum.AUDITED);
            }
            this.updateQtyByBillType(siInfo, true);
            ChannelInWarehsBillFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(siInfo.getId()), siInfo);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void setHeadInfo(Context ctx, ChannelInWarehsBillInfo siInfo, BTPTransformResult result) throws EASBizException, BOSException {
        ICodingRuleManager manager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        Map currencyMap = this.getCurrencyMap(ctx, result);
        int size = result.getBills().size();
        for (int i = 0; i < size; ++i) {
            ChannelSaleIssueBillInfo ciwBillInfo = (ChannelSaleIssueBillInfo)result.getBills().getObject(i);
            if (manager.getCodingRule((IObjectValue)ciwBillInfo, ciwBillInfo.getSaleOrgUnit().getId().toString()) == null) {
                ciwBillInfo.setNumber("*" + siInfo.getNumber());
            }
            ciwBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            ciwBillInfo.setLastUpdateTime(null);
            ciwBillInfo.setAuditTime(null);
            ciwBillInfo.setModificationTime(null);
            CurrencyInfo curInfo = (CurrencyInfo)currencyMap.get(ciwBillInfo.getCurrency().getId().toString());
            ciwBillInfo.setCurrencyPrecision(curInfo.getPrecision());
            curInfo = (CurrencyInfo)currencyMap.get(ciwBillInfo.get("baseCurId"));
            if (curInfo == null) continue;
            ciwBillInfo.setLocalCurPrecision(curInfo.getPrecision());
            ExchangeRateInfo rateInfo = SCMServerUtils.getExchangeRate((Context)ctx, (CompanyOrgUnitInfo)((CompanyOrgUnitInfo)ciwBillInfo.get("couInfo")), (IObjectPK)new ObjectUuidPK(ciwBillInfo.getCurrency().getId()), (IObjectPK)new ObjectUuidPK(curInfo.getId().toString()));
            ciwBillInfo.setExchangeRate(rateInfo == null ? new BigDecimal("1.00") : rateInfo.getConvertRate());
            ciwBillInfo.setExRatePrecision(rateInfo == null ? 2 : rateInfo.getPrecision());
        }
    }

    private CoreBaseCollection setSaleReturnHeadInfo(Context ctx, ChannelInWarehsBillInfo siInfo, BTPTransformResult result) throws EASBizException, BOSException, SQLException {
        this.priceParamInfo = PriceParamFactory.getLocalInstance((Context)ctx).getParameter(siInfo.getCU().getId().toString());
        ICodingRuleManager manager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        CoreBaseCollection colBaseColl = new CoreBaseCollection();
        int size = result.getBills().size();
        for (int i = 0; i < size; ++i) {
            SaleReturnsInfo saleReturnsInfo = (SaleReturnsInfo)result.getBills().getObject(i);
            if (manager.getCodingRule((IObjectValue)saleReturnsInfo, saleReturnsInfo.getSaleOrgUnit().getId().toString()) == null) {
                saleReturnsInfo.setNumber("*" + siInfo.getNumber());
            }
            saleReturnsInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            saleReturnsInfo.setLastUpdateTime(null);
            saleReturnsInfo.setAuditTime(null);
            saleReturnsInfo.setModificationTime(null);
            ChannelBaseInfo channelInfo = ChannelBaseFactory.getLocalInstance((Context)ctx).getChannelBaseInfo((IObjectPK)new ObjectUuidPK(siInfo.getChannel().getId()));
            CustomerInfo customerInfo = channelInfo.getCustomer();
            customerInfo = CustomerFactory.getLocalInstance((Context)ctx).getCustomerInfo((IObjectPK)new ObjectUuidPK(channelInfo.getCustomer().getId()));
            saleReturnsInfo.setOrderCustomer(customerInfo);
            saleReturnsInfo.setReturnsCustomer(customerInfo);
            try {
                saleReturnsInfo.setSalePerson(this.getSalePerson(ctx, customerInfo.getId().toString(), saleReturnsInfo.getSaleOrgUnit().getId().toString()));
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            saleReturnsInfo.setIsInTax(true);
            saleReturnsInfo.setIsCentralBalance(false);
            saleReturnsInfo.setIsSquareBalance(false);
            saleReturnsInfo.setCompanyOrgUnit(this.getCompanyOrgUnit(ctx, OrgType.Sale, OrgType.Company, saleReturnsInfo.getSaleOrgUnit().getId().toString()));
            CurrencyInfo currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(saleReturnsInfo.getCompanyOrgUnit().getBaseCurrency().getId()));
            saleReturnsInfo.setCurrency(currencyInfo);
            if (saleReturnsInfo.getStorageOrgUnit() == null) {
                saleReturnsInfo.setStorageOrgUnit(this.getStorageOrgUnit(ctx, channelInfo.getId().toString(), saleReturnsInfo.getSaleOrgUnit().getId().toString()));
            }
            this.setSaleReturnsEntry(ctx, siInfo, saleReturnsInfo);
            saleReturnsInfo.setStorageOrgUnit(null);
            colBaseColl.add((CoreBaseInfo)saleReturnsInfo);
        }
        return colBaseColl;
    }

    private CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, OrgType srcOrgType, OrgType destOrgType, String saleOrgUnitID) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        int iSrcOrg = srcOrgType.getValue();
        int iDestOrg = destOrgType.getValue();
        CompanyOrgUnitInfo object = new CompanyOrgUnitInfo();
        OrgUnitCollection collection = iOrgRelation.getToUnit(saleOrgUnitID, iSrcOrg, iDestOrg);
        if (collection.size() > 0 && collection.get(0) instanceof CompanyOrgUnitInfo) {
            object = (CompanyOrgUnitInfo)collection.get(0);
        }
        return object;
    }

    private StorageOrgUnitInfo getStorageOrgUnit(Context ctx, String channelID, String saleOrgID) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        Object[] params = new Object[]{channelID, saleOrgID};
        StorageOrgUnitInfo storageOrgUnitInfo = null;
        try {
            sql.append(" select T_BD_ChannelSaleInfo.FID as FID, T_BD_ChannelSaleInfo.FSaleOrgUnitID as FSaleOrgUnitID, T_BD_ChannelSaleInfo.FStorageOrgUnitID as FStorageOrgUnitID ");
            sql.append(" from T_BD_ChannelSaleInfo LEFT OUTER JOIN T_ORG_Sale ON T_BD_ChannelSaleInfo.FSaleOrgUnitID = T_ORG_Sale.FID");
            sql.append(" WHERE T_BD_ChannelSaleInfo.FChannelBaseID = ? and T_ORG_Sale.FID = ? ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
            if (rowSet != null && rowSet.next()) {
                storageOrgUnitInfo = StorageOrgUnitFactory.getLocalInstance((Context)ctx).getStorageOrgUnitInfo((IObjectPK)new ObjectUuidPK(rowSet.getString("FStorageOrgUnitID")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return storageOrgUnitInfo;
    }

    private PersonInfo getSalePerson(Context ctx, String customerId, String saleOrgUnitId) throws BOSException, SQLException, EASBizException {
        PersonInfo personInfo = null;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FPERSONID FROM T_BD_CustomerSaleInfo CSI LEFT OUTER JOIN T_BD_CustomerSaler CS ");
        sql.append(" ON CS.FCustomerSaleID = CSI.FID");
        sql.append(" WHERE CSI.FID = '").append(customerId).append("' AND ");
        sql.append(" CSI.FSaleOrgID = '").append(saleOrgUnitId).append("'");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rowSet != null) {
            if (rowSet.next()) {
                personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(rowSet.getString("PERSONID")));
            } else {
                String personId = null;
                MetaDataPK mainQueryPK = new MetaDataPK("com.kingdee.eas.scm.sd.channel.app", "SalePersonForChannelQuery");
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("saleOrg.id", (Object)saleOrgUnitId, CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1), CompareType.EQUALS));
                viewInfo.setFilter(filterInfo);
                IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
                exec.setObjectView(viewInfo);
                IRowSet rs = exec.executeQuery();
                if (rs.next()) {
                    personId = rs.getString("person.id");
                    personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
                } else {
                    EntityViewInfo viewInfoAll = new EntityViewInfo();
                    FilterInfo filterInfoAll = new FilterInfo();
                    filterInfoAll.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1), CompareType.EQUALS));
                    viewInfoAll.setFilter(filterInfoAll);
                    IQueryExecutor execAll = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)mainQueryPK);
                    execAll.setObjectView(viewInfoAll);
                    IRowSet rsAll = execAll.executeQuery();
                    if (rsAll.next()) {
                        personId = rsAll.getString("person.id");
                        personInfo = PersonFactory.getLocalInstance((Context)ctx).getPersonInfo((IObjectPK)new ObjectUuidPK(personId));
                    }
                }
            }
        }
        return personInfo;
    }

    public void setEntryPrecision(Context ctx, BTPTransformResult result) throws EASBizException, BOSException {
        Map mmuMap = this.getMultiMeasureUnitMap(ctx, result);
        Map matMap = this.getMateiralMap(ctx, result);
        int size = result.getBills().size();
        for (int i = 0; i < size; ++i) {
            ChannelSaleIssueBillInfo ciwBillInfo = (ChannelSaleIssueBillInfo)result.getBills().getObject(i);
            int entrySize = ciwBillInfo.getEntries().size();
            for (int k = 0; k < entrySize; ++k) {
                MultiMeasureUnitInfo mmuInfo;
                ChannelSaleIssueBillEntryInfo entryInfo = ciwBillInfo.getEntries().get(k);
                if (entryInfo.getUnit() != null) {
                    mmuInfo = (MultiMeasureUnitInfo)mmuMap.get(entryInfo.getMaterial().getId().toString() + entryInfo.getUnit().getId().toString());
                    entryInfo.setUnitPrecision(mmuInfo == null ? 0 : mmuInfo.getQtyPrecision());
                }
                if (entryInfo.getBaseUnit() != null) {
                    mmuInfo = (MultiMeasureUnitInfo)mmuMap.get(entryInfo.getMaterial().getId().toString() + entryInfo.getBaseUnit().getId().toString());
                    entryInfo.setBaseUnitPrecision(mmuInfo == null ? 0 : mmuInfo.getQtyPrecision());
                }
                if (entryInfo.getAssistUnit() != null) {
                    mmuInfo = (MultiMeasureUnitInfo)mmuMap.get(entryInfo.getMaterial().getId().toString() + entryInfo.getAssistUnit().getId().toString());
                    entryInfo.setAssistUnitPrecision(mmuInfo == null ? 0 : mmuInfo.getQtyPrecision());
                }
                entryInfo.setPricePrecision(((MaterialInfo)matMap.get(entryInfo.getMaterial().getId().toString())).getPricePrecision());
                if (entryInfo.getAmount() == null || ciwBillInfo.getExchangeRate() == null) continue;
                entryInfo.setLocalAmount(entryInfo.getAmount().multiply(ciwBillInfo.getExchangeRate()));
                entryInfo.setLocalAmount(entryInfo.getLocalAmount().setScale(ciwBillInfo.getLocalCurPrecision(), 4));
            }
        }
    }

    public void setSaleReturnsEntry(Context ctx, ChannelInWarehsBillInfo siInfo, SaleReturnsInfo saleReturnsInfo) throws EASBizException, BOSException, SQLException {
        SaleReturnsEntryCollection collection = saleReturnsInfo.getEntries();
        String[] materialStrId = new String[collection.size()];
        String[] unitStrId = new String[collection.size()];
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            SaleReturnsEntryInfo entryInfo = collection.get(i);
            materialStrId[i] = entryInfo.getMaterial().getId().toString();
            unitStrId[i] = entryInfo.getUnit().getId().toString();
        }
        Map taxRateList = this.getCurrentRate(ctx, materialStrId, saleReturnsInfo.getSaleOrgUnit().getId().toString());
        BigDecimal taxRate = null;
        saleReturnsInfo.setTotalAmount(ZERO);
        saleReturnsInfo.setTotalTax(ZERO);
        saleReturnsInfo.setTotalTaxAmount(ZERO);
        int size2 = collection.size();
        for (int i = 0; i < size2; ++i) {
            SaleReturnsEntryInfo entryInfo = collection.get(i);
            if (entryInfo.getMaterial().getId() != null) {
                taxRate = taxRateList.get(entryInfo.getMaterial().getId().toString()) != null ? new BigDecimal(taxRateList.get(entryInfo.getMaterial().getId().toString()).toString()) : ZERO;
            }
            entryInfo.setTaxPrice(siInfo.getEntries().get(i).getPrice());
            entryInfo.setAmount(siInfo.getEntries().get(i).getAmount());
            entryInfo.setQty(siInfo.getEntries().get(i).getQty());
            saleReturnsInfo.setTotalAmount(saleReturnsInfo.getTotalAmount().add(entryInfo.getAmount()));
            saleReturnsInfo.setTotalTax(saleReturnsInfo.getTotalTax().add(entryInfo.getTax()));
            saleReturnsInfo.setTotalTaxAmount(saleReturnsInfo.getTotalTaxAmount().add(entryInfo.getTaxAmount()));
            entryInfo.setLocalAmount(SCMUtils.convertAmountByCompany((Context)ctx, (BigDecimal)entryInfo.getAmount(), (CompanyOrgUnitInfo)saleReturnsInfo.getCompanyOrgUnit(), (CurrencyInfo)saleReturnsInfo.getCurrency()));
            entryInfo.setLocalTax(SCMUtils.convertAmountByCompany((Context)ctx, (BigDecimal)entryInfo.getTax(), (CompanyOrgUnitInfo)saleReturnsInfo.getCompanyOrgUnit(), (CurrencyInfo)saleReturnsInfo.getCurrency()));
            entryInfo.setLocalTaxAmount(SCMUtils.convertAmountByCompany((Context)ctx, (BigDecimal)entryInfo.getTaxAmount(), (CompanyOrgUnitInfo)saleReturnsInfo.getCompanyOrgUnit(), (CurrencyInfo)saleReturnsInfo.getCurrency()));
            entryInfo.setStorageOrgUnit(saleReturnsInfo.getStorageOrgUnit());
            CustomerInfo customerInfo = saleReturnsInfo.getOrderCustomer();
            entryInfo.setPaymentCustomer(customerInfo);
            entryInfo.setDeliveryCustomer(customerInfo);
            entryInfo.setReceiveCustomer(customerInfo);
            entryInfo.setInvoicedBaseQty(ZERO);
            entryInfo.setInvoicedQty(ZERO);
            entryInfo.setInvoicePrice(ZERO);
            entryInfo.setReturnsBaseQty(ZERO);
            entryInfo.setReturnsQty(ZERO);
            entryInfo.setRemainingBaseQty(ZERO);
            entryInfo.setRemainingQty(ZERO);
            entryInfo.setTotalInvoicedAmt(ZERO);
            entryInfo.setIsPresent(false);
            entryInfo.setIsBetweenCompanySend(false);
            entryInfo.setReturnsDate((Date)siInfo.getLastUpdateTime());
        }
    }

    private Map getCurrentRate(Context ctx, String[] material, String saleOrg) throws EASBizException, BOSException, SQLException {
        HashMap<String, String> taxRate = new HashMap<String, String>();
        IRowSet rateRs = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select  fmaterialid,ftaxrate from T_BD_MaterialSales  where FOrgUnit='");
        sql.append(saleOrg);
        sql.append("' and fmaterialid in (");
        for (int i = 0; i < material.length; ++i) {
            sql.append("'").append(material[i]).append("',");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        rateRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rateRs.next()) {
            taxRate.put(rateRs.getString("fMaterialId"), rateRs.getString("fTaxRate"));
        }
        return taxRate;
    }

    private SaleReturnsEntryInfo managerSaleReturnsEntry(Context ctx, ChannelInWarehsBillInfo siInfo, SaleReturnsEntryInfo saleReturnsEntryInfo, SaleReturnsInfo saleReturns, BigDecimal taxRate) throws EASBizException, BOSException {
        int currencyPrecision;
        MaterialInfo material = null;
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        BigDecimal taxPrice = ZERO;
        DiscountModeEnum mode = null;
        BigDecimal discount = ZERO;
        BigDecimal price = ZERO;
        Map calAmounts = null;
        if (saleReturnsEntryInfo.getMaterial() == null || saleReturnsEntryInfo.getMaterial().getId() == null || saleReturns.getOrderCustomer() == null || saleReturns.getOrderCustomer().getId() == null) {
            throw new BOSException("the material or customer is null");
        }
        material = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(saleReturnsEntryInfo.getMaterial().getId()));
        PriceCondition priceCondition = new PriceCondition();
        priceCondition.setMaterialInfo(saleReturnsEntryInfo.getMaterial());
        priceCondition.setCustomerInfo(saleReturns.getOrderCustomer());
        priceCondition.setCurrencyInfo(saleReturns.getCurrency());
        priceCondition.setSaleOrg(saleReturns.getSaleOrgUnit());
        priceCondition.setOrderQty(saleReturnsEntryInfo.getQty());
        priceCondition.setMeasureUnit(saleReturnsEntryInfo.getUnit().getId().toString());
        priceCondition.setCurDate(new Date());
        priceCondition.setAssiProperty(saleReturnsEntryInfo.getAssistProperty());
        priceCondition.setFetchMode(0);
        IPriceProvider iprovider = PriceProviderFactory.getLocalInstance((Context)ctx);
        Map result = iprovider.calculatePrice(priceCondition);
        ChannelInWarehsBillEntryCollection inWarehsBillEntryCollection = siInfo.getEntries();
        HashMap<String, BigDecimal> siPriceMap = new HashMap<String, BigDecimal>();
        int size = inWarehsBillEntryCollection.size();
        for (int i = 0; i < size; ++i) {
            ChannelInWarehsBillEntryInfo entryInfo = inWarehsBillEntryCollection.get(i);
            String materialId = entryInfo.getMaterial().getId().toString();
            BigDecimal siPrice = entryInfo.getPrice();
            siPriceMap.put(materialId, siPrice);
        }
        taxPrice = result != null && result.size() > 0 ? new BigDecimal(result.get("keyprice").toString()) : (siPriceMap.get(material.getId().toString()) != null ? (BigDecimal)siPriceMap.get(material.getId().toString()) : ZERO);
        int pricePrecision = material.getPricePrecision();
        CurrencyInfo currencyInfo = saleReturns.getCurrency();
        int n = currencyPrecision = currencyInfo != null ? currencyInfo.getPrecision() : 0;
        if (this.priceParamInfo.isContainTax()) {
            price = taxPrice.divide(taxRate.divide(Hundred, 10, 6).add(ONE), 10, 6);
        } else {
            price = taxPrice;
            taxPrice = price.multiply(taxRate.divide(Hundred, 10, 6).add(ONE));
        }
        saleReturnsEntryInfo.setTaxPrice(taxPrice.setScale(pricePrecision, 4));
        saleReturnsEntryInfo.setPrice(price.setScale(pricePrecision, 4));
        calAmounts = this.calDiscountAmount(mode, taxPrice, discount, saleReturnsEntryInfo.getQty(), saleReturns.isIsInTax(), taxRate, currencyPrecision);
        saleReturnsEntryInfo.setTaxAmount((BigDecimal)calAmounts.get("totalTaxAmount"));
        saleReturnsEntryInfo.setTax((BigDecimal)calAmounts.get("tax"));
        saleReturnsEntryInfo.setTaxRate(taxRate);
        BigDecimal amount = null;
        amount = currencyPrecision == 0 ? (BigDecimal)calAmounts.get("amount") : ((BigDecimal)calAmounts.get("amount")).setScale(currencyPrecision, 4);
        saleReturnsEntryInfo.setAmount(amount);
        saleReturnsEntryInfo.setLocalAmount(saleReturnsEntryInfo.getAmount());
        saleReturnsEntryInfo.setLocalTax(saleReturnsEntryInfo.getTax());
        saleReturnsEntryInfo.setLocalTaxAmount(saleReturnsEntryInfo.getLocalTaxAmount());
        return saleReturnsEntryInfo;
    }

    private Map calDiscountAmount(DiscountModeEnum mode, BigDecimal taxPrice, BigDecimal discount, BigDecimal qty, boolean isInTax, BigDecimal taxRate, int precision) throws EASBizException, BOSException {
        HashMap<String, BigDecimal> calAmount = new HashMap<String, BigDecimal>();
        BigDecimal discountAmount = ZERO;
        BigDecimal totalTaxAmount = ZERO;
        BigDecimal tax = ZERO;
        BigDecimal amount = ZERO;
        BigDecimal actualPrice = ZERO;
        BigDecimal actualTaxPrice = ZERO;
        taxRate = taxRate.divide(Hundred, 10, 6);
        if (mode == null) {
            totalTaxAmount = qty.multiply(taxPrice);
        } else if (mode.equals((Object)DiscountModeEnum.PERCENT)) {
            discountAmount = taxPrice.multiply(discount).multiply(qty).divide(Hundred, 2, 6);
            totalTaxAmount = qty.multiply(taxPrice.multiply(ONE.subtract(discount.divide(Hundred, 10, 6))));
        } else {
            discountAmount = qty.multiply(discount);
            totalTaxAmount = qty.multiply(taxPrice.subtract(discount));
        }
        if (isInTax) {
            tax = totalTaxAmount.divide(ONE.add(taxRate), 10, 6).multiply(taxRate);
            amount = totalTaxAmount.subtract(tax);
        }
        actualTaxPrice = totalTaxAmount.divide(qty, 2, 6);
        actualPrice = amount.divide(qty, 2, 6);
        calAmount.put("discountAmount", discountAmount.setScale(precision, 4));
        calAmount.put("totalTaxAmount", totalTaxAmount.setScale(precision, 4));
        calAmount.put("tax", tax.setScale(precision, 4));
        calAmount.put("amount", amount.setScale(precision, 4));
        calAmount.put("actualTaxPrice", actualTaxPrice);
        calAmount.put("actualPrice", actualPrice);
        return calAmount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BTPTransformResult createBillByBotp(Context ctx, ChannelInWarehsBillInfo siInfo) throws BOSException, BTPException, SQLException, BOTPException {
        if (siInfo.getCU() == null) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select FControlUnitID from T_CHA_CHANNELINWAREHSBILL where FID = ?", (Object[])new Object[]{siInfo.getId().toString()});
            try {
                if (rs.next()) {
                    CtrlUnitInfo cuInfo = new CtrlUnitInfo();
                    cuInfo.setId(BOSUuid.read((String)rs.getString("FControlUnitID")));
                    siInfo.setCU(cuInfo);
                }
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        HashMap<String, CtrlUnitInfo> transmitCtx = new HashMap<String, CtrlUnitInfo>();
        transmitCtx.put("TRANSMITCU", siInfo.getCU());
        BOTMappingCollection botCollection = null;
        botCollection = BOTMappingHelper.getMappingForSelect((Context)ctx, (String)SCMConstant.BOSTYPE_CHANNELINWAREHS, (String)SCMConstant.BOSTYPE_CHANNELSALEISSUE, null, transmitCtx);
        if (botCollection == null) {
            return null;
        }
        if (botCollection.size() < 1) {
            return null;
        }
        CoreBillBaseCollection col = new CoreBillBaseCollection();
        col.add((CoreBillBaseInfo)siInfo);
        BTPTransformResult result = null;
        result = BTPManagerFactory.getLocalInstance((Context)ctx).transform(col, SCMConstant.BOSTYPE_CHANNELSALEISSUE);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BTPTransformResult createSaleReturnsBillByBotp(Context ctx, ChannelInWarehsBillInfo siInfo) throws BOSException, BTPException, SQLException, BOTPException {
        String botpId;
        if (siInfo.getCU() == null) {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)"select FControlUnitID from T_CHA_CHANNELINWAREHSBILL where FID = ?", (Object[])new Object[]{siInfo.getId().toString()});
            try {
                if (rs.next()) {
                    CtrlUnitInfo cuInfo = new CtrlUnitInfo();
                    cuInfo.setId(BOSUuid.read((String)rs.getString("FControlUnitID")));
                    siInfo.setCU(cuInfo);
                }
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        if ((botpId = this.getBotpId(ctx, SCMConstant.BOSTYPE_CHANNELINWAREHS, BOSTYPE_SALERETURNS, siInfo.getCU(), "InWarehs-SaleReturn")) == null) {
            return null;
        }
        ArrayList<String> entriesKeys = new ArrayList<String>(siInfo.getEntries().size());
        int size = siInfo.getEntries().size();
        for (int i = 0; i < size; ++i) {
            if (siInfo.getEntries().get(i).getProvideSaleOrgUnit() == null) continue;
            entriesKeys.add(siInfo.getEntries().get(i).getId().toString());
        }
        HashMap<String, CtrlUnitInfo> transmitCtx = new HashMap<String, CtrlUnitInfo>();
        transmitCtx.put("TRANSMITCU", siInfo.getCU());
        BOTMappingCollection botCollection = null;
        botCollection = BOTMappingHelper.getMappingForSelect((Context)ctx, (String)SCMConstant.BOSTYPE_CHANNELINWAREHS, (String)BOSTYPE_SALERETURNS, null, transmitCtx);
        if (botCollection == null) {
            return null;
        }
        if (botCollection.size() < 1) {
            return null;
        }
        CoreBillBaseCollection col = new CoreBillBaseCollection();
        col.add((CoreBillBaseInfo)siInfo);
        BTPTransformResult result = null;
        result = BTPManagerFactory.getLocalInstance((Context)ctx).transform(col, BOSTYPE_SALERETURNS);
        return result;
    }

    @Override
    public void _autoDelete(Context ctx, SCMBillBaseInfo billInfo) throws EASBizException, BOSException {
        ChannelInWarehsBillInfo siInfo = (ChannelInWarehsBillInfo)billInfo;
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct ciw.FId as fid from T_CHA_ChannelSaleIssueEntry ciwe ");
        sql.append("left join T_CHA_ChannelSaleIssueBill ciw on ciw.FId = ciwe.FParentId ");
        sql.append("left join T_BOT_RELATIONENTRY re on ciwe.FId = re.FDestEntryId ");
        sql.append("where ciw.FBaseStatus not in(?,?) and re.FSrcEntryId in (");
        Object[] params = new Object[3 + siInfo.getEntries().size()];
        int size = siInfo.getEntries().size();
        for (int i = 0; i < size; ++i) {
            sql.append("?,");
            params[i + 2] = siInfo.getEntries().get(i).getId().toString();
        }
        sql.append("?)");
        params[params.length - 1] = "1";
        params[0] = new Integer(4);
        params[1] = new Integer(7);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
        try {
            while (rs.next()) {
                ChannelSaleIssueBillFactory.getLocalInstance(ctx).delete((IObjectPK)new ObjectUuidPK(rs.getString("fid")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        sql.setLength(0);
        sql.append("select distinct ciw.FId as fid from T_SD_SaleReturnsEntry ciwe ");
        sql.append("left join T_SD_SaleReturns ciw on ciw.FId = ciwe.FParentId ");
        sql.append("left join T_BOT_RELATIONENTRY re on ciwe.FId = re.FDestEntryId ");
        sql.append("where ciw.FBaseStatus not in(?,?) and re.FSrcEntryId in (");
        Object[] paramsReturns = new Object[3 + siInfo.getEntries().size()];
        int size2 = siInfo.getEntries().size();
        for (int i = 0; i < size2; ++i) {
            sql.append("?,");
            paramsReturns[i + 2] = siInfo.getEntries().get(i).getId().toString();
        }
        sql.append("?)");
        paramsReturns[paramsReturns.length - 1] = "  ";
        paramsReturns[0] = new Integer(4);
        paramsReturns[1] = new Integer(7);
        IRowSet rsResturns = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramsReturns);
        try {
            while (rsResturns.next()) {
                SaleReturnsFactory.getLocalInstance((Context)ctx).delete((IObjectPK)new ObjectUuidPK(rsResturns.getString("fid")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rsResturns);
        }
    }

    @Override
    public boolean isAutoDelete(Context ctx, SCMBillBaseInfo billInfo) throws EASBizException, BOSException {
        boolean flag;
        block15: {
            IRowSet rs;
            StringBuffer sql;
            ChannelInWarehsBillInfo siInfo;
            block14: {
                flag = true;
                siInfo = (ChannelInWarehsBillInfo)billInfo;
                sql = new StringBuffer();
                sql.append("select distinct ciw.FId as fid, ciw.FBaseStatus as fbasestatus from T_CHA_ChannelSaleIssueEntry ciwe ");
                sql.append("left join T_CHA_ChannelSaleIssueBill ciw on ciw.FId = ciwe.FParentId ");
                sql.append("left join T_BOT_RELATIONENTRY re on ciwe.FId = re.FDestEntryId ");
                sql.append("where re.FSrcEntryId in (");
                Object[] params = new Object[1 + siInfo.getEntries().size()];
                int size = siInfo.getEntries().size();
                for (int i = 0; i < size; ++i) {
                    sql.append("?,");
                    params[i] = siInfo.getEntries().get(i).getId().toString();
                }
                sql.append("?)");
                params[params.length - 1] = "  ";
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
                try {
                    if (rs == null) break block14;
                    while (rs.next()) {
                        if (rs.getInt("fbasestatus") != 4 && rs.getInt("fbasestatus") != 7) continue;
                        flag = false;
                        break;
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rs);
                }
            }
            sql.setLength(0);
            sql.append("select distinct ciw.FId as fid, ciw.FBaseStatus as fbasestatus from T_SD_SaleReturnsEntry ciwe ");
            sql.append("left join T_SD_SaleReturns ciw on ciw.FId = ciwe.FParentId ");
            sql.append("left join T_BOT_RELATIONENTRY re on ciwe.FId = re.FDestEntryId ");
            sql.append("where re.FSrcEntryId in (");
            Object[] paramsReturns = new Object[1 + siInfo.getEntries().size()];
            int size = siInfo.getEntries().size();
            for (int i = 0; i < size; ++i) {
                sql.append("?,");
                paramsReturns[i] = siInfo.getEntries().get(i).getId().toString();
            }
            sql.append("?)");
            paramsReturns[paramsReturns.length - 1] = "  ";
            IRowSet rsReturns = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramsReturns);
            try {
                if (rsReturns == null) break block15;
                while (rsReturns.next()) {
                    if (rsReturns.getInt("fbasestatus") != 4 && rsReturns.getInt("fbasestatus") != 7) continue;
                    flag = false;
                    break;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs);
            }
        }
        return flag;
    }

    private Map getMateiralMap(Context ctx, BTPTransformResult result) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        HashSet<BOSUuid> ids = new HashSet<BOSUuid>();
        int size = result.getBills().size();
        for (int i = 0; i < size; ++i) {
            ChannelSaleIssueBillInfo ciwBillInfo = (ChannelSaleIssueBillInfo)result.getBills().getObject(i);
            int entrySize = ciwBillInfo.getEntries().size();
            for (int j = 0; j < entrySize; ++j) {
                ChannelSaleIssueBillEntryInfo entryInfo = ciwBillInfo.getEntries().get(j);
                ids.add(entryInfo.getMaterial().getId());
            }
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add("pricePrecision");
        MaterialCollection col = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(viewInfo);
        HashMap<String, MaterialInfo> map = new HashMap<String, MaterialInfo>(col.size() * 2);
        int size2 = col.size();
        for (int i = 0; i < size2; ++i) {
            map.put(col.get(i).getId().toString(), col.get(i));
        }
        return map;
    }

    protected Map getMultiMeasureUnitMap(Context ctx, BTPTransformResult result) throws BOSException {
        HashMap<String, MultiMeasureUnitInfo> hm = new HashMap<String, MultiMeasureUnitInfo>();
        if (result.getBills().size() > 0) {
            EntityViewInfo entityViewInfo = this.getMultiMeasureUnitEntityViewInfo(result);
            MultiMeasureUnitCollection collection = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(entityViewInfo);
            if (collection != null && collection.size() > 0) {
                int n = collection.size();
                for (int i = 0; i < n; ++i) {
                    MultiMeasureUnitInfo mmuInfo = collection.get(i);
                    String key = mmuInfo.getMaterial().getId().toString() + mmuInfo.getMeasureUnit().getId().toString();
                    hm.put(key, mmuInfo);
                }
            }
        }
        return hm;
    }

    private Map getCurrencyMap(Context ctx, BTPTransformResult result) throws BOSException, EASBizException {
        HashMap<String, CurrencyInfo> hm = null;
        CurrencyCollection col = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(this.getCurrencyEntityViewInfo(ctx, result));
        hm = new HashMap<String, CurrencyInfo>(col.size() * 2);
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            hm.put(col.get(i).getId().toString(), col.get(i));
        }
        return hm;
    }

    private EntityViewInfo getCurrencyEntityViewInfo(Context ctx, BTPTransformResult result) throws BOSException, EASBizException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        HashSet<BOSUuid> currencyIds = new HashSet<BOSUuid>();
        int size = result.getBills().size();
        for (int i = 0; i < size; ++i) {
            ChannelSaleIssueBillInfo ciwBillInfo = (ChannelSaleIssueBillInfo)result.getBills().getObject(i);
            CompanyOrgUnitInfo couInfo = this.getCompanyInfo(ctx, ciwBillInfo.getSaleOrgUnit());
            ciwBillInfo.put("couInfo", couInfo);
            if (couInfo.getBaseCurrency() != null) {
                currencyIds.add(couInfo.getBaseCurrency().getId());
                ciwBillInfo.put("baseCurId", couInfo.getBaseCurrency().getId().toString());
            }
            currencyIds.add(ciwBillInfo.getCurrency().getId());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", currencyIds, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add("precision");
        return viewInfo;
    }

    private CompanyOrgUnitInfo getCompanyInfo(Context ctx, SaleOrgUnitInfo sou) throws BOSException, EASBizException {
        if (sou == null) {
            return null;
        }
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitInfo ret = (CompanyOrgUnitInfo)iUnitRel.getDefaultToUnit(sou.getId().toString(), 2, 1);
        if (ret == null) {
            OrgUnitCollection orgCol = iUnitRel.getToUnit(sou.getId().toString(), 2, 1);
            ret = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        return ret;
    }

    protected EntityViewInfo getMultiMeasureUnitEntityViewInfo(BTPTransformResult result) {
        int i;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        StringBuffer maskString = new StringBuffer();
        int size = result.getBills().size();
        for (i = 0; i < size; ++i) {
            ChannelSaleIssueBillInfo ciwBillInfo = (ChannelSaleIssueBillInfo)result.getBills().getObject(i);
            int entrySize = ciwBillInfo.getEntries().size();
            for (int j = 0; j < entrySize; ++j) {
                ChannelSaleIssueBillEntryInfo entryInfo = ciwBillInfo.getEntries().get(j);
                if (entryInfo.getUnit() != null) {
                    filterInfo.appendFilterItem("material.id", (Object)entryInfo.getMaterial().getId());
                    filterInfo.appendFilterItem("measureUnit.id", (Object)entryInfo.getUnit().getId());
                }
                if (entryInfo.getBaseUnit() != null) {
                    filterInfo.appendFilterItem("material.id", (Object)entryInfo.getMaterial().getId());
                    filterInfo.appendFilterItem("measureUnit.id", (Object)entryInfo.getBaseUnit().getId());
                }
                if (entryInfo.getAssistUnit() == null) continue;
                filterInfo.appendFilterItem("material.id", (Object)entryInfo.getMaterial().getId());
                filterInfo.appendFilterItem("measureUnit.id", (Object)entryInfo.getAssistUnit().getId());
            }
        }
        size = filterInfo.getFilterItems().size() / 2;
        for (i = 0; i < size; ++i) {
            maskString.append("(#").append(i * 2).append(" and #").append(i * 2 + 1).append(")");
            if (i >= size - 1) continue;
            maskString.append(" or ");
        }
        entityViewInfo.setFilter(filterInfo);
        filterInfo.setMaskString(maskString.toString());
        entityViewInfo.getSelector().add("*");
        entityViewInfo.getSelector().add("material.id");
        entityViewInfo.getSelector().add("measureUnit.id");
        return entityViewInfo;
    }

    @Override
    protected boolean shouldAutoCreate(Context ctx, SCMBillBaseInfo billInfo) throws BOSException {
        return true;
    }
}

