/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelSaleInfoCollection;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelSaleInfoFactory;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelSaleInfoInfo;
import com.kingdee.eas.basedata.scm.sd.channel.TerminalChannelStatusEnum;
import com.kingdee.eas.basedata.scm.sd.channel.TerminalChannelTypeEnum;
import com.kingdee.eas.basedata.scm.sd.channel.TerminalSaleInfoCollection;
import com.kingdee.eas.basedata.scm.sd.channel.TerminalSaleInfoFactory;
import com.kingdee.eas.basedata.scm.sd.channel.TerminalSaleInfoInfo;
import com.kingdee.eas.basedata.scm.sd.channel.util.BosUtil;
import com.kingdee.eas.basedata.scm.sd.channel.util.CollectionUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.eip.sso.ltpa.ConfigurationError;
import com.kingdee.eas.cp.eip.sso.ltpa.LtpaTokenManager;
import com.kingdee.eas.scm.sd.channel.ChannelRelationCache;
import com.kingdee.eas.scm.sd.channel.ChannelRelationInfo;
import com.kingdee.eas.scm.sd.channel.OrgUnitFacadeFactory;
import com.kingdee.eas.scm.sd.channel.UserChannelRelationFacadeFactory;
import com.kingdee.eas.scm.sd.channel.app.AbstractChannelFacadeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;

public class ChannelFacadeControllerBean
extends AbstractChannelFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)ChannelFacadeControllerBean.class.getName());

    private boolean isApproveChannel(ChannelBaseInfo channel) {
        boolean flag = false;
        if (BosUtil.isNotEmptyEntity((IObjectValue)channel)) {
            flag = TerminalChannelStatusEnum.APPROVE.equals((Object)channel.getTerminalChannelStatus());
        }
        return flag;
    }

    @Override
    protected ChannelRelationCache _initChannelRelationCache(Context ctx, IObjectValue curUser) throws BOSException {
        ChannelRelationCache cache = new ChannelRelationCache();
        UserInfo user = (UserInfo)curUser;
        if (BosUtil.isNotEmptyEntity((IObjectValue)curUser)) {
            List relatedChannels = CollectionUtil.convertBosColletionToList((IObjectCollection)UserChannelRelationFacadeFactory.getLocalInstance(ctx).getUserRelationChannels(user.getId().toString()));
            cache.setRelatedChannels(relatedChannels);
            if (relatedChannels != null && relatedChannels.size() > 0) {
                ChannelBaseInfo defaultChannel = (ChannelBaseInfo)relatedChannels.get(0);
                cache.setChannelRelationInfo(this.getChannelRelationInfo(ctx, defaultChannel));
                List relatedSaleOrgs = cache.getChannelRelationInfo().getRelatedSaleOrgs();
                if (CollectionUtil.isNotEmptyCollection((Collection)relatedSaleOrgs)) {
                    HashSet<String> saleOrgIds = new HashSet<String>(relatedSaleOrgs.size());
                    int size = relatedSaleOrgs.size();
                    for (int i = 0; i < size; ++i) {
                        saleOrgIds.add(((SaleOrgUnitInfo)relatedSaleOrgs.get(i)).getId().toString());
                    }
                    Map companyOrgCache = OrgUnitFacadeFactory.getLocalInstance(ctx).getCompanyOrgsBySaleOrgIds(saleOrgIds);
                    cache.putAll_CompanyOrgCache(companyOrgCache);
                }
            }
        }
        return cache;
    }

    private ChannelRelationInfo getChannelRelationInfo(Context ctx, ChannelBaseInfo channel) throws BOSException {
        ChannelRelationInfo channelRelationInfo = new ChannelRelationInfo();
        channelRelationInfo.setCurChannel(channel);
        channelRelationInfo.setRelatedCustomer(channel.getCustomer());
        this.setChannelSaleRelagionInfos(ctx, channelRelationInfo);
        return channelRelationInfo;
    }

    private void setChannelSaleRelagionInfos(Context ctx, ChannelRelationInfo channelRelationInfo) throws BOSException {
        ChannelBaseInfo channelInfo = channelRelationInfo.getCurChannel();
        if (BosUtil.isNotEmptyEntity((IObjectValue)channelInfo)) {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("saleOrgUnit.id"));
            view.getSelector().add(new SelectorItemInfo("saleOrgUnit.name"));
            view.getSelector().add(new SelectorItemInfo("saleOrgUnit.number"));
            view.getSelector().add(new SelectorItemInfo("saleOrgUnit.isBizUnit"));
            view.getSelector().add(new SelectorItemInfo("saleOrgUnit.longNumber"));
            view.getSelector().add(new SelectorItemInfo("storageOrgUnit.id"));
            view.getSelector().add(new SelectorItemInfo("storageOrgUnit.name"));
            view.getSelector().add(new SelectorItemInfo("storageOrgUnit.number"));
            view.getSelector().add(new SelectorItemInfo("parentChannel.id"));
            view.getSelector().add(new SelectorItemInfo("parentChannel.name"));
            view.getSelector().add(new SelectorItemInfo("parentChannel.number"));
            view.getSelector().add(new SelectorItemInfo("parentChannel.terminalChannelStatus"));
            view.getSelector().add(new SelectorItemInfo("parentChannel.terminalChannelType"));
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("channelBase.id", (Object)channelInfo.getId()));
            ArrayList<SaleOrgUnitInfo> curChannelRelatedSaleOrgs = null;
            HashMap<String, StorageOrgUnitInfo> curChannelRelatedStoregeOrgs = null;
            HashMap<String, ChannelBaseInfo> parentChannelOfCurChannel = null;
            if (TerminalChannelTypeEnum.CHANNEL.equals((Object)channelInfo.getTerminalChannelType())) {
                ChannelSaleInfoCollection channelSaleInfoCol = ChannelSaleInfoFactory.getLocalInstance((Context)ctx).getChannelSaleInfoCollection(view);
                ChannelSaleInfoInfo info = null;
                int size = channelSaleInfoCol.size();
                curChannelRelatedSaleOrgs = new ArrayList(size);
                curChannelRelatedStoregeOrgs = new HashMap(size);
                parentChannelOfCurChannel = new HashMap(size);
                for (int i = 0; i < size; ++i) {
                    info = channelSaleInfoCol.get(i);
                    if (!BosUtil.isNotEmptyEntity((IObjectValue)info.getSaleOrgUnit()) || !info.getSaleOrgUnit().isIsBizUnit()) continue;
                    curChannelRelatedSaleOrgs.add(info.getSaleOrgUnit());
                    curChannelRelatedStoregeOrgs.put(info.getSaleOrgUnit().getId().toString(), info.getStorageOrgUnit());
                    if (!this.isApproveChannel(info.getParentChannel())) continue;
                    parentChannelOfCurChannel.put(info.getSaleOrgUnit().getId().toString(), info.getParentChannel());
                }
            } else if (TerminalChannelTypeEnum.TERMINAL.equals((Object)channelInfo.getTerminalChannelType())) {
                TerminalSaleInfoCollection terminalSaleInfoCol = TerminalSaleInfoFactory.getLocalInstance((Context)ctx).getTerminalSaleInfoCollection(view);
                TerminalSaleInfoInfo info = null;
                int size = terminalSaleInfoCol.size();
                curChannelRelatedSaleOrgs = new ArrayList(size);
                curChannelRelatedStoregeOrgs = new HashMap(size);
                parentChannelOfCurChannel = new HashMap(size);
                for (int i = 0; i < size; ++i) {
                    info = terminalSaleInfoCol.get(i);
                    if (!BosUtil.isNotEmptyEntity((IObjectValue)info.getSaleOrgUnit()) || !info.getSaleOrgUnit().isIsBizUnit()) continue;
                    curChannelRelatedSaleOrgs.add(info.getSaleOrgUnit());
                    curChannelRelatedStoregeOrgs.put(info.getSaleOrgUnit().getId().toString(), info.getStorageOrgUnit());
                    if (!this.isApproveChannel(info.getParentChannel())) continue;
                    parentChannelOfCurChannel.put(info.getSaleOrgUnit().getId().toString(), info.getParentChannel());
                }
            }
            channelRelationInfo.setRelatedSaleOrgs(curChannelRelatedSaleOrgs == null ? new ArrayList<SaleOrgUnitInfo>(0) : curChannelRelatedSaleOrgs);
            channelRelationInfo.setRelatedStoregeOrgs(curChannelRelatedStoregeOrgs == null ? new HashMap<String, StorageOrgUnitInfo>(0) : curChannelRelatedStoregeOrgs);
            channelRelationInfo.setParentChannels(parentChannelOfCurChannel == null ? new HashMap<String, ChannelBaseInfo>(0) : parentChannelOfCurChannel);
        }
    }

    @Override
    protected Set _getChildChannelIds(Context ctx, ChannelBaseInfo channelInfo, String saleOrgUnitId) throws BOSException {
        HashSet<String> resultIDSet = new HashSet<String>(10);
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("channelBase.id"));
        view.getSelector().add(new SelectorItemInfo("channelBase.name"));
        view.getSelector().add(new SelectorItemInfo("channelBase.number"));
        view.getSelector().add(new SelectorItemInfo("channelBase.terminalChannelStatus"));
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("parentChannel.id", (Object)channelInfo.getId()));
        view.getFilter().getFilterItems().add(new FilterItemInfo("saleOrgUnit.id", (Object)saleOrgUnitId));
        ChannelSaleInfoCollection channelSaleInfoCol = ChannelSaleInfoFactory.getLocalInstance((Context)ctx).getChannelSaleInfoCollection(view);
        ChannelSaleInfoInfo info = null;
        int size = channelSaleInfoCol.size();
        for (int i = 0; i < size; ++i) {
            info = channelSaleInfoCol.get(i);
            if (!this.isApproveChannel(info.getChannelBase())) continue;
            resultIDSet.add(info.getChannelBase().getId().toString());
        }
        TerminalSaleInfoCollection terminalSaleInfoCol = TerminalSaleInfoFactory.getLocalInstance((Context)ctx).getTerminalSaleInfoCollection(view);
        TerminalSaleInfoInfo terminalSaleInfoInfo = null;
        int terminalSaleInfoColSize = terminalSaleInfoCol.size();
        for (int i = 0; i < terminalSaleInfoColSize; ++i) {
            terminalSaleInfoInfo = terminalSaleInfoCol.get(i);
            if (!this.isApproveChannel(terminalSaleInfoInfo.getChannelBase())) continue;
            resultIDSet.add(terminalSaleInfoInfo.getChannelBase().getId().toString());
        }
        return resultIDSet;
    }

    @Override
    protected void _exchangeChannel(Context ctx, ChannelRelationCache channelRelationCache, IObjectValue newChannel) throws BOSException {
        ChannelBaseInfo channel = (ChannelBaseInfo)newChannel;
        if (BosUtil.isNotEmptyEntity((IObjectValue)channel) && (channel = this.reloadChannelFromCache(channelRelationCache, channel)) != null) {
            channelRelationCache.setChannelRelationInfo(this.getChannelRelationInfo(ctx, channel));
            List relatedSaleOrgs = channelRelationCache.getChannelRelationInfo().getRelatedSaleOrgs();
            if (CollectionUtil.isNotEmptyCollection((Collection)relatedSaleOrgs)) {
                HashSet<String> saleOrgIds = new HashSet<String>(relatedSaleOrgs.size());
                int size = relatedSaleOrgs.size();
                for (int i = 0; i < size; ++i) {
                    saleOrgIds.add(((SaleOrgUnitInfo)relatedSaleOrgs.get(i)).getId().toString());
                }
                Set existedSaleOrgIdInCache = channelRelationCache.keySet_CompanyOrgCache();
                saleOrgIds.removeAll(existedSaleOrgIdInCache);
                Map newCompanyOrgCache = OrgUnitFacadeFactory.getLocalInstance(ctx).getCompanyOrgsBySaleOrgIds(saleOrgIds);
                channelRelationCache.putAll_CompanyOrgCache(newCompanyOrgCache);
            }
        }
    }

    private ChannelBaseInfo reloadChannelFromCache(ChannelRelationCache channelRelationCache, ChannelBaseInfo Channel) {
        ChannelBaseInfo reloadedChannel = null;
        if (channelRelationCache != null && CollectionUtil.isNotEmptyCollection((Collection)channelRelationCache.getRelatedChannels())) {
            List relatedChannels = channelRelationCache.getRelatedChannels();
            ChannelBaseInfo tempChannel = null;
            int size = relatedChannels.size();
            for (int i = 0; i < size; ++i) {
                tempChannel = (ChannelBaseInfo)relatedChannels.get(i);
                if (!Channel.getId().equals((Object)tempChannel.getId())) continue;
                reloadedChannel = tempChannel;
            }
        }
        return reloadedChannel;
    }

    @Override
    protected HashMap _getWebUrl(Context ctx) throws BOSException, EASBizException {
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        HashMap<String, String> resultMap = new HashMap<String, String>();
        ctx.getUserName();
        String username = user.getNumber();
        String dataCenter = ctx.getAIS();
        String fileName = System.getProperty("EAS_INSTANCE_CONFIG_PATH").trim() + "/portalConfig/LtpaToken.properties";
        String password = LtpaTokenManager.generate((String)username, (String)fileName).toString();
        Properties properties = new Properties();
        InputStream is = null;
        try {
            is = new FileInputStream(System.getProperty("eas.properties.dir").trim() + "/eas_httpd.conf");
            properties.load(is);
        }
        catch (IOException ioe) {
            throw new ConfigurationError("eas_httpd.conf not found");
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String proxyPassReverse = properties.getProperty("ProxyPassReverse");
        String domian = proxyPassReverse.substring(proxyPassReverse.indexOf("http"));
        String url = domian + "easportal/index2sso.jsp?username=" + username + "&password=" + password + "&dataCenter=" + dataCenter;
        resultMap.put("URL", url);
        return resultMap;
    }
}

