/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.sd.channel.app.AbstractChannelJXCAccountBookControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.log4j.Logger;

public class ChannelJXCAccountBookControllerBean
extends AbstractChannelJXCAccountBookControllerBean {
    private static final long serialVersionUID = 6293685068519117819L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.channel.app.ChannelJXCAccountBookControllerBean");
    private static final String TABLE_IN_BILL = "T_CHA_ChannelInWarehsBill";
    private static final String TABLE_IN_ENTRY = "T_CHA_ChannelInWarehsBillEntry";
    private static final String TABLE_OUT_BILL = "T_CHA_ChannelSaleIssueBill";
    private static final String TABLE_OUT_ENTRY = "T_CHA_ChannelSaleIssueEntry";
    private Context ctx = null;
    private String entrytable = null;
    private String billtable = null;
    private boolean in = true;
    private int flag = 1;
    private String accountMaxYear = null;
    private String accountMaxMon = null;
    private String saleOrgUnitID = "";
    private String channelID = "";
    private java.util.Date bizDate = null;
    private String ID = null;
    private Integer billstatus = new Integer(4);

    @Override
    protected void _audit(Context ctx, String ID, java.util.Date date, String saleOrgUnitID, String channelID, boolean in) throws BOSException {
        this.flag = in ? 1 : -1;
        this.init(ctx, ID, date, saleOrgUnitID, channelID, in);
        String strbizDate = this.parseDate(this.bizDate, "yyyy-MM-dd");
        if (this.existAccount()) {
            this.equalAccount();
        } else {
            this.setMaxAccountDate();
            if (this.accountMaxYear == null) {
                this.firstDoAccount(strbizDate.substring(0, 4), strbizDate.substring(5, 7));
            } else if ((this.accountMaxYear + "-" + this.accountMaxMon + "-01").compareTo(strbizDate) > 0) {
                this.beforeAccount();
            } else if ((this.accountMaxYear + "-" + this.accountMaxMon + "-01").compareTo(strbizDate) < 0) {
                this.afterAccount();
            }
        }
    }

    @Override
    protected void _unAudit(Context ctx, String ID, java.util.Date date, String saleOrgUnitID, String channelID, boolean in) throws BOSException {
        this.flag = in ? -1 : 1;
        this.init(ctx, ID, date, saleOrgUnitID, channelID, in);
        this.equalAccount();
    }

    @Override
    protected void _initData(Context ctx, String saleOrgUnitID, String channelID) throws BOSException, EASBizException {
        this.init(ctx, saleOrgUnitID, channelID, true);
        List inBizDateList = null;
        List outBizDateList = null;
        try {
            this.billtable = TABLE_IN_BILL;
            inBizDateList = this.getBizDate();
            this.deleteAccount(inBizDateList);
            this.billtable = TABLE_OUT_BILL;
            outBizDateList = this.getBizDate();
            this.deleteAccount(outBizDateList);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        this.initAudit(inBizDateList, true);
        this.initAudit(outBizDateList, false);
    }

    private void deleteAccount(List bizDateList) throws BOSException {
        if (bizDateList == null || bizDateList.isEmpty()) {
            return;
        }
        if (bizDateList.size() > 1) {
            this.deleteAccount((java.util.Date)bizDateList.get(0), (java.util.Date)bizDateList.get(bizDateList.size() - 1));
        } else {
            this.deleteAccount((java.util.Date)bizDateList.get(0), (java.util.Date)bizDateList.get(0));
        }
    }

    private void initAudit(List bizDateList, boolean in) throws BOSException {
        String id = null;
        this.billtable = in ? TABLE_IN_BILL : TABLE_OUT_BILL;
        try {
            java.util.Date date = null;
            int n = bizDateList.size();
            for (int i = 0; i < n; ++i) {
                date = (java.util.Date)bizDateList.get(i);
                id = this.transPKToIds(this.getID(date));
                this._audit(this.ctx, id, date, this.saleOrgUnitID, this.channelID, in);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public void setMaxAccountDate() throws BOSException {
        String sql = "select max(jxc.FBizDateYear||jxc.FBizDateMon) as bizdate from T_CHA_ChannelJXCAccountBook jxc where exists(select 1 from " + this.billtable + " bill where 1=1 and bill.fbasestatus = ? and bill.fsaleorgunitid like ? and bill.fchannelid like ? and jxc.fsaleorgunitid=bill.fsaleorgunitid and jxc.fchannelid=bill.fchannelid and to_date(concat(substring(to_char(bill.fbizdate,'YYYY-MM-DD'),1,7),'-01 00:00:00')) = ? group by bill.fsaleorgunitid, bill.fchannelid)";
        Object[] value = new Object[]{this.billstatus, this.saleOrgUnitID + "%", this.channelID + "%", new Date(this.bizDate.getTime())};
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])value);
        try {
            if (rs.next()) {
                String bizdate = rs.getString("bizdate");
                if (bizdate == null) {
                    return;
                }
                this.accountMaxYear = bizdate.substring(0, 4);
                this.accountMaxMon = bizdate.substring(4);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
    }

    public boolean existAccount() throws BOSException {
        String sql = "select fid from T_CHA_ChannelJXCAccountBook jxc where to_date(concat(concat(jxc.FBizDateYear,'-'),concat(jxc.FBizDateMon, '-01 00:00:00'))) = ? and exists(select 1 from " + this.billtable + " bill where 1=1 and bill.fbasestatus = ? and bill.fsaleorgunitid like ? and bill.fchannelid like ? and jxc.fsaleorgunitid=bill.fsaleorgunitid and jxc.fchannelid=bill.fchannelid and to_date(concat(substring(to_char(bill.fbizdate,'YYYY-MM-DD'),1,7),'-01 00:00:00')) = ? group by bill.fsaleorgunitid, bill.fchannelid)";
        Object[] value = new Object[]{new Date(this.bizDate.getTime()), this.billstatus, this.saleOrgUnitID + "%", this.channelID + "%", new Date(this.bizDate.getTime())};
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])value);
        try {
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
    }

    private void deleteAccount(java.util.Date minDate, java.util.Date maxDate) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("delete from t_cha_channeljxcaccountbook ").append("where 1=1 ").append("and exists(select 1 from " + this.billtable + " bill ").append("where fsaleorgunitid=bill.fsaleorgunitid ").append("and fchannelid=bill.fchannelid ").append("and bill.fbasestatus = ? ").append("and bill.fsaleorgunitid like ? ").append("and bill.fchannelid like ? ").append("and to_date(concat(substring(to_char(bill.fbizdate,'YYYY-MM-DD'),1,7),'-01 00:00:00')) between ? and ? ").append("group by bill.fsaleorgunitid, bill.fchannelid) ");
        Object[] value = new Object[]{this.billstatus, this.saleOrgUnitID + "%", this.channelID + "%", new Date(minDate.getTime()), new Date(maxDate.getTime())};
        DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getBizDate() throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select to_date(concat(substring(to_char(bill.fbizdate,'YYYY-MM-DD'),1,7),'-01 00:00:00')) bizdate from " + this.billtable + " bill ").append("where 1=1 ").append("and bill.fbasestatus = ? ").append("and bill.fsaleorgunitid like ? ").append("and bill.fchannelid like ? ").append("group by to_date(concat(substring(to_char(bill.fbizdate,'YYYY-MM-DD'),1,7),'-01 00:00:00')) ").append("order by to_date(concat(substring(to_char(bill.fbizdate,'YYYY-MM-DD'),1,7),'-01 00:00:00')) ");
        ArrayList<Date> bizDate = new ArrayList<Date>();
        Date bizdate = null;
        Object[] value = new Object[]{this.billstatus, this.saleOrgUnitID + "%", this.channelID + "%"};
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])value);
        try {
            while (rs.next()) {
                bizdate = rs.getDate("bizdate");
                if (bizdate == null) {
                    List list = null;
                    return list;
                }
                bizDate.add(bizdate);
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return bizDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getID(java.util.Date bizDate) throws BOSException, SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("select fid from " + this.billtable + " bill ").append("where 1=1 ").append("and bill.fbasestatus = ? ").append("and to_date(concat(substring(to_char(bill.fbizdate,'YYYY-MM-DD'),1,7),'-01 00:00:00')) = ? ").append("and bill.fsaleorgunitid like ? ").append("and bill.fchannelid like ? ");
        ArrayList<String> IDS = new ArrayList<String>();
        String ID = null;
        Object[] value = new Object[]{this.billstatus, new Date(bizDate.getTime()), this.saleOrgUnitID + "%", this.channelID + "%"};
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])value);
        try {
            while (rs.next()) {
                ID = rs.getString("FID");
                IDS.add(ID);
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return IDS;
    }

    private String transPKToIds(List pks) {
        StringBuffer _pks = new StringBuffer();
        int length = pks.size();
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                _pks.append(",");
            }
            _pks.append("'" + pks.get(i) + "'");
        }
        return _pks.toString();
    }

    public void init(Context ctx, String ID, java.util.Date date, String saleOrgUnitID, String channelID, boolean in) {
        if (ID != null && ID.indexOf("'") == -1) {
            ID = "'" + ID + "'";
        }
        this.ctx = ctx;
        this.ID = ID;
        String strbizDate = this.parseDate(date, "yyyy-MM") + "-01";
        this.bizDate = this.parseDate(strbizDate, "yyyy-MM-dd");
        this.saleOrgUnitID = saleOrgUnitID == null ? "" : saleOrgUnitID;
        this.channelID = channelID == null ? "" : channelID;
        this.in = in;
        if (in) {
            this.billtable = TABLE_IN_BILL;
            this.entrytable = TABLE_IN_ENTRY;
        } else {
            this.billtable = TABLE_OUT_BILL;
            this.entrytable = TABLE_OUT_ENTRY;
        }
    }

    public void init(Context ctx, String saleOrgUnitID, String channelID, boolean in) {
        this.init(ctx, null, null, saleOrgUnitID, channelID, in);
    }

    public void firstDoAccount(String year, String month) throws BOSException {
        this.insertAccountDirect(year, month);
    }

    public void beforeAccount() throws BOSException {
        String date;
        String year = null;
        String month = null;
        String bizDateStr = this.parseDate(this.bizDate);
        year = bizDateStr.substring(0, 4);
        month = bizDateStr.substring(5, 7);
        this.firstDoAccount(year, month);
        java.util.Date beginDate = null;
        java.util.Date endDate = null;
        beginDate = this.bizDate;
        endDate = this.parseDate(this.accountMaxYear + "-" + this.accountMaxMon);
        int count = this.getMonths(beginDate, endDate);
        Object[] value = new Object[]{this.accountMaxYear, this.accountMaxMon};
        for (int i = 1; i < count; ++i) {
            beginDate = this.getNextMonth(beginDate);
            date = this.parseDate(beginDate);
            year = date.substring(0, 4);
            month = date.substring(5);
            this.insertAccountDirect(year, month, true);
        }
        beginDate = this.getNextMonth(beginDate);
        date = this.parseDate(beginDate);
        year = date.substring(0, 4);
        month = date.substring(5);
        this.insertAccountCompare(value, year, month);
        this.updateAccount("FInitQty", "FQty");
        this.updateAccount("FBaseInitQty", "FBaseQty");
        this.updateAccount("FAssistInitQty", "FAssistQty");
        this.updateAccount("FLeftQty", "FQty");
        this.updateAccount("FBaseLeftQty", "FBaseQty");
        this.updateAccount("FAssistLeftQty", "FAssistQty");
    }

    public void afterAccount() throws BOSException {
        StringBuffer sql = null;
        java.util.Date beginDate = null;
        java.util.Date endDate = null;
        beginDate = this.parseDate(this.accountMaxYear + "-" + this.accountMaxMon);
        endDate = this.bizDate;
        int count = this.getMonths(beginDate, endDate);
        String year = null;
        String month = null;
        Object[] value = null;
        for (int i = 1; i < count + 1; ++i) {
            beginDate = this.getNextMonth(beginDate);
            String date = this.parseDate(beginDate);
            year = date.substring(0, 4);
            month = date.substring(5);
            sql = new StringBuffer();
            sql.append("insert into T_CHA_ChannelJXCAccountBook(FID, FBizDateYear, FBizDateMon, FSALEORGUNITID, FCHANNELID, FMATERIALID, FBATCHNO, FASSISTPROPERTYID, FINITQTY, FINQTY, FOUTQTY, FLEFTQTY, FUnitID, FBASEINITQTY, FBASEINQTY, FBASEOUTQTY, FBASELEFTQTY, FBaseUnitID, FASSISTINITQTY, FASSISTINQTY, FASSISTOUTQTY, FASSISTLEFTQTY, FAssistUnitID, FCurrencyID, FINITPRICE, FINPRICE, FOUTPRICE, FLEFTPRICE) ").append("select NEWBOSID('8A47E245'), '" + year + "', '" + month + "', FSALEORGUNITID, FCHANNELID, FMATERIALID, FBATCHNO, FASSISTPROPERTYID, FLEFTQTY, 0, 0, FLEFTQTY, FUnitID, FBASELEFTQTY, 0, 0, FBASELEFTQTY, FBaseUnitID, FASSISTLEFTQTY, 0, 0, FASSISTLEFTQTY, FAssistUnitID, FCurrencyID, FINITPRICE, FINPRICE, FOUTPRICE, FLEFTPRICE ").append("from T_CHA_ChannelJXCAccountBook jxc ").append("where 1=1 ").append("and jxc.FBizDateYear = ? ").append("and jxc.FBizDateMon = ? ").append("and exists(select 1 from " + this.billtable + " bill where 1=1 and bill.fsaleorgunitid like ? and bill.fchannelid like ? and jxc.fsaleorgunitid=bill.fsaleorgunitid and jxc.fchannelid=bill.fchannelid and substring(to_char(bill.fbizdate,'YYYY-MM-DD'),1,7) = ? group by bill.fsaleorgunitid, bill.fchannelid)");
            value = new Object[]{this.accountMaxYear, this.accountMaxMon, this.saleOrgUnitID + "%", this.channelID + "%", this.parseDate(endDate, "yyyy-MM")};
            DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])value);
        }
        value = new Object[]{year, month};
        this.insertAccountCompare(value, year, month);
        if (this.in) {
            this.updateAccount("FInQty", "FQty", false);
            this.updateAccount("FBaseInQty", "FBaseQty", false);
            this.updateAccount("FAssistInQty", "FAssistQty", false);
        } else {
            this.flag = -this.flag;
            this.updateAccount("FOutQty", "FQty", false);
            this.updateAccount("FBaseOutQty", "FBaseQty", false);
            this.updateAccount("FAssistOutQty", "FAssistQty", false);
            this.flag = -this.flag;
        }
        this.updateAccount();
    }

    public void equalAccount() throws BOSException {
        String str = this.parseDate(this.bizDate);
        String year = str.substring(0, 4);
        String month = str.substring(5);
        Object[] value = new Object[]{year, month};
        this.insertAccountCompare(value, year, month);
        if (this.in) {
            this.updateAccount("FInQty", "FQty", false);
            this.updateAccount("FBaseInQty", "FBaseQty", false);
            this.updateAccount("FAssistInQty", "FAssistQty", false);
        } else {
            this.flag = -this.flag;
            this.updateAccount("FOutQty", "FQty", false);
            this.updateAccount("FBaseOutQty", "FBaseQty", false);
            this.updateAccount("FAssistOutQty", "FAssistQty", false);
            this.flag = -this.flag;
        }
        this.updateAccount();
        this.updateAccount("FInitQty", "FQty");
        this.updateAccount("FBaseInitQty", "FBaseQty");
        this.updateAccount("FAssistInitQty", "FAssistQty");
        this.updateAccount("FLeftQty", "FQty");
        this.updateAccount("FBaseLeftQty", "FBaseQty");
        this.updateAccount("FAssistLeftQty", "FAssistQty");
    }

    private void insertAccountDirect(String year, String month, boolean nullrecord) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_CHA_ChannelJXCAccountBook(FID, FBizDateYear, FBizDateMon, FSALEORGUNITID, FCHANNELID, FMATERIALID, FBATCHNO, FASSISTPROPERTYID, FINITQTY, FINQTY, FOUTQTY, FLEFTQTY, FUnitID, FBASEINITQTY, FBASEINQTY, FBASEOUTQTY, FBASELEFTQTY, FBaseUnitID, FASSISTINITQTY, FASSISTINQTY, FASSISTOUTQTY, FASSISTLEFTQTY, FAssistUnitID, FCurrencyID, FINITPRICE, FINPRICE, FOUTPRICE, FLEFTPRICE) ");
        if (this.in) {
            if (nullrecord) {
                sql.append("select NEWBOSID('8A47E245'), '" + year + "', '" + month + "', max(bill.FSALEORGUNITID), max(bill.FCHANNELID), entry.FMATERIALID, entry.FBATCHNO, entry.FASSISTPROPERTYID, 0, 0, 0, 0, entry.FUnitID, 0, 0, 0, 0, entry.FBaseUnitID, 0, 0, 0, 0, entry.FAssistUnitID, bill.FCurrencyID, 0, sum(entry.FAmount), 0, sum(entry.FAmount) ");
            } else {
                sql.append("select NEWBOSID('8A47E245'), '" + year + "', '" + month + "', max(bill.FSALEORGUNITID), max(bill.FCHANNELID), entry.FMATERIALID, entry.FBATCHNO, entry.FASSISTPROPERTYID, 0, sum(entry.FQTY), 0, sum(entry.FQTY), entry.FUnitID, 0, sum(entry.FBaseQty), 0, sum(entry.FBaseQty), entry.FBaseUnitID, 0, sum(entry.FAssistQty), 0, sum(entry.FAssistQTY), entry.FAssistUnitID, bill.FCurrencyID, 0, sum(entry.FAmount), 0, sum(entry.FAmount) ");
            }
        } else if (nullrecord) {
            sql.append("select  NEWBOSID('8A47E245'), '" + year + "', '" + month + "', max(bill.FSALEORGUNITID), max(bill.FCHANNELID), entry.FMATERIALID, entry.FBATCHNO, entry.FASSISTPROPERTYID, 0, 0, 0, 0, entry.FUnitID, 0, 0, 0, 0, entry.FBaseUnitID, 0, 0, 0, 0, entry.FAssistUnitID, bill.FCurrencyID, 0, 0, sum(entry.FAmount), sum(entry.FAmount) ");
        } else {
            sql.append("select  NEWBOSID('8A47E245'), '" + year + "', '" + month + "', max(bill.FSALEORGUNITID), max(bill.FCHANNELID), entry.FMATERIALID, entry.FBATCHNO, entry.FASSISTPROPERTYID, 0, 0, sum(entry.FQTY), sum(entry.FQTY), entry.FUnitID, 0, 0, sum(entry.FBaseQty), sum(entry.FBaseQty), entry.FBaseUnitID, 0, 0, sum(entry.FAssistQty), sum(entry.FAssistQTY), entry.FAssistUnitID, bill.FCurrencyID, 0, 0, sum(entry.FAmount), sum(entry.FAmount) ");
        }
        sql.append("from " + this.entrytable + " entry ").append("inner join " + this.billtable + " bill on bill.FID = entry.FPARENTID ").append("where 1=1 ").append("and bill.FID in (" + this.ID + ") ").append("group by entry.FMATERIALID, entry.FBATCHNO, entry.FASSISTPROPERTYID, entry.FUnitID, entry.FBaseUnitID, entry.FAssistUnitID, bill.FCurrencyID ");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    private void insertAccountDirect(String year, String month) throws BOSException {
        this.insertAccountDirect(year, month, false);
    }

    private void insertAccountCompare(Object[] value, String year, String month) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_CHA_ChannelJXCAccountBook(FID, FBizDateYear, FBizDateMon, FSALEORGUNITID, FCHANNELID, FMATERIALID, FBATCHNO, FASSISTPROPERTYID, FINITQTY, FINQTY, FOUTQTY, FLEFTQTY, FUnitID, FBASEINITQTY, FBASEINQTY, FBASEOUTQTY, FBASELEFTQTY, FBaseUnitID, FASSISTINITQTY, FASSISTINQTY, FASSISTOUTQTY, FASSISTLEFTQTY, FAssistUnitID, FCurrencyID, FINITPRICE, FINPRICE, FOUTPRICE, FLEFTPRICE) ").append("select NEWBOSID('8A47E245'), '" + year + "', '" + month + "', max(bill.FSALEORGUNITID), max(bill.FCHANNELID), entry.FMATERIALID, entry.FBATCHNO, entry.FASSISTPROPERTYID, 0, 0, 0, 0, entry.FUnitID, 0, 0, 0, 0, entry.FBaseUnitID, 0, 0, 0, 0, entry.FAssistUnitID, bill.FCurrencyID, 0, 0, sum(entry.FAmount), sum(entry.FAmount) ").append("from " + this.entrytable + " entry ").append("inner join " + this.billtable + " bill on bill.FID = entry.FPARENTID ").append("where 1=1 ").append("and bill.FID in (" + this.ID + ") ").append("and not exists(select 1 from T_CHA_ChannelJXCAccountBook jxc ").append("where 1=1 ").append("and jxc.FSALEORGUNITID=bill.FSALEORGUNITID ").append("and jxc.FCHANNELID=bill.FCHANNELID ").append("and jxc.FMATERIALID=entry.FMATERIALID ").append("and isnull(jxc.FBATCHNO,'1')=isnull(entry.FBATCHNO,'1') ").append("and isnull(jxc.FASSISTPROPERTYID,'1')=isnull(entry.FASSISTPROPERTYID,'1') ").append("and isnull(jxc.FUnitID,'1')=isnull(entry.FUnitID,'1') ").append("and isnull(jxc.FBaseUnitID,'1')=isnull(entry.FBaseUnitID,'1') ").append("and isnull(jxc.FAssistUnitID,'1')=isnull(entry.FAssistUnitID,'1') ").append("and isnull(jxc.FCurrencyID,'1')=isnull(bill.FCurrencyID,'1') ").append("and jxc.FBizDateYear = ? ").append("and jxc.FBizDateMon = ? ) ").append("group by entry.FMATERIALID, entry.FBATCHNO, entry.FASSISTPROPERTYID, entry.FUnitID, entry.FBaseUnitID, entry.FAssistUnitID, bill.FCurrencyID ");
        DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])value);
    }

    private void updateAccount(String updateColumn, String sumColumn, boolean greaterBizDate) throws BOSException {
        String compare = null;
        compare = greaterBizDate ? ">" : "=";
        StringBuffer sql = new StringBuffer();
        sql.append("update T_CHA_ChannelJXCAccountBook as jxc ").append("set " + updateColumn + " = " + updateColumn + " + ( ").append("select (" + this.flag + ")*sum(entry." + sumColumn + ") from " + this.entrytable + " entry ").append("inner join " + this.billtable + " bill on bill.FID = entry.FPARENTID ").append("where 1=1 ").append("and bill.FID in (" + this.ID + ") ").append("and to_date(concat(concat(jxc.FBizDateYear,'-'),concat(jxc.FBizDateMon, '-01 00:00:00')))" + compare + " ? ").append("and jxc.FSALEORGUNITID=bill.FSALEORGUNITID ").append("and jxc.FCHANNELID=bill.FCHANNELID ").append("and jxc.FMATERIALID=entry.FMATERIALID ").append("and isnull(jxc.FBATCHNO,'1')=isnull(entry.FBATCHNO,'1') ").append("and isnull(jxc.FASSISTPROPERTYID,'1')=isnull(entry.FASSISTPROPERTYID,'1') ").append("and isnull(jxc.FUnitID,'1')=isnull(entry.FUnitID,'1') ").append("and isnull(jxc.FBaseUnitID,'1')=isnull(entry.FBaseUnitID,'1') ").append("and isnull(jxc.FAssistUnitID,'1')=isnull(entry.FAssistUnitID,'1') ").append("and isnull(jxc.FCurrencyID,'1')=isnull(bill.FCurrencyID,'1') ").append("group by entry.FMATERIALID, entry.FBATCHNO, entry.FASSISTPROPERTYID, entry.FUnitID, entry.FBaseUnitID, entry.FAssistUnitID, bill.FCurrencyID ").append(") ").append("where 1=1 ").append("and exists(select 1 from " + this.entrytable + " entry ").append("inner join " + this.billtable + " bill on bill.FID = entry.FPARENTID ").append("where 1=1 ").append("and bill.FID in (" + this.ID + ") ").append("and to_date(concat(concat(jxc.FBizDateYear,'-'),concat(jxc.FBizDateMon, '-01 00:00:00')))" + compare + " ? ").append("and jxc.FSALEORGUNITID=bill.FSALEORGUNITID ").append("and jxc.FCHANNELID=bill.FCHANNELID ").append("and jxc.FMATERIALID=entry.FMATERIALID ").append("and isnull(jxc.FBATCHNO,'1')=isnull(entry.FBATCHNO,'1') ").append("and isnull(jxc.FASSISTPROPERTYID,'1')=isnull(entry.FASSISTPROPERTYID,'1') ").append("and isnull(jxc.FUnitID,'1')=isnull(entry.FUnitID,'1') ").append("and isnull(jxc.FBaseUnitID,'1')=isnull(entry.FBaseUnitID,'1') ").append("and isnull(jxc.FAssistUnitID,'1')=isnull(entry.FAssistUnitID,'1') ").append("and isnull(jxc.FCurrencyID,'1')=isnull(bill.FCurrencyID,'1') ").append(")");
        Object[] value = new Object[]{new Date(this.bizDate.getTime()), new Date(this.bizDate.getTime())};
        DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])value);
    }

    private void updateAccount(String updateColumn, String sumColumn) throws BOSException {
        this.updateAccount(updateColumn, sumColumn, true);
    }

    private void updateAccount() throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update T_CHA_ChannelJXCAccountBook as jxc ").append("set (FLeftQty, FBASELEFTQTY, FASSISTLeftQTY) = (select jxc_.FInitQty+jxc_.FInQty-jxc_.FOutQty, jxc_.FBaseInitQty+jxc_.FBaseInQty-jxc_.FBaseOutQty, jxc_.FAssistInitQty+jxc_.FAssistInQty-jxc_.FAssistOutQty from T_CHA_ChannelJXCAccountBook jxc_ where jxc.FID=jxc_.FID) ").append("where 1=1 ").append("and exists(select 1 from " + this.entrytable + " entry ").append("inner join " + this.billtable + " bill on bill.FID = entry.FPARENTID ").append("where 1=1 ").append("and bill.FID in (" + this.ID + ") ").append("and jxc.FBizDateYear = ? ").append("and jxc.FBizDateMon = ? ").append("and jxc.FSALEORGUNITID=bill.FSALEORGUNITID ").append("and jxc.FCHANNELID=bill.FCHANNELID ").append("and jxc.FMATERIALID=entry.FMATERIALID ").append("and isnull(jxc.FBATCHNO,'1')=isnull(entry.FBATCHNO,'1') ").append("and isnull(jxc.FASSISTPROPERTYID,'1')=isnull(entry.FASSISTPROPERTYID,'1') ").append("and isnull(jxc.FUnitID,'1')=isnull(entry.FUnitID,'1') ").append("and isnull(jxc.FBaseUnitID,'1')=isnull(entry.FBaseUnitID,'1') ").append("and isnull(jxc.FAssistUnitID,'1')=isnull(entry.FAssistUnitID,'1') ").append("and isnull(jxc.FCurrencyID,'1')=isnull(bill.FCurrencyID,'1') ").append(")");
        String str = this.parseDate(this.bizDate);
        String year = str.substring(0, 4);
        String month = str.substring(5);
        Object[] value = new Object[]{year, month};
        DbUtil.execute((Context)this.ctx, (String)sql.toString(), (Object[])value);
    }

    private String parseDate(java.util.Date date) {
        String pattern = "yyyy-MM";
        return this.parseDate(date, pattern);
    }

    private String parseDate(java.util.Date date, String pattern) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern(pattern);
        return sdf.format(date);
    }

    private java.util.Date parseDate(String str) {
        return this.parseDate(str, "yyyy-MM");
    }

    private java.util.Date parseDate(String str, String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern(pattern);
        java.util.Date date = null;
        try {
            date = sdf.parse(str);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return date;
    }

    private java.util.Date getNextMonth(java.util.Date date) {
        GregorianCalendar gc = (GregorianCalendar)Calendar.getInstance();
        gc.setTime(date);
        gc.add(2, 1);
        return gc.getTime();
    }

    private int getMonths(java.util.Date date1, java.util.Date date2) {
        int iMonth = 0;
        int flag = 0;
        try {
            Calendar objCalendarDate1 = Calendar.getInstance();
            objCalendarDate1.setTime(date1);
            Calendar objCalendarDate2 = Calendar.getInstance();
            objCalendarDate2.setTime(date2);
            if (objCalendarDate2.equals(objCalendarDate1)) {
                return 0;
            }
            if (objCalendarDate1.after(objCalendarDate2)) {
                Calendar temp = objCalendarDate1;
                objCalendarDate1 = objCalendarDate2;
                objCalendarDate2 = temp;
            }
            if (objCalendarDate2.get(5) < objCalendarDate1.get(5)) {
                flag = 1;
            }
            iMonth = objCalendarDate2.get(1) > objCalendarDate1.get(1) ? (objCalendarDate2.get(1) - objCalendarDate1.get(1)) * 12 + objCalendarDate2.get(2) - flag - objCalendarDate1.get(2) : objCalendarDate2.get(2) - objCalendarDate1.get(2) - flag;
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return iMonth;
    }
}

