/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseFactory;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.DataCollectionTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.channel.ChannelBillException;
import com.kingdee.eas.scm.sd.channel.ChannelJXCBillEntryCollection;
import com.kingdee.eas.scm.sd.channel.ChannelJXCBillInfo;
import com.kingdee.eas.scm.sd.channel.app.AbstractChannelJXCBillControllerBean;
import com.kingdee.eas.scm.sd.channel.app.SaleChannelInventoryHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.log4j.Logger;

public class ChannelJXCBillControllerBean
extends AbstractChannelJXCBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.channel.app.ChannelJXCBillControllerBean");
    private static String RESOURCE_PATH = "com.kingdee.eas.scm.sd.channel.ChannelStockBillResource";
    private static BigDecimal DEFAULT_NUM = new BigDecimal("0");

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ChannelJXCBillInfo billInfo = this.getChannelJXCBillInfo(ctx, pk);
        if (!billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            throw new ChannelBillException(ChannelBillException.ONLYSUBMITCANAUDIT, new String[]{billInfo.getNumber()});
        }
        billInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
        billInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        billInfo.setAuditTime(new Timestamp(System.currentTimeMillis()));
        int j = billInfo.getEntries().size();
        for (int i = 0; i < j; ++i) {
            billInfo.getEntries().get(i).setBaseStatus(EntryBaseStatusEnum.AUDITED);
        }
        this.update(ctx, pk, billInfo);
        try {
            if (this.isUpdateChannelInventory(ctx, pk, billInfo)) {
                new SaleChannelInventoryHelper().updateInventory(ctx, (IObjectValue)billInfo, BizActionEnum.AUDIT);
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this.audit(ctx, pks[i]);
        }
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ChannelJXCBillInfo billInfo = this.getChannelJXCBillInfo(ctx, pk);
        if (!billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new ChannelBillException(ChannelBillException.ONLYAUDITCANUNAUDIT, new String[]{billInfo.getNumber()});
        }
        String orgUnitID = billInfo.getSaleOrgUnit().getId().toString();
        if (!this.isUnAudit(ctx, billInfo, orgUnitID, 2)) {
            throw new ChannelBillException(ChannelBillException.NOALLOWUNADUIT);
        }
        billInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        billInfo.setAuditor(null);
        billInfo.setAuditTime(null);
        this.update(ctx, pk, billInfo);
        try {
            if (this.isUpdateChannelInventory(ctx, pk, billInfo)) {
                new SaleChannelInventoryHelper().updateInventory(ctx, (IObjectValue)billInfo, BizActionEnum.UNAUDIT);
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this.unAudit(ctx, pks[i]);
        }
    }

    private boolean isUpdateChannelInventory(Context ctx, IObjectPK pk, ChannelJXCBillInfo billInfo) throws BOSException, EASBizException {
        DataCollectionTypeEnum channelUpdateType;
        ChannelBaseInfo channelBaseInfo = billInfo.getChannel();
        if (channelBaseInfo != null) {
            channelBaseInfo = ChannelBaseFactory.getLocalInstance((Context)ctx).getChannelBaseInfo((IObjectPK)new ObjectUuidPK(channelBaseInfo.getId().toString()));
        }
        return (channelUpdateType = channelBaseInfo.getDataCollectionType()).getValue().equals("4");
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ChannelJXCBillInfo billInfo = (ChannelJXCBillInfo)model;
        ObjectUuidPK pk = null;
        if (!this.isAddNew(ctx, (IObjectValue)billInfo)) {
            pk = new ObjectUuidPK(billInfo.getId());
            this.checkSubmit(ctx, billInfo);
        }
        BillTypeInfo billTypeInfo = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK("pGcPqwEaEADgAAAywKg9C0Y+1VI="));
        billInfo.setBillType(billTypeInfo);
        billInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        pk = super._submit(ctx, model);
        String orgUnitID = billInfo.getSaleOrgUnit().getId().toString();
        if (this.isAuditAfterSubmit(ctx, billInfo, orgUnitID, 2)) {
            this.auditAndLog(ctx, (IObjectPK)pk, billInfo.getBOSType(), billInfo.getNumber(), null);
        }
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ChannelJXCBillInfo billInfo = (ChannelJXCBillInfo)model;
        billInfo.setBotpCallSave(false);
        this.checkSave(ctx, billInfo);
        return super._save(ctx, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ChannelJXCBillInfo billInfo = this.getChannelJXCBillInfo(ctx, pk);
        this.checkDelete(ctx, billInfo);
        super._delete(ctx, pk);
    }

    private void checkDelete(Context ctx, ChannelJXCBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo.getBaseStatus() != null && billInfo.getBaseStatus().getValue() == 4) {
            throw new ChannelBillException(ChannelBillException.DELETE_IS_AUDIT);
        }
    }

    private void checkUpdate(Context ctx, ChannelJXCBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo.getBaseStatus() != null && billInfo.getBaseStatus().getValue() == 4) {
            throw new ChannelBillException(ChannelBillException.UPDATE_IS_AUDIT);
        }
    }

    private void checkSubmit(Context ctx, ChannelJXCBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo.getBaseStatus() != null && billInfo.getBaseStatus().getValue() == 4) {
            throw new ChannelBillException(ChannelBillException.SUBMIT_IS_AUDIT);
        }
    }

    private void checkSave(Context ctx, ChannelJXCBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo.getBaseStatus() != null) {
            if (billInfo.getBaseStatus().getValue() == 4) {
                throw new ChannelBillException(ChannelBillException.SAVE_IS_AUDIT);
            }
            if (billInfo.getBaseStatus().getValue() == 2) {
                throw new ChannelBillException(ChannelBillException.SAVE_IS_SUBMIT);
            }
        }
    }

    private void beforeSubmitValidateData(Context ctx, ChannelJXCBillInfo info) throws BOSException, EASBizException {
        if (info.getSaleOrgUnit() == null) {
            throw new ChannelBillException(ChannelBillException.SALEORGNOTNULL);
        }
        if (info.getSalePerson() == null) {
            throw new ChannelBillException(ChannelBillException.SALEPERSONNULL);
        }
        if (info.getChannelType() == null) {
            throw new ChannelBillException(ChannelBillException.CHANNELTYPENULL);
        }
        if (info.getChannel() == null) {
            throw new ChannelBillException(ChannelBillException.CHANNELNULL);
        }
        if (info.getCurrency() == null) {
            throw new ChannelBillException(ChannelBillException.CURRENCYNOTNULL);
        }
        ChannelJXCBillEntryCollection entries = info.getEntries();
        StringBuffer message = new StringBuffer();
        if (entries.size() == 0) {
            message.append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"ENTRYNOTNULL", (Context)ctx));
            throw new ChannelBillException(ChannelBillException.EXCEPTIONWITHMESSAGE, new String[]{message.toString()});
        }
        boolean isError = false;
        boolean isNumError = false;
        int c = entries.size();
        for (int i = 0; i < c; ++i) {
            message.append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"SEQ", (Context)ctx)).append(i + 1).append(" ");
            if (entries.get(i).getMaterial() == null) {
                message.append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"MATERIAL", (Context)ctx)).append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"NOTNULLALL", (Context)ctx));
                isError = true;
            }
            if (entries.get(i).getUnit() == null) {
                if (message.length() > 0) {
                    message.append(";");
                }
                message.append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"UNIT", (Context)ctx)).append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"NOTNULL", (Context)ctx));
                isError = true;
            }
            if (entries.get(i).getInQty() == null || entries.get(i).getInQty().doubleValue() == 0.0) {
                if (message.length() > 0) {
                    message.append(";");
                }
                message.append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"QTY", (Context)ctx));
                isError = true;
                isNumError = true;
            }
            if (entries.get(i).getOutQty() == null || entries.get(i).getOutQty().doubleValue() == 0.0) {
                if (message.length() > 0) {
                    message.append(";");
                }
                message.append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"QTY", (Context)ctx));
                isError = true;
                isNumError = true;
            }
            if (entries.get(i).getInvQty() == null || entries.get(i).getInvQty().doubleValue() == 0.0) {
                if (message.length() > 0) {
                    message.append(";");
                }
                message.append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"QTY", (Context)ctx));
                isError = true;
                isNumError = true;
            }
            if (isNumError) {
                message.append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"NOTZERO", (Context)ctx));
            }
            if (!isError) continue;
            throw new ChannelBillException(ChannelBillException.EXCEPTIONWITHMESSAGE, new String[]{message.toString()});
        }
    }

    @Override
    protected java.util.Date _getCurrenMaxStockDate(Context ctx, String channelID) throws BOSException {
        Date stockMaxDate = null;
        StringBuffer querySql = new StringBuffer();
        querySql.append("\n Select Max(FStorageDate) As MaxStorageDate From T_SD_ChannelInventory ");
        querySql.append("\n Where FSaleChannelID='" + channelID + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)querySql.toString());
        try {
            while (rs.next()) {
                stockMaxDate = rs.getDate("MaxStorageDate");
            }
            Date date = stockMaxDate;
            return date;
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
    }
}

