/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseCollection;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseFactory;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.DataCollectionTypeEnum;
import com.kingdee.eas.basedata.scm.sd.sale.SalePersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.cal.util.DBUtil;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.sd.channel.ChannelBillEnum;
import com.kingdee.eas.scm.sd.channel.ChannelJXCBillCollection;
import com.kingdee.eas.scm.sd.channel.ChannelJXCBillEntryCollection;
import com.kingdee.eas.scm.sd.channel.ChannelJXCBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.ChannelJXCBillFactory;
import com.kingdee.eas.scm.sd.channel.ChannelJXCBillInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;

public class ChannelJXCBillImport
extends AbstractDataTransmission {
    public static final String RES_IMPORT_CLASS = "com.kingdee.eas.scm.sd.channel.ChannelImportResource";
    ChannelJXCBillInfo jxcBillInfo = null;
    public static final String Locale_en = "l1";
    public static final String Locale_zh = "l2";
    public static final String Locale_tw = "l3";
    Locale local = new Locale("l2");
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    String[] BIGDECIMAL_FIELDS_EN = new String[]{"FEntries_inQty", "FEntries_outQty", "FEntries_invQty", "FEntries_price", "FEntries_amount"};
    String[] BIGDECIMAL_OBJ_EN = new String[]{"inQty", "outQty", "invQty", "price", "amount"};

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return ChannelJXCBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        return this.transmitHead(hsData, ctx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ChannelJXCBillInfo transmitHead(Hashtable lineData, Context ctx) throws TaskExternalException {
        CurrencyInfo baseCurrencyInfo;
        int baseStatus;
        ChannelBaseCollection collection;
        ChannelBaseInfo channelBaseInfo;
        String objString = null;
        Object data = ((DataToken)lineData.get((Object)"FNumber")).data;
        if (data == null || data != null && data.toString().trim().length() < 1) {
            data = this.getContextParameter("number");
        }
        ChannelBaseInfo tempChannelBaseInfo = channelBaseInfo = (ChannelBaseInfo)this.getContextParameter("channel");
        this.jxcBillInfo = null;
        if (data != null && data.toString().trim().length() >= 1) {
            this.jxcBillInfo = this.getBillFromNumber(data.toString().trim(), ctx);
        }
        SaleOrgUnitInfo saleOrgUnitInfo = null;
        SalePersonInfo salePersonInfo = null;
        if (tempChannelBaseInfo == null) {
            if (data == null || data.toString().trim().length() < 1) {
                throw new TaskExternalException(this.getChannelImportResource("NUMBER_CANNOT_NULL"));
            }
            Object channelData = ((DataToken)lineData.get((Object)"FChannel_number")).data;
            if (channelData == null) throw new TaskExternalException(this.getChannelImportResource("CHANNEL_CANNOT_NULL"));
            objString = channelData.toString();
            if (objString == null || objString.trim().length() <= 0) throw new TaskExternalException(this.getChannelImportResource("CHANNEL_CANNOT_NULL"));
            collection = null;
            try {
                collection = ChannelBaseFactory.getLocalInstance((Context)ctx).getChannelBaseCollection(this.getFilter(objString.trim()));
            }
            catch (BOSException e) {
                throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_CHANNEL"));
            }
            if (collection == null || collection.size() <= 0) throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_CHANNEL"));
            channelBaseInfo = collection.get(0);
            if (!this.verifyCollectionType(channelBaseInfo)) {
                throw new TaskExternalException(this.getChannelImportResource("ERROR_COLLECT_TYPE"));
            }
        } else {
            saleOrgUnitInfo = (SaleOrgUnitInfo)this.getContextParameter("saleOrg");
            data = this.getNumber(ctx, data, saleOrgUnitInfo);
            salePersonInfo = (SalePersonInfo)this.getContextParameter("salePerson");
        }
        if (tempChannelBaseInfo == null) {
            Object saleOrgUnitData = ((DataToken)lineData.get((Object)"FSaleOrgUnit_number")).data;
            if (saleOrgUnitData == null) throw new TaskExternalException(this.getChannelImportResource("SALEORG_CANNOT_NULL"));
            objString = saleOrgUnitData.toString();
            if (objString == null || objString.trim().length() <= 0) throw new TaskExternalException(this.getChannelImportResource("SALEORG_CANNOT_NULL"));
            collection = null;
            try {
                collection = SaleOrgUnitFactory.getLocalInstance((Context)ctx).getSaleOrgUnitCollection(this.getFilter(objString.trim()));
            }
            catch (BOSException e) {
                throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_SALEORG"));
            }
            if (collection == null || collection.size() <= 0) throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_SALEORG"));
            saleOrgUnitInfo = collection.get(0);
            data = this.getNumber(ctx, data, saleOrgUnitInfo);
        }
        if (this.jxcBillInfo == null) {
            this.jxcBillInfo = new ChannelJXCBillInfo();
            this.jxcBillInfo.setNumber(data.toString().trim());
            this.jxcBillInfo.setSumQty(new BigDecimal("0.00"));
            this.jxcBillInfo.setSumJXCQty(new BigDecimal("0.00"));
            this.jxcBillInfo.setSumSellQty(new BigDecimal("0.00"));
        } else {
            if (this.jxcBillInfo.getChannel() != null && channelBaseInfo != null && !this.jxcBillInfo.getChannel().getId().toString().equals(channelBaseInfo.getId().toString())) {
                throw new TaskExternalException(data.toString() + this.getChannelImportResource("SAME_NUMBER"));
            }
            if (this.jxcBillInfo.getBaseStatus().getValue() == 4) {
                throw new TaskExternalException(data.toString() + this.getChannelImportResource("HAVE_AUDIT"));
            }
        }
        this.jxcBillInfo.setChannel(channelBaseInfo);
        this.jxcBillInfo.setChannelType(ChannelBillEnum.getEnum(channelBaseInfo.getTerminalChannelType().getName()));
        this.jxcBillInfo.setSaleOrgUnit(saleOrgUnitInfo);
        if (salePersonInfo == null) {
            String salePersonNumber;
            Object salePersonData = ((DataToken)lineData.get((Object)"FSalePerson_number")).data;
            if (salePersonData != null && (salePersonNumber = salePersonData.toString()) != null && salePersonNumber.trim().length() > 0) {
                CoreBaseCollection collection2 = null;
                try {
                    collection2 = PersonFactory.getLocalInstance((Context)ctx).getCollection(this.getFilter(salePersonNumber.toString().trim()));
                }
                catch (BOSException bOSException) {
                    // empty catch block
                }
                if (collection2 != null && collection2.size() > 0) {
                    this.jxcBillInfo.setSalePerson((PersonInfo)collection2.get(0));
                }
            }
        } else {
            this.jxcBillInfo.setSalePerson(salePersonInfo.getPerson());
        }
        if (this.jxcBillInfo.getBizDate() == null) {
            this.jxcBillInfo.setBizDate(new Date());
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Object date = ((DataToken)lineData.get((Object)"FStartDate")).data;
        if (date == null || date.toString().trim().length() <= 0) throw new TaskExternalException(this.getChannelImportResource("STARTDATE_CANNOT_NULL"));
        try {
            this.jxcBillInfo.setStartDate(df.parse(date.toString().trim()));
        }
        catch (ParseException e) {
            throw new TaskExternalException(this.getChannelImportResource("DATE_FORMAT_ERROR"));
        }
        date = ((DataToken)lineData.get((Object)"FEndDate")).data;
        if (date == null || date.toString().trim().length() <= 0) throw new TaskExternalException(this.getChannelImportResource("ENDDATE_CANNOT_NULL"));
        try {
            this.jxcBillInfo.setEndDate(df.parse(date.toString().trim()));
        }
        catch (ParseException e) {
            throw new TaskExternalException(this.getChannelImportResource("DATE_FORMAT_ERROR"));
        }
        Object statusdate = ((DataToken)lineData.get((Object)"FBaseStatus")).data;
        this.jxcBillInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        if (statusdate != null && statusdate.toString().trim().length() > 0 && 1 == (baseStatus = Integer.parseInt(statusdate.toString().trim()))) {
            this.jxcBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        }
        if ((baseCurrencyInfo = (CurrencyInfo)this.getContextParameter("baseCurrencyInfo")) != null) {
            this.jxcBillInfo.setCurrency(baseCurrencyInfo);
            this.jxcBillInfo.setExchangeRate(new BigDecimal("1.00"));
            int precision = baseCurrencyInfo.getPrecision();
            this.jxcBillInfo.setLocalCurPrecision(precision);
            this.jxcBillInfo.setCurrencyPrecision(precision);
            this.jxcBillInfo.setExRatePrecision(2);
        }
        this.jxcBillInfo.setRemark((String)((DataToken)lineData.get((Object)"FRemark")).data);
        try {
            BillTypeInfo billTypeInfo = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK("pGcPqwEaEADgAAAywKg9C0Y+1VI="));
            this.jxcBillInfo.setBillType(billTypeInfo);
        }
        catch (Exception e) {
            throw new TaskExternalException(this.getChannelImportResource("ERROR_SETBILLTYPE"));
        }
        ChannelJXCBillEntryInfo entryInfo = null;
        boolean isUpdateEntry = false;
        data = ((DataToken)lineData.get((Object)"FEntries_seq")).data;
        if (data != null && data.toString().trim().length() > 0) {
            int seq = Integer.parseInt(data.toString());
            ChannelJXCBillEntryCollection entryCollection = this.jxcBillInfo.getEntries();
            int num = entryCollection.size();
            for (int i = 0; i < num; ++i) {
                ChannelJXCBillEntryInfo tempentryInfo = entryCollection.get(i);
                if (tempentryInfo.getSeq() != seq) continue;
                entryInfo = tempentryInfo;
                isUpdateEntry = true;
            }
            if (!isUpdateEntry) {
                entryInfo = new ChannelJXCBillEntryInfo();
                entryInfo.setParent(this.jxcBillInfo);
                entryInfo.setSeq(seq);
                entryCollection.add(entryInfo);
            }
        } else {
            ChannelJXCBillEntryCollection entryCollection = this.jxcBillInfo.getEntries();
            int seq = entryCollection.size() + 1;
            entryInfo = new ChannelJXCBillEntryInfo();
            entryInfo.setParent(this.jxcBillInfo);
            entryInfo.setSeq(seq);
            entryCollection.add(entryInfo);
        }
        this.handleEntry(entryInfo, lineData, ctx);
        return this.jxcBillInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleEntry(ChannelJXCBillEntryInfo entryInfo, Hashtable hsData, Context ctx) throws TaskExternalException {
        for (int i = 0; i < this.BIGDECIMAL_FIELDS_EN.length; ++i) {
            try {
                BigDecimal value;
                if (hsData.get(this.BIGDECIMAL_FIELDS_EN[i]) == null) continue;
                Object dataObj = ((DataToken)hsData.get((Object)this.BIGDECIMAL_FIELDS_EN[i])).data;
                if (this.BIGDECIMAL_OBJ_EN[i].equals("inQty") || this.BIGDECIMAL_OBJ_EN[i].equals("outQty") || this.BIGDECIMAL_OBJ_EN[i].equals("invQty")) {
                    if (dataObj != null && dataObj.toString().trim().length() > 0) {
                        value = new BigDecimal(dataObj.toString());
                        if (value != null) {
                            entryInfo.setBigDecimal(this.BIGDECIMAL_OBJ_EN[i], value);
                            continue;
                        }
                        entryInfo.setBigDecimal(this.BIGDECIMAL_OBJ_EN[i], ZERO);
                        continue;
                    }
                    entryInfo.setBigDecimal(this.BIGDECIMAL_OBJ_EN[i], ZERO);
                    continue;
                }
                if (dataObj == null || dataObj.toString().trim().length() <= 0 || (value = new BigDecimal(dataObj.toString())) == null) continue;
                entryInfo.setBigDecimal(this.BIGDECIMAL_OBJ_EN[i], value);
                continue;
            }
            catch (NumberFormatException nex) {
                Logger.error((Throwable)nex);
                throw new TaskExternalException(this.BIGDECIMAL_FIELDS_EN[i] + this.getChannelImportResource("ERROR_FORMAT") + "\uff0c" + this.getChannelImportResource("BIGDECIMAL_FORMAT"));
            }
        }
        String str = null;
        Object material = ((DataToken)hsData.get((Object)"FEntries$material_number")).data;
        String materialNumber = null;
        if (material == null) throw new TaskExternalException(this.getChannelImportResource("MATERIAL_CANNOT_NULL"));
        materialNumber = str = material.toString();
        if (str == null || str.trim().length() <= 0) throw new TaskExternalException(this.getChannelImportResource("MATERIAL_CANNOT_NULL"));
        MaterialCollection collection = null;
        try {
            collection = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(this.getFilter(str));
        }
        catch (BOSException e) {
            throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_MATERIAL"));
        }
        if (collection == null || collection.size() <= 0) throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_MATERIAL"));
        MaterialInfo info = collection.get(0);
        if (info == null) {
            throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_MATERIAL"));
        }
        entryInfo.setMaterial(info);
        entryInfo.setPricePrecision(info.getPricePrecision());
        MeasureUnitInfo baseUnitinfo = info.getBaseUnit();
        entryInfo.setBaseUnit(baseUnitinfo);
        entryInfo.setBaseUnitPrecision(baseUnitinfo.getQtyPrecision());
        Object unit = ((DataToken)hsData.get((Object)"FEntries$unit_number")).data;
        if (unit == null) throw new TaskExternalException(this.getChannelImportResource("UNIT_CANNOT_NULL"));
        str = unit.toString();
        if (str == null || str.trim().length() <= 0) throw new TaskExternalException(this.getChannelImportResource("UNIT_CANNOT_NULL"));
        boolean flag = this.isExistMeasureUnit(ctx, materialNumber, str);
        if (!flag) {
            throw new TaskExternalException(this.getChannelImportResource("ERROR_MATERIAL_UNIT"));
        }
        MeasureUnitCollection collection2 = null;
        try {
            collection2 = MeasureUnitFactory.getLocalInstance((Context)ctx).getMeasureUnitCollection(this.getFilter(str));
        }
        catch (BOSException e) {
            throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_NUIT"));
        }
        if (collection2 == null || collection2.size() <= 0) throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_NUIT"));
        MeasureUnitInfo info2 = collection2.get(0);
        if (info2 == null) {
            throw new TaskExternalException(this.getChannelImportResource("UN_EXIST_NUIT"));
        }
        entryInfo.setUnit(info2);
        MultiMeasureUnitInfo multiMeasureUnitInfo = null;
        try {
            multiMeasureUnitInfo = this.getMultiMeasureUnit(ctx, entryInfo.getMaterial().getId().toString(), entryInfo.getUnit().getId().toString());
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        if (multiMeasureUnitInfo != null) {
            entryInfo.setUnitPrecision(multiMeasureUnitInfo.getQtyPrecision());
            entryInfo.setInQty(entryInfo.getInQty().setScale(multiMeasureUnitInfo.getQtyPrecision(), 4));
            entryInfo.setBaseInQty(entryInfo.getInQty().multiply(multiMeasureUnitInfo.getBaseConvsRate()));
            BigDecimal baseQty = entryInfo.getBaseInQty().setScale(entryInfo.getBaseUnitPrecision(), 4);
            entryInfo.setBaseInQty(baseQty);
            entryInfo.setOutQty(entryInfo.getOutQty().setScale(multiMeasureUnitInfo.getQtyPrecision(), 4));
            entryInfo.setBaseOutQty(entryInfo.getOutQty().multiply(multiMeasureUnitInfo.getBaseConvsRate()));
            BigDecimal baseOutQty = entryInfo.getBaseOutQty().setScale(entryInfo.getBaseUnitPrecision(), 4);
            entryInfo.setBaseOutQty(baseOutQty);
            entryInfo.setInvQty(entryInfo.getInvQty().setScale(multiMeasureUnitInfo.getQtyPrecision(), 4));
            entryInfo.setBaseInvQty(entryInfo.getInvQty().multiply(multiMeasureUnitInfo.getBaseConvsRate()));
            BigDecimal baseInvQty = entryInfo.getBaseInvQty().setScale(entryInfo.getBaseUnitPrecision(), 4);
            entryInfo.setBaseInvQty(baseInvQty);
        }
        entryInfo.setRemark((String)((DataToken)hsData.get((Object)"FEntries_remark")).data);
        this.jxcBillInfo.setSumQty(this.jxcBillInfo.getSumQty().add(entryInfo.getInQty()));
        this.jxcBillInfo.setSumJXCQty(this.jxcBillInfo.getSumJXCQty().add(entryInfo.getInvQty()));
        this.jxcBillInfo.setSumSellQty(this.jxcBillInfo.getSumSellQty().add(entryInfo.getOutQty()));
    }

    private ChannelJXCBillInfo getBillFromNumber(String number, Context ctx) throws TaskExternalException {
        ChannelJXCBillCollection collection;
        try {
            collection = ChannelJXCBillFactory.getLocalInstance(ctx).getChannelJXCBillCollection("where number ='" + number + "'");
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        if (collection != null && collection.size() > 0) {
            return collection.get(0);
        }
        return null;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            String _qtyPrecision = rs.getString("multiMeasureUnit.qtyPrecision");
            int qtyPrecision = _qtyPrecision == null ? 0 : Integer.parseInt(_qtyPrecision);
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FChannel_number", rs.getString("channel.number"));
            this.putTable(result, "FSaleOrgUnit_number", rs.getString("saleOrgUnit.number"));
            this.putTable(result, "FSalePerson_number", rs.getString("salePerson.number"));
            this.putTable(result, "FStartDate", rs.getString("startDate"));
            this.putTable(result, "FEndDate", rs.getString("endDate"));
            this.putTable(result, "FBaseStatus", rs.getString("baseStatus"));
            this.putTable(result, "FRemark", rs.getString("remark"));
            this.putTable(result, "FEntries_seq", rs.getString("entries.seq"));
            this.putTable(result, "FEntries$material_number", rs.getString("material.number"));
            this.putTable(result, "FEntries$material_name_l1", rs.getString("material.name"));
            this.putTable(result, "FEntries$material_model", rs.getString("material.model"));
            this.putTable(result, "FEntries$unit_number", rs.getString("unit.number"));
            this.putTable(result, "FEntries_inQty", this.dealPrecisioin(rs.getBigDecimal("entries.inQty"), qtyPrecision));
            this.putTable(result, "FEntries_outQty", this.dealPrecisioin(rs.getBigDecimal("entries.outQty"), qtyPrecision));
            this.putTable(result, "FEntries_invQty", this.dealPrecisioin(rs.getBigDecimal("entries.invQty"), qtyPrecision));
            this.putTable(result, "FEntries_remark", rs.getString("entries.remark"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    private String dealPrecisioin(BigDecimal number, int precision) {
        if (number != null && number.toString().indexOf("0E") != -1) {
            number = ZERO.setScale(precision);
        } else if (number != null) {
            number = number.setScale(precision, 4);
        }
        return number != null ? number.toString() : null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.sd.channel.app.ChannelJXCBillExportQuery";
    }

    private EntityViewInfo getFilter(String number) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private EntityViewInfo getMultiMeasureUnitEntityViewInfo(String materialId, String unitId) {
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        entityViewInfo.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("measureUnit.id", (Object)unitId, CompareType.EQUALS));
        filterInfo.setMaskString("#0 and #1");
        return entityViewInfo;
    }

    private MultiMeasureUnitInfo getMultiMeasureUnit(Context ctx, String materialId, String unitId) throws BOSException {
        EntityViewInfo entityViewInfo = this.getMultiMeasureUnitEntityViewInfo(materialId, unitId);
        MultiMeasureUnitCollection collection = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(entityViewInfo);
        if (collection != null && collection.size() > 0) {
            return collection.get(0);
        }
        return null;
    }

    public String getChannelImportResource(String key) {
        return ResourceBase.getString((String)RES_IMPORT_CLASS, (String)key, (Locale)this.local);
    }

    public boolean verifyCollectionType(ChannelBaseInfo channelBaseInfo) {
        DataCollectionTypeEnum dataCollectionType = channelBaseInfo.getDataCollectionType();
        return dataCollectionType.compareTo((Object)DataCollectionTypeEnum.REPORTALL) == 0;
    }

    private Object getNumber(Context ctx, Object data, SaleOrgUnitInfo saleOrgUnitInfo) throws TaskExternalException {
        data = data != null && data.toString().trim().length() >= 1 ? data : this.getContextParameter("number");
        ChannelJXCBillInfo caller = new ChannelJXCBillInfo();
        if (data == null || data.toString().trim().length() < 1) {
            boolean isHasCodingRule = this.hasCodingRule(ctx, (IObjectValue)caller, saleOrgUnitInfo.getId().toString());
            if (isHasCodingRule) {
                try {
                    data = CodingRuleManagerFactory.getLocalInstance((Context)ctx).getNumber((IObjectValue)caller, saleOrgUnitInfo.getId().toString());
                    this.getContextParameter().put("number", data);
                }
                catch (EASBizException e) {
                    Logger.error((Throwable)e);
                    throw new TaskExternalException(this.getChannelImportResource("GETNUMBER_ERROR"));
                }
                catch (BOSException e) {
                    Logger.error((Throwable)e);
                    throw new TaskExternalException(this.getChannelImportResource("GETNUMBER_ERROR"));
                }
            } else {
                throw new TaskExternalException(this.getChannelImportResource("CODINGRULE_UNDEFINED"));
            }
        }
        return data;
    }

    private boolean hasCodingRule(Context ctx, IObjectValue caller, String orgId) {
        try {
            if (orgId != null && orgId.trim().length() > 0 && CodingRuleManagerFactory.getLocalInstance((Context)ctx).isExist(caller, orgId)) {
                return true;
            }
            String companyId = this.getNextCompanyId(ctx);
            return companyId != null && companyId.trim().length() > 0 && CodingRuleManagerFactory.getLocalInstance((Context)ctx).isExist(caller, companyId);
        }
        catch (Exception err) {
            return false;
        }
    }

    private String getNextCompanyId(Context ctx) throws Exception {
        CompanyOrgUnitInfo comInfo = null;
        ObjectUuidPK pk = new ObjectUuidPK("00000000-0000-0000-0000-000000000000CCE7AED4");
        CtrlUnitInfo rootCU = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitInfo((IObjectPK)pk);
        if (rootCU.isIsCompanyOrgUnit()) {
            comInfo = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(rootCU.getId()));
        }
        if (comInfo != null) {
            return comInfo.getId().toString();
        }
        return null;
    }

    private boolean isExistMeasureUnit(Context ctx, String materialNumber, String unitNumber) {
        boolean flag = false;
        StringBuffer sql = new StringBuffer();
        sql.append("select count(*) as numbers from T_BD_MultiMeasureUnit t where t.fmaterialid = ");
        sql.append("(select max(fid) from T_BD_Material where fnumber = '").append(materialNumber).append("' group by fnumber) ");
        sql.append(" and t.FMeasureUnitID = ");
        sql.append("(select max(fid) from T_BD_MeasureUnit where fnumber = '").append(unitNumber).append("' group by fnumber)");
        try {
            IRowSet rowSet = DBUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet != null) {
                while (rowSet.next()) {
                    int numbers = rowSet.getInt("numbers");
                    if (numbers <= 0) continue;
                    flag = true;
                }
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return false;
        }
        return flag;
    }
}

