/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeFactory;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseFactory;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.DataCollectionTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.channel.ChannelBillException;
import com.kingdee.eas.scm.sd.channel.ChannelStockBillEntryCollection;
import com.kingdee.eas.scm.sd.channel.ChannelStockBillEntryFactory;
import com.kingdee.eas.scm.sd.channel.ChannelStockBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.ChannelStockBillInfo;
import com.kingdee.eas.scm.sd.channel.app.AbstractChannelStockBillControllerBean;
import com.kingdee.eas.scm.sd.channel.app.ChannelBillServerutils;
import com.kingdee.eas.scm.sd.channel.app.SaleChannelInventoryHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class ChannelStockBillControllerBean
extends AbstractChannelStockBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.channel.app.ChannelStockBillControllerBean");
    private static String RESOURCE_PATH = "com.kingdee.eas.scm.sd.channel.ChannelStockBillResource";
    private static final BigDecimal DEFAULT_NUM = new BigDecimal("0");
    public static final BigDecimal ZERO = new BigDecimal(String.valueOf("0"));

    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ChannelStockBillInfo billInfo = this.getChannelStockBillInfo(ctx, pk);
        if (!billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            throw new ChannelBillException(ChannelBillException.ONLYSUBMITCANAUDIT, new String[]{billInfo.getNumber()});
        }
        billInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
        billInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        billInfo.setAuditTime(new Timestamp(System.currentTimeMillis()));
        int j = billInfo.getEntries().size();
        for (int i = 0; i < j; ++i) {
            billInfo.getEntries().get(i).setBaseStatus(EntryBaseStatusEnum.AUDITED);
            boolean flag = this.checkBizData(ctx, billInfo, i);
            if (flag) continue;
            throw new ChannelBillException(ChannelBillException.CHECKSTORAGEDATE, new String[]{billInfo.getNumber()});
        }
        this.update(ctx, pk, billInfo);
        try {
            if (this.isUpdateChannelInventory(ctx, pk, billInfo)) {
                new SaleChannelInventoryHelper().updateInventory(ctx, (IObjectValue)billInfo, BizActionEnum.AUDIT);
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this.audit(ctx, pks[i]);
        }
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ChannelStockBillInfo billInfo = this.getChannelStockBillInfo(ctx, pk);
        if (!billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new ChannelBillException(ChannelBillException.ONLYAUDITCANUNAUDIT, new String[]{billInfo.getNumber()});
        }
        String orgUnitID = billInfo.getSaleOrgUnit().getId().toString();
        if (!this.isUnAudit(ctx, billInfo, orgUnitID, 2)) {
            throw new ChannelBillException(ChannelBillException.NOALLOWUNADUIT);
        }
        billInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        billInfo.setAuditor(null);
        billInfo.setAuditTime(null);
        this.update(ctx, pk, billInfo);
        try {
            if (this.isUpdateChannelInventory(ctx, pk, billInfo)) {
                new SaleChannelInventoryHelper().updateInventory(ctx, (IObjectValue)billInfo, BizActionEnum.UNAUDIT);
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this.unAudit(ctx, pks[i]);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ChannelStockBillInfo billInfo = (ChannelStockBillInfo)model;
        ObjectUuidPK pk = null;
        if (!this.isAddNew(ctx, (IObjectValue)billInfo)) {
            pk = new ObjectUuidPK(billInfo.getId());
            this.checkSubmit(ctx, billInfo);
        }
        BillTypeInfo billTypeInfo = BillTypeFactory.getLocalInstance((Context)ctx).getBillTypeInfo((IObjectPK)new ObjectUuidPK("pGlaewEaEADgAAA+wKg9C0Y+1VI="));
        billInfo.setBillType(billTypeInfo);
        billInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        billInfo.setBotpCallSave(false);
        pk = super._submit(ctx, model);
        String orgUnitID = billInfo.getSaleOrgUnit().getId().toString();
        if (this.isAuditAfterSubmit(ctx, billInfo, orgUnitID, 2)) {
            this.auditAndLog(ctx, (IObjectPK)pk, billInfo.getBOSType(), billInfo.getNumber(), null);
        }
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        ChannelStockBillInfo billInfo = (ChannelStockBillInfo)model;
        billInfo.setBotpCallSave(false);
        this.checkSave(ctx, billInfo);
        return super._save(ctx, model);
    }

    private void autoToEntry(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BigDecimal qty = ZERO;
        BigDecimal baseQty = ZERO;
        IMaterial iMaterial = MaterialFactory.getLocalInstance((Context)ctx);
        ChannelStockBillInfo csInfo = (ChannelStockBillInfo)model;
        if (csInfo == null || csInfo.getEntries() == null) {
            return;
        }
        int size = csInfo.getEntries().size();
        for (int i = 0; i < size; ++i) {
            ChannelStockBillEntryInfo csEntry = csInfo.getEntries().get(i);
            MaterialInfo materialInfo = csEntry.getMaterial();
            qty = csEntry.getQty();
            MeasureUnitInfo assUnit = csEntry.getAssistUnit();
            if ((materialInfo = iMaterial.getMaterialInfo((IObjectPK)new ObjectUuidPK(materialInfo.getId()))) != null) {
                if (qty != null && (csEntry.getBaseQty() == null || csEntry.getBaseQty().compareTo(ZERO) == 0)) {
                    baseQty = ChannelBillServerutils.getBaseUnitQty(ctx, csEntry.getUnit(), materialInfo, qty);
                    csEntry.setBaseQty(baseQty);
                }
                if (assUnit != null && (csEntry.getAssistQty() == null || csEntry.getAssistQty().compareTo(ZERO) == 0)) {
                    try {
                        csEntry.setAssistQty(ChannelBillServerutils.getAssUnitQty(ctx, assUnit, materialInfo, baseQty));
                    }
                    catch (BaseException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
            }
            if (csEntry.getQty() != null) continue;
            csEntry.setQty(ZERO);
        }
    }

    private boolean isUpdateChannelInventory(Context ctx, IObjectPK pk, ChannelStockBillInfo billInfo) throws BOSException, EASBizException {
        DataCollectionTypeEnum channelUpdateType;
        ChannelBaseInfo channelBaseInfo = billInfo.getChannel();
        if (channelBaseInfo != null) {
            channelBaseInfo = ChannelBaseFactory.getLocalInstance((Context)ctx).getChannelBaseInfo((IObjectPK)new ObjectUuidPK(channelBaseInfo.getId().toString()));
        }
        return (channelUpdateType = channelBaseInfo.getDataCollectionType()).getValue().equals("2");
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ChannelStockBillInfo billInfo = this.getChannelStockBillInfo(ctx, pk);
        this.checkDelete(ctx, billInfo);
        super._delete(ctx, pk);
    }

    private void checkDelete(Context ctx, ChannelStockBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo.getBaseStatus() != null && billInfo.getBaseStatus().getValue() == 4) {
            throw new ChannelBillException(ChannelBillException.DELETE_IS_AUDIT);
        }
    }

    private void checkUpdate(Context ctx, ChannelStockBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo.getBaseStatus() != null && billInfo.getBaseStatus().getValue() == 4) {
            throw new ChannelBillException(ChannelBillException.UPDATE_IS_AUDIT);
        }
    }

    protected boolean checkBizData(Context ctx, ChannelStockBillInfo billInfo, int index) {
        MaterialInfo material = billInfo.getEntries().get(index).getMaterial();
        String materialId = material.getId().toString();
        String batchNo = billInfo.getEntries().get(index).getBatchNo();
        AsstAttrValueInfo asstAttrValueInfo = billInfo.getEntries().get(index).getAssistProperty();
        String assistProperty = asstAttrValueInfo == null ? null : asstAttrValueInfo.getId().toString();
        Object parentID = null;
        String saleOrgID = billInfo.getSaleOrgUnit().getId().toString();
        String channelID = billInfo.getChannel().getId().toString();
        Date bizDate = billInfo.getBizDate();
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        entityViewInfo.setFilter(filterInfo);
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.id", parentID, CompareType.NOTEQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.saleOrgUnit.id", (Object)saleOrgID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.channel.id", (Object)channelID, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.bizDate", (Object)this.getBeginDate(bizDate), CompareType.GREATER_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.bizDate", (Object)this.getEndDate(bizDate), CompareType.LESS_EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId, CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("parent.baseStatus", (Object)BillBaseStatusEnum.AUDITED, CompareType.GREATER_EQUALS));
        entityViewInfo.getSelector().add("material.id");
        try {
            CoreBaseCollection collection = ChannelStockBillEntryFactory.getLocalInstance(ctx).getCollection(entityViewInfo);
            if (collection != null && collection.size() > 0) {
                for (int i = 0; i < collection.size(); ++i) {
                    if (!billInfo.getId().equals((Object)collection.get(i).getId())) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (BOSException e) {
            logger.error((Object)e);
            return false;
        }
    }

    private void checkSubmit(Context ctx, ChannelStockBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo.getBaseStatus() != null && billInfo.getBaseStatus().getValue() == 4) {
            throw new ChannelBillException(ChannelBillException.SUBMIT_IS_AUDIT);
        }
    }

    private void checkSave(Context ctx, ChannelStockBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo.getBaseStatus() != null) {
            if (billInfo.getBaseStatus().getValue() == 4) {
                throw new ChannelBillException(ChannelBillException.SAVE_IS_AUDIT);
            }
            if (billInfo.getBaseStatus().getValue() == 2) {
                throw new ChannelBillException(ChannelBillException.SAVE_IS_SUBMIT);
            }
        }
    }

    private void beforeSubmitValidateData(Context ctx, ChannelStockBillInfo info) throws BOSException, EASBizException {
        if (info.getSaleOrgUnit() == null) {
            throw new ChannelBillException(ChannelBillException.SALEORGNOTNULL);
        }
        if (info.getSalePerson() == null) {
            throw new ChannelBillException(ChannelBillException.SALEPERSONNULL);
        }
        if (info.getChannelType() == null) {
            throw new ChannelBillException(ChannelBillException.CHANNELTYPENULL);
        }
        if (info.getChannel() == null) {
            throw new ChannelBillException(ChannelBillException.CHANNELNULL);
        }
        if (info.getCurrency() == null) {
            throw new ChannelBillException(ChannelBillException.CURRENCYNOTNULL);
        }
        ChannelStockBillEntryCollection entries = info.getEntries();
        StringBuffer message = new StringBuffer();
        if (entries.size() == 0) {
            message.append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"ENTRYNOTNULL", (Context)ctx));
            throw new ChannelBillException(ChannelBillException.EXCEPTIONWITHMESSAGE, new String[]{message.toString()});
        }
        boolean isError = false;
        boolean isNumError = false;
        int c = entries.size();
        for (int i = 0; i < c; ++i) {
            message.append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"SEQ", (Context)ctx)).append(i + 1).append(" ");
            if (entries.get(i).getMaterial() == null) {
                message.append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"MATERIAL", (Context)ctx)).append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"NOTNULLALL", (Context)ctx));
                isError = true;
            }
            if (entries.get(i).getUnit() == null) {
                if (message.length() > 0) {
                    message.append(";");
                }
                message.append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"UNIT", (Context)ctx)).append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"NOTNULL", (Context)ctx));
                isError = true;
            }
            if (entries.get(i).getQty() == null || entries.get(i).getQty().doubleValue() == 0.0) {
                if (message.length() > 0) {
                    message.append(";");
                }
                message.append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"QTY", (Context)ctx));
                isError = true;
                isNumError = true;
            }
            if (isNumError) {
                message.append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"NOTZERO", (Context)ctx));
            }
            if (!isError) continue;
            throw new ChannelBillException(ChannelBillException.EXCEPTIONWITHMESSAGE, new String[]{message.toString()});
        }
    }

    protected IObjectValue _createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        ChannelStockBillInfo info = new ChannelStockBillInfo();
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        info.setCreateTime(ts);
        info.setBizDate(curDate);
        return info;
    }

    private Date getBeginDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    private Date getEndDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        if (date != null) {
            calendar.setTime(date);
        }
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }
}

