/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.sd.channel.NetOrderBillFactory;
import com.kingdee.eas.scm.sd.channel.NetOrderBillInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Locale;

public class NetOrderFollowImport
extends AbstractDataTransmission {
    public static final String RES_IMPORT_CLASS = "com.kingdee.eas.scm.sd.channel.ChannelImportResource";
    public static final String Locale_en = "l1";
    public static final String Locale_zh = "l2";
    public static final String Locale_tw = "l3";
    Locale local = new Locale("l2");
    public static final BigDecimal ZERO = new BigDecimal("0.00");

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return NetOrderBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        return this.transmitHead(hsData, ctx);
    }

    private NetOrderBillInfo transmitHead(Hashtable lineData, Context ctx) throws TaskExternalException {
        return null;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "netOrderBill_number", rs.getString("netOrderBill.number"));
            this.putTable(result, "saleIssueBill_number", rs.getString("saleIssueBill.number"));
            this.putTable(result, "netOrderBill_bizDate", rs.getString("netOrderBill.bizDate"));
            this.putTable(result, "saleIssueBill_bizDate", rs.getString("saleIssueBill.bizDate"));
            this.putTable(result, "netOrderBillEntry_qty", this.dealPrecisioin(rs.getBigDecimal("netOrderBillEntry.qty"), 4));
            this.putTable(result, "netOrderBillEntry_amount", this.dealPrecisioin(rs.getBigDecimal("netOrderBillEntry.amount"), 2));
            this.putTable(result, "totalQty", this.dealPrecisioin(rs.getBigDecimal("totalQty"), 4));
            this.putTable(result, "totalAmount", this.dealPrecisioin(rs.getBigDecimal("totalAmount"), 2));
            String baseStatus = null;
            BigDecimal confirmQty = rs.getBigDecimal("saleIssueBillEntry.confirmQty");
            String postRequisition = rs.getString("postRequisition.baseStatus");
            String saleIssueBill_number = rs.getString("saleIssueBill.number");
            String saleOrderStatus = rs.getString("saleOrder.baseStatus");
            String saleIssueStatus = rs.getString("saleIssueBill.baseStatus");
            if (saleIssueBill_number != null && !"".equals(saleIssueBill_number)) {
                if (confirmQty != null) {
                    baseStatus = confirmQty.compareTo(new BigDecimal("0.00")) > 0 ? this.getChannelImportResource("CONFIRM") : this.getChannelImportResource("HASCONSIGNMENT");
                }
            } else if (postRequisition != null && "4".equals(postRequisition)) {
                baseStatus = this.getChannelImportResource("CONSIGNMENTING");
            } else if (saleOrderStatus != null && "4".equals(saleOrderStatus)) {
                baseStatus = this.getChannelImportResource("CONSIGNMENTING");
            } else if (saleIssueStatus != null && Integer.parseInt(saleIssueStatus) < 4) {
                baseStatus = this.getChannelImportResource("BILLDEALING");
            }
            this.putTable(result, "baseStatus", baseStatus);
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    private String dealPrecisioin(BigDecimal number, int precision) {
        if (number != null && number.toString().indexOf("0E") != -1) {
            number = ZERO.setScale(precision);
        } else if (number != null) {
            number = number.setScale(precision, 4);
        }
        return number != null ? number.toString() : null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.sd.channel.app.SaleIssueForNetOrderQuery";
    }

    public String getChannelImportResource(String key) {
        return ResourceBase.getString((String)RES_IMPORT_CLASS, (String)key, (Locale)this.local);
    }
}

