/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.eas.basedata.scm.common.DiscountConditionEnum;
import com.kingdee.eas.basedata.scm.common.DiscountModeEnum;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceProvider;
import com.kingdee.eas.basedata.scm.sd.sale.PriceCondition;
import com.kingdee.eas.basedata.scm.sd.sale.PriceProviderFactory;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class PriceSolve {
    private IPriceProvider priceStrategy = null;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.basedata.scm.sd.sale.client.PriceSolve");
    private Map priceResult = new HashMap();
    private static final BigDecimal Hundred = new BigDecimal("100.0");

    public Map getPriceInfo(PriceCondition priceCondition) {
        logger.info((Object)"start getting price info");
        if (priceCondition == null || priceCondition.getMaterialInfo() == null || priceCondition.getMaterialInfo().getId() == null || priceCondition.getCurrencyInfo() == null || priceCondition.getCurrencyInfo().getId() == null || priceCondition.getSaleOrg() == null && priceCondition.getCompanyOrg() == null) {
            return new HashMap();
        }
        try {
            if (this.priceStrategy == null) {
                this.priceStrategy = PriceProviderFactory.getRemoteInstance();
            }
            this.priceResult = this.priceStrategy.calculatePrice(priceCondition);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return this.priceResult;
    }

    public Collection fetchPriceInfos(PriceCondition priceCondition) {
        logger.info((Object)"start fetching price infos");
        if (priceCondition == null || priceCondition.getMaterialInfo() == null || priceCondition.getMaterialInfo().getId() == null || priceCondition.getCurrencyInfo() == null || priceCondition.getCurrencyInfo().getId() == null || priceCondition.getSaleOrg() == null && priceCondition.getCompanyOrg() == null) {
            return null;
        }
        try {
            if (this.priceStrategy == null) {
                this.priceStrategy = PriceProviderFactory.getRemoteInstance();
            }
            return this.priceStrategy.fetchPrices(priceCondition);
        }
        catch (Exception e) {
            logger.error((Object)e);
            return null;
        }
    }

    public Map getPriceInfoByInnerPriceType(PriceCondition priceCondition) {
        logger.info((Object)"start getting price info");
        if (priceCondition == null || priceCondition.getCustomerInfo() == null || priceCondition.getCustomerInfo().getId() == null || priceCondition.getMaterialInfo() == null || priceCondition.getMaterialInfo().getId() == null || priceCondition.getCurrencyInfo() == null || priceCondition.getCurrencyInfo().getId() == null || priceCondition.getSaleOrg() == null && priceCondition.getCompanyOrg() == null) {
            return new HashMap();
        }
        priceCondition.setPriceTypeID("00000000-0000-0000-0000-0000000000036A61CE8D");
        try {
            if (this.priceStrategy == null) {
                this.priceStrategy = PriceProviderFactory.getRemoteInstance();
            }
            this.priceResult = this.priceStrategy.calculatePrice(priceCondition);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return this.priceResult;
    }

    public Map getDiscountInfo(PriceCondition priceCondition) {
        if (priceCondition == null || priceCondition.getCustomerInfo() == null || priceCondition.getCustomerInfo().getId() == null || priceCondition.getMaterialInfo() == null || priceCondition.getMaterialInfo().getId() == null || priceCondition.getCurrencyInfo() == null || priceCondition.getCurrencyInfo().getId() == null || priceCondition.getSaleOrg() == null && priceCondition.getCompanyOrg() == null) {
            return new HashMap();
        }
        try {
            if (this.priceStrategy == null) {
                this.priceStrategy = PriceProviderFactory.getRemoteInstance();
            }
            this.priceResult = this.priceStrategy.calculateDiscount(priceCondition);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return this.priceResult;
    }

    public Map getDiscountInfoByInnerPriceType(PriceCondition priceCondition) {
        if (priceCondition == null || priceCondition.getCustomerInfo() == null || priceCondition.getCustomerInfo().getId() == null || priceCondition.getMaterialInfo() == null || priceCondition.getMaterialInfo().getId() == null || priceCondition.getCurrencyInfo() == null || priceCondition.getCurrencyInfo().getId() == null || priceCondition.getSaleOrg() == null && priceCondition.getCompanyOrg() == null) {
            return new HashMap();
        }
        priceCondition.setPriceTypeID("00000000-0000-0000-0000-0000000000036A61CE8D");
        try {
            if (this.priceStrategy == null) {
                this.priceStrategy = PriceProviderFactory.getRemoteInstance();
            }
            this.priceResult = this.priceStrategy.calculateDiscount(priceCondition);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return this.priceResult;
    }

    public BigDecimal visitPrice(Map value) {
        if (value == null) {
            return null;
        }
        Object tmp = value.get("keyprice");
        if (tmp == null || tmp.equals("")) {
            return null;
        }
        return new BigDecimal((String)tmp);
    }

    public BigDecimal visitDiscount(Map value) {
        if (value == null) {
            return null;
        }
        Object tmp = value.get("keydiscountvalue");
        if (tmp == null || tmp.equals("")) {
            return null;
        }
        return new BigDecimal((String)tmp);
    }

    public DiscountConditionEnum visitDiscountCondition(Map value) {
        if (value == null) {
            return null;
        }
        Object o = value.get("keydiscountcondition");
        if (o == null || !(o instanceof String)) {
            return null;
        }
        int tmp = -1;
        try {
            tmp = Integer.parseInt((String)value.get("keydiscountcondition"));
        }
        catch (NumberFormatException e) {
            return null;
        }
        tmp = Integer.parseInt((String)value.get("keydiscountcondition"));
        return DiscountConditionEnum.getEnum((int)tmp);
    }

    public DiscountModeEnum visitDiscountMode(Map value) {
        if (value == null) {
            return null;
        }
        Object o = value.get("keydiscountmode");
        if (o == null || !(o instanceof String)) {
            return null;
        }
        int tmp = -1;
        try {
            tmp = Integer.parseInt((String)value.get("keydiscountmode"));
        }
        catch (NumberFormatException e) {
            return null;
        }
        return DiscountModeEnum.getEnum((int)tmp);
    }

    public BigDecimal visitPriceMin(Map value) {
        if (value == null) {
            return null;
        }
        Object tmp = value.get("keypricemin");
        if (tmp == null || tmp.equals("")) {
            return null;
        }
        return new BigDecimal((String)tmp);
    }

    public BigDecimal visitPriceMax(Map value) {
        if (value == null) {
            return null;
        }
        Object tmp = value.get("keypricemax");
        if (tmp == null || tmp.equals("")) {
            return null;
        }
        return new BigDecimal((String)tmp);
    }

    public BigDecimal getDiscountAmount(DiscountModeEnum mode, BigDecimal taxPrice, BigDecimal discount, BigDecimal qty) {
        BigDecimal discountAmount = new BigDecimal("0.0");
        if (mode != null) {
            discountAmount = mode.equals((Object)DiscountModeEnum.PERCENT) ? taxPrice.multiply(discount).multiply(qty).divide(Hundred, 2, 6) : qty.multiply(discount);
        }
        return discountAmount;
    }

    public BigDecimal getDiscountPrice(DiscountModeEnum mode, BigDecimal price, BigDecimal discount) {
        if (mode == null) {
            return price;
        }
        BigDecimal discountPrice = new BigDecimal("0.00");
        if (mode.equals((Object)DiscountModeEnum.PERCENT)) {
            discountPrice = price.multiply(discount).divide(Hundred, 2, 6);
            discountPrice = price.subtract(discountPrice);
        } else {
            discountPrice = price.subtract(discount);
        }
        return discountPrice;
    }
}

