/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.channel.SaleBackProfitBillEntryCollection;
import com.kingdee.eas.scm.sd.channel.SaleBackProfitBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.SaleBackProfitBillInfo;
import com.kingdee.eas.scm.sd.channel.SaleBackProfitException;
import com.kingdee.eas.scm.sd.channel.SaleBackProfitTypeEnum;
import com.kingdee.eas.scm.sd.channel.app.AbstractSaleBackProfitBillControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import org.apache.log4j.Logger;

public class SaleBackProfitBillControllerBean
extends AbstractSaleBackProfitBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.channel.app.SaleBackProfitBillControllerBean");
    private static String RESOURCE_PATH = "com.kingdee.eas.scm.sd.channel.SaleBackProfitResource";
    private static BigDecimal DEFAULT_NUM = new BigDecimal("0");

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SaleBackProfitBillInfo billInfo = this.getSaleBackProfitBillInfo(ctx, pk);
        if (!billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            throw new SaleBackProfitException(SaleBackProfitException.ONLYSUBMITCANAUDIT, new String[]{billInfo.getNumber()});
        }
        billInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
        billInfo.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        billInfo.setAuditTime(new Timestamp(System.currentTimeMillis()));
        int c = billInfo.getEntries().size();
        for (int i = 0; i < c; ++i) {
            billInfo.getEntries().get(i).setBaseStatus(EntryBaseStatusEnum.AUDITED);
        }
        this.update(ctx, pk, (CoreBaseInfo)billInfo);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        super._update(ctx, pk, model);
    }

    protected Result _update(Context ctx, IObjectCollection colls) throws BOSException, EASBizException {
        return super._update(ctx, colls);
    }

    public Result update(Context ctx, CoreBaseCollection colls) throws BOSException, EASBizException {
        return super.update(ctx, colls);
    }

    public void update(Context ctx, IObjectPK pk, CoreBaseInfo model) throws BOSException, EASBizException {
        super.update(ctx, pk, model);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this.audit(ctx, pks[i]);
        }
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SaleBackProfitBillInfo billInfo = this.getSaleBackProfitBillInfo(ctx, pk);
        if (!billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED)) {
            throw new SaleBackProfitException(SaleBackProfitException.ONLYAUDITCANUNAUDIT, new String[]{billInfo.getNumber()});
        }
        SCMServerUtils.checkUnAuditDetail((Context)ctx, (SCMBillBaseInfo)billInfo);
        billInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        billInfo.setAuditor(null);
        billInfo.setAuditTime(null);
        int c = billInfo.getEntries().size();
        for (int i = 0; i < c; ++i) {
            billInfo.getEntries().get(i).setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
        }
        this.update(ctx, pk, (CoreBaseInfo)billInfo);
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this.unAudit(ctx, pks[i]);
        }
    }

    @Override
    protected void _revoke(Context ctx, IObjectPK pk, String reason) throws BOSException, EASBizException {
        SaleBackProfitBillInfo billInfo = this.getSaleBackProfitBillInfo(ctx, pk);
        if (!billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED) && !billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED)) {
            throw new SaleBackProfitException(SaleBackProfitException.ONLYSUBMITCANREVOKE, new String[]{billInfo.getNumber()});
        }
        billInfo.setBaseStatus(BillBaseStatusEnum.DELETED);
        SaleBackProfitBillEntryInfo sbEntryInfo = null;
        int size = billInfo.getEntries().size();
        for (int i = 0; i < size; ++i) {
            sbEntryInfo = billInfo.getEntries().get(i);
            sbEntryInfo.setReason(reason);
            sbEntryInfo.setBaseStatus(EntryBaseStatusEnum.DELETED);
        }
        this.update(ctx, pk, (CoreBaseInfo)billInfo);
    }

    @Override
    protected void _revoke(Context ctx, IObjectPK[] pks, String[] reasons) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this.revoke(ctx, pks[i], reasons[i]);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SaleBackProfitBillInfo billInfo = (SaleBackProfitBillInfo)model;
        ObjectUuidPK pk = null;
        if (!this.isAddNew(ctx, (IObjectValue)billInfo)) {
            pk = new ObjectUuidPK(billInfo.getId());
            this.checkUpdate(ctx, billInfo);
        }
        this.beforeSubmitValidateData(ctx, billInfo);
        billInfo.setBaseStatus(BillBaseStatusEnum.SUBMITED);
        int size = billInfo.getEntries().size();
        for (int i = 0; i < size; ++i) {
            billInfo.getEntries().get(i).setBaseStatus(EntryBaseStatusEnum.SUBMITED);
        }
        pk = super._submit(ctx, model);
        String orgUnitID = billInfo.getCompanyOrgUnit().getId().toString();
        if (this.isAuditAfterSubmit(ctx, billInfo, orgUnitID, 1)) {
            this.auditAndLog(ctx, (IObjectPK)pk, billInfo.getBOSType(), billInfo.getNumber(), "salebackProfit_audit");
        }
        return pk;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SaleBackProfitBillInfo info = (SaleBackProfitBillInfo)model;
        SaleBackProfitBillEntryInfo entryInfo = null;
        int size = info.getEntries().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = info.getEntries().get(i);
            entryInfo.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
        }
        return super._save(ctx, model);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SaleBackProfitBillInfo billInfo = this.getSaleBackProfitBillInfo(ctx, pk);
        if (billInfo.getBaseStatus().getValue() != 0 && billInfo.getBaseStatus().getValue() != 1 && billInfo.getBaseStatus().getValue() != 2) {
            throw new SaleBackProfitException(SaleBackProfitException.CANNOT_DELETE, new String[]{billInfo.getBaseStatus().toString()});
        }
        super._delete(ctx, pk);
    }

    private void checkUpdate(Context ctx, SaleBackProfitBillInfo billInfo) throws BOSException, EASBizException {
        if (billInfo.getBaseStatus() != null) {
            if (billInfo.getBaseStatus().getValue() == 4) {
                throw new SaleBackProfitException(SaleBackProfitException.UPDATE_IS_AUDIT);
            }
            if (billInfo.getBaseStatus().getValue() == 7) {
                throw new SaleBackProfitException(SaleBackProfitException.UPDATE_IS_CLOSED);
            }
            if (billInfo.getBaseStatus().getValue() == 3) {
                throw new SaleBackProfitException(SaleBackProfitException.UPDATE_IS_CANCEL);
            }
        }
    }

    private void beforeSubmitValidateData(Context ctx, SaleBackProfitBillInfo info) throws BOSException, EASBizException {
        if (info.getCompanyOrgUnit() == null) {
            throw new SaleBackProfitException(SaleBackProfitException.COMPANYORGNOTNULL);
        }
        if (info.getAccountID() == null) {
            throw new SaleBackProfitException(SaleBackProfitException.ACCOUNTNOTNULL);
        }
        if (info.getBizOrgUnitID() == null) {
            if (info.getSaleBackProfitType().equals((Object)SaleBackProfitTypeEnum.CUSTOMER)) {
                throw new SaleBackProfitException(SaleBackProfitException.SALEORGNOTNULL);
            }
            throw new SaleBackProfitException(SaleBackProfitException.PURCHASEORGNOTNULL);
        }
        if (info.getCurrency() == null) {
            throw new SaleBackProfitException(SaleBackProfitException.CURRENCYNOTNULL);
        }
        SaleBackProfitBillEntryCollection entries = info.getEntries();
        StringBuffer message = new StringBuffer();
        if (entries.size() == 0) {
            message.append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"ENTRYNOTNULL", (Context)ctx));
            throw new SaleBackProfitException(SaleBackProfitException.EXCEPTIONWITHMESSAGE, new String[]{message.toString()});
        }
        boolean isError = false;
        boolean isNumError = false;
        int c = entries.size();
        for (int i = 0; i < c; ++i) {
            message.append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"SEQ", (Context)ctx)).append(i + 1).append(" ");
            if (entries.get(i).getMaterial() == null && entries.get(i).getMaterialGroup() == null) {
                message.append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"MATERIAL", (Context)ctx)).append(",").append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"MATERIALGROUP", (Context)ctx)).append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"NOTNULLALL", (Context)ctx));
                isError = true;
            }
            if (entries.get(i).getMaterial() != null && entries.get(i).getUnit() == null) {
                if (message.length() > 0) {
                    message.append(";");
                }
                message.append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"UNIT", (Context)ctx)).append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"NOTNULL", (Context)ctx));
                isError = true;
            }
            if (entries.get(i).getQty() == null) {
                if (message.length() > 0) {
                    message.append(";");
                }
                message.append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"QTY", (Context)ctx));
                isError = true;
                isNumError = true;
            }
            if (entries.get(i).getBaseQty() == null) {
                if (message.length() > 0 && !isNumError) {
                    message.append(";");
                }
                if (message.length() > 0 && isNumError) {
                    message.append(",");
                }
                message.append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"BASEQTY", (Context)ctx));
                isError = true;
                isNumError = true;
            }
            if (entries.get(i).getBaseProfitAmount() == null) {
                if (message.length() > 0 && !isNumError) {
                    message.append(";");
                }
                if (message.length() > 0 && isNumError) {
                    message.append(",");
                }
                message.append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"BASEAMOUNT", (Context)ctx));
                isError = true;
                isNumError = true;
            }
            if (entries.get(i).getAmount() == null) {
                if (message.length() > 0 && !isNumError) {
                    message.append(";");
                }
                if (message.length() > 0 && isNumError) {
                    message.append(",");
                }
                message.append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"AMOUNT", (Context)ctx));
                isError = true;
                isNumError = true;
            }
            if (entries.get(i).getProfitAmount() == null) {
                if (message.length() > 0 && !isNumError) {
                    message.append(";");
                }
                if (message.length() > 0 && isNumError) {
                    message.append(",");
                }
                message.append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"PROFITAMOUNT", (Context)ctx));
                isError = true;
                isNumError = true;
            }
            if (isNumError) {
                message.append(SCMUtils.getResource((String)RESOURCE_PATH, (String)"NOTZERO", (Context)ctx));
            }
            if (!isError) continue;
            throw new SaleBackProfitException(SaleBackProfitException.EXCEPTIONWITHMESSAGE, new String[]{message.toString()});
        }
    }

    protected IObjectValue _createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        SaleBackProfitBillInfo info = new SaleBackProfitBillInfo();
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        info.setCreateTime(ts);
        info.setBizDate(curDate);
        info.setProfitFromDate(curDate);
        info.setProfitToDate(curDate);
        return info;
    }
}

