/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.sd.channel.ISaleBackProfitBill;
import com.kingdee.eas.scm.sd.channel.SaleBackProfitBillEntryCollection;
import com.kingdee.eas.scm.sd.channel.SaleBackProfitBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.SaleBackProfitBillFactory;
import com.kingdee.eas.scm.sd.channel.SaleBackProfitBillInfo;
import com.kingdee.eas.scm.sd.channel.SaleBackProfitException;
import com.kingdee.eas.scm.sd.channel.app.AbstractSaleBackProfitBillEntryControllerBean;
import org.apache.log4j.Logger;

public class SaleBackProfitBillEntryControllerBean
extends AbstractSaleBackProfitBillEntryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.channel.app.SaleBackProfitBillEntryControllerBean");

    @Override
    protected void _unClose(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SaleBackProfitBillEntryInfo entryInfo = this.getSaleBackProfitBillEntryInfo(ctx, pk);
        ISaleBackProfitBill iSaleBackPrift = SaleBackProfitBillFactory.getLocalInstance(ctx);
        ObjectUuidPK billInfoPK = new ObjectUuidPK(entryInfo.getParent().getId());
        SaleBackProfitBillInfo billInfo = iSaleBackPrift.getSaleBackProfitBillInfo((IObjectPK)billInfoPK);
        if (!entryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.CLOSED)) {
            throw new SaleBackProfitException(SaleBackProfitException.ONLYCLOSECANUNCLOSE, new String[]{billInfo.getNumber(), String.valueOf(entryInfo.getSeq())});
        }
        entryInfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
        entryInfo.setReason(null);
        this.update(ctx, pk, (CoreBaseInfo)entryInfo);
        if (billInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.CLOSED)) {
            billInfo = iSaleBackPrift.getSaleBackProfitBillInfo((IObjectPK)billInfoPK);
            billInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
            iSaleBackPrift.update((IObjectPK)billInfoPK, (CoreBaseInfo)billInfo);
        }
    }

    @Override
    protected void _unClose(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this.unClose(ctx, pks[i]);
        }
    }

    @Override
    protected void _close(Context ctx, IObjectPK pk, String reason) throws BOSException, EASBizException {
        SaleBackProfitBillEntryInfo entryInfo = this.getSaleBackProfitBillEntryInfo(ctx, pk);
        ISaleBackProfitBill iSaleBackPrift = SaleBackProfitBillFactory.getLocalInstance(ctx);
        SaleBackProfitBillInfo billInfo = iSaleBackPrift.getSaleBackProfitBillInfo((IObjectPK)new ObjectUuidPK(entryInfo.getParent().getId()));
        if (!entryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.AUDITED)) {
            throw new SaleBackProfitException(SaleBackProfitException.ONLYAUDITCANCLOSE, new String[]{billInfo.getNumber(), String.valueOf(entryInfo.getSeq())});
        }
        entryInfo.setBaseStatus(EntryBaseStatusEnum.CLOSED);
        entryInfo.setReason(reason);
        this.update(ctx, pk, (CoreBaseInfo)entryInfo);
        this.closeBillHead(ctx, pk);
    }

    private void closeBillHead(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (this.checkAllEntryStatus(ctx, pk, EntryBaseStatusEnum.CLOSED)) {
            SaleBackProfitBillEntryInfo entryInfo = this.getSaleBackProfitBillEntryInfo(ctx, pk);
            ISaleBackProfitBill iSaleBackPrift = SaleBackProfitBillFactory.getLocalInstance(ctx);
            ObjectUuidPK billInfoPK = new ObjectUuidPK(entryInfo.getParent().getId());
            SaleBackProfitBillInfo billInfo = iSaleBackPrift.getSaleBackProfitBillInfo((IObjectPK)billInfoPK);
            billInfo.setBaseStatus(BillBaseStatusEnum.CLOSED);
            iSaleBackPrift.update((IObjectPK)new ObjectUuidPK(billInfo.getId()), (CoreBaseInfo)billInfo);
        }
    }

    private boolean checkAllEntryStatus(Context ctx, IObjectPK entryPk, EntryBaseStatusEnum targeStatus) throws EASBizException, BOSException {
        SaleBackProfitBillEntryInfo entryInfo = this.getSaleBackProfitBillEntryInfo(ctx, entryPk);
        ISaleBackProfitBill iSaleBackPrift = SaleBackProfitBillFactory.getLocalInstance(ctx);
        ObjectUuidPK billInfoPK = new ObjectUuidPK(entryInfo.getParent().getId());
        SaleBackProfitBillInfo billInfo = iSaleBackPrift.getSaleBackProfitBillInfo((IObjectPK)billInfoPK);
        SaleBackProfitBillEntryCollection entryCollection = billInfo.getEntries();
        int num = entryCollection.size();
        for (int i = 0; i < num; ++i) {
            if (entryCollection.get(i).getBaseStatus().getValue() == targeStatus.getValue()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void _close(Context ctx, IObjectPK[] pks, String[] reasons) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this.close(ctx, pks[i], reasons[i]);
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SaleBackProfitBillEntryInfo info = (SaleBackProfitBillEntryInfo)this.getValue(ctx, pk);
        SaleBackProfitBillInfo sInfo = SaleBackProfitBillFactory.getLocalInstance(ctx).getSaleBackProfitBillInfo((IObjectPK)new ObjectUuidPK(info.getParent().getId()));
        return sInfo.getNumber() + "  " + info.getSeq();
    }
}

