/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.app.InvAppUtils;
import com.kingdee.eas.scm.sd.channel.ISaleBackProfitBill;
import com.kingdee.eas.scm.sd.channel.SaleBackProfitBillCollection;
import com.kingdee.eas.scm.sd.channel.SaleBackProfitBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.SaleBackProfitBillFactory;
import com.kingdee.eas.scm.sd.channel.SaleBackProfitBillInfo;
import com.kingdee.eas.scm.sd.channel.SaleBackProfitTypeEnum;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.Enum;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Locale;

public class SaleBackProfitBillImport
extends AbstractDataTransmission {
    SaleBackProfitBillInfo saleBackInfo = null;
    private static final String resource = "com.kingdee.eas.scm.im.inv.WarehsManageResource";
    private static final String RESOURCE = "com.kingdee.eas.scm.im.dt.DTDataImportResource";
    private static final String scmresource = "com.kingdee.eas.scm.common.SCMImportExportResource";
    public static final String Locale_en = "l1";
    public static final String Locale_zh = "l2";
    public static final String Locale_tw = "l3";
    private static final String[] DATE_BILL = new String[]{"FProfitFromDate", "FProfitToDate", "FBizDate"};
    private static final String[] DATE_BILL_NNME = new String[]{"profitFromDate", "profitToDate", "bizDate"};
    private static final String[] DATE_BILL_Entry = new String[]{"FProfitFromDate", "FProfitToDate", "FBizDate"};
    private static final String[] DECIMAL_ENTRY = new String[]{"FEntries_qty", "FEntries_amount", "FEntries_baseProfitQty", "FEntries_baseProfitAmount", "FEntries_profitAmount", "FEntries_localAmount"};
    private static final String[] DECIMAL_ENTRY_NAME = new String[]{"qty", "amount", "baseProfitQty", "baseProfitAmount", "profitAmount", "localAmount"};
    private static final String[] QTY_MATERILAL_ENTRY = new String[]{"qty"};
    private CompanyOrgUnitInfo companyOrg = null;
    private static final BigDecimal ZERO = new BigDecimal("0.00");

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return SaleBackProfitBillFactory.getLocalInstance(ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    private static String getResource(Context ctx, String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return SCMUtils.getResource((String)resource, (String)strKey, (Context)ctx);
    }

    private static String getSCMResource(Context ctx, String strKey) {
        if (strKey == null || strKey.trim().length() == 0) {
            return null;
        }
        return SCMUtils.getResource((String)scmresource, (String)strKey, (Context)ctx);
    }

    private static String getMyResource(Context ctx, String strKey) {
        if (StringUtil.isEmptyString((String)strKey)) {
            return null;
        }
        return SCMUtils.getResource((String)RESOURCE, (String)strKey, (Context)ctx);
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        this.saleBackInfo = null;
        int keyCursor = 0;
        for (int i = 0; i < hsData.size(); ++i) {
            Hashtable lineData = (Hashtable)hsData.get(new Integer(i));
            if (keyCursor == 0) {
                this.saleBackInfo = this.transmitHead(lineData, ctx);
                if (this.saleBackInfo == null) {
                    return null;
                }
            }
            SaleBackProfitBillEntryInfo entry = this.transmitEntry(lineData, ctx);
            int seq = this.saleBackInfo.getEntries().size() + 1;
            entry.setSeq(seq);
            entry.setParent(this.saleBackInfo);
            this.saleBackInfo.getEntries().add(entry);
            ++keyCursor;
        }
        return this.saleBackInfo;
    }

    private SaleBackProfitBillInfo transmitHead(Hashtable lineData, Context ctx) throws TaskExternalException {
        block42: {
            CurrencyCollection collection;
            block41: {
                Object exchangeRateData;
                boolean noNumber;
                block40: {
                    SaleOrgUnitCollection collection2;
                    block39: {
                        this.saleBackInfo = new SaleBackProfitBillInfo();
                        noNumber = false;
                        Object number = ((DataToken)lineData.get((Object)"FNumber")).data;
                        if (number != null && number.toString().trim().length() > 0) {
                            this.saleBackInfo.setNumber(number.toString().trim());
                            String existId = this.getIdFromNumber(number.toString().trim(), ctx);
                            if (!this.isSltImportUpdate() && !StringUtil.isEmptyString((String)existId)) {
                                throw new TaskExternalException(number.toString().trim() + SaleBackProfitBillImport.getResource(ctx, "EXISTS"));
                            }
                            if (this.isSltImportUpdate() && !StringUtil.isEmptyString((String)existId)) {
                                SaleBackProfitBillInfo existInfo = null;
                                try {
                                    existInfo = ((ISaleBackProfitBill)this.getController(ctx)).getSaleBackProfitBillInfo((IObjectPK)new ObjectUuidPK(existId));
                                }
                                catch (Exception e) {
                                    throw new TaskExternalException("", (Throwable)e);
                                }
                                if (BillBaseStatusEnum.AUDITED.equals((Object)existInfo.getBaseStatus()) || BillBaseStatusEnum.CLOSED.equals((Object)existInfo.getBaseStatus())) {
                                    throw new TaskExternalException(number.toString().trim() + SaleBackProfitBillImport.getSCMResource(ctx, "import_bill_audited"));
                                }
                            }
                        } else {
                            noNumber = true;
                        }
                        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                        for (int i = 0; i < DATE_BILL.length; ++i) {
                            Object date = ((DataToken)lineData.get((Object)SaleBackProfitBillImport.DATE_BILL[i])).data;
                            if (date == null || date.toString().length() <= 0) continue;
                            try {
                                date = df.parse(date.toString());
                            }
                            catch (ParseException e) {
                                Logger.error((Throwable)e);
                                throw new TaskExternalException(DATE_BILL[i] + SaleBackProfitBillImport.getResource(ctx, "InvalidDateFormat") + date.toString());
                            }
                            if (date == null || !(date instanceof Date)) continue;
                            this.saleBackInfo.setDate(DATE_BILL_NNME[i], (Date)date);
                        }
                        SaleOrgUnitInfo saleOrgUnit = null;
                        try {
                            Object saleOrgUnitData = ((DataToken)lineData.get((Object)"FBizOrgUnitNumber")).data;
                            if (saleOrgUnitData == null || saleOrgUnitData.toString().trim().length() <= 0) break block39;
                            ISaleOrgUnit iSaleOrgUni = SaleOrgUnitFactory.getLocalInstance((Context)ctx);
                            collection2 = iSaleOrgUni.getSaleOrgUnitCollection(this.getFilter(saleOrgUnitData.toString().trim()));
                            if (collection2 != null && collection2.size() > 0) {
                                saleOrgUnit = collection2.get(0);
                                if (!saleOrgUnit.isIsBizUnit()) {
                                    throw new TaskExternalException(SaleBackProfitBillImport.getSCMResource(ctx, "SaleOrgUnitIsNotBizUnit"));
                                }
                                this.saleBackInfo.setBizOrgUnitID(saleOrgUnit);
                                this.saleBackInfo.setBizOrgUnitNumber(saleOrgUnit.getNumber());
                                this.saleBackInfo.setBizOrgUnitName(saleOrgUnit.getName());
                                break block39;
                            }
                            throw new TaskExternalException(saleOrgUnitData.toString().trim() + " " + SaleBackProfitBillImport.getSCMResource(ctx, "SaleOrgUnitNotExists"));
                        }
                        catch (BOSException e) {
                            throw new TaskExternalException(e.getMessage(), e.getCause());
                        }
                    }
                    this.companyOrg = null;
                    try {
                        Object companyOrgData = ((DataToken)lineData.get((Object)"FCompanyOrgUnit_number")).data;
                        if (companyOrgData == null || companyOrgData.toString().trim().length() <= 0) break block40;
                        ICompanyOrgUnit iCompanyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                        collection2 = iCompanyOrgUnit.getCompanyOrgUnitCollection(this.getFilter(companyOrgData.toString().trim()));
                        if (collection2 != null && collection2.size() > 0) {
                            this.companyOrg = collection2.get(0);
                            this.saleBackInfo.setCompanyOrgUnit(this.companyOrg);
                            break block40;
                        }
                        throw new TaskExternalException(companyOrgData.toString().trim() + " " + SaleBackProfitBillImport.getSCMResource(ctx, "CompanyOrgUnitNotExists"));
                    }
                    catch (BOSException e) {
                        throw new TaskExternalException(e.getMessage(), e.getCause());
                    }
                }
                if (noNumber) {
                    ICodingRuleManager iCodingRuleManager;
                    String companyOrgId = this.companyOrg.getId().toString().trim();
                    try {
                        iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
                    }
                    catch (BOSException e) {
                        throw new TaskExternalException(e.getMessage(), e.getCause());
                    }
                    try {
                        if (!iCodingRuleManager.isExist((IObjectValue)this.saleBackInfo, companyOrgId)) {
                            throw new SCMBillException(SCMBillException.NOCORDRULE);
                        }
                        this.saleBackInfo.setNumber(iCodingRuleManager.getNumber((IObjectValue)this.saleBackInfo, companyOrgId, ""));
                    }
                    catch (SCMBillException e) {
                        throw new TaskExternalException(e.getMessage(), e.getCause());
                    }
                    catch (EASBizException e) {
                        throw new TaskExternalException(e.getMessage(), e.getCause());
                    }
                    catch (BOSException e) {
                        throw new TaskExternalException(e.getMessage(), e.getCause());
                    }
                }
                if ((exchangeRateData = ((DataToken)lineData.get((Object)"FExchangeRate")).data) != null && exchangeRateData.toString().trim().length() > 0) {
                    try {
                        BigDecimal value = new BigDecimal(exchangeRateData.toString());
                        if (value != null && value.compareTo(ZERO) < 0) {
                            throw new TaskExternalException(value + SaleBackProfitBillImport.getSCMResource(ctx, "ExchangeMustPositive"));
                        }
                        this.saleBackInfo.setExchangeRate(new BigDecimal(exchangeRateData.toString().trim()));
                    }
                    catch (NumberFormatException nex) {
                        Logger.error((Throwable)nex);
                        throw new TaskExternalException(exchangeRateData + SaleBackProfitBillImport.getResource(ctx, "FormatMustBeNumber"));
                    }
                }
                try {
                    Object currencyData = ((DataToken)lineData.get((Object)"FCurrency_number")).data;
                    if (currencyData == null || currencyData.toString().trim().length() <= 0) break block41;
                    ICurrency iCurrency = CurrencyFactory.getLocalInstance((Context)ctx);
                    collection = iCurrency.getCurrencyCollection(this.getFilter(currencyData.toString().trim()));
                    if (collection != null && collection.size() > 0) {
                        CurrencyInfo currencyInfo = collection.get(0);
                        this.saleBackInfo.setCurrency(currencyInfo);
                        break block41;
                    }
                    throw new TaskExternalException(currencyData.toString().trim() + " " + SaleBackProfitBillImport.getSCMResource(ctx, "CurrencyNotExists"));
                }
                catch (BOSException e) {
                    throw new TaskExternalException(e.getMessage(), e.getCause());
                }
            }
            try {
                Object customerData = ((DataToken)lineData.get((Object)"FAccountNumber")).data;
                if (customerData == null || customerData.toString() == null || customerData.toString().trim().length() <= 0) break block42;
                ICustomer ic = CustomerFactory.getLocalInstance((Context)ctx);
                collection = ic.getCustomerCollection(this.getFilter(customerData.toString()));
                if (collection != null && collection.size() > 0) {
                    CustomerInfo info = collection.get(0);
                    if (info != null) {
                        this.saleBackInfo.setAccountID(info);
                        this.saleBackInfo.setAccountNumber(info.getNumber());
                        this.saleBackInfo.setAccountName(info.getName());
                        break block42;
                    }
                    throw new TaskExternalException(customerData.toString() + " " + SaleBackProfitBillImport.getSCMResource(ctx, "AccountNotExists"));
                }
                throw new TaskExternalException(customerData.toString() + " " + SaleBackProfitBillImport.getSCMResource(ctx, "AccountNotExists"));
            }
            catch (BOSException e) {
                throw new TaskExternalException(e.getMessage(), e.getCause());
            }
        }
        Object commentData = ((DataToken)lineData.get((Object)"FRemark")).data;
        if (commentData != null && commentData.toString() != null && commentData.toString().length() > 0 && commentData.toString() != null && commentData.toString().trim().length() > 0) {
            if (commentData.toString().trim().length() < 200) {
                this.saleBackInfo.setRemark(commentData.toString());
            } else {
                throw new TaskExternalException(commentData.toString() + " " + SaleBackProfitBillImport.getSCMResource(ctx, "RemarkTooLong"));
            }
        }
        this.saleBackInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        this.saleBackInfo.setCreator(userInfo);
        Date d = new Date();
        this.saleBackInfo.setCreateTime(new Timestamp(d.getTime()));
        this.saleBackInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        BillTypeInfo bii = new BillTypeInfo();
        bii.setId(BOSUuid.read((String)"528d806a-0106-1000-e111-0194c0a812e6463ED552"));
        this.saleBackInfo.setBillType(bii);
        return this.saleBackInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SaleBackProfitBillEntryInfo transmitEntry(Hashtable hsData, Context ctx) throws TaskExternalException {
        if (hsData == null) {
            return null;
        }
        SaleBackProfitBillEntryInfo entryInfo = new SaleBackProfitBillEntryInfo();
        MaterialInfo materialInfo = new MaterialInfo();
        MeasureUnitInfo mui = new MeasureUnitInfo();
        StringBuffer errorString = new StringBuffer();
        for (int i = 0; i < DECIMAL_ENTRY.length; ++i) {
            try {
                Object o = ((DataToken)hsData.get((Object)SaleBackProfitBillImport.DECIMAL_ENTRY[i])).data;
                if (o != null && o.toString().trim().length() > 0) {
                    BigDecimal value = new BigDecimal(o.toString());
                    if (value == null) continue;
                    if (value.compareTo(ZERO) < 0) {
                        throw new TaskExternalException(DECIMAL_ENTRY[i] + SaleBackProfitBillImport.getMyResource(ctx, "import_price_must_positive"));
                    }
                    entryInfo.setBigDecimal(DECIMAL_ENTRY_NAME[i], value);
                    continue;
                }
                entryInfo.setBigDecimal(DECIMAL_ENTRY_NAME[i], ZERO);
                continue;
            }
            catch (NumberFormatException nex) {
                Logger.error((Throwable)nex);
                throw new TaskExternalException(DECIMAL_ENTRY_NAME[i] + SaleBackProfitBillImport.getResource(ctx, "FormatMustBeNumber"));
            }
        }
        try {
            MultiMeasureUnitInfo mmu;
            IMeasureUnit imu;
            MaterialInfo info;
            IMaterial imaterial;
            MaterialCollection collection;
            String number = null;
            Object data = ((DataToken)hsData.get((Object)"FEntries$material_number")).data;
            if (data != null && data.toString().length() > 0 && (number = data.toString()) != null && number.trim().length() > 0 && (collection = (imaterial = MaterialFactory.getLocalInstance((Context)ctx)).getMaterialCollection(this.getFilter(number))) != null && collection.size() > 0) {
                info = collection.get(0);
                if (info == null) throw new TaskExternalException(data.toString() + " " + SaleBackProfitBillImport.getResource(ctx, "MaterialNotExists"));
                entryInfo.setMaterial(info);
                entryInfo.setMaterialGroup(info.getMaterialGroup());
                materialInfo = info;
            }
            if ((data = ((DataToken)hsData.get((Object)"FEntries$unit_number")).data) != null && (number = data.toString()) != null && number.trim().length() > 0) {
                imu = MeasureUnitFactory.getLocalInstance((Context)ctx);
                collection = imu.getMeasureUnitCollection(this.getFilter(number));
                if (collection == null || collection.size() <= 0) throw new TaskExternalException(data.toString() + " " + SaleBackProfitBillImport.getResource(ctx, "UnitNotExists"));
                info = collection.get(0);
                this.checkUnit(ctx, materialInfo, (MeasureUnitInfo)info);
                if (info == null) throw new TaskExternalException(data.toString() + " " + SaleBackProfitBillImport.getResource(ctx, "UnitNotExists"));
                entryInfo.setUnit((MeasureUnitInfo)info);
                mui = info;
            }
            if (entryInfo.getUnit() != null && (mmu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiUnit(materialInfo.getId().toString(), entryInfo.getUnit().getId().toString())) != null) {
                int qtyPrecision = mmu.getQtyPrecision();
                for (int i = 0; i < QTY_MATERILAL_ENTRY.length; ++i) {
                    if (entryInfo.getBigDecimal(QTY_MATERILAL_ENTRY[i]) == null) continue;
                    entryInfo.setBigDecimal(QTY_MATERILAL_ENTRY[i], entryInfo.getBigDecimal(QTY_MATERILAL_ENTRY[i]).setScale(qtyPrecision, 4));
                }
            }
            if ((data = ((DataToken)hsData.get((Object)"FEntries_remark")).data) != null && (number = data.toString()) != null && number.trim().length() > 0) {
                if (number.trim().length() >= 200) throw new TaskExternalException(data.toString() + " " + SaleBackProfitBillImport.getResource(ctx, "RemarkTooLong"));
                entryInfo.setRemark(number.trim());
            }
            if (materialInfo != null && materialInfo.getBaseUnit() != null) {
                imu = MeasureUnitFactory.getLocalInstance((Context)ctx);
                ObjectUuidPK pk = new ObjectUuidPK(materialInfo.getBaseUnit().getId());
                MeasureUnitInfo baseUnit = imu.getMeasureUnitInfo((IObjectPK)pk);
                entryInfo.setBaseUnit(baseUnit);
                BigDecimal qty = entryInfo.getQty();
                BigDecimal baseQty = InvAppUtils.getBaseUnitQty((Context)ctx, (MeasureUnitInfo)mui, (MeasureUnitInfo)baseUnit, (MaterialInfo)materialInfo, (BigDecimal)qty);
                entryInfo.setBaseQty(baseQty);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        if (errorString.length() <= 0) return entryInfo;
        throw new TaskExternalException(errorString.toString());
    }

    private String getIdFromNumber(String number, Context ctx) throws TaskExternalException {
        SaleBackProfitBillCollection collection;
        try {
            collection = SaleBackProfitBillFactory.getLocalInstance(ctx).getSaleBackProfitBillCollection("where number ='" + number + "'");
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        if (collection != null && collection.size() > 0) {
            return collection.get(0).getId().toString();
        }
        return null;
    }

    public int getSubmitType() {
        return 1;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        if (firstData == null || currentData == null) {
            return false;
        }
        DataToken firstNumber = (DataToken)firstData.get(this.getMainField());
        DataToken currentNumber = (DataToken)currentData.get(this.getMainField());
        return firstNumber != null && (currentNumber.data == null || currentNumber.data.toString().length() == 0 || firstNumber.data.equals(currentNumber.data));
    }

    public String getMainField() {
        return "FNumber";
    }

    public static SaleBackProfitTypeEnum getSaleBackProfitTypeEnum(String value, Context ctx) throws TaskExternalException {
        if (value != null) {
            if (SaleBackProfitBillImport.EnumEqualByAlias(value, (Enum)SaleBackProfitTypeEnum.CUSTOMER)) {
                return SaleBackProfitTypeEnum.CUSTOMER;
            }
            throw new TaskExternalException(DataImportTools.getResString((String)"SaleBackProfitTypeError", (Context)ctx));
        }
        return null;
    }

    public static boolean EnumEqualByAlias(String value, Enum enumValue) {
        return value.equals(enumValue.getAlias(new Locale(Locale_zh))) || value.equals(enumValue.getAlias(new Locale(Locale_tw)));
    }

    private EntityViewInfo getFilter(String number) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private void checkUnit(Context ctx, MaterialInfo materialInfo, MeasureUnitInfo mui) throws TaskExternalException, BOSException, EASBizException {
        IMultiMeasureUnit immu = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo mmui = immu.getMultiUnit(materialInfo.getId().toString(), mui.getId().toString());
        if (mmui == null) {
            throw new TaskExternalException(materialInfo.getNumber() + SaleBackProfitBillImport.getResource(ctx, "UnitNotExists"));
        }
    }

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo == null || !(coreBaseInfo instanceof CoreBillBaseInfo)) {
            return;
        }
        try {
            SaleBackProfitBillInfo bill = (SaleBackProfitBillInfo)coreBaseInfo;
            String id = this.getIdFromNumber(bill.getNumber(), ctx);
            IObjectPK userPK = ctx.getCaller();
            if (StringUtil.isEmptyString((String)id)) {
                this.getController(ctx).addnew(coreBaseInfo);
            } else {
                coreBaseInfo.setId(BOSUuid.read((String)id));
                this.getController(ctx).update((IObjectPK)new ObjectUuidPK(id), coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FCompanyOrgUnit_number", rs.getString("companyOrgUnit.number"));
            this.putTable(result, "FCompanyOrgUnit_name", rs.getString("companyOrgUnit.name"));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FSaleBackProfitType", rs.getString("saleBackProfitType"));
            this.putTable(result, "FAccountNumber", rs.getString("accountNumber"));
            this.putTable(result, "FAccountName", rs.getString("accountName"));
            this.putTable(result, "FBizOrgUnitNumber", rs.getString("bizOrgUnitNumber"));
            this.putTable(result, "FBizOrgUnitName", rs.getString("bizOrgUnitName"));
            this.putTable(result, "FCurrency_number", rs.getString("currency.number"));
            this.putTable(result, "FCurrency_name", rs.getString("currency.name"));
            this.putTable(result, "FProfitFromDate", rs.getString("profitFromDate"));
            this.putTable(result, "FProfitToDate", rs.getString("profitToDate"));
            this.putTable(result, "FExchangeRate", rs.getString("exchangeRate"));
            this.putTable(result, "FRemark", rs.getString("remark"));
            this.putTable(result, "FEntries$materialGroup_name_l2", rs.getString("materialGroup.name"));
            this.putTable(result, "FEntries$material_number", rs.getString("material.number"));
            this.putTable(result, "FEntries$material_name_l2", rs.getString("material.name"));
            this.putTable(result, "FEntries$material_model", rs.getString("material.model"));
            this.putTable(result, "FEntries$unit_number", rs.getString("unit.number"));
            this.putTable(result, "FEntries$unit_name", rs.getString("unit.name"));
            this.putTable(result, "FEntries_qty", rs.getString("entries.qty"));
            this.putTable(result, "FEntries$baseUnit_name_l2", rs.getString("baseUnit.name"));
            this.putTable(result, "FEntries_baseQty", rs.getString("entries.baseQty"));
            this.putTable(result, "FEntries_amount", rs.getString("entries.amount"));
            this.putTable(result, "FEntries_baseProfitQty", rs.getString("entries.baseProfitQty"));
            this.putTable(result, "FEntries_baseProfitAmount", rs.getString("entries.baseProfitAmount"));
            this.putTable(result, "FEntries_profitAmount", rs.getString("entries.profitAmount"));
            this.putTable(result, "FEntries_localAmount", rs.getString("entries.localAmount"));
            this.putTable(result, "FEntries_totalArApAmount", rs.getString("entries.totalArApAmount"));
            this.putTable(result, "FEntries_totalLocalArApAmount", rs.getString("entries.totalLocalArApAmount"));
            this.putTable(result, "FEntries_remark", rs.getString("entries.remark"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo = new FilterInfo();
        OrgUnitCollection collection = null;
        try {
            collection = SCMGroupServerUtils.getAuthOrgByPermItem((Context)ctx, (OrgType)OrgType.Company, (String)"salebackProfit_view");
        }
        catch (EASBizException e) {
            Logger.error((Throwable)e);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        if (collection != null && collection.size() > 0) {
            LinkedHashSet<String> keys = new LinkedHashSet<String>();
            for (int i = 0; i < collection.size(); ++i) {
                keys.add(collection.get(i).getId().toString());
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", keys, CompareType.INCLUDE));
            return filterInfo;
        }
        return null;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.sd.channel.app.ExportSaleBackProfiltQuery";
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }
}

