/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sd.channel.app.AbstractSaleChannelInventoryFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class SaleChannelInventoryFacadeControllerBean
extends AbstractSaleChannelInventoryFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.channel.app.SaleChannelInventoryFacadeControllerBean");
    private static final String ResClassName = "com.kingdee.eas.scm.sd.channel.report.ChannelRPTResource";
    private String sp = "\r\n";
    private String SubLabel = "";
    String orgUnitNumber;

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        String displaySql = this.getDisplaySql(params, ctx);
        StringBuffer tempSql = new StringBuffer();
        tempSql.append(displaySql);
        tempSql.append("\n WHERE org.FLevel=1");
        tempSql.append("\n ORDER BY temp.FmaterialNum,temp.FAssistProperty");
        tempSql.append("\n ,temp.Flot,temp.FUnitName");
        RptRowSet rs = this.executeQuery(tempSql.toString(), null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private String getDisplaySql(RptParams params, Context ctx) {
        String tempTable = params.getString("tempTable");
        String orgtempTable = params.getString("orgtempTable");
        StringBuffer displaySql = new StringBuffer();
        displaySql.append("SELECT ");
        displaySql.append("\r\n temp.FmaterialNum FMatNumber");
        displaySql.append("\r\n ,temp.FmaterialName FMatName");
        displaySql.append("\r\n ,temp.FAssistProperty  FAssistProperty");
        displaySql.append("\r\n ,temp.Flot FLot");
        displaySql.append("\r\n ,temp.FUnitName FUnitName");
        displaySql.append("\r\n ,org.FName Channel");
        displaySql.append("\r\n ,(CASE WHEN temp.FQty IS NULL THEN 0 ELSE temp.FQty END) FQty");
        displaySql.append("\r\n ,temp.FAssistUnitName FAssistUnitName");
        displaySql.append("\r\n ,(CASE WHEN temp.FAssistQty IS NULL THEN 0 ELSE temp.FAssistQty END)FAssistQty");
        displaySql.append("\r\n ,temp.FInventoryDate FInventoryDate");
        displaySql.append("\r\n ,temp.FChannelBaseID AS CHANNELBASEID");
        displaySql.append("\r\n ,org.FIsleaf AS CHANNEL_ISLEAF");
        displaySql.append("\r\n ,org.FLevel AS CHANNEL_LEVEL");
        displaySql.append("\r\n ,temp.FMaterialID AS MATERIALID");
        displaySql.append("\r\n FROM  ");
        displaySql.append(tempTable + " temp ");
        displaySql.append("\n INNER JOIN " + orgtempTable + " org ");
        displaySql.append("\n on  org.FID = temp.FChannelBaseID");
        return displaySql.toString();
    }

    public RptParams getDataForIdList(Context ctx, List idList, RptParams params) throws BOSException, EASBizException {
        return this.getDatas(ctx, params, idList, false);
    }

    private RptParams getDatas(Context ctx, RptParams params, List idList, boolean first) throws BOSException {
        String orgTempTable = params.getString("PurChaseUnitTempTable");
        String TempTable = params.getString("tempTable");
        if (first) {
            String subWhere = " org.flevel = 1 ";
        } else {
            StringBuffer fid = new StringBuffer("tem.FId IN (  '").append(idList.get(0).toString()).append("'");
            int n = idList.size();
            for (int i = 1; i < n; ++i) {
                fid.append(", '").append(idList.get(i).toString()).append("'");
            }
            fid.append(" ) ");
            String subWhere = fid.toString();
        }
        StringBuffer sql = new StringBuffer();
        sql.append(this.getDisplaySql(params, ctx));
        sql.append("\n WHERE org.FLevel=1");
        sql.append("\n ORDER BY temp.FmaterialNum,temp.FAssistProperty");
        sql.append("\n ,temp.Flot,temp.FUnitName");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    protected RptParams _findData(Context ctx, RptParams param, int start, int count, String tempTableName, Object treeTypeObject) throws BOSException, EASBizException {
        RptRowSet rs;
        String tempSql = "";
        StringBuffer filter = new StringBuffer();
        filter.append("\n WHERE ");
        filter.append("\n temp.FMaterialID = '" + param.getString("MATERIALID") + "'");
        filter.append("\n AND org.fparentid='" + param.getString("fparentid") + "'");
        if (param.getBoolean("ISFASSISTPROPERTY")) {
            filter.append("\n AND temp.FASSISTPROPERTY IS null");
        } else {
            filter.append("\n AND temp.FASSISTPROPERTY ='" + param.getString("FASSISTPROPERTY") + "'");
        }
        if (param.getBoolean("ISFLOT")) {
            filter.append("\n AND temp.FLOT IS null");
        } else {
            filter.append("\n AND temp.FLOT ='" + param.getString("FLOT") + "'");
        }
        if (param.getBoolean("ISFASSISTUNITNAME")) {
            filter.append("\n AND temp.FASSISTUNITNAME IS null");
        } else if (param.getString("FASSISTUNITNAME") != null) {
            filter.append("\n AND temp.FASSISTUNITNAME = '" + param.getString("FASSISTUNITNAME") + "'");
        }
        if (start <= -1 && count <= -1) {
            tempSql = this.getDisplaySql(param, ctx) + filter.toString();
            rs = this.executeQuery(tempSql, null, ctx);
        } else {
            tempSql = this.getDisplaySql(param, ctx) + filter.toString();
            rs = this.executeQuery(tempSql, null, start, count, ctx);
        }
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    protected IRowSet _getIdList(Context ctx, RptParams param) throws BOSException {
        String tempTable = param.getString("tempTable");
        String orgtempTable = param.getString("orgtempTable");
        StringBuffer rsList = new StringBuffer();
        rsList.append("SELECT ");
        rsList.append("\r\n temp.FID");
        rsList.append("\r\n FROM  ");
        rsList.append(tempTable + " temp ");
        rsList.append("\n INNER JOIN " + orgtempTable + " org ");
        rsList.append("\n on  org.FID = temp.FChannelBaseID");
        rsList.append("\n where org.flevel = 1 ");
        rsList.append("\n ORDER BY temp.FmaterialNum,temp.FAssistProperty");
        rsList.append("\n ,temp.Flot,temp.FUnitName");
        return DbUtil.executeQuery((Context)ctx, (String)rsList.toString());
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTempTable(params.getString("tempTable"), ctx);
        String tempTable = this.getTempTableName(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.report.SMReportResource", (String)"purPriceWMRptUI", (Context)ctx) + "_derekee", ctx);
        params.setString("TempTable", tempTable);
        String orgUnitTempTable = this.getTempTableName(this.getServerResource("ORGUintTempTable", ctx), ctx);
        params.setString("OrgTempTable", orgUnitTempTable);
        StringTokenizer orgTokenizer = new StringTokenizer(params.getString("saleOrgUnit.number"), ";");
        StringBuffer orgUnit = new StringBuffer();
        while (orgTokenizer.hasMoreTokens()) {
            orgUnit.append(",");
            orgUnit.append("'");
            orgUnit.append(orgTokenizer.nextToken().trim());
            orgUnit.append("'");
        }
        this.orgUnitNumber = orgUnit.delete(0, 1).toString();
        this.createAndInsTreeTable(ctx, orgUnitTempTable, params);
        this.createTempTableAndInsertData(ctx, tempTable, params);
        String countSql = "select count(1) cc from " + tempTable;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        RptTableHeader header = new RptTableHeader();
        this.setInventoryReportHead(header, ctx);
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        result.setString("orgtempTable", orgUnitTempTable);
        result.setObject("header", (Object)header);
        result.setInt("verticalCount", count);
        return result;
    }

    private void createTempTableAndInsertData(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        String createSql = this.getCreateTempTable(tempTable, params);
        this.executeSQL(ctx, createSql);
        String insertSql = this.getQtyFromInventory(params, tempTable, ctx);
        this.executeUpdate(insertSql, null, ctx);
        String orgUnitTempTable = params.getString("OrgTempTable");
        this.updateTotal(ctx, tempTable, orgUnitTempTable, params);
        StringBuffer updateOrg = new StringBuffer();
        String orgTempTable = params.getString("OrgTempTable");
        updateOrg.append(" DELETE ");
        updateOrg.append(orgTempTable);
        updateOrg.append("\n WHERE ");
        updateOrg.append(orgTempTable + ".FID NOT IN ");
        updateOrg.append("\n ( SELECT FChannelBaseID ");
        updateOrg.append("\n FROM ");
        updateOrg.append(tempTable).append(")");
        updateOrg.append(" AND ").append(orgTempTable).append(".FParentID IS NOT null");
        this.executeSQL(ctx, updateOrg.toString());
    }

    private void updateTotal(Context ctx, String tempSumTable, String orgTable, RptParams params) throws BOSException {
        StringBuffer inSertCols = new StringBuffer();
        inSertCols.append("\r\n (FID");
        inSertCols.append("\r\n ,FmaterialID");
        inSertCols.append("\r\n ,FmaterialNum");
        inSertCols.append("\r\n ,FmaterialName");
        inSertCols.append("\r\n ,FAssistProperty");
        inSertCols.append("\r\n ,Flot");
        inSertCols.append("\r\n ,FUnitName");
        inSertCols.append("\r\n ,FChannelBaseID");
        inSertCols.append("\r\n ,FQty");
        inSertCols.append("\r\n ,FAssistUnitName");
        inSertCols.append("\r\n ,FAssistQty");
        inSertCols.append("\r\n )");
        StringBuffer selCols = new StringBuffer();
        selCols.append("\r\n newbosid('88888888')");
        selCols.append("\r\n ,temp.FmaterialID");
        selCols.append("\r\n ,temp.FmaterialNum");
        selCols.append("\r\n ,temp.FmaterialName");
        selCols.append("\r\n ,temp.FAssistProperty");
        selCols.append("\r\n ,temp.Flot");
        selCols.append("\r\n ,temp.FUnitName");
        selCols.append("\r\n ,org.FParentID");
        selCols.append("\r\n ,sum(temp.FQty)");
        selCols.append("\r\n ,temp.FAssistUnitName");
        selCols.append("\r\n ,sum(temp.FAssistQty)");
        StringBuffer groupCols = new StringBuffer();
        groupCols.append("\r\n temp.FmaterialID");
        groupCols.append("\r\n ,temp.FmaterialNum");
        groupCols.append("\r\n ,temp.FmaterialName");
        groupCols.append("\r\n ,temp.FAssistProperty");
        groupCols.append("\r\n ,temp.Flot");
        groupCols.append("\r\n ,temp.FUnitName");
        groupCols.append("\r\n ,temp.FAssistUnitName");
        groupCols.append("\r\n ,org.FParentID");
        StringBuffer tableName = new StringBuffer();
        tableName.append(tempSumTable).append(" AS Temp");
        tableName.append("\r\n INNER JOIN ").append(orgTable).append(" AS ORG");
        tableName.append("\r\n ON temp.FChannelBaseID = ORG.FID");
        StringBuffer insertSQL = new StringBuffer();
        insertSQL.append("insert into " + tempSumTable);
        insertSQL.append(inSertCols);
        insertSQL.append("\n SELECT ");
        insertSQL.append(selCols);
        insertSQL.append("\n FROM ");
        insertSQL.append(tableName);
        insertSQL.append("\n GROUP BY ");
        insertSQL.append(groupCols);
        this.executeUpdate(insertSQL.toString(), null, ctx);
    }

    private void setRPTData(SqlParams sqlParams, RptParams params) {
        int count = sqlParams.size() + 1;
        for (int i = 0; i < 4; ++i) {
            if (params.getString("prmtSaleOrgFrom") != null) {
                sqlParams.setString(count++, params.getString("prmtSaleOrgFrom"));
            }
            if (params.getString("ChannelFrom") != null) {
                sqlParams.setString(count++, params.getString("ChannelFrom"));
            }
            if (params.getString("ChannelTo") != null) {
                sqlParams.setString(count++, params.getString("ChannelTo"));
            }
            if (params.getString("materialFrom") != null) {
                sqlParams.setString(count++, params.getString("materialFrom"));
            }
            if (params.getString("materialTo") == null) continue;
            sqlParams.setString(count++, params.getString("materialTo"));
        }
    }

    private void createAndInsTreeTable(Context ctx, String orgTempTable, RptParams params) throws BOSException {
        this.buildTreeTable(ctx, orgTempTable, params);
        StringBuffer insertOrg = new StringBuffer();
        insertOrg.append(" INSERT INTO");
        insertOrg.append("\n ").append(orgTempTable);
        insertOrg.append("\n (FID,FName");
        insertOrg.append("\n ,FParentID");
        insertOrg.append("\n ,FLevel");
        insertOrg.append("\n ,FIsleaf)");
        insertOrg.append(this.getSaleOrg(ctx, orgTempTable, params));
        insertOrg.append("\n UNION ALL ");
        insertOrg.append(this.getChaParentIDISNull(ctx, orgTempTable, params));
        insertOrg.append("\n UNION ALL ");
        insertOrg.append(this.getterminalsaleParentIDISNull(ctx, orgTempTable, params));
        this.executeSQL(ctx, insertOrg.toString());
    }

    private String getSaleOrg(Context ctx, String orgTempTable, RptParams params) {
        StringTokenizer orgTokenizer = new StringTokenizer(params.getString("saleOrgUnit.number"), ";");
        StringBuffer orgUnitNumber = new StringBuffer();
        while (orgTokenizer.hasMoreTokens()) {
            orgUnitNumber.append(",");
            orgUnitNumber.append("'");
            orgUnitNumber.append(orgTokenizer.nextToken().trim());
            orgUnitNumber.append("'");
        }
        orgUnitNumber.delete(0, 1);
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("\n select ");
        tempSql.append("\n FID FID");
        tempSql.append("\n ,FName_").append(ctx.getLocale().getLanguage());
        tempSql.append(" FName");
        tempSql.append("\n ,null FParentID");
        tempSql.append("\n ,1 Flevel");
        tempSql.append("\n ,0 FIsleaf");
        tempSql.append("\n from T_ORG_sale");
        tempSql.append("\n where FNumber IN (");
        tempSql.append(orgUnitNumber);
        tempSql.append(")");
        return tempSql.toString();
    }

    private String getChaParentIDISNull(Context ctx, String orgTempTable, RptParams params) {
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("\n select ");
        tempSql.append("\n ChaBase.FID FID");
        tempSql.append("\n ,ChaBase.FName_").append(ctx.getLocale().getLanguage()).append(" FName");
        tempSql.append("\n ,SaleOrg.FID FParentID");
        tempSql.append("\n ,2 Flevel");
        tempSql.append("\n ,1 FIsleaf");
        tempSql.append("\n from T_BD_ChannelBase ChaBase ");
        tempSql.append("\n INNER JOIN T_BD_ChannelSaleInfo saleInfo ");
        tempSql.append("\n ON saleInfo.FChannelBaseID = ChaBase.FID ");
        tempSql.append("\n inner join T_org_Sale saleOrg ");
        tempSql.append("\n on saleInfo.FSaleORGUnitID = saleOrg.FID ");
        tempSql.append("\n WHERE SaleOrg.FNumber IN (");
        tempSql.append(this.orgUnitNumber + ")");
        return tempSql.toString();
    }

    private String getterminalsaleParentIDISNull(Context ctx, String orgTempTable, RptParams params) {
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("\n select ");
        tempSql.append("\n ChaBase.FID FID");
        tempSql.append("\n ,ChaBase.FName_").append(ctx.getLocale().getLanguage()).append(" FName");
        tempSql.append("\n ,SaleOrg.FID FParentID");
        tempSql.append("\n ,2 Flevel");
        tempSql.append("\n ,1 FIsleaf");
        tempSql.append("\n from T_BD_ChannelBase ChaBase ");
        tempSql.append("\n INNER JOIN T_BD_terminalsaleinfo saleInfo ");
        tempSql.append("\n ON saleInfo.FChannelBaseID = ChaBase.FID ");
        tempSql.append("\n inner join T_org_Sale saleOrg ");
        tempSql.append("\n on saleInfo.FSaleORGUnitID = saleOrg.FID ");
        tempSql.append("\n WHERE SaleOrg.FNumber IN (");
        tempSql.append(this.orgUnitNumber + ")");
        return tempSql.toString();
    }

    private String getChaParentIDNotNull(Context ctx, String orgTempTable, RptParams params) {
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("\n select ");
        tempSql.append("\n ChaBase.FID FID");
        tempSql.append("\n ,ChaBase.FName_").append(ctx.getLocale().getLanguage()).append(" FName");
        tempSql.append("\n ,saleInfo.FParentChannelID FParentID");
        tempSql.append("\n ,0 Flevel");
        tempSql.append("\n ,1 FIsleaf");
        tempSql.append("\n from T_BD_ChannelBase ChaBase ");
        tempSql.append("\n INNER JOIN T_BD_ChannelSaleInfo saleInfo ");
        tempSql.append("\n ON saleInfo.FChannelBaseID = ChaBase.FID ");
        tempSql.append("\n inner join T_org_Sale saleOrg ");
        tempSql.append("\n on saleInfo.FSaleORGUnitID = saleOrg.FID ");
        tempSql.append("\n WHERE SaleOrg.FNumber IN (");
        tempSql.append(this.orgUnitNumber + ")");
        tempSql.append("\n AND saleInfo.FParentChannelID is not null");
        return tempSql.toString();
    }

    private void updateTreeLevelTB(Context ctx, String orgTempTable, RptParams params) throws BOSException {
        StringBuffer updateSql = new StringBuffer();
        for (int i = 3; i <= 10; ++i) {
            int lastLevel = i - 1;
            updateSql.setLength(0);
            updateSql.append(" UPDATE ");
            updateSql.append(orgTempTable);
            updateSql.append("\n SET ");
            updateSql.append(" FLevel =");
            updateSql.append(i);
            updateSql.append("\n WHERE ");
            updateSql.append(" FParentID IN (");
            updateSql.append("\n SELECT  FID FROM ");
            updateSql.append(orgTempTable);
            updateSql.append("\n WHERE FLevel=");
            updateSql.append(lastLevel);
            updateSql.append("\n )");
            updateSql.append("\n AND ");
            updateSql.append(orgTempTable);
            updateSql.append(".FLevel= 0 ");
            this.executeSQL(ctx, updateSql.toString());
        }
    }

    private void buildTreeTable(Context ctx, String orgTempTable, RptParams params) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + orgTempTable + " (");
        sqlbf.append("\n FID varchar(44)");
        sqlbf.append("\n ,FName varchar(100)");
        sqlbf.append("\n ,FParentID varchar(44)");
        sqlbf.append("\n ,FLevel int");
        sqlbf.append("\n ,FIsleaf int");
        sqlbf.append("\n )");
        this.executeSQL(ctx, sqlbf.toString());
    }

    private String getCreateTempTable(String tempTable, RptParams params) {
        StringBuffer createsql = new StringBuffer();
        createsql.append("Create Table " + tempTable + "(\r\n");
        createsql.append("FID Varchar(44) \r\n");
        createsql.append(",FmaterialID Varchar(44) \r\n");
        createsql.append(",FmaterialNum Varchar(80) \r\n");
        createsql.append(",FmaterialName Varchar(80) \r\n");
        createsql.append(",FAssistProperty Varchar(80) \r\n");
        createsql.append(",Flot Varchar(80) \r\n");
        createsql.append(",FUnitName Varchar(80) \r\n");
        createsql.append(",FChannelBaseID Varchar(80) \r\n");
        createsql.append(",FQty  Decimal(28,10)\r\n");
        createsql.append(",FAssistUnitName Varchar(80) \r\n");
        createsql.append(",FAssistQty  Decimal(28,10)\r\n");
        createsql.append(",FInventoryDate DateTime\r\n");
        createsql.append(");");
        return createsql.toString();
    }

    private String getQtyFromInventory(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        StringBuffer tempSql = new StringBuffer();
        StringBuffer groupCols = new StringBuffer();
        tempSql.append("INSERT INTO ");
        tempSql.append(tableName);
        tempSql.append(this.getQtyUnionChaBase(params, tableName, ctx));
        tempSql.append(groupCols.toString());
        return tempSql.toString();
    }

    private String getQtyUnionChaBase(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        StringBuffer selCols = new StringBuffer();
        StringBuffer fromTable = new StringBuffer();
        selCols.append("\r\n newbosid('88888888')");
        selCols.append("\r\n ,mat.fid FMaterialid");
        selCols.append("\r\n ,mat.fnumber Fmaterialnumber");
        selCols.append("\r\n ,mat.fname_" + ctx.getLocale().getLanguage() + " Fmaterialname");
        selCols.append("\r\n ,property.fname_" + ctx.getLocale().getLanguage() + " FAssistpropertyname");
        selCols.append("\r\n ,bill.FLot FLot");
        selCols.append("\r\n ,unit.FName_" + ctx.getLocale().getLanguage() + " FUnitname");
        selCols.append("\r\n ,chaBase.FID  FChannelID");
        selCols.append("\r\n ,bill.FQty FQty ");
        selCols.append("\r\n ,assistUnit.fname_" + ctx.getLocale().getLanguage() + " FassistUnitname");
        selCols.append("\r\n ,bill.fassistqty FassistQty");
        selCols.append("\r\n ,bill.FStorageDate FInventoryDate");
        fromTable.append("\r\n T_SD_ChannelInventory bill");
        fromTable.append("\r\n  INNER JOIN T_BD_Material Mat");
        fromTable.append("\r\n ON Mat.fid = bill.FMaterialID");
        fromTable.append("\r\n  LEFT OUTER JOIN T_BD_AsstAttrValue property");
        fromTable.append(" ON bill.FAssistPropertyID = property.fid");
        fromTable.append("\r\n LEFT OUTER JOIN T_BD_MeasureUnit assistUnit  ");
        fromTable.append(" ON assistUnit.fid = bill.FAssistUnitID");
        fromTable.append("\r\n  INNER JOIN T_ORG_sale ORG");
        fromTable.append("\r\n  ON Org.fid = bill.FSaleOrgUnitID");
        fromTable.append("\r\n INNER JOIN T_BD_ChannelBase chaBase");
        fromTable.append(" ON bill.FSaleChannelID  = chaBase.FID");
        fromTable.append("\r\n  LEFT OUTER JOIN T_BD_MeasureUnit unit");
        fromTable.append(" ON bill.FUnitID = unit.FID");
        StringBuffer filter = new StringBuffer();
        if (params.getString("materialFrom") != null) {
            filter.append(" AND Mat.FNumber >= '");
            filter.append(params.getString("materialFrom") + "'");
        }
        if (params.getString("materialTo") != null) {
            filter.append(" AND Mat.FNumber <='");
            filter.append(params.getString("materialTo") + "'");
        }
        if (params.getString("ChannelFrom") != null) {
            filter.append(" AND chaBase.FNumber >= '");
            filter.append(params.getString("ChannelFrom") + "'");
        }
        if (params.getString("ChannelTo") != null) {
            filter.append(" AND chaBase.FNumber <= '");
            filter.append(params.getString("ChannelTo") + "'");
        }
        if (params.getString("StorageDateFrom") != null) {
            filter.append(" AND FStorageDate >= to_date('");
            filter.append(params.getString("StorageDateFrom") + "')");
        }
        if (params.getString("StorageDateTo") != null) {
            filter.append(" AND FStorageDate <= to_date('");
            filter.append(params.getString("StorageDateTo") + "')");
        }
        if (params.getString("BatchNoFrom") != null) {
            filter.append(" AND FLot >= '");
            filter.append(params.getString("BatchNoFrom") + "'");
        }
        if (params.getString("BatchNoTo") != null) {
            filter.append(" AND FLot <= '");
            filter.append(params.getString("BatchNoTo") + "'");
        }
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("\n SELECT");
        tempSql.append(selCols);
        tempSql.append("\n FROM ");
        tempSql.append(fromTable);
        tempSql.append(" WHERE ORG.FNumber IN (");
        tempSql.append(this.orgUnitNumber + ") ");
        tempSql.append(filter);
        return tempSql.toString();
    }

    private String getFilterString(RptParams params, String purName, Context ctx) throws EASBizException, BOSException {
        StringBuffer filter = new StringBuffer();
        if (params.getString("materialFrom") != null) {
            filter.append(" AND Mat.FNumber >= ? ");
        }
        if (params.getString("materialTo") != null) {
            filter.append(" AND Mat.FNumber <= ? ");
        }
        if (params.getString("ChannelFrom") != null) {
            filter.append(" AND chaBase.FNumber >= ? ");
        }
        if (params.getString("ChannelFrom") != null) {
            filter.append(" AND chaBase.FNumber <= ? ");
        }
        return filter.toString();
    }

    private void insertGroupData(RptParams params, String tempTable, Context ctx) throws BOSException, EASBizException {
        StringBuffer insertCol = new StringBuffer();
        StringBuffer selectBy = new StringBuffer();
        StringBuffer groupBy = new StringBuffer();
        insertCol.append("FID");
        insertCol.append(",FsaleOrgID");
        insertCol.append(",FTerminalChannelType");
        insertCol.append(",FchannelBaseNumber");
        insertCol.append(",FchannelBaseName");
        insertCol.append(",FMaterialNumber");
        selectBy.append(" newbosid('88888888')");
        selectBy.append(",FsaleOrgID");
        selectBy.append(",FTerminalChannelType");
        selectBy.append(",FchannelBaseNumber");
        selectBy.append(",FchannelBaseName");
        selectBy.append(",'" + this.SubLabel + "' ");
        groupBy.append("FsaleOrgID");
        groupBy.append(",FTerminalChannelType");
        groupBy.append(",FchannelBaseNumber");
        groupBy.append(",FchannelBaseName");
        StringBuffer totalSql = new StringBuffer();
        totalSql.append("insert into ").append(tempTable).append(" (").append(insertCol).append(",FAmount) ").append(this.sp);
        totalSql.append(" SELECT ").append(selectBy).append(",sum(FAmount) ").append(this.sp).append(" FROM ").append(tempTable).append(this.sp).append(" GROUP BY ").append(groupBy).append(this.sp);
        this.executeUpdate(totalSql.toString(), null, ctx);
    }

    private void setInventoryReportHead(RptTableHeader header, Context ctx) {
        String materialNum = SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.channel.ChannelReportResource", (String)"materialNumber", (Context)ctx);
        String materialName = SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.channel.ChannelReportResource", (String)"materialName", (Context)ctx);
        String saleOrgUnit = SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.channel.ChannelReportResource", (String)"saleOrgUnit", (Context)ctx);
        String channel = SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.channel.ChannelReportResource", (String)"channel", (Context)ctx);
        String assistProperty = SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.channel.ChannelReportResource", (String)"assistProperty", (Context)ctx);
        String lot = SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.channel.ChannelReportResource", (String)"lot", (Context)ctx);
        String unit = SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.channel.ChannelReportResource", (String)"unit", (Context)ctx);
        String qty = SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.channel.ChannelReportResource", (String)"qty", (Context)ctx);
        String assistUnit = SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.channel.ChannelReportResource", (String)"assistUnit", (Context)ctx);
        String assistQty = SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.channel.ChannelReportResource", (String)"assistQty", (Context)ctx);
        String inventoryDate = SCMUtils.getResource((String)"com.kingdee.eas.scm.sd.channel.ChannelReportResource", (String)"inventoryDate", (Context)ctx);
        String CHANNELBASEID = "CHANNELBASEID";
        String CHANNEL_ISLEAF = "CHANNEL_ISLEAF";
        String CHANNEL_LEVEL = "CHANNEL_LEVEL";
        String MATERIALID = "MATERIALID";
        String[] cols = new String[]{"materialNum", "materialName", "assistProperty", "lot", "unit", "channel", "qty", "assistUnit", "assistQty", "inventoryDate", "CHANNELBASEID", "CHANNEL_ISLEAF", "CHANNEL_LEVEL", "MATERIALID"};
        this.setHeaderColumns(header, cols);
        header.setLabels((Object[][])new Object[][]{{materialNum, materialName, assistProperty, lot, unit, channel, qty, assistUnit, assistQty, inventoryDate, CHANNELBASEID, CHANNEL_ISLEAF, CHANNEL_LEVEL, MATERIALID}});
    }

    private void setHeaderColumns(RptTableHeader header, String[] columns) {
        String dateFormat = RptCellFormatter.getDateFormat((String)"yyyy-MM-dd");
        String prcFormat = RptCellFormatter.getNumberFormat((int)6, (boolean)false);
        RptTableColumn col = null;
        int c = 14;
        for (int i = 0; i < c; ++i) {
            col = new RptTableColumn(columns[i]);
            if (i == 6 || i == 8) {
                col.setWidth(120);
                col.setAligment(2);
                col.setFormatPattern(prcFormat);
            }
            if (i == 9) {
                col.setWidth(120);
                col.setAligment(2);
                col.setFormatPattern(dateFormat);
            }
            if (i >= 10) {
                col.setHided(true);
            }
            header.addColumn(col);
        }
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)ResClassName, (String)key, (Context)ctx);
    }
}

