/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.im.inv.SaleIssueBillFactory;
import com.kingdee.eas.scm.im.inv.SaleIssueBillInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.util.Hashtable;
import java.util.Locale;

public class SaleIssueBillImport
extends AbstractDataTransmission {
    SaleIssueBillInfo netOrderBillInfo = null;
    public static final String RES_IMPORT_CLASS = "com.kingdee.eas.scm.sd.channel.ChannelImportResource";
    public static final String Locale_en = "l1";
    public static final String Locale_zh = "l2";
    public static final String Locale_tw = "l3";
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    Locale local = new Locale("l2");
    String[] BIGDECIMAL_FIELDS_EN = new String[]{"FEntries_qty", "FEntries_price", "FEntries_amount"};
    String[] BIGDECIMAL_OBJ_EN = new String[]{"qty", "price", "amount"};

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return SaleIssueBillFactory.getLocalInstance((Context)ctx);
        }
        catch (BOSException e) {
            throw new TaskExternalException("", (Throwable)e);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        return this.transmitHead(hsData, ctx);
    }

    private SaleIssueBillInfo transmitHead(Hashtable lineData, Context ctx) throws TaskExternalException {
        return null;
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            String currencyPrecision = rs.getString("currency.precision");
            String qtyPrecision = rs.getString("multiMeasureUnit.qtyPrecision");
            String pricePrecision = rs.getString("material.pricePrecision");
            this.putTable(result, "FMaterial_number", rs.getString("material.number"));
            this.putTable(result, "FMaterial_name", rs.getString("material.name"));
            this.putTable(result, "FMaterial_model", rs.getString("material.model"));
            this.putTable(result, "FUnit_name", rs.getString("unit.name"));
            this.putTable(result, "FEntries_lot", rs.getString("entry.lot"));
            this.putTable(result, "FEntries_qty", this.dealPrecision(rs.getBigDecimal("entry.qty"), qtyPrecision));
            this.putTable(result, "FEntries_price", this.dealPrecision(rs.getBigDecimal("entry.price"), pricePrecision));
            this.putTable(result, "FEntries_amount", this.dealPrecision(rs.getBigDecimal("entry.amount"), currencyPrecision));
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FBizDate", rs.getString("bizDate"));
            this.putTable(result, "FAssistProperty_name", rs.getString("assistProperty.name"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }

    private BigDecimal dealPrecision(BigDecimal number, String precision) {
        int _precision = precision != null ? Integer.parseInt(precision) : 2;
        number = number != null && number.toString().indexOf("0E") == -1 ? number.setScale(_precision, 4) : ZERO.setScale(_precision);
        return number;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.sd.channel.app.SaleIssueBillDetailQuery";
    }

    public String getChannelImportResource(String key) {
        return ResourceBase.getString((String)RES_IMPORT_CLASS, (String)key, (Locale)this.local);
    }
}

