/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.framework.DataStateEnum;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseCollection;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.TerminalChannelStatusEnum;
import com.kingdee.eas.basedata.scm.sd.channel.UserChannelRelationCollection;
import com.kingdee.eas.basedata.scm.sd.channel.UserChannelRelationFactory;
import com.kingdee.eas.basedata.scm.sd.channel.util.BosUtil;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.sd.channel.app.AbstractUserChannelRelationFacadeControllerBean;
import org.apache.log4j.Logger;

public class UserChannelRelationFacadeControllerBean
extends AbstractUserChannelRelationFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.channel.app.UserChannelRelationFacadeControllerBean");

    @Override
    protected IObjectCollection _getUserRelationChannels(Context ctx, String userId) throws BOSException {
        ChannelBaseCollection authorizedChannels = new ChannelBaseCollection();
        if (!StringUtil.isEmpty((String)userId)) {
            EntityViewInfo view = new EntityViewInfo();
            view.getSelector().add(new SelectorItemInfo("RelationNumberC.*"));
            view.getSelector().add(new SelectorItemInfo("RelationNumberC.customer.id"));
            view.getSelector().add(new SelectorItemInfo("RelationNumberC.customer.name"));
            view.getSelector().add(new SelectorItemInfo("RelationNumberC.customer.number"));
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("userAccount.id", (Object)userId));
            view.getFilter().getFilterItems().add(new FilterItemInfo("DataState", (Object)DataStateEnum.ENABLE));
            UserChannelRelationCollection userChannelRelationCol = UserChannelRelationFactory.getLocalInstance((Context)ctx).getUserChannelRelationCollection(view);
            if (!userChannelRelationCol.isEmpty()) {
                ChannelBaseInfo channel = null;
                int size = userChannelRelationCol.size();
                for (int i = 0; i < size; ++i) {
                    channel = userChannelRelationCol.get(i).getRelationNumberC();
                    if (!this.isApproveChannel(channel)) continue;
                    authorizedChannels.add(channel);
                }
            }
        }
        return authorizedChannels;
    }

    private boolean isApproveChannel(ChannelBaseInfo channel) {
        boolean flag = false;
        if (BosUtil.isNotEmptyEntity((IObjectValue)channel)) {
            flag = TerminalChannelStatusEnum.APPROVE.equals((Object)channel.getTerminalChannelStatus());
        }
        return flag;
    }

    @Override
    protected IObjectValue _getUserRelationChannel(Context ctx, String userId) throws BOSException {
        ChannelBaseCollection authorizedChannels = this.getUserRelationChannels(ctx, userId);
        ChannelBaseInfo authorizedChannel = null;
        if (authorizedChannels.size() > 0) {
            authorizedChannel = authorizedChannels.get(0);
        }
        return authorizedChannel == null ? new ChannelBaseInfo() : authorizedChannel;
    }
}

