/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.ITableManagerFacade;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.credit.CreditBalanceUpdateFacadeFactory;
import com.kingdee.eas.scm.credit.CreditOperationEnum;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class WriteBackNetOrderHandleFactory {
    private static final Logger logger = Logger.getLogger(WriteBackNetOrderHandleFactory.class);
    private static final String SOBOSTYPE = "C48A423A";
    private static final String SOENTRYBOSTYPE = "88882A58";
    private static final String PRBOSTYPE = "9CA9D08F";
    private static final String SALEISSUEBOSTYPE = "CC3E933B";
    private static final String CHANNELINWAREHSBOSTYPE = "05F02018";

    public static void headHandleB2C(Context ctx, String srcBOSType, BizActionEnum bizAction, IObjectPK[] pks) throws EASBizException, BOSException {
    }

    public static void headHandle(Context ctx, String srcBOSType, BizActionEnum bizAction, IObjectPK[] pks) throws EASBizException, BOSException {
        if (SOBOSTYPE.equals(srcBOSType)) {
            WriteBackNetOrderHandleFactory.wbFromSOBill(ctx, bizAction, pks, true);
        }
        if (PRBOSTYPE.equals(srcBOSType)) {
            WriteBackNetOrderHandleFactory.wbFromPRBill(ctx, bizAction, pks);
        }
        if (SALEISSUEBOSTYPE.equals(srcBOSType)) {
            WriteBackNetOrderHandleFactory.wbFromSaleIssueBill(ctx, bizAction, pks);
        }
        if (CHANNELINWAREHSBOSTYPE.equals(srcBOSType)) {
            WriteBackNetOrderHandleFactory.wbFromChannelInwarehsBill(ctx, bizAction, pks);
        }
    }

    public static void entryHandle(Context ctx, String srcBOSType, BizActionEnum bizAction, IObjectPK[] pks) throws EASBizException, BOSException {
        if (SOENTRYBOSTYPE.equals(srcBOSType)) {
            WriteBackNetOrderHandleFactory.wbFromSOBill(ctx, bizAction, pks, false);
        }
    }

    private static void wbFromSOBill(Context ctx, BizActionEnum bizAction, IObjectPK[] pks, boolean flag) throws BOSException, EASBizException {
        String tablename = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            tablename = pool.createTempTable(WriteBackNetOrderHandleFactory.createTableSQL("tempTable"));
            pool.createIndex(tablename, "FNETORDERBILLID", false, false);
            pool.createIndex(tablename, "FNETORDERBILLENTRYID", false, false);
            String insertSQl = WriteBackNetOrderHandleFactory.insertSaleOrderTableSQL(tablename, WriteBackNetOrderHandleFactory.transPKToIds(pks), flag);
            DbUtil.execute((Context)ctx, (String)insertSQl);
            StringBuffer sql = new StringBuffer();
            StringBuffer deleteActionUpdateSql1 = new StringBuffer();
            StringBuffer deleteActionUpdateSql2 = new StringBuffer();
            if (bizAction == BizActionEnum.SAVE || bizAction == BizActionEnum.SUBMIT) {
                WriteBackNetOrderHandleFactory.updateHasDeleteEntry(ctx, tablename);
                sql.append("UPDATE T_CHA_NETORDERBILLENTRY AS ENTRY SET (FApproveQty,FApprovePrice,FApproveAmount) = ");
                sql.append(" (SELECT T1.FApproveQty AS FAPPROVEQTY, T1.FPRICE, T1.FAMOUNT ");
            } else if (bizAction == BizActionEnum.DELETE) {
                IRowSet idset = DbUtil.executeQuery((Context)ctx, (String)("select FNETORDERBILLENTRYID from " + tablename));
                if (idset != null) {
                    ArrayList<String> entryIDList = new ArrayList<String>();
                    while (idset.next()) {
                        entryIDList.add(idset.getString(1));
                    }
                    CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(entryIDList.toArray(), CreditOperationEnum.SUBMIT);
                }
                sql.append("UPDATE T_CHA_NETORDERBILLENTRY AS ENTRY SET (FApproveQty,FEntryStatus,FBaseStatus,FApproveAmount) = ");
                sql.append(" (SELECT 0 as FApproveQty,");
                sql.append(4).append(" AS FEntryStatus, ");
                sql.append(4).append(" AS FBaseStatus,0 as FApproveAmount ");
                deleteActionUpdateSql1.append("UPDATE T_CHA_NETORDERBILL BILL SET ");
                deleteActionUpdateSql1.append("FBillStatus = ").append(8).append(", ");
                deleteActionUpdateSql1.append("FBaseStatus = ").append(4).append(" ");
                deleteActionUpdateSql1.append("WHERE EXISTS(SELECT 1 FROM ").append(tablename).append(" T1 WHERE T1.FNETORDERBILLID = BILL.FID)");
                deleteActionUpdateSql2.append("UPDATE T_CHA_NETORDERBILL BILL SET ");
                deleteActionUpdateSql2.append("FBillStatus = ").append(4).append(" ");
                deleteActionUpdateSql2.append("WHERE EXISTS( ");
                deleteActionUpdateSql2.append("SELECT 1 FROM ").append(tablename).append(" T2 ");
                deleteActionUpdateSql2.append("WHERE BILL.FID = T2.FNETORDERBILLID AND NOT EXISTS(");
                deleteActionUpdateSql2.append("SELECT 1 FROM ").append(tablename).append(" T1 ");
                deleteActionUpdateSql2.append("INNER JOIN T_CHA_NETORDERBILLENTRY BILLENTRY ON T1.FNETORDERBILLID = BILLENTRY.FPARENTID ");
                deleteActionUpdateSql2.append("WHERE T2.FNETORDERBILLID = T1.FNETORDERBILLID AND (BILLENTRY.FENTRYSTATUS > ").append(4).append(" OR BILLENTRY.FENTRYSTATUS < ").append(4).append(")))");
            } else if (bizAction == BizActionEnum.ALTER) {
                sql.append("UPDATE T_CHA_NETORDERBILLENTRY AS ENTRY SET (FApproveQty,FEntryStatus, FApprovePrice,FApproveAmount) = ");
                sql.append(" (SELECT T1.FApproveQty AS FAPPROVEQTY, ");
                sql.append(" CASE WHEN T1.FApproveQty = 0 THEN ").append(6).append(" ");
                sql.append(" ELSE N1.FEntryStatus END, T1.FPRICE, ");
                sql.append(" CASE WHEN T1.FApproveQty = 0 THEN 0 ELSE T1.FAMOUNT END ");
            } else if (bizAction == BizActionEnum.CLOSE) {
                sql.append("UPDATE T_CHA_NETORDERBILLENTRY AS ENTRY SET (FApproveQty,FTotalPostRequisionQty,FEntryStatus,FApproveAmount) = ");
                sql.append(" (SELECT CASE WHEN T1.FTOTALISSUEQTY > 0 THEN T1.FTOTALISSUEQTY ELSE 0 END,");
                sql.append(" CASE WHEN T1.FTOTALISSUEQTY > 0 THEN CASE WHEN T1.FTOTALISSUEQTY > T1.FTOTALPOSTQTY THEN T1.FTOTALPOSTQTY ");
                sql.append(" ELSE T1.FTOTALISSUEQTY END ELSE 0 END, ");
                sql.append(" CASE WHEN T1.FTOTALISSUEQTY > 0 THEN N1.FEntryStatus ELSE ").append(6).append(" END, ");
                sql.append(" CASE WHEN T1.FTOTALISSUEQTY > 0 THEN T1.FTOTALISSUEQTY*N1.FApprovePrice ELSE 0 END ");
            } else if (bizAction == BizActionEnum.UNCLOSE) {
                sql.append("UPDATE T_CHA_NETORDERBILLENTRY AS ENTRY SET (FApproveQty,FTotalPostRequisionQty,FTotalIssueQty, FEntryStatus,FApproveAmount) = ");
                sql.append(" (SELECT T1.FApproveQty AS FAPPROVEQTY, T1.FTOTALPOSTQTY AS FTotalPostRequisionQty,T1.FTOTALISSUEQTY AS FTotalIssueQty,");
                sql.append(" CASE WHEN T1.FTOTALISSUEQTY = 0 THEN ").append(5).append(" ");
                sql.append(" ELSE N1.FEntryStatus END, T1.FApproveQty*N1.FApprovePrice AS FApproveAmount ");
            } else if (bizAction == BizActionEnum.AUDIT) {
                sql.append(" UPDATE T_CHA_NETORDERBILLENTRY AS ENTRY SET (FApproveQty,FApprovePrice,FApproveAmount,FEntryStatus) = ");
                sql.append(" (SELECT T1.FApproveQty AS FAPPROVEQTY, T1.FPRICE, T1.FAMOUNT,  ");
                sql.append(5).append(" AS EntryStatus ");
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                sql.append(" UPDATE T_CHA_NETORDERBILLENTRY AS ENTRY SET (FApproveQty,FApprovePrice,FApproveAmount,FEntryStatus) = ");
                sql.append(" (SELECT T1.FApproveQty AS FAPPROVEQTY, T1.FPRICE, T1.FAMOUNT,  ");
                sql.append(12).append(" AS EntryStatus ");
            }
            sql.append(" FROM T_CHA_NETORDERBILLENTRY N1 INNER JOIN ");
            sql.append(tablename);
            sql.append(" T1 ON T1.FNETORDERBILLENTRYID = N1.FID AND T1.FNETORDERBILLID = N1.FPARENTID ");
            sql.append(" WHERE T1.FNETORDERBILLENTRYID = ENTRY.FID)");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            if (bizAction == BizActionEnum.DELETE) {
                DbUtil.execute((Context)ctx, (String)deleteActionUpdateSql1.toString());
                DbUtil.execute((Context)ctx, (String)deleteActionUpdateSql2.toString());
            }
        }
        catch (Exception e) {
            throw new BOSException("\u9500\u552e\u8ba2\u5355\u7684\u53cd\u5199\u6e20\u9053\u8ba2\u5355\u9519\u8bef\uff01", (Throwable)e);
        }
        finally {
            if (pool != null && tablename != null) {
                pool.releaseTable(tablename);
            }
        }
    }

    private static void updateHasDeleteEntry(Context ctx, String tablename) throws BOSException, SQLException, EASBizException {
        List entryIdList = WriteBackNetOrderHandleFactory.getDeleteEntryIdsFromSaleOrder(ctx, tablename);
        if (entryIdList.size() > 0) {
            CreditBalanceUpdateFacadeFactory.getLocalInstance((Context)ctx).updateBalance(entryIdList.toArray(), CreditOperationEnum.SUBMIT);
            String ids = WriteBackNetOrderHandleFactory.transferIdList(entryIdList);
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE T_CHA_NETORDERBILLENTRY  SET FApproveQty = 0 ,FApproveAmount = 0,FEntryStatus = ");
            sql.append(4).append(" ");
            sql.append(" WHERE FID IN (").append(ids).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private static List getDeleteEntryIdsFromSaleOrder(Context ctx, String tablename) throws BOSException, SQLException {
        ArrayList<String> entryIdList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FID FROM T_CHA_NETORDERBILLENTRY AS ENTRY  ");
        sql.append(" WHERE ENTRY.FPARENTID IN (");
        sql.append(" SELECT TMP.FNETORDERBILLID FROM ").append(tablename).append(" TMP GROUP BY TMP.FNETORDERBILLID)");
        sql.append(" AND ENTRY.FID NOT IN (");
        sql.append(" SELECT N1.FID FROM T_CHA_NETORDERBILLENTRY N1 INNER JOIN (");
        sql.append(" SELECT FNETORDERBILLENTRYID  FROM T_SD_SaleOrderEntry WHERE  FNETORDERBILLID IN (");
        sql.append(" SELECT TMP.FNETORDERBILLID FROM ").append(tablename).append(" TMP GROUP BY TMP.FNETORDERBILLID))T1");
        sql.append(" ON N1.FID = T1.FNETORDERBILLENTRYID ) AND ");
        sql.append(" ENTRY.FEntryStatus = ").append(5);
        IRowSet idset = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (idset != null) {
            while (idset.next()) {
                if (StringUtils.isEmpty((String)idset.getString(1))) continue;
                entryIdList.add(idset.getString(1));
            }
        }
        return entryIdList;
    }

    private static String transferIdList(List idList) {
        StringBuffer ids = new StringBuffer("");
        for (int i = 0; i < idList.size(); ++i) {
            ids.append("'");
            ids.append((String)idList.get(i));
            ids.append("',");
        }
        return ids.deleteCharAt(ids.length() - 1).toString();
    }

    private static void wbFromPRBill(Context ctx, BizActionEnum bizAction, IObjectPK[] pks) throws BOSException, EASBizException {
        String tablename = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            tablename = pool.createTempTable(WriteBackNetOrderHandleFactory.createTableSQL("tempTable"));
            pool.createIndex(tablename, "FNETORDERBILLID", false, false);
            pool.createIndex(tablename, "FNETORDERBILLENTRYID", false, false);
            String insertSQl = WriteBackNetOrderHandleFactory.insertPostTableSQL(tablename, WriteBackNetOrderHandleFactory.transPKToIds(pks), true);
            DbUtil.execute((Context)ctx, (String)insertSQl);
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE T_CHA_NETORDERBILLENTRY AS ENTRY SET (FTotalPostRequisionQty) = ");
            if (bizAction == BizActionEnum.AUDIT) {
                sql.append(" (SELECT T1.FPOSTQTY+N1.FTotalPostRequisionQty AS  FTotalPostRequisionQty ");
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                sql.append(" (SELECT N1.FTotalPostRequisionQty-T1.FPOSTQTY AS  FTotalPostRequisionQty ");
            }
            sql.append(" FROM T_CHA_NETORDERBILLENTRY N1 INNER JOIN ");
            sql.append(tablename);
            sql.append(" T1 ON T1.FNETORDERBILLENTRYID = N1.FID AND T1.FNETORDERBILLID = N1.FPARENTID ");
            sql.append(" WHERE T1.FNETORDERBILLENTRYID = ENTRY.FID)");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            throw new BOSException("\u53d1\u8d27\u901a\u77e5\u5355\u7684\u53cd\u5199\u9519\u8bef\uff01", (Throwable)e);
        }
        finally {
            if (pool != null && tablename != null) {
                pool.releaseTable(tablename);
            }
        }
    }

    private static void wbFromSaleIssueBill(Context ctx, BizActionEnum bizAction, IObjectPK[] pks) throws BOSException, EASBizException {
        String tablename = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            tablename = pool.createTempTable(WriteBackNetOrderHandleFactory.createTableSQL("tempTable"));
            pool.createIndex(tablename, "FNETORDERBILLID", false, false);
            pool.createIndex(tablename, "FNETORDERBILLENTRYID", false, false);
            String insertSQl = WriteBackNetOrderHandleFactory.insertSaleIssueTableSQL(tablename, WriteBackNetOrderHandleFactory.transPKToIds(pks), true);
            DbUtil.execute((Context)ctx, (String)insertSQl);
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE T_CHA_NETORDERBILLENTRY AS ENTRY SET (FTotalIssueQty,FEntryStatus) = ");
            if (bizAction == BizActionEnum.AUDIT) {
                sql.append(" (SELECT T1.FSALEISSUEQTY+N1.FTotalIssueQty AS FTotalIssueQty, ");
                sql.append(" CASE WHEN T1.FSALEISSUEQTY+N1.FTotalIssueQty > 0 AND N1.FEntryStatus != ");
                sql.append(11);
                sql.append(" THEN ");
                sql.append(10).append(" ");
                sql.append(" WHEN T1.FSALEISSUEQTY+N1.FTotalIssueQty <= 0 AND N1.FEntryStatus != ");
                sql.append(11);
                sql.append(" THEN ");
                sql.append(5).append(" ");
                sql.append(" ELSE ").append("N1.FEntryStatus").append(" END ");
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                sql.append(" (SELECT N1.FTotalIssueQty-T1.FSALEISSUEQTY AS FTotalIssueQty, ");
                sql.append(" CASE WHEN N1.FTotalIssueQty-T1.FSALEISSUEQTY > 0 THEN ");
                sql.append(10).append(" ");
                sql.append(" ELSE ").append(5).append(" END ");
            }
            sql.append(" FROM T_CHA_NETORDERBILLENTRY N1 INNER JOIN ");
            sql.append(tablename);
            sql.append(" T1 ON T1.FNETORDERBILLENTRYID = N1.FID AND T1.FNETORDERBILLID = N1.FPARENTID ");
            sql.append(" WHERE T1.FNETORDERBILLENTRYID = ENTRY.FID)");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            throw new BOSException("\u9500\u552e\u51fa\u5e93\u5355\u7684\u53cd\u5199\u9519\u8bef\uff01", (Throwable)e);
        }
        finally {
            if (pool != null && tablename != null) {
                pool.releaseTable(tablename);
            }
        }
    }

    private static void wbFromChannelInwarehsBill(Context ctx, BizActionEnum bizAction, IObjectPK[] pks) throws BOSException, EASBizException {
        String tablename = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            tablename = pool.createTempTable(WriteBackNetOrderHandleFactory.createTableSQL("tempTable"));
            pool.createIndex(tablename, "FNETORDERBILLID", false, false);
            pool.createIndex(tablename, "FNETORDERBILLENTRYID", false, false);
            String insertSQl = WriteBackNetOrderHandleFactory.insertChannelInWarehsTableSQL(tablename, WriteBackNetOrderHandleFactory.transPKToIds(pks), true);
            DbUtil.execute((Context)ctx, (String)insertSQl);
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE T_CHA_NETORDERBILLENTRY AS ENTRY SET (FTotalConfirmQty,FEntryStatus) = ");
            if (bizAction == BizActionEnum.AUDIT) {
                sql.append(" (SELECT T1.FTOTALCONFIRMQTY+N1.FTotalConfirmQty AS FTotalConfirmQty, ");
                sql.append(" CASE WHEN T1.FTOTALCONFIRMQTY+N1.FTotalConfirmQty > 0 THEN ");
                sql.append(11).append(" ");
                sql.append(" ELSE ").append(11).append(" END ");
            } else if (bizAction == BizActionEnum.UNAUDIT) {
                sql.append(" (SELECT N1.FTotalConfirmQty-T1.FTOTALCONFIRMQTY AS FTotalConfirmQty, ");
                sql.append(" CASE WHEN N1.FTotalConfirmQty-T1.FTOTALCONFIRMQTY > 0 THEN ");
                sql.append(11).append(" ");
                sql.append(" ELSE ").append(10).append(" END ");
            }
            sql.append(" FROM T_CHA_NETORDERBILLENTRY N1 INNER JOIN ");
            sql.append(tablename);
            sql.append(" T1 ON T1.FNETORDERBILLENTRYID = N1.FID AND T1.FNETORDERBILLID = N1.FPARENTID ");
            sql.append(" WHERE T1.FNETORDERBILLENTRYID = ENTRY.FID)");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            throw new BOSException("\u9500\u552e\u51fa\u5e93\u5355\u7684\u53cd\u5199\u9519\u8bef\uff01", (Throwable)e);
        }
        finally {
            if (pool != null && tablename != null) {
                pool.releaseTable(tablename);
            }
        }
    }

    private static String createTemptable(Context ctx) throws BOSException {
        ITableManagerFacade iTableManager = TableManagerFacadeFactory.getLocalInstance((Context)ctx);
        String tablename = iTableManager.getTableName("com.kingdee.eas.scm.sd.channel.app.WriteBackNetOrderHandleFactory");
        iTableManager.createTempTable(WriteBackNetOrderHandleFactory.createTableSQL(tablename));
        return tablename;
    }

    private static String createTableSQL(String tablename) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE ");
        sql.append(tablename);
        sql.append("(FNETORDERBILLID VARCHAR(44),");
        sql.append("FNETORDERBILLENTRYID VARCHAR(44),");
        sql.append("FPRICE DECIMAL(21,8),");
        sql.append("FAMOUNT DECIMAL(21,8),");
        sql.append("FAPPROVEQTY DECIMAL(21,8),");
        sql.append("FPOSTQTY DECIMAL(21,8),");
        sql.append("FSALEISSUEQTY DECIMAL(21,8),");
        sql.append("FTOTALPOSTQTY DECIMAL(21,8),");
        sql.append("FTOTALISSUEQTY DECIMAL(21,8),");
        sql.append("FTOTALCONFIRMQTY DECIMAL(21,8))");
        return sql.toString();
    }

    private static String insertSaleOrderTableSQL(String tablename, String ids, boolean flag) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tablename).append(" SELECT FNETORDERBILLID, FNETORDERBILLENTRYID,MAX(FTaxPrice) AS FPRICE, SUM(FTaxAmount) AS FAMOUNT, SUM(FQty) AS FAPPRIVEQTY, ").append("0 AS FPOSTQTY,0 AS FSALEISSUEQTY, SUM(FTotalShippingQty) AS FTOTALPOSTQTY, SUM(FTotalIssueQty) AS FTOTALISSUEQTY,0 AS FTOTALCONFIRMQTY").append(" FROM T_SD_SaleOrderEntry WHERE ").append(flag ? "FPARENTID" : "FID").append(" IN ('").append(ids).append("') AND FNETORDERBILLENTRYID IS NOT NULL GROUP BY FNETORDERBILLENTRYID,FNETORDERBILLID");
        return sql.toString();
    }

    private static String insertPostTableSQL(String tablename, String ids, boolean flag) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tablename).append(" SELECT FNETORDERBILLID, FNETORDERBILLENTRYID,0 AS FPRICE, 0 AS FAMOUNT, 0 AS FAPPROVEQTY, ").append("SUM(FQty) AS FPOSTQTY,0 AS FSALEISSUEQTY, 0 AS FTOTALPOSTQTY, 0 AS FTOTALISSUEQTY,0 AS FTOTALCONFIRMQTY").append(" FROM T_SD_PostRequisitionEntry WHERE ").append(flag ? "FPARENTID" : "FID").append(" IN ('").append(ids).append("') AND FNETORDERBILLENTRYID IS NOT NULL GROUP BY FNETORDERBILLENTRYID,FNETORDERBILLID");
        return sql.toString();
    }

    private static String insertSaleIssueTableSQL(String tablename, String ids, boolean flag) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tablename).append(" SELECT FNETORDERBILLID, FNETORDERBILLENTRYID,0 AS FPRICE, 0 AS FAMOUNT,0 AS FAPPROVEQTY,").append(" 0 AS FPOSTQTY,SUM(FQTY) AS FSALEISSUEQTY, 0 AS FTOTALPOSTQTY, 0 AS FTOTALISSUEQTY,0 AS FTOTALCONFIRMQTY").append(" FROM T_IM_SaleIssueEntry WHERE ").append(flag ? "FPARENTID" : "FID").append(" IN ('").append(ids).append("') AND FNETORDERBILLENTRYID IS NOT NULL GROUP BY FNETORDERBILLENTRYID,FNETORDERBILLID");
        return sql.toString();
    }

    private static String insertChannelInWarehsTableSQL(String tablename, String ids, boolean flag) {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ").append(tablename).append(" SELECT FNETORDERBILLID, FNETORDERBILLENTRYID,0 AS FPRICE, 0 AS FAMOUNT, 0 AS FAPPROVEQTY,").append("0 AS FPOSTQTY,0 AS FSALEISSUEQTY, 0 AS FTOTALPOSTQTY, 0 AS FTOTALISSUEQTY,SUM(FQTY) AS FTOTALCONFIRMQTY").append(" FROM T_CHA_ChannelInWarehsBillEntry WHERE ").append(flag ? "FPARENTID" : "FID").append(" IN ('").append(ids).append("') AND FNETORDERBILLENTRYID IS NOT NULL GROUP BY FNETORDERBILLENTRYID,FNETORDERBILLID");
        return sql.toString();
    }

    private static String transPKToIds(IObjectPK[] pks) {
        StringBuffer _pks = new StringBuffer();
        int length = pks.length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                _pks.append("','");
            }
            _pks.append(pks[i]);
        }
        return _pks.toString();
    }
}

