/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.webservice.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.util.BosUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.sd.channel.ChannelSaleIssueBillEntryCollection;
import com.kingdee.eas.scm.sd.channel.ChannelSaleIssueBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.ChannelSaleIssueBillFactory;
import com.kingdee.eas.scm.sd.channel.ChannelSaleIssueBillInfo;
import com.kingdee.eas.scm.sd.channel.ChannelSaleIssueTypeEnum;
import com.kingdee.eas.scm.sd.channel.IChannelSaleIssueBill;
import com.kingdee.eas.scm.sd.channel.UserChannelRelationFacadeFactory;
import com.kingdee.eas.scm.sd.channel.webservice.WsChannelSaleIssueBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.webservice.WsChannelSaleIssueBillInfo;
import com.kingdee.eas.scm.sd.channel.webservice.app.utils.WSDataGetUtil;
import com.kingdee.eas.scm.sd.channel.webservice.app.utils.WsImportChannelInWarehsBillUtils;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class WsChannelSaleIssueUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.channel.webservice.app.utils.WsChannelSaleIssueUtils");

    public static IObjectCollection import_ChannelSaleIssueBill(Context ctx, IObjectCollection billCols, IObjectCollection entries) throws BOSException, EASBizException {
        IChannelSaleIssueBill iChannelSaleIssueBill = ChannelSaleIssueBillFactory.getLocalInstance(ctx);
        HashMap<String, String> numberMap = new HashMap<String, String>();
        int count = billCols.size();
        for (int i = 0; i < count; ++i) {
            String rtnNumber;
            boolean isChannelUser;
            ChannelSaleIssueBillInfo bill = new ChannelSaleIssueBillInfo();
            WsChannelSaleIssueBillInfo billInfo = (WsChannelSaleIssueBillInfo)billCols.getObject(i);
            String number = String.valueOf(billInfo.getNumber());
            billInfo.put("ws_number", number);
            if (number == null) {
                WsChannelSaleIssueUtils.setMessage(billInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"23_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            if (numberMap.containsKey(number)) {
                WsChannelSaleIssueUtils.setMessage(billInfo, "1001 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"24_WsChannelJXCUtils", (Locale)ctx.getLocale()), number));
                continue;
            }
            numberMap.put(number, number);
            bill.setNumber(String.valueOf(billInfo.getNumber()));
            String saleIssueType = billInfo.getSaleIssueType();
            if (saleIssueType == null || "".equals(saleIssueType)) {
                bill.setSaleIssueType(ChannelSaleIssueTypeEnum.SALEOUT);
            } else {
                ChannelSaleIssueTypeEnum inSaleIssueType = ChannelSaleIssueTypeEnum.getEnum(Integer.parseInt(saleIssueType));
                if (inSaleIssueType == null) {
                    inSaleIssueType = ChannelSaleIssueTypeEnum.SALEOUT;
                }
                bill.setSaleIssueType(inSaleIssueType);
            }
            String channelNumber = billInfo.getChannelNumber();
            SaleOrgUnitInfo saleOrgUnitInfo = null;
            UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
            if (BosUtil.isEmptyEntity((IObjectValue)userInfo)) {
                WsChannelSaleIssueUtils.setMessage(billInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"25_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            ChannelBaseInfo curChannelBaseInfo = UserChannelRelationFacadeFactory.getLocalInstance(ctx).getUserRelationChannel(userInfo.getId().toString());
            boolean bl = isChannelUser = !BosUtil.isNotEmptyEntity((IObjectValue)curChannelBaseInfo);
            if (!isChannelUser && (null == channelNumber || "".equals(channelNumber))) {
                WsChannelSaleIssueUtils.setMessage(billInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"26_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            ChannelBaseInfo channelBaseInfo = WSDataGetUtil.findChannelBase(ctx, channelNumber);
            if (channelBaseInfo != null) {
                bill.setChannel(channelBaseInfo);
            } else if (isChannelUser) {
                bill.setChannel(curChannelBaseInfo);
            } else {
                WsChannelSaleIssueUtils.setMessage(billInfo, "2001", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"27_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            String orgUnit = billInfo.getSaleOrgUnit();
            if (!isChannelUser && (null == orgUnit || "".equals(orgUnit))) {
                WsChannelSaleIssueUtils.setMessage(billInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"28_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            saleOrgUnitInfo = WSDataGetUtil.findSaleOrgUnit(ctx, orgUnit);
            if (saleOrgUnitInfo != null) {
                bill.setSaleOrgUnit(saleOrgUnitInfo);
            } else if (isChannelUser) {
                saleOrgUnitInfo = WSDataGetUtil.getChannelSaleInfo(ctx, curChannelBaseInfo);
                bill.setSaleOrgUnit(saleOrgUnitInfo);
            } else {
                WsChannelSaleIssueUtils.setMessage(billInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"29_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            String salePerson = billInfo.getSalePerson();
            PersonInfo personInfo = WSDataGetUtil.findSalePerson(ctx, salePerson);
            if (personInfo != null) {
                bill.setSalePerson(personInfo);
            } else if (isChannelUser && saleOrgUnitInfo != null && saleOrgUnitInfo.getLeader() != null) {
                bill.setSalePerson(saleOrgUnitInfo.getLeader());
            }
            CompanyOrgUnitInfo companyOrgUnitInfo = WsChannelSaleIssueUtils.getCompanyOrgUnit(OrgType.Sale, OrgType.Company, saleOrgUnitInfo.getId(), ctx);
            if (companyOrgUnitInfo != null) {
                CurrencyInfo baseCurrencyInfo = WsImportChannelInWarehsBillUtils.getBaseCurrencyInfo(ctx, companyOrgUnitInfo);
                bill.setCurrency(baseCurrencyInfo);
            }
            bill.setExchangeRate(new BigDecimal("1.00"));
            Date date = billInfo.getBizDate();
            if (date == null) {
                WsChannelSaleIssueUtils.setMessage(billInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"47_WsChannelSaleIssueUtils", (Locale)ctx.getLocale()));
                continue;
            }
            bill.setBizDate(billInfo.getBizDate());
            String baseStatus = billInfo.getBaseStatus();
            if (null == baseStatus || "".equals(baseStatus)) {
                bill.setBaseStatus(BillBaseStatusEnum.SUBMITED);
            } else {
                BillBaseStatusEnum baseStatusEnum = BillBaseStatusEnum.getEnum((int)Integer.parseInt(baseStatus));
                if (baseStatusEnum != null) {
                    bill.setBaseStatus(BillBaseStatusEnum.ADD);
                } else {
                    bill.setBaseStatus(BillBaseStatusEnum.SUBMITED);
                }
            }
            bill.setRemark(billInfo.getRemark());
            if (entries != null && entries.size() > 0) {
                ChannelSaleIssueBillEntryCollection entryCol = bill.getEntries();
                int size = entries.size();
                for (int j = 0; j < size; ++j) {
                    ChannelSaleIssueBillEntryInfo entryInfo = new ChannelSaleIssueBillEntryInfo();
                    WsChannelSaleIssueBillEntryInfo wsChannelSaleIssueBillEntryInfo = (WsChannelSaleIssueBillEntryInfo)entries.getObject(j);
                    if (wsChannelSaleIssueBillEntryInfo.getEntrySeq() != billInfo.getEntrySeq()) {
                        WsChannelSaleIssueUtils.setMessage(billInfo, "1023 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"32_WsChannelJXCUtils", (Locale)ctx.getLocale()), billInfo.getNumber().toString()));
                        continue;
                    }
                    entryInfo.setSeq(wsChannelSaleIssueBillEntryInfo.getEntrySeq());
                    String materialNumber = wsChannelSaleIssueBillEntryInfo.getMaterialNumber();
                    if (materialNumber == null) {
                        WsChannelSaleIssueUtils.setMessage(billInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"34_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    MaterialInfo materialInfo = WSDataGetUtil.findMaterial(ctx, wsChannelSaleIssueBillEntryInfo.getMaterialNumber());
                    if (materialInfo == null) {
                        WsChannelSaleIssueUtils.setMessage(billInfo, "2001 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"35_WsChannelJXCUtils", (Locale)ctx.getLocale()), materialNumber));
                        continue;
                    }
                    entryInfo.setMaterial(materialInfo);
                    double qty = wsChannelSaleIssueBillEntryInfo.getQty();
                    if (qty == 0.0) {
                        WsChannelSaleIssueUtils.setMessage(billInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"48_WsChannelSaleIssueUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    entryInfo.setQty(new BigDecimal(wsChannelSaleIssueBillEntryInfo.getQty()));
                    entryInfo.setPrice(wsChannelSaleIssueBillEntryInfo.getPrice());
                    entryInfo.setAmount(wsChannelSaleIssueBillEntryInfo.getAmount());
                    String unitNumber = wsChannelSaleIssueBillEntryInfo.getUnitNumber();
                    if (unitNumber == null) {
                        WsChannelSaleIssueUtils.setMessage(billInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"49_WsChannelSaleIssueUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    MeasureUnitInfo measureUnitInfo = WSDataGetUtil.findMeasureUnit(ctx, unitNumber);
                    if (measureUnitInfo == null) {
                        WsChannelSaleIssueUtils.setMessage(billInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"37_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    entryInfo.setUnit(measureUnitInfo);
                    entryInfo.setRemark(wsChannelSaleIssueBillEntryInfo.getRemark());
                    entryCol.add(entryInfo);
                }
            } else if (bill.getEntries() == null || bill.getEntries().size() == 0) {
                WsChannelSaleIssueUtils.setMessage(billInfo, "1023 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"32_WsChannelJXCUtils", (Locale)ctx.getLocale()), billInfo.getNumber().toString()));
                continue;
            }
            if ((rtnNumber = (String)billInfo.get("ws_returnNumber")) != null || billInfo.get("ws_SuccessID") != null) continue;
            ChannelSaleIssueBillInfo tempBillInfo = WSDataGetUtil.findChannelSaleIssueBill(ctx, channelNumber, number);
            if (tempBillInfo != null) {
                int _baseStatus = tempBillInfo.getBaseStatus().getValue();
                if (_baseStatus == 2 || _baseStatus == 1) {
                    ObjectUuidPK pk = new ObjectUuidPK(tempBillInfo.getId());
                    bill.setId(tempBillInfo.getId());
                    bill.setBaseStatus(tempBillInfo.getBaseStatus());
                    iChannelSaleIssueBill.update((IObjectPK)pk, bill);
                    billInfo.put("ws_SuccessID", number);
                    WsChannelSaleIssueUtils.setMessage(billInfo, "0000", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"38_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                    continue;
                }
                WsChannelSaleIssueUtils.setMessage(billInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"39_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            try {
                billInfo.put("ws_SuccessID", number);
                WsChannelSaleIssueUtils.setMessage(billInfo, "0000", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"38_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            catch (Exception e) {
                WsChannelSaleIssueUtils.dealException(ctx, e, billInfo);
            }
        }
        return billCols;
    }

    public static IObjectCollection update_ChannelBill(Context ctx, IObjectCollection billCols, IObjectCollection entries) throws BOSException, EASBizException {
        IChannelSaleIssueBill iChannelSaleIssueBill = ChannelSaleIssueBillFactory.getLocalInstance(ctx);
        HashMap<String, String> numberMap = new HashMap<String, String>();
        int count = billCols.size();
        for (int i = 0; i < count; ++i) {
            ChannelSaleIssueBillInfo bill = new ChannelSaleIssueBillInfo();
            WsChannelSaleIssueBillInfo channelSaleIssueBillInfo = (WsChannelSaleIssueBillInfo)billCols.getObject(i);
            String number = channelSaleIssueBillInfo.getNumber();
            channelSaleIssueBillInfo.put("ws_number", number);
            String channelNumber = channelSaleIssueBillInfo.getChannelNumber();
            ChannelSaleIssueBillInfo tempBillInfo = WSDataGetUtil.findChannelSaleIssueBill(ctx, channelNumber, number);
            if (tempBillInfo != null) {
                int _baseStatus = tempBillInfo.getBaseStatus().getValue();
                if (_baseStatus == 2 || _baseStatus == 1) {
                    String rtnNumber;
                    boolean isChannelUser;
                    if (number == null) {
                        WsChannelSaleIssueUtils.setMessage(channelSaleIssueBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"23_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (numberMap.containsKey(number)) {
                        WsChannelSaleIssueUtils.setMessage(channelSaleIssueBillInfo, "1001 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"40_WsChannelJXCUtils", (Locale)ctx.getLocale()), number));
                        continue;
                    }
                    numberMap.put(number, number);
                    bill.setNumber(number);
                    String saleIssueType = channelSaleIssueBillInfo.getSaleIssueType();
                    if (saleIssueType == null || "".equals(saleIssueType)) {
                        bill.setSaleIssueType(ChannelSaleIssueTypeEnum.SALEOUT);
                    } else {
                        ChannelSaleIssueTypeEnum inSaleIssueType = ChannelSaleIssueTypeEnum.getEnum(Integer.parseInt(saleIssueType));
                        if (inSaleIssueType == null) {
                            inSaleIssueType = ChannelSaleIssueTypeEnum.SALEOUT;
                        }
                        bill.setSaleIssueType(inSaleIssueType);
                    }
                    SaleOrgUnitInfo saleOrgUnitInfo = null;
                    UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
                    if (BosUtil.isEmptyEntity((IObjectValue)userInfo)) {
                        WsChannelSaleIssueUtils.setMessage(channelSaleIssueBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"25_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    ChannelBaseInfo curChannelBaseInfo = UserChannelRelationFacadeFactory.getLocalInstance(ctx).getUserRelationChannel(userInfo.getId().toString());
                    boolean bl = isChannelUser = !BosUtil.isNotEmptyEntity((IObjectValue)curChannelBaseInfo);
                    if (!isChannelUser && (null == channelNumber || "".equals(channelNumber))) {
                        WsChannelSaleIssueUtils.setMessage(channelSaleIssueBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"26_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    ChannelBaseInfo channelBaseInfo = WSDataGetUtil.findChannelBase(ctx, channelNumber);
                    if (channelBaseInfo != null) {
                        bill.setChannel(channelBaseInfo);
                    } else if (isChannelUser) {
                        bill.setChannel(curChannelBaseInfo);
                    } else {
                        WsChannelSaleIssueUtils.setMessage(channelSaleIssueBillInfo, "2001", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"27_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    String orgUnit = channelSaleIssueBillInfo.getSaleOrgUnit();
                    if (!isChannelUser && (null == orgUnit || "".equals(orgUnit))) {
                        WsChannelSaleIssueUtils.setMessage(channelSaleIssueBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"28_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    saleOrgUnitInfo = WSDataGetUtil.findSaleOrgUnit(ctx, orgUnit);
                    if (saleOrgUnitInfo != null) {
                        bill.setSaleOrgUnit(saleOrgUnitInfo);
                    } else if (isChannelUser) {
                        saleOrgUnitInfo = WSDataGetUtil.getChannelSaleInfo(ctx, curChannelBaseInfo);
                        bill.setSaleOrgUnit(saleOrgUnitInfo);
                    } else {
                        WsChannelSaleIssueUtils.setMessage(channelSaleIssueBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"29_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    String salePerson = channelSaleIssueBillInfo.getSaleOrgUnit();
                    PersonInfo personInfo = WSDataGetUtil.findSalePerson(ctx, salePerson);
                    if (personInfo != null) {
                        bill.setSalePerson(personInfo);
                    } else if (isChannelUser && saleOrgUnitInfo != null && saleOrgUnitInfo.getLeader() != null) {
                        bill.setSalePerson(saleOrgUnitInfo.getLeader());
                    }
                    CompanyOrgUnitInfo companyOrgUnitInfo = WsChannelSaleIssueUtils.getCompanyOrgUnit(OrgType.Sale, OrgType.Company, saleOrgUnitInfo.getId(), ctx);
                    if (companyOrgUnitInfo != null) {
                        CurrencyInfo baseCurrencyInfo = WsImportChannelInWarehsBillUtils.getBaseCurrencyInfo(ctx, companyOrgUnitInfo);
                        bill.setCurrency(baseCurrencyInfo);
                    }
                    bill.setExchangeRate(new BigDecimal("1.00"));
                    Date date = channelSaleIssueBillInfo.getBizDate();
                    if (date == null) {
                        WsChannelSaleIssueUtils.setMessage(channelSaleIssueBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"47_WsChannelSaleIssueUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    bill.setBizDate(channelSaleIssueBillInfo.getBizDate());
                    String baseStatus = channelSaleIssueBillInfo.getBaseStatus();
                    if (null == baseStatus || "".equals(baseStatus)) {
                        bill.setBaseStatus(BillBaseStatusEnum.SUBMITED);
                    } else {
                        BillBaseStatusEnum baseStatusEnum = BillBaseStatusEnum.getEnum((int)Integer.parseInt(baseStatus));
                        if (baseStatusEnum != null) {
                            bill.setBaseStatus(BillBaseStatusEnum.ADD);
                        } else {
                            bill.setBaseStatus(BillBaseStatusEnum.SUBMITED);
                        }
                    }
                    bill.setRemark(channelSaleIssueBillInfo.getRemark());
                    if (entries != null && entries.size() > 0) {
                        ChannelSaleIssueBillEntryCollection entryCol = bill.getEntries();
                        int size = entries.size();
                        for (int j = 0; j < size; ++j) {
                            ChannelSaleIssueBillEntryInfo entryInfo = new ChannelSaleIssueBillEntryInfo();
                            WsChannelSaleIssueBillEntryInfo wsChannelSaleIssueBillEntryInfo = (WsChannelSaleIssueBillEntryInfo)entries.getObject(j);
                            entryInfo.setSeq(wsChannelSaleIssueBillEntryInfo.getEntrySeq());
                            if (wsChannelSaleIssueBillEntryInfo.getEntrySeq() != channelSaleIssueBillInfo.getEntrySeq()) {
                                WsChannelSaleIssueUtils.setMessage(channelSaleIssueBillInfo, "1023 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"32_WsChannelJXCUtils", (Locale)ctx.getLocale()), channelSaleIssueBillInfo.getNumber().toString()));
                                continue;
                            }
                            String materialNumber = wsChannelSaleIssueBillEntryInfo.getMaterialNumber();
                            if (materialNumber == null) {
                                WsChannelSaleIssueUtils.setMessage(channelSaleIssueBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"34_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                                continue;
                            }
                            MaterialInfo materialInfo = WSDataGetUtil.findMaterial(ctx, wsChannelSaleIssueBillEntryInfo.getMaterialNumber());
                            if (materialInfo == null) {
                                WsChannelSaleIssueUtils.setMessage(channelSaleIssueBillInfo, "2001 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"35_WsChannelJXCUtils", (Locale)ctx.getLocale()), materialNumber));
                                continue;
                            }
                            entryInfo.setMaterial(materialInfo);
                            double qty = wsChannelSaleIssueBillEntryInfo.getQty();
                            if (qty == 0.0) {
                                WsChannelSaleIssueUtils.setMessage(channelSaleIssueBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"48_WsChannelSaleIssueUtils", (Locale)ctx.getLocale()));
                                continue;
                            }
                            entryInfo.setQty(new BigDecimal(wsChannelSaleIssueBillEntryInfo.getQty()));
                            entryInfo.setPrice(wsChannelSaleIssueBillEntryInfo.getPrice());
                            entryInfo.setAmount(wsChannelSaleIssueBillEntryInfo.getAmount());
                            String unitNumber = wsChannelSaleIssueBillEntryInfo.getUnitNumber();
                            if (unitNumber == null) {
                                WsChannelSaleIssueUtils.setMessage(channelSaleIssueBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"49_WsChannelSaleIssueUtils", (Locale)ctx.getLocale()));
                                continue;
                            }
                            MeasureUnitInfo measureUnitInfo = WSDataGetUtil.findMeasureUnit(ctx, unitNumber);
                            if (measureUnitInfo == null) {
                                WsChannelSaleIssueUtils.setMessage(channelSaleIssueBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"37_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                                continue;
                            }
                            entryInfo.setUnit(measureUnitInfo);
                            entryInfo.setRemark(wsChannelSaleIssueBillEntryInfo.getRemark());
                            entryCol.add(entryInfo);
                        }
                    }
                    if ((rtnNumber = (String)channelSaleIssueBillInfo.get("ws_returnNumber")) != null || channelSaleIssueBillInfo.get("ws_SuccessID") != null) continue;
                    try {
                        ObjectUuidPK pk = new ObjectUuidPK(tempBillInfo.getId());
                        bill.setId(tempBillInfo.getId());
                        bill.setBaseStatus(tempBillInfo.getBaseStatus());
                        iChannelSaleIssueBill.update((IObjectPK)pk, bill);
                        channelSaleIssueBillInfo.put("ws_SuccessID", number);
                        WsChannelSaleIssueUtils.setMessage(channelSaleIssueBillInfo, "0000", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"41_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                    }
                    catch (Exception e) {
                        WsChannelSaleIssueUtils.dealException(ctx, e, channelSaleIssueBillInfo);
                    }
                    continue;
                }
                WsChannelSaleIssueUtils.setMessage(channelSaleIssueBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"42_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            WsChannelSaleIssueUtils.setMessage(channelSaleIssueBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"43_WsChannelJXCUtils", (Locale)ctx.getLocale()));
        }
        return billCols;
    }

    public static IObjectCollection delete_ChannelBill(Context ctx, IObjectCollection billCols) throws BOSException, EASBizException {
        IChannelSaleIssueBill iChannelSaleIssueBill = ChannelSaleIssueBillFactory.getLocalInstance(ctx);
        int count = billCols.size();
        for (int i = 0; i < count; ++i) {
            ChannelSaleIssueBillInfo bill = new ChannelSaleIssueBillInfo();
            WsChannelSaleIssueBillInfo channelSaleIssueBillInfo = (WsChannelSaleIssueBillInfo)billCols.getObject(i);
            String number = String.valueOf(channelSaleIssueBillInfo.getNumber());
            channelSaleIssueBillInfo.put("ws_number", number);
            String channelNumber = channelSaleIssueBillInfo.getChannelNumber();
            ChannelSaleIssueBillInfo tempBillInfo = WSDataGetUtil.findChannelSaleIssueBill(ctx, channelNumber, number);
            if (tempBillInfo != null) {
                int _baseStatus = tempBillInfo.getBaseStatus().getValue();
                if (_baseStatus == 2 || _baseStatus == 1) {
                    try {
                        ObjectUuidPK pk = new ObjectUuidPK(tempBillInfo.getId());
                        bill.setId(tempBillInfo.getId());
                        bill.setBaseStatus(tempBillInfo.getBaseStatus());
                        iChannelSaleIssueBill.delete((IObjectPK)pk);
                        channelSaleIssueBillInfo.put("ws_SuccessID", number);
                        WsChannelSaleIssueUtils.setMessage(channelSaleIssueBillInfo, "0000", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"44_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                    }
                    catch (Exception e) {
                        WsChannelSaleIssueUtils.dealException(ctx, e, channelSaleIssueBillInfo);
                    }
                    continue;
                }
                WsChannelSaleIssueUtils.setMessage(channelSaleIssueBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"45_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            WsChannelSaleIssueUtils.setMessage(channelSaleIssueBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"43_WsChannelJXCUtils", (Locale)ctx.getLocale()));
        }
        return billCols;
    }

    private static CompanyOrgUnitInfo getCompanyOrgUnit(OrgType srcOrgType, OrgType destOrgType, BOSUuid orgPK, Context ctx) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        int iSrcOrg = srcOrgType.getValue();
        int iDestOrg = destOrgType.getValue();
        OrgUnitCollection collection = iOrgRelation.getToUnit(orgPK.toString(), iSrcOrg, iDestOrg);
        if (collection.size() > 0 && collection.get(0) instanceof CompanyOrgUnitInfo) {
            return (CompanyOrgUnitInfo)collection.get(0);
        }
        return null;
    }

    public static final CurrencyInfo getBaseCurrencyInfo(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo) throws EASBizException, BOSException {
        return CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getBaseCurrency().getId()));
    }

    private static void setMessage(AbstractObjectValue billInfo, String returnNumber, String returnValue) {
        logger.info((Object)(returnNumber + ":" + returnValue));
        billInfo.put("ws_returnNumber", (Object)returnNumber);
        billInfo.put("ws_returnValue", (Object)returnValue);
    }

    private static void dealException(Context ctx, Exception e, AbstractObjectValue billInfo) throws BOSException {
        if (e instanceof PermissionException) {
            WsChannelSaleIssueUtils.setMessage(billInfo, "6" + ((PermissionException)e).getSubCode(), e.getMessage());
        }
        if (e instanceof PermissionServiceException) {
            WsChannelSaleIssueUtils.setMessage(billInfo, "7***", e.getMessage());
        } else if (e instanceof EASBizException) {
            WsChannelSaleIssueUtils.setMessage(billInfo, "5" + ((EASBizException)((Object)e)).getSubCode(), e.getMessage());
        } else {
            WsChannelSaleIssueUtils.setMessage(billInfo, "9001", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"46_WsChannelJXCUtils", (Locale)ctx.getLocale()), e.getMessage().toString()));
        }
    }
}

