/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.webservice.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.util.BosUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.sd.channel.ChannelStockBillEntryCollection;
import com.kingdee.eas.scm.sd.channel.ChannelStockBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.ChannelStockBillFactory;
import com.kingdee.eas.scm.sd.channel.ChannelStockBillInfo;
import com.kingdee.eas.scm.sd.channel.IChannelStockBill;
import com.kingdee.eas.scm.sd.channel.UserChannelRelationFacadeFactory;
import com.kingdee.eas.scm.sd.channel.webservice.WsChannelStockBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.webservice.WsChannelStockBillInfo;
import com.kingdee.eas.scm.sd.channel.webservice.app.utils.WSDataGetUtil;
import com.kingdee.eas.scm.sd.channel.webservice.app.utils.WsImportChannelInWarehsBillUtils;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class WsChannelStockUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.channel.webservice.app.utils.WsChannelStockUtils");

    public static IObjectCollection import_ChannelStockBill(Context ctx, IObjectCollection billCols, IObjectCollection entries) throws BOSException, EASBizException {
        IChannelStockBill iChannelStockBill = ChannelStockBillFactory.getLocalInstance(ctx);
        HashMap<String, String> numberMap = new HashMap<String, String>();
        int count = billCols.size();
        for (int i = 0; i < count; ++i) {
            String rtnNumber;
            boolean isChannelUser;
            ChannelStockBillInfo bill = new ChannelStockBillInfo();
            WsChannelStockBillInfo channelStockBillInfo = (WsChannelStockBillInfo)billCols.getObject(i);
            String number = String.valueOf(channelStockBillInfo.getNumber());
            channelStockBillInfo.put("ws_number", number);
            if (number == null) {
                WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"23_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            if (numberMap.containsKey(number)) {
                WsChannelStockUtils.setMessage(channelStockBillInfo, "1001 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"24_WsChannelJXCUtils", (Locale)ctx.getLocale()), number));
                continue;
            }
            numberMap.put(number, number);
            bill.setNumber(String.valueOf(channelStockBillInfo.getNumber()));
            String channelNumber = channelStockBillInfo.getChannelNumber();
            SaleOrgUnitInfo saleOrgUnitInfo = null;
            UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
            if (BosUtil.isEmptyEntity((IObjectValue)userInfo)) {
                WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"25_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            ChannelBaseInfo curChannelBaseInfo = UserChannelRelationFacadeFactory.getLocalInstance(ctx).getUserRelationChannel(userInfo.getId().toString());
            boolean bl = isChannelUser = !BosUtil.isNotEmptyEntity((IObjectValue)curChannelBaseInfo);
            if (!isChannelUser && (null == channelNumber || "".equals(channelNumber))) {
                WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"26_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            ChannelBaseInfo channelBaseInfo = WSDataGetUtil.findChannelBase(ctx, channelNumber);
            if (channelBaseInfo != null) {
                bill.setChannel(channelBaseInfo);
            } else if (isChannelUser) {
                bill.setChannel(curChannelBaseInfo);
            } else {
                WsChannelStockUtils.setMessage(channelStockBillInfo, "2001", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"27_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            String orgUnit = channelStockBillInfo.getSaleOrgUnit();
            if (!isChannelUser && (null == orgUnit || "".equals(orgUnit))) {
                WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"28_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            saleOrgUnitInfo = WSDataGetUtil.findSaleOrgUnit(ctx, orgUnit);
            if (saleOrgUnitInfo != null) {
                bill.setSaleOrgUnit(saleOrgUnitInfo);
            } else if (isChannelUser) {
                saleOrgUnitInfo = WSDataGetUtil.getChannelSaleInfo(ctx, curChannelBaseInfo);
                bill.setSaleOrgUnit(saleOrgUnitInfo);
            } else {
                WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"29_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            String salePerson = channelStockBillInfo.getSalePerson();
            PersonInfo personInfo = WSDataGetUtil.findSalePerson(ctx, salePerson);
            if (personInfo != null) {
                bill.setSalePerson(personInfo);
            } else if (isChannelUser && saleOrgUnitInfo != null && saleOrgUnitInfo.getLeader() != null) {
                bill.setSalePerson(saleOrgUnitInfo.getLeader());
            }
            CompanyOrgUnitInfo companyOrgUnitInfo = WsChannelStockUtils.getCompanyOrgUnit(OrgType.Sale, OrgType.Company, saleOrgUnitInfo.getId(), ctx);
            if (companyOrgUnitInfo != null) {
                CurrencyInfo baseCurrencyInfo = WsImportChannelInWarehsBillUtils.getBaseCurrencyInfo(ctx, companyOrgUnitInfo);
                bill.setCurrency(baseCurrencyInfo);
            }
            bill.setExchangeRate(new BigDecimal("1.00"));
            Date date = channelStockBillInfo.getBizDate();
            if (date == null) {
                WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"50_WsChannelStockUtils", (Locale)ctx.getLocale()));
                continue;
            }
            bill.setBizDate(channelStockBillInfo.getBizDate());
            String baseStatus = channelStockBillInfo.getBaseStatus();
            if (null == baseStatus || "".equals(baseStatus)) {
                bill.setBaseStatus(BillBaseStatusEnum.SUBMITED);
            } else {
                BillBaseStatusEnum baseStatusEnum = BillBaseStatusEnum.getEnum((int)Integer.parseInt(baseStatus));
                if (baseStatusEnum != null) {
                    bill.setBaseStatus(BillBaseStatusEnum.ADD);
                } else {
                    bill.setBaseStatus(BillBaseStatusEnum.SUBMITED);
                }
            }
            bill.setRemark(channelStockBillInfo.getRemark());
            if (entries != null && entries.size() > 0) {
                ChannelStockBillEntryCollection entryCol = bill.getEntries();
                int size = entries.size();
                for (int j = 0; j < size; ++j) {
                    ChannelStockBillEntryInfo entryInfo = new ChannelStockBillEntryInfo();
                    WsChannelStockBillEntryInfo wsChannelStockBillEntryInfo = (WsChannelStockBillEntryInfo)entries.getObject(j);
                    if (wsChannelStockBillEntryInfo.getEntryNumber() != channelStockBillInfo.getEntrySeq()) {
                        WsChannelStockUtils.setMessage(channelStockBillInfo, "1023 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"32_WsChannelJXCUtils", (Locale)ctx.getLocale()), channelStockBillInfo.getNumber().toString()));
                        continue;
                    }
                    entryInfo.setSeq(wsChannelStockBillEntryInfo.getEntryNumber());
                    String materialNumber = wsChannelStockBillEntryInfo.getMaterialNumber();
                    if (materialNumber == null) {
                        WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"34_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    MaterialInfo materialInfo = WSDataGetUtil.findMaterial(ctx, wsChannelStockBillEntryInfo.getMaterialNumber());
                    if (materialInfo == null) {
                        WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"35_WsChannelJXCUtils", (Locale)ctx.getLocale()), materialNumber));
                        continue;
                    }
                    entryInfo.setMaterial(materialInfo);
                    double qty = wsChannelStockBillEntryInfo.getQty();
                    if (qty == 0.0) {
                        WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"51_WsChannelStockUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    entryInfo.setQty(new BigDecimal(wsChannelStockBillEntryInfo.getQty()));
                    entryInfo.setPrice(wsChannelStockBillEntryInfo.getPrice());
                    entryInfo.setAmount(wsChannelStockBillEntryInfo.getAmount());
                    String unitNumber = wsChannelStockBillEntryInfo.getUnitNumber();
                    if (unitNumber == null) {
                        WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"36_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    MeasureUnitInfo measureUnitInfo = WSDataGetUtil.findMeasureUnit(ctx, unitNumber);
                    if (measureUnitInfo == null) {
                        WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"37_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    entryInfo.setUnit(measureUnitInfo);
                    entryInfo.setRemark(wsChannelStockBillEntryInfo.getRemark());
                    entryCol.add(entryInfo);
                }
            } else if (bill.getEntries() == null || bill.getEntries().size() == 0) {
                WsChannelStockUtils.setMessage(channelStockBillInfo, "1023 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"32_WsChannelJXCUtils", (Locale)ctx.getLocale()), channelStockBillInfo.getNumber().toString()));
                continue;
            }
            if ((rtnNumber = (String)channelStockBillInfo.get("ws_returnNumber")) != null || channelStockBillInfo.get("ws_SuccessID") != null) continue;
            ChannelStockBillInfo tempBillInfo = WSDataGetUtil.findChannelStockBill(ctx, channelNumber, number);
            if (tempBillInfo != null) {
                int _baseStatus = tempBillInfo.getBaseStatus().getValue();
                if (_baseStatus == 2 || _baseStatus == 1) {
                    ObjectUuidPK pk = new ObjectUuidPK(tempBillInfo.getId());
                    bill.setId(tempBillInfo.getId());
                    bill.setBaseStatus(tempBillInfo.getBaseStatus());
                    iChannelStockBill.update((IObjectPK)pk, bill);
                    channelStockBillInfo.put("ws_SuccessID", number);
                    WsChannelStockUtils.setMessage(channelStockBillInfo, "0000", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"38_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                    continue;
                }
                WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"39_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            try {
                channelStockBillInfo.put("ws_SuccessID", number);
                WsChannelStockUtils.setMessage(channelStockBillInfo, "0000", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"38_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            catch (Exception e) {
                WsChannelStockUtils.dealException(ctx, e, channelStockBillInfo);
            }
        }
        return billCols;
    }

    public static IObjectCollection update_ChannelBill(Context ctx, IObjectCollection billCols, IObjectCollection entries) throws BOSException, EASBizException {
        IChannelStockBill iChannelStockBill = ChannelStockBillFactory.getLocalInstance(ctx);
        HashMap<String, String> numberMap = new HashMap<String, String>();
        int count = billCols.size();
        for (int i = 0; i < count; ++i) {
            ChannelStockBillInfo bill = new ChannelStockBillInfo();
            WsChannelStockBillInfo channelStockBillInfo = (WsChannelStockBillInfo)billCols.getObject(i);
            String number = channelStockBillInfo.getNumber();
            channelStockBillInfo.put("ws_number", number);
            String channelNumber = channelStockBillInfo.getChannelNumber();
            ChannelStockBillInfo tempBillInfo = WSDataGetUtil.findChannelStockBill(ctx, channelNumber, number);
            if (tempBillInfo != null) {
                int _baseStatus = tempBillInfo.getBaseStatus().getValue();
                if (_baseStatus == 2 || _baseStatus == 1) {
                    String rtnNumber;
                    boolean isChannelUser;
                    if (number == null) {
                        WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"23_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (numberMap.containsKey(number)) {
                        WsChannelStockUtils.setMessage(channelStockBillInfo, "1001 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"40_WsChannelJXCUtils", (Locale)ctx.getLocale()), number));
                        continue;
                    }
                    numberMap.put(number, number);
                    bill.setNumber(number);
                    SaleOrgUnitInfo saleOrgUnitInfo = null;
                    UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
                    if (BosUtil.isEmptyEntity((IObjectValue)userInfo)) {
                        WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"25_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    ChannelBaseInfo curChannelBaseInfo = UserChannelRelationFacadeFactory.getLocalInstance(ctx).getUserRelationChannel(userInfo.getId().toString());
                    boolean bl = isChannelUser = !BosUtil.isNotEmptyEntity((IObjectValue)curChannelBaseInfo);
                    if (!isChannelUser && (null == channelNumber || "".equals(channelNumber))) {
                        WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"26_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    ChannelBaseInfo channelBaseInfo = WSDataGetUtil.findChannelBase(ctx, channelNumber);
                    if (channelBaseInfo != null) {
                        bill.setChannel(channelBaseInfo);
                    } else if (isChannelUser) {
                        bill.setChannel(curChannelBaseInfo);
                    } else {
                        WsChannelStockUtils.setMessage(channelStockBillInfo, "2001", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"27_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    String orgUnit = channelStockBillInfo.getSaleOrgUnit();
                    if (!isChannelUser && (null == orgUnit || "".equals(orgUnit))) {
                        WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"28_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    saleOrgUnitInfo = WSDataGetUtil.findSaleOrgUnit(ctx, orgUnit);
                    if (saleOrgUnitInfo != null) {
                        bill.setSaleOrgUnit(saleOrgUnitInfo);
                    } else if (isChannelUser) {
                        saleOrgUnitInfo = WSDataGetUtil.getChannelSaleInfo(ctx, curChannelBaseInfo);
                        bill.setSaleOrgUnit(saleOrgUnitInfo);
                    } else {
                        WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"29_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    String salePerson = channelStockBillInfo.getSalePerson();
                    PersonInfo personInfo = WSDataGetUtil.findSalePerson(ctx, salePerson);
                    if (personInfo != null) {
                        bill.setSalePerson(personInfo);
                    } else if (isChannelUser && saleOrgUnitInfo != null && saleOrgUnitInfo.getLeader() != null) {
                        bill.setSalePerson(saleOrgUnitInfo.getLeader());
                    }
                    CompanyOrgUnitInfo companyOrgUnitInfo = WsChannelStockUtils.getCompanyOrgUnit(OrgType.Sale, OrgType.Company, saleOrgUnitInfo.getId(), ctx);
                    if (companyOrgUnitInfo != null) {
                        CurrencyInfo baseCurrencyInfo = WsImportChannelInWarehsBillUtils.getBaseCurrencyInfo(ctx, companyOrgUnitInfo);
                        bill.setCurrency(baseCurrencyInfo);
                    }
                    bill.setExchangeRate(new BigDecimal("1.00"));
                    Date date = channelStockBillInfo.getBizDate();
                    if (date == null) {
                        WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"50_WsChannelStockUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    bill.setBizDate(channelStockBillInfo.getBizDate());
                    String baseStatus = channelStockBillInfo.getBaseStatus();
                    if (null == baseStatus || "".equals(baseStatus)) {
                        bill.setBaseStatus(BillBaseStatusEnum.SUBMITED);
                    } else {
                        BillBaseStatusEnum baseStatusEnum = BillBaseStatusEnum.getEnum((int)Integer.parseInt(baseStatus));
                        if (baseStatusEnum != null) {
                            bill.setBaseStatus(BillBaseStatusEnum.ADD);
                        } else {
                            bill.setBaseStatus(BillBaseStatusEnum.SUBMITED);
                        }
                    }
                    bill.setRemark(channelStockBillInfo.getRemark());
                    if (entries != null && entries.size() > 0) {
                        ChannelStockBillEntryCollection entryCol = bill.getEntries();
                        int size = entries.size();
                        for (int j = 0; j < size; ++j) {
                            ChannelStockBillEntryInfo entryInfo = new ChannelStockBillEntryInfo();
                            WsChannelStockBillEntryInfo wsChannelStockBillEntryInfo = (WsChannelStockBillEntryInfo)entries.getObject(j);
                            entryInfo.setSeq(wsChannelStockBillEntryInfo.getEntryNumber());
                            if (wsChannelStockBillEntryInfo.getEntryNumber() != channelStockBillInfo.getEntrySeq()) {
                                WsChannelStockUtils.setMessage(channelStockBillInfo, "1023 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"32_WsChannelJXCUtils", (Locale)ctx.getLocale()), channelStockBillInfo.getNumber().toString()));
                                continue;
                            }
                            String materialNumber = wsChannelStockBillEntryInfo.getMaterialNumber();
                            if (materialNumber == null) {
                                WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"34_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                                continue;
                            }
                            MaterialInfo materialInfo = WSDataGetUtil.findMaterial(ctx, wsChannelStockBillEntryInfo.getMaterialNumber());
                            if (materialInfo == null) {
                                WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"35_WsChannelJXCUtils", (Locale)ctx.getLocale()), materialNumber));
                                continue;
                            }
                            entryInfo.setMaterial(materialInfo);
                            double qty = wsChannelStockBillEntryInfo.getQty();
                            if (qty == 0.0) {
                                WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"51_WsChannelStockUtils", (Locale)ctx.getLocale()));
                                continue;
                            }
                            entryInfo.setQty(new BigDecimal(wsChannelStockBillEntryInfo.getQty()));
                            entryInfo.setPrice(wsChannelStockBillEntryInfo.getPrice());
                            entryInfo.setAmount(wsChannelStockBillEntryInfo.getAmount());
                            String unitNumber = wsChannelStockBillEntryInfo.getUnitNumber();
                            if (unitNumber == null) {
                                WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"36_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                                continue;
                            }
                            MeasureUnitInfo measureUnitInfo = WSDataGetUtil.findMeasureUnit(ctx, unitNumber);
                            if (measureUnitInfo == null) {
                                WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"37_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                                continue;
                            }
                            entryInfo.setUnit(measureUnitInfo);
                            entryInfo.setRemark(wsChannelStockBillEntryInfo.getRemark());
                            entryCol.add(entryInfo);
                        }
                    }
                    if ((rtnNumber = (String)channelStockBillInfo.get("ws_returnNumber")) != null || channelStockBillInfo.get("ws_SuccessID") != null) continue;
                    try {
                        ObjectUuidPK pk = new ObjectUuidPK(tempBillInfo.getId());
                        bill.setId(tempBillInfo.getId());
                        bill.setBaseStatus(tempBillInfo.getBaseStatus());
                        iChannelStockBill.update((IObjectPK)pk, bill);
                        channelStockBillInfo.put("ws_SuccessID", number);
                        WsChannelStockUtils.setMessage(channelStockBillInfo, "0000", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"41_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                    }
                    catch (Exception e) {
                        WsChannelStockUtils.dealException(ctx, e, channelStockBillInfo);
                    }
                    continue;
                }
                WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"42_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"43_WsChannelJXCUtils", (Locale)ctx.getLocale()));
        }
        return billCols;
    }

    public static IObjectCollection delete_ChannelBill(Context ctx, IObjectCollection billCols) throws BOSException, EASBizException {
        IChannelStockBill iChannelStockBill = ChannelStockBillFactory.getLocalInstance(ctx);
        int count = billCols.size();
        for (int i = 0; i < count; ++i) {
            ChannelStockBillInfo bill = new ChannelStockBillInfo();
            WsChannelStockBillInfo channelStockBillInfo = (WsChannelStockBillInfo)billCols.getObject(i);
            String number = String.valueOf(channelStockBillInfo.getNumber());
            channelStockBillInfo.put("ws_number", number);
            String channelNumber = channelStockBillInfo.getChannelNumber();
            ChannelStockBillInfo tempBillInfo = WSDataGetUtil.findChannelStockBill(ctx, channelNumber, number);
            if (tempBillInfo != null) {
                int _baseStatus = tempBillInfo.getBaseStatus().getValue();
                if (_baseStatus == 2 || _baseStatus == 1) {
                    try {
                        ObjectUuidPK pk = new ObjectUuidPK(tempBillInfo.getId());
                        bill.setId(tempBillInfo.getId());
                        bill.setBaseStatus(tempBillInfo.getBaseStatus());
                        iChannelStockBill.delete((IObjectPK)pk);
                        channelStockBillInfo.put("ws_SuccessID", number);
                        WsChannelStockUtils.setMessage(channelStockBillInfo, "0000", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"44_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                    }
                    catch (Exception e) {
                        WsChannelStockUtils.dealException(ctx, e, channelStockBillInfo);
                    }
                    continue;
                }
                WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"45_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            WsChannelStockUtils.setMessage(channelStockBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"43_WsChannelJXCUtils", (Locale)ctx.getLocale()));
        }
        return billCols;
    }

    private static CompanyOrgUnitInfo getCompanyOrgUnit(OrgType srcOrgType, OrgType destOrgType, BOSUuid orgPK, Context ctx) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        int iSrcOrg = srcOrgType.getValue();
        int iDestOrg = destOrgType.getValue();
        OrgUnitCollection collection = iOrgRelation.getToUnit(orgPK.toString(), iSrcOrg, iDestOrg);
        if (collection.size() > 0 && collection.get(0) instanceof CompanyOrgUnitInfo) {
            return (CompanyOrgUnitInfo)collection.get(0);
        }
        return null;
    }

    public static final CurrencyInfo getBaseCurrencyInfo(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo) throws EASBizException, BOSException {
        return CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getBaseCurrency().getId()));
    }

    private static void setMessage(AbstractObjectValue billInfo, String returnNumber, String returnValue) {
        logger.info((Object)(returnNumber + ":" + returnValue));
        billInfo.put("ws_returnNumber", (Object)returnNumber);
        billInfo.put("ws_returnValue", (Object)returnValue);
    }

    private static void dealException(Context ctx, Exception e, AbstractObjectValue billInfo) throws BOSException {
        if (e instanceof PermissionException) {
            WsChannelStockUtils.setMessage(billInfo, "6" + ((PermissionException)e).getSubCode(), e.getMessage());
        }
        if (e instanceof PermissionServiceException) {
            WsChannelStockUtils.setMessage(billInfo, "7***", e.getMessage());
        } else if (e instanceof EASBizException) {
            WsChannelStockUtils.setMessage(billInfo, "5" + ((EASBizException)((Object)e)).getSubCode(), e.getMessage());
        } else {
            WsChannelStockUtils.setMessage(billInfo, "9001", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"46_WsChannelJXCUtils", (Locale)ctx.getLocale()), e.getMessage().toString()));
        }
    }
}

