/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sd.channel.webservice.app.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionServiceException;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.sd.channel.ChannelBaseInfo;
import com.kingdee.eas.basedata.scm.sd.channel.util.BosUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillEntryCollection;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillFactory;
import com.kingdee.eas.scm.sd.channel.ChannelInWarehsBillInfo;
import com.kingdee.eas.scm.sd.channel.ChannelInwarehsTypeEnum;
import com.kingdee.eas.scm.sd.channel.IChannelInWarehsBill;
import com.kingdee.eas.scm.sd.channel.UserChannelRelationFacadeFactory;
import com.kingdee.eas.scm.sd.channel.webservice.WsChannelInWarehsBillEntryInfo;
import com.kingdee.eas.scm.sd.channel.webservice.WsChannelInWarehsBillInfo;
import com.kingdee.eas.scm.sd.channel.webservice.app.utils.WSDataGetUtil;
import com.kingdee.eas.util.ResourceBase;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.log4j.Logger;

public class WsImportChannelInWarehsBillUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sd.channel.webservice.app.utils.WsImportChannelInWarehsBillUtils");

    public static IObjectCollection import01_ChannelBill(Context ctx, IObjectCollection billCols, IObjectCollection entries) throws BOSException, EASBizException {
        IChannelInWarehsBill iChannelInWarehsBill = ChannelInWarehsBillFactory.getLocalInstance(ctx);
        HashMap<String, String> numberMap = new HashMap<String, String>();
        int count = billCols.size();
        for (int i = 0; i < count; ++i) {
            String rtnNumber;
            CompanyOrgUnitInfo companyOrgUnitInfo;
            ChannelBaseInfo channelBaseInfo;
            boolean isChannelUser;
            ChannelInWarehsBillInfo bill = new ChannelInWarehsBillInfo();
            WsChannelInWarehsBillInfo channelInWarehsBillInfo = (WsChannelInWarehsBillInfo)billCols.getObject(i);
            String number = channelInWarehsBillInfo.getNumber();
            channelInWarehsBillInfo.put("ws_number", number);
            if (number == null) {
                WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"23_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            if (numberMap.containsKey(number)) {
                WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "1001 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"24_WsChannelJXCUtils", (Locale)ctx.getLocale()), number));
                continue;
            }
            numberMap.put(number, number);
            bill.setNumber(number);
            String channelNumber = channelInWarehsBillInfo.getChannelNumber();
            ChannelInwarehsTypeEnum inWarehsTypeEnum = ChannelInwarehsTypeEnum.getEnum(channelInWarehsBillInfo.getInWarehsType());
            if (inWarehsTypeEnum == null) {
                inWarehsTypeEnum = ChannelInwarehsTypeEnum.NATURAL;
            }
            bill.setInWarehsType(inWarehsTypeEnum);
            SaleOrgUnitInfo saleOrgUnitInfo = null;
            UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
            if (BosUtil.isEmptyEntity((IObjectValue)userInfo)) {
                WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"25_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            ChannelBaseInfo curChannelBaseInfo = UserChannelRelationFacadeFactory.getLocalInstance(ctx).getUserRelationChannel(userInfo.getId().toString());
            boolean bl = isChannelUser = !BosUtil.isNotEmptyEntity((IObjectValue)curChannelBaseInfo);
            if (!isChannelUser && (null == channelNumber || "".equals(channelNumber))) {
                WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"26_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            if (isChannelUser && (null == channelNumber || "".equals(channelNumber))) {
                channelNumber = curChannelBaseInfo.getNumber();
            }
            if ((channelBaseInfo = WSDataGetUtil.findChannelBase(ctx, channelNumber)) != null) {
                bill.setChannel(channelBaseInfo);
            } else if (isChannelUser) {
                bill.setChannel(curChannelBaseInfo);
            } else {
                WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"27_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            String orgUnit = channelInWarehsBillInfo.getSaleOrgUnit();
            if (!isChannelUser && (null == orgUnit || "".equals(orgUnit))) {
                WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"28_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            saleOrgUnitInfo = WSDataGetUtil.findSaleOrgUnit(ctx, channelInWarehsBillInfo.getSaleOrgUnit());
            if (saleOrgUnitInfo != null) {
                bill.setSaleOrgUnit(saleOrgUnitInfo);
            } else if (isChannelUser) {
                saleOrgUnitInfo = WSDataGetUtil.getChannelSaleInfo(ctx, curChannelBaseInfo);
                if (saleOrgUnitInfo == null) {
                    WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"29_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                    continue;
                }
                bill.setSaleOrgUnit(saleOrgUnitInfo);
            } else {
                WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"29_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            String salePerson = channelInWarehsBillInfo.getSalePerson();
            PersonInfo personInfo = WSDataGetUtil.findSalePerson(ctx, salePerson);
            if (personInfo != null) {
                bill.setSalePerson(personInfo);
            } else if (isChannelUser && saleOrgUnitInfo != null && saleOrgUnitInfo.getLeader() != null) {
                bill.setSalePerson(saleOrgUnitInfo.getLeader());
            }
            if (saleOrgUnitInfo != null && (companyOrgUnitInfo = WsImportChannelInWarehsBillUtils.getCompanyOrgUnit(OrgType.Sale, OrgType.Company, saleOrgUnitInfo.getId(), ctx)) != null) {
                CurrencyInfo baseCurrencyInfo = WsImportChannelInWarehsBillUtils.getBaseCurrencyInfo(ctx, companyOrgUnitInfo);
                bill.setCurrency(baseCurrencyInfo);
            }
            bill.setExchangeRate(new BigDecimal("1.00"));
            Date date = channelInWarehsBillInfo.getBizDate();
            if (date == null) {
                WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"47_WsChannelSaleIssueUtils", (Locale)ctx.getLocale()));
                continue;
            }
            bill.setBizDate(channelInWarehsBillInfo.getBizDate());
            String baseStatus = channelInWarehsBillInfo.getBaseStatus();
            if (null == baseStatus || "".equals(baseStatus)) {
                bill.setBaseStatus(BillBaseStatusEnum.SUBMITED);
            } else {
                BillBaseStatusEnum baseStatusEnum = BillBaseStatusEnum.getEnum((int)Integer.parseInt(baseStatus));
                if (baseStatusEnum != null) {
                    bill.setBaseStatus(BillBaseStatusEnum.ADD);
                } else {
                    bill.setBaseStatus(BillBaseStatusEnum.SUBMITED);
                }
            }
            bill.setRemark(channelInWarehsBillInfo.getRemark());
            if (entries != null && entries.size() > 0) {
                ChannelInWarehsBillEntryCollection entryCol = bill.getEntries();
                int size = entries.size();
                for (int j = 0; j < size; ++j) {
                    ChannelInWarehsBillEntryInfo entryInfo = new ChannelInWarehsBillEntryInfo();
                    WsChannelInWarehsBillEntryInfo wsChannelInWarehsBillEntryInfo = (WsChannelInWarehsBillEntryInfo)entries.getObject(j);
                    if (wsChannelInWarehsBillEntryInfo.getEntryNumber() != channelInWarehsBillInfo.getEntrySeq()) {
                        WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "1023 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"32_WsChannelJXCUtils", (Locale)ctx.getLocale()), channelInWarehsBillInfo.getNumber().toString()));
                        continue;
                    }
                    entryInfo.setSeq(wsChannelInWarehsBillEntryInfo.getEntryNumber());
                    String materialNumber = wsChannelInWarehsBillEntryInfo.getMaterialNumber();
                    if (materialNumber == null) {
                        WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"34_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    MaterialInfo materialInfo = WSDataGetUtil.findMaterial(ctx, wsChannelInWarehsBillEntryInfo.getMaterialNumber());
                    if (materialInfo == null) {
                        WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"35_WsChannelJXCUtils", (Locale)ctx.getLocale()), materialNumber));
                        continue;
                    }
                    entryInfo.setMaterial(materialInfo);
                    double qty = wsChannelInWarehsBillEntryInfo.getQty();
                    if (qty == 0.0) {
                        WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"52_WsImportChannelInWarehsBillUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    entryInfo.setQty(new BigDecimal(wsChannelInWarehsBillEntryInfo.getQty()));
                    entryInfo.setPrice(wsChannelInWarehsBillEntryInfo.getPrice());
                    entryInfo.setAmount(wsChannelInWarehsBillEntryInfo.getAmount());
                    String unitNumber = wsChannelInWarehsBillEntryInfo.getUnitNumber();
                    if (unitNumber == null) {
                        WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"36_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    MeasureUnitInfo measureUnitInfo = WSDataGetUtil.findMeasureUnit(ctx, unitNumber);
                    if (measureUnitInfo == null) {
                        WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"37_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    entryInfo.setUnit(measureUnitInfo);
                    entryInfo.setBaseUnit(measureUnitInfo);
                    entryInfo.setPricePrecision(measureUnitInfo.getQtyPrecision());
                    entryInfo.setBaseUnitPrecision(measureUnitInfo.getQtyPrecision());
                    entryInfo.setRemark(wsChannelInWarehsBillEntryInfo.getRemark());
                    entryCol.add(entryInfo);
                }
            } else if (bill.getEntries() == null || bill.getEntries().size() == 0) {
                WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "1023 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"32_WsChannelJXCUtils", (Locale)ctx.getLocale()), channelInWarehsBillInfo.getNumber().toString()));
                continue;
            }
            if ((rtnNumber = (String)channelInWarehsBillInfo.get("ws_returnNumber")) != null || channelInWarehsBillInfo.get("ws_SuccessID") != null) continue;
            ChannelInWarehsBillInfo tempBillInfo = WSDataGetUtil.findChannelInWarehsBill(ctx, channelNumber, number);
            if (tempBillInfo != null) {
                int _baseStatus = tempBillInfo.getBaseStatus().getValue();
                if (_baseStatus == 2 || _baseStatus == 1) {
                    ObjectUuidPK pk = new ObjectUuidPK(tempBillInfo.getId());
                    bill.setId(tempBillInfo.getId());
                    bill.setBaseStatus(tempBillInfo.getBaseStatus());
                    iChannelInWarehsBill.update((IObjectPK)pk, bill);
                    channelInWarehsBillInfo.put("ws_SuccessID", number);
                    WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "0000", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"38_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                    continue;
                }
                WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"39_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            try {
                channelInWarehsBillInfo.put("ws_SuccessID", number);
                WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "0000", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"38_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            catch (Exception e) {
                WsImportChannelInWarehsBillUtils.dealException(ctx, e, channelInWarehsBillInfo);
            }
        }
        return billCols;
    }

    public static IObjectCollection update_ChannelBill(Context ctx, IObjectCollection billCols, IObjectCollection entries) throws BOSException, EASBizException {
        IChannelInWarehsBill iChannelInWarehsBill = ChannelInWarehsBillFactory.getLocalInstance(ctx);
        HashMap<String, String> numberMap = new HashMap<String, String>();
        int count = billCols.size();
        for (int i = 0; i < count; ++i) {
            ChannelInWarehsBillInfo bill = new ChannelInWarehsBillInfo();
            WsChannelInWarehsBillInfo channelInWarehsBillInfo = (WsChannelInWarehsBillInfo)billCols.getObject(i);
            String number = channelInWarehsBillInfo.getNumber();
            channelInWarehsBillInfo.put("ws_number", number);
            String channelNumber = channelInWarehsBillInfo.getChannelNumber();
            ChannelInWarehsBillInfo tempBillInfo = WSDataGetUtil.findChannelInWarehsBill(ctx, channelNumber, number);
            if (tempBillInfo != null) {
                int _baseStatus = tempBillInfo.getBaseStatus().getValue();
                if (_baseStatus == 2 || _baseStatus == 1) {
                    String rtnNumber;
                    boolean isChannelUser;
                    if (number == null) {
                        WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"23_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    if (numberMap.containsKey(number)) {
                        WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "1001 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"40_WsChannelJXCUtils", (Locale)ctx.getLocale()), number));
                        continue;
                    }
                    numberMap.put(number, number);
                    bill.setNumber(number);
                    ChannelInwarehsTypeEnum inWarehsTypeEnum = ChannelInwarehsTypeEnum.getEnum(channelInWarehsBillInfo.getInWarehsType());
                    if (inWarehsTypeEnum == null) {
                        inWarehsTypeEnum = ChannelInwarehsTypeEnum.NATURAL;
                    }
                    bill.setInWarehsType(inWarehsTypeEnum);
                    SaleOrgUnitInfo saleOrgUnitInfo = null;
                    UserInfo userInfo = (UserInfo)ctx.get((Object)"UserInfo");
                    if (BosUtil.isEmptyEntity((IObjectValue)userInfo)) {
                        WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"25_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    ChannelBaseInfo curChannelBaseInfo = UserChannelRelationFacadeFactory.getLocalInstance(ctx).getUserRelationChannel(userInfo.getId().toString());
                    boolean bl = isChannelUser = !BosUtil.isNotEmptyEntity((IObjectValue)curChannelBaseInfo);
                    if (!isChannelUser && (null == channelNumber || "".equals(channelNumber))) {
                        WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"26_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    ChannelBaseInfo channelBaseInfo = WSDataGetUtil.findChannelBase(ctx, channelNumber);
                    if (channelBaseInfo != null) {
                        bill.setChannel(channelBaseInfo);
                    } else if (isChannelUser) {
                        bill.setChannel(curChannelBaseInfo);
                    } else {
                        WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"27_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    String orgUnit = channelInWarehsBillInfo.getSaleOrgUnit();
                    if (!isChannelUser && (null == orgUnit || "".equals(orgUnit))) {
                        WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"28_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    saleOrgUnitInfo = WSDataGetUtil.findSaleOrgUnit(ctx, channelInWarehsBillInfo.getSaleOrgUnit());
                    if (saleOrgUnitInfo != null) {
                        bill.setSaleOrgUnit(saleOrgUnitInfo);
                    } else if (isChannelUser) {
                        saleOrgUnitInfo = WSDataGetUtil.getChannelSaleInfo(ctx, curChannelBaseInfo);
                        bill.setSaleOrgUnit(saleOrgUnitInfo);
                    } else {
                        WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"29_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    String salePerson = channelInWarehsBillInfo.getSalePerson();
                    PersonInfo personInfo = WSDataGetUtil.findSalePerson(ctx, salePerson);
                    if (personInfo != null) {
                        bill.setSalePerson(personInfo);
                    } else if (saleOrgUnitInfo != null && saleOrgUnitInfo.getLeader() != null) {
                        bill.setSalePerson(saleOrgUnitInfo.getLeader());
                    }
                    CompanyOrgUnitInfo companyOrgUnitInfo = WsImportChannelInWarehsBillUtils.getCompanyOrgUnit(OrgType.Sale, OrgType.Company, saleOrgUnitInfo.getId(), ctx);
                    if (companyOrgUnitInfo != null) {
                        CurrencyInfo baseCurrencyInfo = WsImportChannelInWarehsBillUtils.getBaseCurrencyInfo(ctx, companyOrgUnitInfo);
                        bill.setCurrency(baseCurrencyInfo);
                    }
                    bill.setExchangeRate(new BigDecimal("1.00"));
                    Date date = channelInWarehsBillInfo.getBizDate();
                    if (date == null) {
                        WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"47_WsChannelSaleIssueUtils", (Locale)ctx.getLocale()));
                        continue;
                    }
                    bill.setBizDate(channelInWarehsBillInfo.getBizDate());
                    String baseStatus = channelInWarehsBillInfo.getBaseStatus();
                    if (null == baseStatus || "".equals(baseStatus)) {
                        bill.setBaseStatus(BillBaseStatusEnum.SUBMITED);
                    } else {
                        BillBaseStatusEnum baseStatusEnum = BillBaseStatusEnum.getEnum((int)Integer.parseInt(baseStatus));
                        if (baseStatusEnum != null) {
                            bill.setBaseStatus(BillBaseStatusEnum.ADD);
                        } else {
                            bill.setBaseStatus(BillBaseStatusEnum.SUBMITED);
                        }
                    }
                    bill.setRemark(channelInWarehsBillInfo.getRemark());
                    if (entries != null && entries.size() > 0) {
                        ChannelInWarehsBillEntryCollection entryCol = bill.getEntries();
                        int size = entries.size();
                        for (int j = 0; j < size; ++j) {
                            ChannelInWarehsBillEntryInfo entryInfo = new ChannelInWarehsBillEntryInfo();
                            WsChannelInWarehsBillEntryInfo wsChannelInWarehsBillEntryInfo = (WsChannelInWarehsBillEntryInfo)entries.getObject(j);
                            entryInfo.setSeq(wsChannelInWarehsBillEntryInfo.getEntryNumber());
                            if (wsChannelInWarehsBillEntryInfo.getEntryNumber() != channelInWarehsBillInfo.getEntrySeq()) {
                                WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "1023 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"32_WsChannelJXCUtils", (Locale)ctx.getLocale()), channelInWarehsBillInfo.getNumber().toString()));
                                continue;
                            }
                            String materialNumber = wsChannelInWarehsBillEntryInfo.getMaterialNumber();
                            if (materialNumber == null) {
                                WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"34_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                                continue;
                            }
                            MaterialInfo materialInfo = WSDataGetUtil.findMaterial(ctx, wsChannelInWarehsBillEntryInfo.getMaterialNumber());
                            if (materialInfo == null) {
                                WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"35_WsChannelJXCUtils", (Locale)ctx.getLocale()), materialNumber));
                                continue;
                            }
                            entryInfo.setMaterial(materialInfo);
                            double qty = wsChannelInWarehsBillEntryInfo.getQty();
                            if (qty == 0.0) {
                                WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"52_WsImportChannelInWarehsBillUtils", (Locale)ctx.getLocale()));
                                continue;
                            }
                            entryInfo.setQty(new BigDecimal(wsChannelInWarehsBillEntryInfo.getQty()));
                            entryInfo.setPrice(wsChannelInWarehsBillEntryInfo.getPrice());
                            entryInfo.setAmount(wsChannelInWarehsBillEntryInfo.getAmount());
                            String unitNumber = wsChannelInWarehsBillEntryInfo.getUnitNumber();
                            if (unitNumber == null) {
                                WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"36_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                                continue;
                            }
                            MeasureUnitInfo measureUnitInfo = WSDataGetUtil.findMeasureUnit(ctx, unitNumber);
                            if (measureUnitInfo == null) {
                                WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"37_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                                continue;
                            }
                            entryInfo.setUnit(measureUnitInfo);
                            entryInfo.setBaseUnit(measureUnitInfo);
                            entryInfo.setPricePrecision(measureUnitInfo.getQtyPrecision());
                            entryInfo.setBaseUnitPrecision(measureUnitInfo.getQtyPrecision());
                            entryInfo.setRemark(wsChannelInWarehsBillEntryInfo.getRemark());
                            entryCol.add(entryInfo);
                        }
                    } else if (bill.getEntries() == null || bill.getEntries().size() == 0) {
                        WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "1023 ", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"32_WsChannelJXCUtils", (Locale)ctx.getLocale()), channelInWarehsBillInfo.getNumber().toString()));
                        continue;
                    }
                    if ((rtnNumber = (String)channelInWarehsBillInfo.get("ws_returnNumber")) != null || channelInWarehsBillInfo.get("ws_SuccessID") != null) continue;
                    try {
                        ObjectUuidPK pk = new ObjectUuidPK(tempBillInfo.getId());
                        bill.setId(tempBillInfo.getId());
                        bill.setBaseStatus(tempBillInfo.getBaseStatus());
                        iChannelInWarehsBill.update((IObjectPK)pk, bill);
                        channelInWarehsBillInfo.put("ws_SuccessID", number);
                        WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "0000", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"41_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                    }
                    catch (Exception e) {
                        WsImportChannelInWarehsBillUtils.dealException(ctx, e, channelInWarehsBillInfo);
                    }
                    continue;
                }
                WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"42_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"43_WsChannelJXCUtils", (Locale)ctx.getLocale()));
        }
        return billCols;
    }

    public static IObjectCollection delete_ChannelBill(Context ctx, IObjectCollection billCols) throws BOSException, EASBizException {
        IChannelInWarehsBill iChannelInWarehsBill = ChannelInWarehsBillFactory.getLocalInstance(ctx);
        int count = billCols.size();
        for (int i = 0; i < count; ++i) {
            ChannelInWarehsBillInfo bill = new ChannelInWarehsBillInfo();
            WsChannelInWarehsBillInfo channelInWarehsBillInfo = (WsChannelInWarehsBillInfo)billCols.getObject(i);
            String number = String.valueOf(channelInWarehsBillInfo.getNumber());
            channelInWarehsBillInfo.put("ws_number", number);
            String channelNumber = channelInWarehsBillInfo.getChannelNumber();
            ChannelInWarehsBillInfo tempBillInfo = WSDataGetUtil.findChannelInWarehsBill(ctx, channelNumber, number);
            if (tempBillInfo != null) {
                int _baseStatus = tempBillInfo.getBaseStatus().getValue();
                if (_baseStatus == 2 || _baseStatus == 1) {
                    try {
                        ObjectUuidPK pk = new ObjectUuidPK(tempBillInfo.getId());
                        bill.setId(tempBillInfo.getId());
                        bill.setBaseStatus(tempBillInfo.getBaseStatus());
                        iChannelInWarehsBill.delete((IObjectPK)pk);
                        channelInWarehsBillInfo.put("ws_SuccessID", number);
                        WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "0000", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"44_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                    }
                    catch (Exception e) {
                        WsImportChannelInWarehsBillUtils.dealException(ctx, e, channelInWarehsBillInfo);
                    }
                    continue;
                }
                WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"45_WsChannelJXCUtils", (Locale)ctx.getLocale()));
                continue;
            }
            WsImportChannelInWarehsBillUtils.setMessage(channelInWarehsBillInfo, "2001 ", ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"43_WsChannelJXCUtils", (Locale)ctx.getLocale()));
        }
        return billCols;
    }

    private static CompanyOrgUnitInfo getCompanyOrgUnit(OrgType srcOrgType, OrgType destOrgType, BOSUuid orgPK, Context ctx) throws BOSException, EASBizException {
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        int iSrcOrg = srcOrgType.getValue();
        int iDestOrg = destOrgType.getValue();
        OrgUnitCollection collection = iOrgRelation.getToUnit(orgPK.toString(), iSrcOrg, iDestOrg);
        if (collection.size() > 0 && collection.get(0) instanceof CompanyOrgUnitInfo) {
            return (CompanyOrgUnitInfo)collection.get(0);
        }
        return null;
    }

    public static final CurrencyInfo getBaseCurrencyInfo(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo) throws EASBizException, BOSException {
        return CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getBaseCurrency().getId()));
    }

    private static void setMessage(AbstractObjectValue billInfo, String returnNumber, String returnValue) {
        logger.info((Object)(returnNumber + ":" + returnValue));
        billInfo.put("ws_returnNumber", (Object)returnNumber);
        billInfo.put("ws_returnValue", (Object)returnValue);
    }

    private static void dealException(Context ctx, Exception e, AbstractObjectValue billInfo) throws BOSException {
        if (e instanceof PermissionException) {
            WsImportChannelInWarehsBillUtils.setMessage(billInfo, "6" + ((PermissionException)e).getSubCode(), e.getMessage());
        }
        if (e instanceof PermissionServiceException) {
            WsImportChannelInWarehsBillUtils.setMessage(billInfo, "7***", e.getMessage());
        } else if (e instanceof EASBizException) {
            WsImportChannelInWarehsBillUtils.setMessage(billInfo, "5" + ((EASBizException)((Object)e)).getSubCode(), e.getMessage());
        } else {
            WsImportChannelInWarehsBillUtils.setMessage(billInfo, "9001", MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.scm.sd.channel.CHANNELAutoGenerateResource", (String)"46_WsChannelJXCUtils", (Locale)ctx.getLocale()), e.getMessage().toString()));
        }
    }
}

