/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.app.bizprocess.beans;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.app.bizprocess.beans.DynValueThreadLocal;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.BeanDefinition;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.BeanDefinitionMap;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.BeanInstanceDefinition;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.BeanUtils;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.EntityActionMap;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.Initializer;
import com.kingdee.eas.scm.framework.dataloader.IDataLoader;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class BeanFactory {
    private BeanFactory() {
    }

    private static Object getBean(String beanId) throws BOSException {
        if (StringUtils.isEmpty((String)beanId)) {
            throw new BOSException("\u914d\u7f6e\u6587\u4ef6\u89e3\u6790\u51fa\u9519\uff1a\u6ce8\u518c\u7684bean\u7684id\u4e0d\u80fd\u4e3a\u7a7a! ");
        }
        BeanDefinition beanDef = BeanDefinitionMap.getBeanDefinition(beanId);
        if (beanDef == null) {
            throw new BOSException("\u914d\u7f6e\u6587\u4ef6\u89e3\u6790\u51fa\u9519\uff1a\u5f15\u7528\u7684beanid\u6ca1\u6709\u914d\u7f6e(bean id: " + beanId + ")! ");
        }
        return BeanUtils.instance(beanDef);
    }

    public static Object getBean(Context ctx, String beanId) throws BOSException {
        DynValueThreadLocal.setContext(ctx);
        try {
            Object object = BeanFactory.getBean(beanId);
            return object;
        }
        finally {
            DynValueThreadLocal.removeContext();
        }
    }

    private static List<IDataLoader> getDataLoaderList(BOSObjectType bosType, BatchActionEnum batchAction) throws BOSException {
        if (bosType == null || batchAction == null) {
            throw new BOSException("Error: incorrect parameter (can not be null)! bostype: " + bosType + "; batchAction: " + batchAction);
        }
        Initializer.reloadForDebug();
        List<BeanInstanceDefinition> beanInstList = EntityActionMap.getDataLoaderList(bosType.toString(), batchAction);
        ArrayList<IDataLoader> dataLoaderList = new ArrayList<IDataLoader>();
        if (null != beanInstList && beanInstList.size() > 0) {
            for (BeanInstanceDefinition beanInst : beanInstList) {
                IDataLoader dataLoader = (IDataLoader)BeanUtils.instance(beanInst);
                if (null == dataLoader) continue;
                dataLoaderList.add(dataLoader);
            }
        }
        return dataLoaderList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IDataLoader> getDataLoaderList(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction) throws BOSException {
        DynValueThreadLocal.setContext(ctx);
        try {
            List<IDataLoader> list = BeanFactory.getDataLoaderList(bosType, batchAction);
            return list;
        }
        finally {
            DynValueThreadLocal.removeContext();
        }
    }

    private static List<IVRule> getVRuleList(BOSObjectType bosType, BatchActionEnum batchAction) throws BOSException {
        if (bosType == null || batchAction == null) {
            throw new BOSException("Error: incorrect parameter (can not be null)! bostype: " + bosType + "; batchAction: " + batchAction);
        }
        Initializer.reloadForDebug();
        List<BeanInstanceDefinition> beanInstList = EntityActionMap.getVRuleList(bosType.toString(), batchAction);
        ArrayList<IVRule> vruleList = new ArrayList<IVRule>();
        if (null != beanInstList && beanInstList.size() > 0) {
            for (BeanInstanceDefinition beanInst : beanInstList) {
                IVRule vrule = (IVRule)BeanUtils.instance(beanInst);
                if (null == vrule) continue;
                vruleList.add(vrule);
            }
        }
        return vruleList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IVRule> getVRuleList(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction) throws BOSException {
        DynValueThreadLocal.setContext(ctx);
        try {
            List<IVRule> list = BeanFactory.getVRuleList(bosType, batchAction);
            return list;
        }
        finally {
            DynValueThreadLocal.removeContext();
        }
    }

    static {
        Initializer.init();
    }
}

