/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.app.bizprocess.beans.parser;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.BeanDefinition;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.ConstructorArgumentValues;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.DebugConfig;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.PropertyValue;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.ValueHolder;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.ValueTypeEnum;
import com.kingdee.util.StringUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeanDefinitionMap {
    private static Map<String, BeanDefinition> beanDefMap = new HashMap<String, BeanDefinition>();

    private BeanDefinitionMap() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addBeanDefinition(BeanDefinition beanDef) {
        if (beanDef == null) {
            return;
        }
        Map<String, BeanDefinition> map = beanDefMap;
        synchronized (map) {
            beanDefMap.put(beanDef.getBeanId(), beanDef);
        }
    }

    public static BeanDefinition getBeanDefinition(String beanId) {
        return beanDefMap.get(beanId);
    }

    static Collection<BeanDefinition> getBeanDefCollection() {
        return beanDefMap.values();
    }

    static boolean contain(String beanId) {
        return beanDefMap.containsKey(beanId);
    }

    static void checkCircularReference() throws BOSException {
        for (String beanId : beanDefMap.keySet()) {
            BeanDefinition beanDef = beanDefMap.get(beanId);
            HashMap<String, String> beanIdMap = new HashMap<String, String>();
            BeanDefinitionMap.checkIsReference2Map(beanDef, beanIdMap);
        }
    }

    private static void checkIsReference2Map(BeanDefinition beanDef, Map<String, String> map) throws BOSException {
        List<PropertyValue> pvList;
        ValueHolder valueHolder;
        if (null == beanDef || StringUtils.isEmpty((String)beanDef.getBeanId())) {
            return;
        }
        if (map.containsKey(beanDef.getBeanId())) {
            throw new BOSException("Failed: circular reference \u3002bean id is ( " + beanDef.getBeanId() + " ) .");
        }
        map.put(beanDef.getBeanId(), null);
        ConstructorArgumentValues cav = beanDef.getConstructorArgumentValues();
        if (cav != null && cav.size() > 0) {
            int size = cav.size();
            for (int i = 0; i < size; ++i) {
                valueHolder = cav.getArgumentValue(i);
                if (!ValueTypeEnum.REFBEAN.equals((Object)valueHolder.getType())) continue;
                String refBeanId = (String)valueHolder.getValue();
                BeanDefinition def = beanDefMap.get(refBeanId);
                BeanDefinitionMap.checkIsReference2Map(def, map);
            }
        }
        if ((pvList = beanDef.getPropertyValues()) != null && pvList.size() > 0) {
            for (PropertyValue pv : pvList) {
                valueHolder = pv.getValue();
                if (!ValueTypeEnum.REFBEAN.equals((Object)valueHolder.getType())) continue;
                String refBeanId = (String)valueHolder.getValue();
                BeanDefinition def = beanDefMap.get(refBeanId);
                BeanDefinitionMap.checkIsReference2Map(def, map);
            }
        }
        map.remove(beanDef.getBeanId());
    }

    static void clearForDebug() {
        if (DebugConfig.isReloadBeanCfgXmlForDebug()) {
            beanDefMap.clear();
        }
    }
}

