/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.app.bizprocess.beans.parser;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.BeanDefinition;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.BeanDefinitionMap;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.BeanInstanceDefinition;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.ConstructorArgumentValues;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.PropertyValue;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.SingletonBeanInstanceMap;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.ValueHolder;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BeanUtils {
    private BeanUtils() {
    }

    public static Object instance(BeanDefinition beanDef) throws BOSException {
        if (null == beanDef || beanDef.getBeanClass() == null) {
            throw new BOSException("Failed: BeanDefinition is null or BeanDefinition's beanClass is null!");
        }
        if (beanDef.isSingleton() && SingletonBeanInstanceMap.isContainBean(beanDef.getBeanId())) {
            return SingletonBeanInstanceMap.getBeanInstance(beanDef.getBeanId());
        }
        ConstructorArgumentValues cav = beanDef.getConstructorArgumentValues();
        if (null == cav) {
            cav = new ConstructorArgumentValues();
        }
        Class<?> clazz = beanDef.getBeanClass();
        Object instance = BeanUtils.newInstance(clazz, cav);
        List<PropertyValue> pvList = beanDef.getPropertyValues();
        BeanUtils.setProperty(instance, pvList);
        return instance;
    }

    public static Object instance(BeanInstanceDefinition beanInst) throws BOSException {
        if (null == beanInst || beanInst.getRefBeanId() == null || beanInst.getRefBeanId().length() == 0) {
            throw new BOSException("Failed: BeanInstanceDefinition is null or BeanInstanceDefinition's refBeanId is null!");
        }
        String refBeanId = beanInst.getRefBeanId();
        BeanDefinition beanDef = BeanDefinitionMap.getBeanDefinition(refBeanId);
        if (beanDef == null) {
            throw new BOSException("\u9519\u8bef\uff1a\u5f15\u7528\u7684Bean\u672a\u5b9a\u4e49\uff0cbean id is (" + refBeanId + " )");
        }
        if (beanDef.isSingleton() && SingletonBeanInstanceMap.isContainBean(refBeanId)) {
            return SingletonBeanInstanceMap.getBeanInstance(refBeanId);
        }
        ConstructorArgumentValues cav = beanInst.getConstructorArgumentValues();
        if (cav == null) {
            cav = beanDef.getConstructorArgumentValues();
        }
        if (cav == null) {
            cav = new ConstructorArgumentValues();
        }
        Class<?> clazz = beanDef.getBeanClass();
        Object instance = BeanUtils.newInstance(clazz, cav);
        List<PropertyValue> pvList = BeanUtils.merge(beanInst.getPropertyValues(), beanDef.getPropertyValues());
        BeanUtils.setProperty(instance, pvList);
        return instance;
    }

    private static List<PropertyValue> merge(List<PropertyValue> highList, List<PropertyValue> addList) {
        if (highList == null || highList.size() == 0) {
            return addList;
        }
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        HashMap map = new HashMap();
        for (PropertyValue pv : highList) {
            map.put(pv.getName(), null);
            result.add(pv);
        }
        for (PropertyValue pv : addList) {
            if (map.containsKey(pv.getName())) continue;
            result.add(pv);
        }
        return result;
    }

    private static void setProperty(Object instance, List<PropertyValue> pvList) throws BOSException {
        assert (instance != null);
        if (pvList == null || pvList.size() == 0) {
            return;
        }
        for (PropertyValue pv : pvList) {
            String pName = pv.getName();
            Method method = BeanUtils.getSettingMethodByPropertyName(instance.getClass(), pName);
            Class<?> paramClass = method.getParameterTypes()[0];
            ValueHolder valueHolder = pv.getValue();
            Object paramValue = valueHolder.getTargetValue(paramClass);
            try {
                method.invoke(instance, paramValue);
            }
            catch (Exception e) {
                throw new BOSException("Failed: cause exception by invoke setting method ! instance : " + instance.getClass().getName() + ";field : " + pName, (Throwable)e);
            }
        }
    }

    private static Method getSettingMethodByPropertyName(Class<?> instanceClazz, String propertyName) throws BOSException {
        Method[] methods;
        String methodName;
        assert (instanceClazz != null);
        assert (propertyName != null && propertyName.length() > 0);
        char c = propertyName.charAt(0);
        if (c >= 'a' && c <= 'z') {
            c = (char)(c - 32);
            methodName = "set" + c + propertyName.substring(1);
        } else {
            methodName = "set" + propertyName;
        }
        for (Method method : methods = instanceClazz.getMethods()) {
            if (!methodName.equals(method.getName()) || method.getParameterTypes().length != 1) continue;
            return method;
        }
        throw new BOSException("\u9519\u8bef\uff1a\u6b64\u7c7b\u6ca1\u6709\u5b9a\u4e49\u5bf9\u5e94\u7684set\u65b9\u6cd5 \u3002class : " + instanceClazz.getName() + ", property : " + propertyName);
    }

    private static Object newInstance(Class<?> clazz, ConstructorArgumentValues cav) throws BOSException {
        Constructor<?>[] constructors;
        if (clazz == null) {
            throw new BOSException("Failed: class name is null");
        }
        if (null == cav) {
            cav = new ConstructorArgumentValues();
        }
        if ((constructors = clazz.getConstructors()) == null || constructors.length == 0) {
            throw new BOSException("Failed: no public Constructor ! (" + clazz.getName() + ")");
        }
        Constructor<?> t = null;
        Class<?>[] paramTypes = null;
        for (Constructor<?> c : constructors) {
            paramTypes = c.getParameterTypes();
            if (paramTypes.length != cav.size()) continue;
            if (cav.size() == 0) {
                t = c;
                break;
            }
            boolean isMatch = true;
            int len = paramTypes.length;
            for (int i = 0; i < len; ++i) {
                ValueHolder valueHolder = cav.getArgumentValue(i);
                if (valueHolder.clazzMatch(paramTypes[i])) continue;
                isMatch = false;
                break;
            }
            if (!isMatch) continue;
            t = c;
            break;
        }
        if (t == null) {
            throw new BOSException("Bean\u521d\u59cb\u5316\u9519\u8bef\uff1a\u6ce8\u5165\u7684\u6784\u9020\u65b9\u6cd5\u53c2\u6570\u7c7b\u578b\u548c\u7c7b\u5b9a\u4e49\u7684\u7c7b\u578b\u4e0d\u5339\u914d \u3002class : " + clazz.getName() + " \u3002 ");
        }
        Object[] paramValues = cav.toArgumentValueArray(paramTypes);
        try {
            if (null == paramValues) {
                return t.newInstance(new Object[0]);
            }
            return t.newInstance(paramValues);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }
}

