/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.app.bizprocess.beans.parser;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.BeanDefinition;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.BeanDefinitionMap;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.BeanInstanceDefinition;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.BeanUtils;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.DebugConfig;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.EntityActionDefinition;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.EntityActionMap;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.SingletonBeanInstanceMap;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.XmlConfigParser;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.XmlResourceReader;
import com.kingdee.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jdom2.Element;

public class Initializer {
    private static final Logger logger = Logger.getLogger(Initializer.class);
    private static boolean isInitialized = false;
    private static BOSException throwable = null;

    private Initializer() {
    }

    public static void reloadForDebug() throws BOSException {
        if (DebugConfig.isReloadBeanCfgXmlForDebug()) {
            BeanDefinitionMap.clearForDebug();
            EntityActionMap.clearForDebug();
            SingletonBeanInstanceMap.clearForDebug();
            isInitialized = false;
            throwable = null;
            Initializer.init();
        }
        if (throwable != null) {
            throw throwable;
        }
    }

    public static synchronized void init() {
        if (isInitialized) {
            return;
        }
        isInitialized = true;
        try {
            Initializer._init();
        }
        catch (BOSException e) {
            throwable = e;
            logger.error((Object)"error,cause by parse:", (Throwable)e);
        }
        catch (Exception e) {
            throwable = new BOSException((Throwable)e);
            logger.error((Object)"error,cause by parse:", (Throwable)e);
        }
    }

    private static void _init() throws BOSException {
        String resouce = "com.kingdee.eas.scm.common.app.bizprocess.beans.xml.bill-bean-config.xml";
        XmlResourceReader reader = new XmlResourceReader(resouce);
        List<Element> standardResourceList = reader.getStandardResourceList();
        List<Element> extResourceList = reader.getExtResourceList();
        standardResourceList.addAll(extResourceList);
        for (Element root : standardResourceList) {
            XmlConfigParser parser = new XmlConfigParser(root);
            List<BeanDefinition> beanDefList = parser.getBeanDefinitionList();
            Initializer.addBeanDef2Map(beanDefList);
            List<EntityActionDefinition> entityActionList = parser.getEntityActionDefinitionList();
            Initializer.addEntityAction2Map(entityActionList);
        }
        BeanDefinitionMap.checkCircularReference();
        Initializer.instanceSingletonBean();
    }

    private static void instanceSingletonBean() throws BOSException {
        Collection<BeanDefinition> col = BeanDefinitionMap.getBeanDefCollection();
        for (BeanDefinition beanDef : col) {
            Object instance = BeanUtils.instance(beanDef);
            SingletonBeanInstanceMap.addInstance(beanDef.getBeanId(), instance);
        }
    }

    private static void addBeanDef2Map(List<BeanDefinition> beanDefList) throws BOSException {
        if (null == beanDefList || beanDefList.size() == 0) {
            return;
        }
        for (BeanDefinition beanDef : beanDefList) {
            if (BeanDefinitionMap.contain(beanDef.getBeanId())) {
                throw new BOSException("\u9519\u8bef\uff1abean\u5b9a\u4e49\u91cd\u590d (bean id is : " + beanDef.getBeanId() + ") \u3002");
            }
            BeanDefinitionMap.addBeanDefinition(beanDef);
        }
    }

    private static void addEntityAction2Map(List<EntityActionDefinition> entityActionList) {
        if (null == entityActionList || entityActionList.size() == 0) {
            return;
        }
        for (EntityActionDefinition entityActionDef : entityActionList) {
            List<BeanInstanceDefinition> beanInstDefList;
            String bosType = entityActionDef.getBosType();
            Map<String, List<BeanInstanceDefinition>> map = entityActionDef.getActionVRuleMap();
            if (null != map && map.size() > 0) {
                for (String action : map.keySet()) {
                    beanInstDefList = map.get(action);
                    EntityActionMap.addVRule(bosType, Initializer.string2BatchAction(action), beanInstDefList);
                }
            }
            if (null == (map = entityActionDef.getActionDataLoaderMap()) || map.size() <= 0) continue;
            for (String action : map.keySet()) {
                beanInstDefList = map.get(action);
                EntityActionMap.addDataLoader(bosType, Initializer.string2BatchAction(action), beanInstDefList);
            }
        }
    }

    private static BatchActionEnum string2BatchAction(String action) {
        if (StringUtils.isEmpty((String)action)) {
            logger.error((Object)"\u914d\u7f6e\u7684Action\u540d\u79f0\u4e3a\u7a7a! ");
            return BatchActionEnum.ADDNEW;
        }
        if ("save".equalsIgnoreCase(action = action.trim())) {
            return BatchActionEnum.SAVE;
        }
        if ("submit".equalsIgnoreCase(action)) {
            return BatchActionEnum.SUBMIT;
        }
        if ("audit".equalsIgnoreCase(action)) {
            return BatchActionEnum.AUDIT;
        }
        if ("unaudit".equalsIgnoreCase(action)) {
            return BatchActionEnum.UNAUDIT;
        }
        if ("close".equalsIgnoreCase(action)) {
            return BatchActionEnum.CLOSE;
        }
        logger.error((Object)("\u65e0\u6cd5\u8bc6\u522b\u7684Action\u540d\u79f0: " + action));
        return BatchActionEnum.ADDNEW;
    }
}

