/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.app.bizprocess.beans.parser;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.scm.framework.validator.beanvalidation.IPropertyValidatorDescription;
import com.kingdee.eas.scm.framework.validator.beanvalidation.desc.AbstractPropertyValidatorDescription;
import com.kingdee.eas.scm.framework.validator.beanvalidation.desc.AssertFalseValidatorDesc;
import com.kingdee.eas.scm.framework.validator.beanvalidation.desc.AssertTrueValidatorDesc;
import com.kingdee.eas.scm.framework.validator.beanvalidation.desc.DecimalMaxValidatorDesc;
import com.kingdee.eas.scm.framework.validator.beanvalidation.desc.DecimalMinValidatorDesc;
import com.kingdee.eas.scm.framework.validator.beanvalidation.desc.DecimalNotEqualsValidatorDesc;
import com.kingdee.eas.scm.framework.validator.beanvalidation.desc.DigitsValidatorDesc;
import com.kingdee.eas.scm.framework.validator.beanvalidation.desc.FutureValidatorDesc;
import com.kingdee.eas.scm.framework.validator.beanvalidation.desc.MaxValidatorDesc;
import com.kingdee.eas.scm.framework.validator.beanvalidation.desc.MinValidatorDesc;
import com.kingdee.eas.scm.framework.validator.beanvalidation.desc.NotNullValidatorDesc;
import com.kingdee.eas.scm.framework.validator.beanvalidation.desc.NullValidatorDesc;
import com.kingdee.eas.scm.framework.validator.beanvalidation.desc.PastValidatorDesc;
import com.kingdee.eas.scm.framework.validator.beanvalidation.desc.PatternValidatorDesc;
import com.kingdee.eas.scm.framework.validator.beanvalidation.desc.SizeValidatorDesc;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import org.jdom2.Element;

class ValidatorConfigParser {
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ATTRIBUTE_VALIDATOR = "validator";
    private static final String ATTRIBUTE_WHEN = "when";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_MAX = "max";
    private static final String ATTRIBUTE_MIN = "min";
    private static final String ATTRIBUTE_ERRORRES = "errorResource";
    private static final String ATTRIBUTE_REGEXP = "regexp";
    private static final String ATTRIBUTE_FLAGS = "flags";
    private static final String ATTRIBUTE_FRACTION = "fraction";
    private static final String ATTRIBUTE_INTEGER = "integer";

    private ValidatorConfigParser() {
    }

    static IPropertyValidatorDescription getPropertyValidatorDesc(Element config) throws BOSException {
        String name = config.getAttributeValue(ATTRIBUTE_NAME);
        String when = config.getAttributeValue(ATTRIBUTE_WHEN);
        String validator = config.getAttributeValue(ATTRIBUTE_VALIDATOR);
        String errorResource = config.getAttributeValue(ATTRIBUTE_ERRORRES);
        AbstractPropertyValidatorDescription desc = null;
        if (StringUtils.isEmpty((String)validator)) {
            validator = "notnull";
        }
        if ("assertfalse".equalsIgnoreCase(validator = validator.trim().toLowerCase())) {
            desc = ValidatorConfigParser.createAssertFalseDesc(config);
        } else if ("asserttrue".equalsIgnoreCase(validator)) {
            desc = ValidatorConfigParser.createAssertTrueDesc(config);
        } else if ("decimalmax".equalsIgnoreCase(validator)) {
            desc = ValidatorConfigParser.createDecimalMaxDesc(config);
        } else if ("decimalmin".equalsIgnoreCase(validator)) {
            desc = ValidatorConfigParser.createDecimalMinDesc(config);
        } else if ("decimalnotequals".equalsIgnoreCase(validator)) {
            desc = ValidatorConfigParser.createDeciamlNotEqualsDesc(config);
        } else if ("digits".equalsIgnoreCase(validator)) {
            desc = ValidatorConfigParser.createDigitsDesc(config);
        } else if ("future".equalsIgnoreCase(validator)) {
            desc = ValidatorConfigParser.createFutureDesc(config);
        } else if (ATTRIBUTE_MAX.equalsIgnoreCase(validator)) {
            desc = ValidatorConfigParser.createMaxDesc(config);
        } else if (ATTRIBUTE_MIN.equalsIgnoreCase(validator)) {
            desc = ValidatorConfigParser.createMinDesc(config);
        } else if ("notnull".equalsIgnoreCase(validator)) {
            desc = ValidatorConfigParser.createNotNullDesc(config);
        } else if ("null".equalsIgnoreCase(validator)) {
            desc = ValidatorConfigParser.createNullDesc(config);
        } else if ("past".equalsIgnoreCase(validator)) {
            desc = ValidatorConfigParser.createPastDesc(config);
        } else if ("pattern".equalsIgnoreCase(validator)) {
            desc = ValidatorConfigParser.createPatternDesc(config);
        } else if ("size".equalsIgnoreCase(validator)) {
            desc = ValidatorConfigParser.createSizeDesc(config);
        } else {
            throw new BOSException("\u672a\u77e5\u7684\u5b57\u6bb5\u6821\u9a8c\u5668\u7c7b\u578b: " + validator);
        }
        desc.setErrorResource(errorResource);
        desc.setPropertyName(name);
        desc.setWhen(when);
        return desc;
    }

    private static AbstractPropertyValidatorDescription createSizeDesc(Element config) {
        SizeValidatorDesc desc = new SizeValidatorDesc();
        String min = config.getAttributeValue(ATTRIBUTE_MIN);
        String max = config.getAttributeValue(ATTRIBUTE_MAX);
        if (!StringUtils.isEmpty((String)min)) {
            desc.setMin(Integer.parseInt(min.trim()));
        }
        if (!StringUtils.isEmpty((String)max)) {
            desc.setMax(Integer.parseInt(max.trim()));
        }
        return desc;
    }

    private static AbstractPropertyValidatorDescription createPatternDesc(Element config) {
        PatternValidatorDesc desc = new PatternValidatorDesc();
        String regexp = config.getAttributeValue(ATTRIBUTE_REGEXP);
        desc.setRegexp(regexp);
        String flags = config.getAttributeValue(ATTRIBUTE_FLAGS);
        if (!StringUtils.isEmpty((String)flags)) {
            desc.setFlags(Integer.parseInt(flags.trim()));
        }
        return desc;
    }

    private static AbstractPropertyValidatorDescription createPastDesc(Element config) {
        return new PastValidatorDesc();
    }

    private static AbstractPropertyValidatorDescription createNullDesc(Element config) {
        return new NullValidatorDesc();
    }

    private static AbstractPropertyValidatorDescription createNotNullDesc(Element config) {
        return new NotNullValidatorDesc();
    }

    private static AbstractPropertyValidatorDescription createMinDesc(Element config) {
        MinValidatorDesc desc = new MinValidatorDesc();
        String min = config.getAttributeValue(ATTRIBUTE_MIN);
        if (!StringUtils.isEmpty((String)min)) {
            desc.setMin(Long.parseLong(min.trim()));
        }
        return desc;
    }

    private static AbstractPropertyValidatorDescription createMaxDesc(Element config) {
        MaxValidatorDesc desc = new MaxValidatorDesc();
        String max = config.getAttributeValue(ATTRIBUTE_MAX);
        if (!StringUtils.isEmpty((String)max)) {
            desc.setMax(Long.parseLong(max.trim()));
        }
        return desc;
    }

    private static AbstractPropertyValidatorDescription createFutureDesc(Element config) {
        return new FutureValidatorDesc();
    }

    private static AbstractPropertyValidatorDescription createDigitsDesc(Element config) {
        String integer;
        DigitsValidatorDesc desc = new DigitsValidatorDesc();
        String fraction = config.getAttributeValue(ATTRIBUTE_FRACTION);
        if (!StringUtils.isEmpty((String)fraction)) {
            desc.setFraction(Integer.parseInt(fraction.trim()));
        }
        if (!StringUtils.isEmpty((String)(integer = config.getAttributeValue(ATTRIBUTE_INTEGER)))) {
            desc.setInteger(Integer.parseInt(integer.trim()));
        }
        return desc;
    }

    private static AbstractPropertyValidatorDescription createDeciamlNotEqualsDesc(Element config) {
        DecimalNotEqualsValidatorDesc desc = new DecimalNotEqualsValidatorDesc();
        String value = config.getAttributeValue(ATTRIBUTE_VALUE);
        if (!StringUtils.isEmpty((String)value)) {
            desc.setValue(new BigDecimal(value.trim()));
        }
        return desc;
    }

    private static AbstractPropertyValidatorDescription createDecimalMinDesc(Element config) {
        DecimalMinValidatorDesc desc = new DecimalMinValidatorDesc();
        String min = config.getAttributeValue(ATTRIBUTE_MIN);
        if (!StringUtils.isEmpty((String)min)) {
            desc.setMin(new BigDecimal(min.trim()));
        }
        return desc;
    }

    private static AbstractPropertyValidatorDescription createDecimalMaxDesc(Element config) {
        DecimalMaxValidatorDesc desc = new DecimalMaxValidatorDesc();
        String max = config.getAttributeValue(ATTRIBUTE_MAX);
        if (!StringUtils.isEmpty((String)max)) {
            desc.setMax(new BigDecimal(max.trim()));
        }
        return desc;
    }

    private static AbstractPropertyValidatorDescription createAssertTrueDesc(Element config) {
        return new AssertTrueValidatorDesc();
    }

    private static AbstractPropertyValidatorDescription createAssertFalseDesc(Element config) {
        return new AssertFalseValidatorDesc();
    }
}

