/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.app.bizprocess.beans.parser;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.scm.common.app.bizprocess.beans.DynValueThreadLocal;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.BeanDefinition;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.BeanDefinitionMap;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.BeanUtils;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.ValueTypeEnum;
import com.kingdee.eas.scm.util.numeric.NumericUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ValueHolder {
    private Object value;
    private ValueTypeEnum type;

    public ValueHolder(Object value) {
        this(value, ValueTypeEnum.BASIC);
    }

    public ValueHolder(Object value, ValueTypeEnum type) {
        this.setValue(value);
        this.setType(type);
    }

    void setType(ValueTypeEnum type) {
        this.type = type;
        if (this.type == null) {
            this.type = ValueTypeEnum.BASIC;
        }
    }

    public void setValue(Object value) {
        this.value = value;
    }

    Object getValue() {
        return this.value;
    }

    public Object getTargetValue(Class<?> targetType) throws BOSException {
        if (ValueTypeEnum.REFBEAN.equals((Object)this.type)) {
            String beanId = (String)this.value;
            BeanDefinition beanDef = BeanDefinitionMap.getBeanDefinition(beanId);
            if (beanDef == null) {
                throw new BOSException("\u9519\u8bef\uff1a\u6ce8\u5165\u5b57\u6bb5\u503c\u7684\u5f15\u7528\u7684bean\u6ca1\u6709\u5b9a\u4e49\u3002bean id \uff1a" + beanId);
            }
            Object ret = BeanUtils.instance(beanDef);
            if (ret.getClass().equals(targetType)) {
                return ret;
            }
            throw new BOSException("\u9519\u8bef\uff1a\u6ce8\u5165\u5b57\u6bb5\u503c\u7684\u5f15\u7528\u7684bean\u7c7b\u578b\u548c\u6240\u9700\u7c7b\u578b\u4e0d\u5339\u914d\u3002 require:" + targetType.getName() + ", actual: " + ret.getClass().getName());
        }
        if (ValueTypeEnum.DYN.equals((Object)this.type)) {
            return DynValueThreadLocal.getContext();
        }
        if (ValueTypeEnum.ARRAY.equals((Object)this.type)) {
            ValueHolder[] valueHolders = (ValueHolder[])this.getValue();
            if (String[].class.equals(targetType)) {
                String[] result = new String[valueHolders.length];
                int len = valueHolders.length;
                for (int i = 0; i < len; ++i) {
                    result[i] = (String)valueHolders[i].getTargetValue(String.class);
                }
                return result;
            }
            if (int[].class.equals(targetType)) {
                int[] result = new int[valueHolders.length];
                int len = valueHolders.length;
                for (int i = 0; i < len; ++i) {
                    result[i] = (Integer)valueHolders[i].getTargetValue(Integer.TYPE);
                }
                return result;
            }
            if (long[].class.equals(targetType)) {
                long[] result = new long[valueHolders.length];
                int len = valueHolders.length;
                for (int i = 0; i < len; ++i) {
                    result[i] = (Long)valueHolders[i].getTargetValue(Long.TYPE);
                }
                return result;
            }
            if (int[].class.equals(targetType)) {
                double[] result = new double[valueHolders.length];
                int len = valueHolders.length;
                for (int i = 0; i < len; ++i) {
                    result[i] = (Double)valueHolders[i].getTargetValue(Double.TYPE);
                }
                return result;
            }
            if (int[].class.equals(targetType)) {
                float[] result = new float[valueHolders.length];
                int len = valueHolders.length;
                for (int i = 0; i < len; ++i) {
                    result[i] = ((Float)valueHolders[i].getTargetValue(Float.TYPE)).floatValue();
                }
                return result;
            }
            throw new BOSException("\u9519\u8bef\uff1a\u6ce8\u5165\u7684\u6570\u7ec4\u7c7b\u578b\u6682\u4e0d\u652f\u6301\u3002array-class: " + targetType.getName());
        }
        if (ValueTypeEnum.COLLECTION.equals((Object)this.type)) {
            return (List)this.getValue();
        }
        if (ValueTypeEnum.BASIC.equals((Object)this.type)) {
            Object obj = this.getValue();
            if (BigDecimal.class.equals(targetType)) {
                return NumericUtil.toBigDecimal((Object)obj);
            }
            if (String.class.equals(targetType)) {
                return obj.toString();
            }
            if (Double.class.equals(targetType) || Double.TYPE.equals(targetType)) {
                return Double.parseDouble(obj.toString());
            }
            if (Float.class.equals(targetType) || Float.TYPE.equals(targetType)) {
                return Float.valueOf(Float.parseFloat(obj.toString()));
            }
            if (Long.class.equals(targetType) || Long.TYPE.equals(targetType)) {
                return Long.parseLong(obj.toString());
            }
            if (Integer.class.equals(targetType) || Integer.TYPE.equals(targetType)) {
                return Integer.parseInt(obj.toString());
            }
            if (Boolean.class.equals(targetType) || Boolean.TYPE.equals(targetType)) {
                return Boolean.parseBoolean(obj.toString());
            }
            throw new BOSException("\u9519\u8bef\uff1a\u6ce8\u5165\u7684\u5b57\u6bb5\u7684\u503c\u7c7b\u578b\u6682\u65f6\u4e0d\u652f\u6301! targetType: " + targetType);
        }
        if (ValueTypeEnum.MAP.equals((Object)this.type)) {
            throw new BOSException("\u9519\u8bef\uff1a\u6ce8\u5165\u7684\u5b57\u6bb5\u7684\u503c\u7c7b\u578b\u6682\u65f6\u4e0d\u652f\u6301! need Map, but actual is  " + targetType);
        }
        throw new BOSException("\u9519\u8bef\uff1a\u6ce8\u5165\u7684\u5b57\u6bb5\u7684\u503c\u7c7b\u578b\u6682\u65f6\u4e0d\u652f\u6301! targetType: " + targetType);
    }

    public ValueTypeEnum getType() {
        return this.type;
    }

    public boolean clazzMatch(Class<?> clazz) {
        if (ValueTypeEnum.BASIC.equals((Object)this.type)) {
            return Number.class.isAssignableFrom(clazz) || String.class.isAssignableFrom(clazz);
        }
        if (ValueTypeEnum.COLLECTION.equals((Object)this.type)) {
            return Collection.class.isAssignableFrom(clazz);
        }
        if (ValueTypeEnum.MAP.equals((Object)this.type)) {
            return Map.class.isAssignableFrom(clazz);
        }
        if (ValueTypeEnum.DYN.equals((Object)this.type)) {
            return Context.class.isAssignableFrom(clazz);
        }
        if (ValueTypeEnum.REFBEAN.equals((Object)this.type)) {
            String beanId = (String)this.value;
            BeanDefinition beanDef = BeanDefinitionMap.getBeanDefinition(beanId);
            if (null == beanDef || beanDef.getBeanClass() == null) {
                return false;
            }
            return beanDef.getBeanClass().isAssignableFrom(clazz);
        }
        return false;
    }
}

