/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.app.bizprocess.beans.parser;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.BeanDefinition;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.BeanInstanceDefinition;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.ConstructorArgumentValues;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.DefaultBeanDefinition;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.DefaultBeanInstanceDefinition;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.EntityActionDefinition;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.PropertyValue;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.ValidatorConfigParser;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.ValueHolder;
import com.kingdee.eas.scm.common.app.bizprocess.beans.parser.ValueTypeEnum;
import com.kingdee.eas.scm.framework.validator.beanvalidation.IPropertyValidatorDescription;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import org.jdom2.Element;

public class XmlConfigParser {
    private final String TAG_PROPERTY = "property";
    private final String TAG_ENTITIES = "entities";
    private final String TAG_ENTITY = "entity";
    private final String TAG_FIELD = "field";
    private final String TAG_BEAN = "bean";
    private final String TAG_CONSTRUCTOR = "constructor";
    private final String TAG_VALUE = "value";
    private final String TAG_REF = "ref";
    private final String TAG_ARRAY = "array";
    private final String TAG_ARG = "arg";
    private final String TAG_ACTION = "action";
    private final String TAG_VRULE = "vrule";
    private final String TAG_LOADER = "loader";
    private final String TAG_ENTRY = "entry";
    private final String TAG_HEADER = "header";
    private final String TAG_VRULELIST = "vrule-list";
    private final String TAG_DATALOADERLIST = "dataloader-list";
    private final String TAG_ENTRY1 = "entry1";
    private final String ATTRIBUTE_PARENTNAME = "parentName";
    private final String ATTRIBUTE_ID = "id";
    private final String ATTRIBUTE_NAME = "name";
    private final String ATTRIBUTE_TYPE = "type";
    private final String ATTRIBUTE_BOSTYPE = "bosType";
    private final String ATTRIBUTE_CLASS = "class";
    private final String ATTRIBUTE_REF = "ref";
    private final String ATTRIBUTE_BEAN = "bean";
    private final String ATTRIBUTE_ISFIELDVALIDATOR = "isFieldValidator";
    private final String ATTRIBUTE_SINGLETON = "singleton";
    private final String ATTRIBUTE_DESCRIPTION = "description";
    private final String ATTRIBUTE_EXTENDABLE = "extendable";
    private Element root;

    XmlConfigParser(Element root) {
        this.root = root;
    }

    public List<BeanDefinition> getBeanDefinitionList() throws BOSException {
        if (null == this.root) {
            return null;
        }
        Element beansElement = this.root.getChild("beans");
        if (null == beansElement) {
            return null;
        }
        List beanListElement = beansElement.getChildren("bean");
        if (null == beanListElement || beanListElement.size() == 0) {
            return null;
        }
        ArrayList<BeanDefinition> result = new ArrayList<BeanDefinition>();
        for (Element e : beanListElement) {
            BeanDefinition beanDef = this.getBeanDefinition(e);
            if (null == beanDef) continue;
            result.add(beanDef);
        }
        return result;
    }

    public List<EntityActionDefinition> getEntityActionDefinitionList() throws BOSException {
        if (null == this.root) {
            return null;
        }
        ArrayList<EntityActionDefinition> result = new ArrayList<EntityActionDefinition>();
        Element entities = this.root.getChild("entities");
        if (null == entities) {
            return null;
        }
        List entityList = entities.getChildren("entity");
        for (Element entity : entityList) {
            EntityActionDefinition def = this.getEntityActionDefinition(entity);
            if (null == def) continue;
            result.add(def);
        }
        return result;
    }

    private EntityActionDefinition getEntityActionDefinition(Element entityElement) throws BOSException {
        if (entityElement == null) {
            return null;
        }
        EntityActionDefinition entityActionDef = new EntityActionDefinition();
        String name = entityElement.getAttributeValue("name");
        String bosType = entityElement.getAttributeValue("bosType");
        entityActionDef.setName(name);
        entityActionDef.setBosType(bosType);
        List actionList = entityElement.getChildren("action");
        for (Element actionElement : actionList) {
            Element vruleListElement;
            List<BeanInstanceDefinition> vruleList;
            String actionType = actionElement.getAttributeValue("type");
            if (StringUtils.isEmpty((String)actionType)) {
                throw new BOSException("action type is null ! entity :" + bosType + " ,name :" + name + " \u3002");
            }
            Element dataloaderListElement = actionElement.getChild("dataloader-list");
            List<BeanInstanceDefinition> dataLoaderList = this.getDataLoader(dataloaderListElement);
            if (null != dataLoaderList && dataLoaderList.size() > 0) {
                entityActionDef.setActionDataLoaderList(actionType, dataLoaderList);
            }
            if (null == (vruleList = this.getVRuleList(vruleListElement = actionElement.getChild("vrule-list"))) || vruleList.size() <= 0) continue;
            entityActionDef.setActionVRuleList(actionType, vruleList);
        }
        return entityActionDef;
    }

    private BeanDefinition getBeanDefinition(Element beanElement) throws BOSException {
        List proList;
        String singleton;
        Class<?> beanClass;
        if (beanElement == null) {
            return null;
        }
        DefaultBeanDefinition beanDef = new DefaultBeanDefinition();
        String id = beanElement.getAttributeValue("id");
        if (StringUtils.isEmpty((String)id)) {
            throw new BOSException("Bean\u5b9a\u4e49\u9519\u8bef\uff0c\u6ca1\u6709\u5b9a\u4e49bean\u7684id\u503c");
        }
        beanDef.setBeanId(id.trim());
        String clazz = beanElement.getAttributeValue("class");
        if (StringUtils.isEmpty((String)clazz)) {
            throw new BOSException("Bean\u5b9a\u4e49\u9519\u8bef\uff0c\u6ca1\u6709\u5b9a\u4e49bean\u7684class\u503c");
        }
        String extendable = beanElement.getAttributeValue("extendable");
        if (Boolean.valueOf(extendable).booleanValue()) {
            try {
                beanClass = Class.forName(clazz.trim() + "CTEx");
            }
            catch (ClassNotFoundException e1) {
                try {
                    beanClass = Class.forName(clazz.trim());
                }
                catch (ClassNotFoundException e) {
                    throw new BOSException("Bean\u5b9a\u4e49\u9519\u8bef\uff0c\u5b9a\u4e49\u7684class\u4e0d\u5728classpath\u4e2d\u3002( " + clazz + " )");
                }
            }
        } else {
            try {
                beanClass = Class.forName(clazz.trim());
            }
            catch (ClassNotFoundException e) {
                throw new BOSException("Bean\u5b9a\u4e49\u9519\u8bef\uff0c\u5b9a\u4e49\u7684class\u4e0d\u5728classpath\u4e2d\u3002( " + clazz + " )");
            }
        }
        beanDef.setBeanClass(beanClass);
        String description = beanElement.getAttributeValue("description");
        if (!StringUtils.isEmpty((String)description)) {
            beanDef.setDescription(description);
        }
        if (!StringUtils.isEmpty((String)(singleton = beanElement.getAttributeValue("singleton"))) && "true".equalsIgnoreCase(singleton.trim())) {
            beanDef.setSingleton(true);
        } else {
            beanDef.setSingleton(false);
        }
        Element constrElement = beanElement.getChild("constructor");
        if (null != constrElement) {
            ConstructorArgumentValues cav = this.getConstructorArgumentValues(constrElement);
            beanDef.setConstructorArgValues(cav);
        }
        if (null != (proList = beanElement.getChildren("property")) && proList.size() > 0) {
            ArrayList<PropertyValue> pvList = new ArrayList<PropertyValue>();
            for (Element pe : proList) {
                PropertyValue pv = this.getPropertyValue(pe);
                pvList.add(pv);
            }
            beanDef.setPropertyValues(pvList);
        }
        return beanDef;
    }

    private List<BeanInstanceDefinition> getDataLoader(Element dataloaderListElement) throws BOSException {
        if (null == dataloaderListElement) {
            return null;
        }
        List dataLoaderList = dataloaderListElement.getChildren("loader");
        if (null == dataLoaderList || dataLoaderList.size() == 0) {
            return null;
        }
        ArrayList<BeanInstanceDefinition> beanInstList = new ArrayList<BeanInstanceDefinition>();
        for (Element childElement : dataLoaderList) {
            List proList;
            DefaultBeanInstanceDefinition beanInst = new DefaultBeanInstanceDefinition();
            String ref = childElement.getAttributeValue("ref");
            if (StringUtils.isEmpty((String)ref)) {
                throw new BOSException("\u6821\u9a8c\u89c4\u5219\u9519\u8bef\uff0c\u4e1a\u52a1\u89c4\u5219\u5f15\u7528bean\u7684id\u4e0d\u80fd\u4e3a\u7a7a\u3002(ref)");
            }
            beanInst.setRefBeanId(ref);
            Element constrElement = childElement.getChild("constructor");
            if (null != constrElement) {
                ConstructorArgumentValues cav = this.getConstructorArgumentValues(constrElement);
                beanInst.setConstructorArgumentValues(cav);
            }
            if ((proList = childElement.getChildren("property")) != null && proList.size() > 0) {
                for (Element pe : proList) {
                    PropertyValue pv = this.getPropertyValue(pe);
                    beanInst.addPropertyValues(pv);
                }
            }
            beanInstList.add(beanInst);
        }
        return beanInstList;
    }

    private List<BeanInstanceDefinition> getVRuleList(Element vruleListElement) throws BOSException {
        if (null == vruleListElement) {
            return null;
        }
        List vruleList = vruleListElement.getChildren("vrule");
        if (null == vruleList || vruleList.size() == 0) {
            return null;
        }
        ArrayList<BeanInstanceDefinition> beanInstList = new ArrayList<BeanInstanceDefinition>();
        for (Element childElement : vruleList) {
            List proList;
            String ref;
            DefaultBeanInstanceDefinition beanInst = new DefaultBeanInstanceDefinition();
            String isFieldValidator = childElement.getAttributeValue("isFieldValidator");
            if ("true".equalsIgnoreCase(isFieldValidator)) {
                List<PropertyValue> filedValidatorProList = this.parserFieldValidator(childElement);
                beanInst.setPropertyValues(filedValidatorProList);
            }
            if (StringUtils.isEmpty((String)(ref = childElement.getAttributeValue("ref")))) {
                throw new BOSException("\u6821\u9a8c\u89c4\u5219\u9519\u8bef\uff0c\u4e1a\u52a1\u89c4\u5219\u5f15\u7528bean\u7684id(ref)\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            beanInst.setRefBeanId(ref);
            Element constrElement = childElement.getChild("constructor");
            if (null != constrElement) {
                ConstructorArgumentValues cav = this.getConstructorArgumentValues(constrElement);
                beanInst.setConstructorArgumentValues(cav);
            }
            if ((proList = childElement.getChildren("property")) != null && proList.size() > 0) {
                for (Element pe : proList) {
                    PropertyValue pv = this.getPropertyValue(pe);
                    beanInst.addPropertyValues(pv);
                }
            }
            beanInstList.add(beanInst);
        }
        return beanInstList;
    }

    private List<PropertyValue> parserFieldValidator(Element beanPropertyElement) throws BOSException {
        Element entry1Element;
        PropertyValue pv;
        Element entryElement;
        PropertyValue pv2;
        List fieldList;
        if (beanPropertyElement == null) {
            return null;
        }
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        Element headerElement = beanPropertyElement.getChild("header");
        if (headerElement != null && (fieldList = headerElement.getChildren("field")) != null && fieldList.size() > 0) {
            ArrayList<IPropertyValidatorDescription> fieldDesList = new ArrayList<IPropertyValidatorDescription>();
            for (Element fieldElement : fieldList) {
                IPropertyValidatorDescription fieldDes = ValidatorConfigParser.getPropertyValidatorDesc(fieldElement);
                fieldDesList.add(fieldDes);
            }
            pv2 = new PropertyValue();
            pv2.setName("headerValidatorList");
            pv2.setValue(fieldDesList, ValueTypeEnum.COLLECTION);
            result.add(pv2);
        }
        if ((entryElement = beanPropertyElement.getChild("entry")) != null) {
            String entryName;
            List fieldList2 = entryElement.getChildren("field");
            if (fieldList2 != null && fieldList2.size() > 0) {
                ArrayList<IPropertyValidatorDescription> fieldDesList = new ArrayList<IPropertyValidatorDescription>();
                for (Element fieldElement : fieldList2) {
                    IPropertyValidatorDescription fieldDes = ValidatorConfigParser.getPropertyValidatorDesc(fieldElement);
                    fieldDesList.add(fieldDes);
                }
                pv = new PropertyValue();
                pv.setName("entryValidatorList");
                pv.setValue(fieldDesList, ValueTypeEnum.COLLECTION);
                result.add(pv);
            }
            if (!StringUtils.isEmpty((String)(entryName = entryElement.getAttributeValue("name")))) {
                pv2 = new PropertyValue();
                pv2.setName("entryName");
                pv2.setValue(entryName.trim(), ValueTypeEnum.BASIC);
                result.add(pv2);
            }
        }
        if ((entry1Element = beanPropertyElement.getChild("entry1")) != null) {
            String parentName;
            String entryName;
            PropertyValue pv3;
            List fieldList3 = entry1Element.getChildren("field");
            if (fieldList3 != null && fieldList3.size() > 0) {
                ArrayList<IPropertyValidatorDescription> fieldDesList = new ArrayList<IPropertyValidatorDescription>();
                for (Element fieldElement : fieldList3) {
                    IPropertyValidatorDescription fieldDes = ValidatorConfigParser.getPropertyValidatorDesc(fieldElement);
                    fieldDesList.add(fieldDes);
                }
                pv3 = new PropertyValue();
                pv3.setName("entry1ValidatorList");
                pv3.setValue(fieldDesList, ValueTypeEnum.COLLECTION);
                result.add(pv3);
            }
            if (!StringUtils.isEmpty((String)(entryName = entry1Element.getAttributeValue("name")))) {
                pv = new PropertyValue();
                pv.setName("entry1Name");
                pv.setValue(entryName.trim(), ValueTypeEnum.BASIC);
                result.add(pv);
            }
            if (!StringUtils.isEmpty((String)(parentName = entry1Element.getAttributeValue("parentName")))) {
                pv3 = new PropertyValue();
                pv3.setName("parent1Name");
                pv3.setValue(parentName.trim(), ValueTypeEnum.BASIC);
                result.add(pv3);
            }
        }
        return result;
    }

    private PropertyValue getPropertyValue(Element pvElement) throws BOSException {
        if (null == pvElement) {
            return null;
        }
        PropertyValue pv = new PropertyValue();
        String name = pvElement.getAttributeValue("name");
        pv.setName(name);
        List children = pvElement.getChildren();
        if (children == null || children.size() == 0) {
            throw new BOSException("\u5c5e\u6027\u914d\u7f6e\u9519\u8bef\uff0c\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002\uff08" + name + "\uff09");
        }
        ValueHolder valueHolder = this.getValue((Element)children.get(0));
        pv.setValue(valueHolder);
        return pv;
    }

    private ValueHolder getValue(Element vElement) throws BOSException {
        if (vElement == null) {
            throw new BOSException("(\u5c5e\u6027\u503c|\u53c2\u6570\u503c)\u914d\u7f6e\u9519\u8bef,\u503c\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        String valueType = vElement.getName();
        if ("value".equalsIgnoreCase(valueType)) {
            String value = vElement.getText();
            if (StringUtils.isEmpty((String)value)) {
                throw new BOSException();
            }
            if (null != value && value.indexOf("dyn:") != -1) {
                return new ValueHolder(value, ValueTypeEnum.DYN);
            }
            return new ValueHolder(value);
        }
        if ("ref".equalsIgnoreCase(valueType)) {
            String ref = vElement.getAttributeValue("bean");
            if (StringUtils.isEmpty((String)ref)) {
                throw new BOSException("(\u5c5e\u6027\u503c|\u53c2\u6570\u503c)\u914d\u7f6e\u9519\u8bef\uff0c\u5f15\u7528\u7684Bean\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            return new ValueHolder(ref, ValueTypeEnum.REFBEAN);
        }
        if ("array".equalsIgnoreCase(valueType)) {
            List arrayElement = vElement.getChildren();
            ValueHolder[] result = new ValueHolder[arrayElement.size()];
            int size = arrayElement.size();
            for (int i = 0; i < size; ++i) {
                result[i] = this.getValue((Element)arrayElement.get(i));
            }
            return new ValueHolder(result, ValueTypeEnum.ARRAY);
        }
        throw new BOSException("(\u5c5e\u6027\u503c|\u53c2\u6570\u503c)\u914d\u7f6e\u9519\u8bef\uff0c\u65e0\u6cd5\u8bc6\u522b\u7684\u503c\u7c7b\u578b\u3002");
    }

    private ConstructorArgumentValues getConstructorArgumentValues(Element constructorElement) throws BOSException {
        if (null == constructorElement) {
            return null;
        }
        ConstructorArgumentValues cav = new ConstructorArgumentValues();
        List argList = constructorElement.getChildren("arg");
        int size = argList.size();
        for (int i = 0; i < size; ++i) {
            Element child = (Element)argList.get(i);
            List argvalue = child.getChildren();
            if (argvalue == null || argvalue.size() <= 0) continue;
            ValueHolder valueHolder = this.getValue((Element)argvalue.get(0));
            cav.addArgumentValue(i, valueHolder);
        }
        return cav;
    }
}

