/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.ISCMBizChainParams;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBizChainParamsFactory;
import com.kingdee.eas.scm.common.app.BillTypeUtils;
import java.util.ArrayList;
import java.util.List;

public class ClearAccountViewProcess
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 1L;

    public ClearAccountViewProcess(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public ClearAccountViewProcess(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        ISCMBizChainParams iSCMBizChainParams = SCMBizChainParamsFactory.getLocalInstance((Context)this.ctx);
        boolean isStartUsed = iSCMBizChainParams.isStartUsed(this.bosType.toString(), this.batchAction.getBizAction(), "ClearAccountViewProcess");
        if (!isStartUsed) {
            return;
        }
        IObjectCollection objCol = batchResults.getObjCollection();
        this.clearAccountView(this.ctx, objCol);
    }

    protected void clearAccountView(Context ctx, IObjectCollection billCol) throws BOSException, EASBizException {
        SCMBillBaseInfo billInfo = null;
        String entryTableName = null;
        ArrayList<String> billList = new ArrayList<String>();
        Object billType = null;
        for (int i = 0; i < billCol.size(); ++i) {
            billInfo = (SCMBillBaseInfo)billCol.getObject(i);
            billList.add(billInfo.getId().toString());
            if (i != 0) continue;
            entryTableName = BillTypeUtils.getBillEntryTableName((Context)ctx, (String)billInfo.getBillType().getId().toString());
        }
        this.clearAccountView(ctx, entryTableName, billList);
    }

    protected void clearAccountView(Context ctx, String entryTableName, List<String> billIds) throws BOSException, EASBizException {
        if (billIds.isEmpty()) {
            return;
        }
        StringBuffer sqlBuff = new StringBuffer();
        sqlBuff.append("update " + entryTableName + "\r\n");
        sqlBuff.append("set FaccountviewInId = null,FaccountviewOutId=null\r\n");
        sqlBuff.append("where FparentId in (" + this.getIdCondition(billIds) + ")");
        DBUtil.executeUpdate((Context)ctx, (String)sqlBuff.toString(), null);
    }

    private String getIdCondition(List<String> idList) {
        StringBuffer ids = new StringBuffer();
        int size = idList.size();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                ids.append("'" + idList.get(i) + "'");
                continue;
            }
            ids.append(",'" + idList.get(i) + "'");
        }
        return ids.toString();
    }
}

