/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.util.KsqlUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.dataloader.DefaultDataCache;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryInfo;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class SCMAuditCheckProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 1L;
    protected static final int INT_YEAR = 0;
    protected static final int INT_PERIOD = 1;
    private String mainTableName = null;

    public SCMAuditCheckProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SCMAuditCheckProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public SCMAuditCheckProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public SCMAuditCheckProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        if (!BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            return;
        }
        if (batchResults == null) {
            return;
        }
        IObjectCollection collection = batchResults.getObjCollection();
        if (collection == null || collection.size() <= 0) {
            return;
        }
        SCMBillBaseInfo info = null;
        for (int i = 0; i < collection.size(); ++i) {
            info = (SCMBillBaseInfo)collection.getObject(i);
            this.checkEntryStorage(this.ctx, info);
            this.checkEntryCompany(this.ctx, info);
        }
        this.mainTableName = this.getMainTableName(this.ctx, this.bosType);
        ArrayList sqlList = new ArrayList();
        for (int i = 0; i < collection.size(); ++i) {
            info = (SCMBillBaseInfo)collection.getObject(i);
            this.doPeriod(this.ctx, info, sqlList);
            this.doPurlocalAmount(this.ctx, info, sqlList);
            this.doCostAdjustActualCost(this.ctx, info, sqlList);
        }
        if (sqlList != null && sqlList.size() > 0) {
            String[] sqlarr = new String[sqlList.size()];
            sqlList.toArray(sqlarr);
            KsqlUtil.executeBatch((Context)this.ctx, (String[])sqlarr);
        }
    }

    public String getMainTableName(Context ctx, BOSObjectType bostype) throws EASBizException, BOSException {
        if (bostype == null) {
            return null;
        }
        IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IMetaDataPK pk = imeataLoader.getEntityObjectPK(bostype);
        EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(pk);
        DataTableInfo tableInfo = entityObjectInfo.getTable();
        String tableName = tableInfo.getName();
        return tableName;
    }

    public String getDetailTableName(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            return null;
        }
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        IObjectCollection coll = (IObjectCollection)aSCMBillBaseInfo.get("entry");
        if (coll == null || coll.size() == 0) {
            return null;
        }
        IObjectValue entryValue = coll.getObject(0);
        IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IMetaDataPK pk = imeataLoader.getEntityObjectPK(entryValue.getBOSType());
        EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(pk);
        DataTableInfo tableInfo = entityObjectInfo.getTable();
        String tableName = tableInfo.getName();
        return tableName;
    }

    private void checkEntryCompany(Context ctx, SCMBillBaseInfo info) throws EASBizException, BOSException {
        if (info instanceof InvBillBaseInfo) {
            InvBillBaseInfo invBill = (InvBillBaseInfo)info;
            StorageOrgUnitInfo headerStorage = invBill.getStorageOrgUnit();
            CompanyOrgUnitInfo souDelegateCou = this.getSouDelegateCou(headerStorage);
            if (souDelegateCou == null) {
                throw new SCMBillException(SCMBillException.STORAGE_ENTRUST_COU_NULL, new Object[]{headerStorage.getName()});
            }
            IObjectCollection iObjectCollection = (IObjectCollection)invBill.get("entry");
            InvBillBaseEntryInfo inventry = null;
            if (iObjectCollection != null && iObjectCollection.size() > 0) {
                int size = iObjectCollection.size();
                for (int i = 0; i < size; ++i) {
                    inventry = (InvBillBaseEntryInfo)iObjectCollection.getObject(0);
                    if (inventry.getCompanyOrgUnit() != null && inventry.getCompanyOrgUnit().getId().toString().equals(souDelegateCou.getId().toString())) continue;
                    throw new SCMBillException(SCMBillException.ENTRYCOMPANYERROR, new Object[]{invBill.getNumber()});
                }
            }
        }
    }

    private void checkEntryStorage(Context ctx, SCMBillBaseInfo info) throws SCMBillException {
        if (info instanceof InvBillBaseInfo) {
            InvBillBaseInfo invBill = (InvBillBaseInfo)info;
            StorageOrgUnitInfo headerStorage = invBill.getStorageOrgUnit();
            StorageOrgUnitInfo entryStorage = null;
            IObjectCollection iObjectCollection = (IObjectCollection)invBill.get("entry");
            InvBillBaseEntryInfo aInvBillBaseEntryInfo = null;
            if (iObjectCollection != null && iObjectCollection.size() > 0) {
                int size = iObjectCollection.size();
                for (int i = 0; i < size; ++i) {
                    aInvBillBaseEntryInfo = (InvBillBaseEntryInfo)iObjectCollection.getObject(0);
                    entryStorage = aInvBillBaseEntryInfo.getStorageOrgUnit();
                    if (entryStorage != null && entryStorage.getId().toString().equals(headerStorage.getId().toString())) continue;
                    throw new SCMBillException(SCMBillException.ENTRYSTORAGEERROR, new Object[]{invBill.getNumber()});
                }
            }
        }
    }

    private void doCostAdjustActualCost(Context ctx, SCMBillBaseInfo info, List sqlList) {
        if (info.getBillType() != null && info.getBillType().getId() != null && "3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(info.getBillType().getId().toString())) {
            StringBuffer sql = new StringBuffer();
            sql.append(" UPDATE T_CL_COSTADJUSTBILLENTRY SET FACTUALCOST = FAMOUNT WHERE FPARENTID = '");
            sql.append(info.getId().toString()).append("';");
            sqlList.add(sql.toString());
        }
    }

    private void doPurlocalAmount(Context ctx, SCMBillBaseInfo info, List sqlList) {
        if (info.getBillType() != null && info.getBillType().getId() != null && "50957179-0105-1000-e000-015fc0a812fd463ED552".equals(info.getBillType().getId().toString())) {
            StringBuffer sql = new StringBuffer();
            sql.append(" UPDATE T_IM_PURINWAREHSENTRY SET FLOCALAMOUNT  = FPURCHASECOST WHERE FPARENTID = '");
            sql.append(info.getId().toString()).append("';");
            sqlList.add(sql.toString());
        }
    }

    private void doPeriod(Context ctx, SCMBillBaseInfo info, List sqlList) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        if (info.getBizDate() != null) {
            Date item = info.getBizDate();
            info.setBizDate((Date)SCMUtils.getDayStartTime((Date)item));
        }
        if (info.getBillType() != null && info.getBillType().getId() != null && !"XlazxwEREADgAAAJwKgSxUY+1VI=".equals(info.getBillType().getId().toString())) {
            int[] period = this.convertBizPeriod(ctx, (IObjectValue)info);
            sql.append(" update ").append(this.mainTableName).append(" set  fyear = ").append(period[0]).append(",");
            sql.append(" fperiod = ").append(period[1]).append(" where ");
            sql.append(" fid = '").append(info.getId().toString()).append("';");
        }
        if (sql.length() > 0) {
            sqlList.add(sql.toString());
        }
    }

    protected CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        SCMBillBaseInfo invBillBaseInfo = (SCMBillBaseInfo)model;
        IObjectCollection iObjectCollection = (IObjectCollection)invBillBaseInfo.get("entry");
        if (iObjectCollection != null && iObjectCollection.size() > 0) {
            SCMBillEntryBaseInfo aInvBillBaseEntryInfo = (SCMBillEntryBaseInfo)iObjectCollection.getObject(0);
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = (CompanyOrgUnitInfo)aInvBillBaseEntryInfo.get("companyOrgUnit");
            return aCompanyOrgUnitInfo;
        }
        return null;
    }

    protected int[] convertBizPeriod(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        SCMBillBaseInfo v = (SCMBillBaseInfo)model;
        if (v.getBizDate() == null) {
            throw new SCMBillException(SCMBillException.BIZDATEISNULL);
        }
        int[] period = new int[]{2199, 1};
        CompanyOrgUnitInfo company = this.getCompanyOrgUnit(ctx, (IObjectValue)v);
        if (company != null && company.getId() != null) {
            PeriodInfo pInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)v.getBizDate(), (CompanyOrgUnitInfo)company);
            if (pInfo != null && pInfo.getPeriodYear() > 0 && pInfo.getPeriodNumber() > 0) {
                period[0] = pInfo.getPeriodYear();
                period[1] = pInfo.getPeriodNumber();
            } else {
                InvBillBaseInfo aInvBillBaseInfo;
                boolean isStartBill = false;
                if (v instanceof InvBillBaseInfo && (aInvBillBaseInfo = (InvBillBaseInfo)v).isIsInitBill()) {
                    isStartBill = true;
                }
                if (isStartBill) {
                    PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)company);
                    if (currPeriodInfo == null) {
                        throw new SCMBillException(SCMBillException.CURRENTPERIODISNULL);
                    }
                    int startYear = currPeriodInfo.getPeriodYear();
                    int startNumber = currPeriodInfo.getPeriodNumber();
                    if (startNumber == 1) {
                        startNumber = 12;
                    }
                    period[0] = --startYear;
                    period[1] = --startNumber;
                } else if (!(model instanceof PurOrderInfo) && !(model instanceof SaleOrderInfo)) {
                    throw new SCMBillException(SCMBillException.GETBIZPERIODFAIL);
                }
            }
        } else {
            Calendar cal = Calendar.getInstance();
            cal.setTime(v.getBizDate());
            period[0] = cal.get(1);
            period[1] = cal.get(2);
        }
        return period;
    }

    protected CompanyOrgUnitInfo getSouDelegateCou(StorageOrgUnitInfo info) throws BOSException, EASBizException {
        if (null == info || info.getId() == null) {
            return null;
        }
        IDataCache dataCache = this.getDataCacheFromContext();
        if (dataCache.contain(info.getId().toString(), DataTypeEnum.MAINORGUNIT_2_COMPANY)) {
            return (CompanyOrgUnitInfo)dataCache.get(info.getId().toString(), DataTypeEnum.MAINORGUNIT_2_COMPANY);
        }
        CompanyOrgUnitInfo cou = null;
        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx);
        OrgUnitCollection orgCol = iOrgUnitRelation.getToUnit(info.getId().toString(), 4, 1);
        if (orgCol != null && orgCol.size() > 0) {
            cou = (CompanyOrgUnitInfo)orgCol.get(0);
        }
        dataCache.put(info.getId().toString(), cou, DataTypeEnum.MAINORGUNIT_2_COMPANY);
        return cou;
    }

    protected IDataCache getDataCacheFromContext() {
        DefaultDataCache result = null;
        ExecuteContext executeContext = this.getExecuteContext();
        if (executeContext != null) {
            ApplicationContext applicationContext = executeContext.getApplicationContext();
            result = (IDataCache)applicationContext.getData("CONTEXT_KEY_DATACACHE");
        }
        if (result == null) {
            result = new DefaultDataCache();
        }
        return result;
    }
}

