/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.adv.chain.app.BizChainLogger;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.app.bizprocess.beans.BeanFactory;
import com.kingdee.eas.scm.common.app.bizprocess.processor.AbstractSCMBusinessProcessor;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.framework.validator.ValidationUtils;
import java.util.List;
import org.apache.log4j.Logger;

public class SCMBizRuleCheckProcessor
extends AbstractSCMBusinessProcessor {
    private static final long serialVersionUID = 3177054098560515106L;
    private static final Logger logger1 = CoreUIObject.getLogger(SCMBizRuleCheckProcessor.class);

    public SCMBizRuleCheckProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public SCMBizRuleCheckProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public SCMBizRuleCheckProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        BizChainLogger logger = null;
        if (this.getExecuteContext() != null) {
            logger = this.getExecuteContext().getLogger();
        }
        List<IVRule> vRuleList = BeanFactory.getVRuleList(this.ctx, this.bosType, this.batchAction);
        IDataCache dataCache = this.getDataCacheFromContext();
        IObjectCollection objCol = batchResults.getToDoResults().getObjCollection();
        if (objCol.size() == 1) {
            ValidationUtils.validate((IObjectValue)objCol.getObject(0), vRuleList, (IDataCache)dataCache, (BizChainLogger)logger);
            return;
        }
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            try {
                ValidationUtils.validate((IObjectValue)objCol.getObject(i), vRuleList, (IDataCache)dataCache, (BizChainLogger)logger);
                continue;
            }
            catch (EASBizException ex) {
                String id = objCol.getObject(i).get("id").toString();
                batchResults.addError(id, (Exception)((Object)ex));
            }
        }
    }
}

