/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.IORMappingDAO;
import com.kingdee.bos.dao.ormapping.ORMappingDAO;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.IMaterialPlan;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPlanCollection;
import com.kingdee.eas.basedata.master.material.MaterialPlanFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMNumberHelper;
import com.kingdee.eas.scm.framework.dataloader.DefaultDataCache;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.scm.sd.sale.SaleOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class SCMCommonBizMethodProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -5924650260718070617L;
    protected static final int INT_YEAR = 0;
    protected static final int INT_PERIOD = 1;
    Map numberMap = new HashMap();

    public SCMCommonBizMethodProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SCMCommonBizMethodProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public SCMCommonBizMethodProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    protected abstract void doProcessing(BatchActionResults var1) throws BOSException, EASBizException;

    protected abstract CompanyOrgUnitInfo getCompanyOrgUnit(Context var1, IObjectValue var2) throws BOSException, EASBizException;

    protected OrgUnitInfo getMainBizOrgUnit(Context ctx, CoreBillBaseInfo model) {
        if (model.get(model.getBizOrgPropertyName()) != null) {
            return (OrgUnitInfo)model.get(model.getBizOrgPropertyName());
        }
        return (OrgUnitInfo)ctx.get((Object)this.getMainBizOrgType());
    }

    protected Map getCompanyInfos(String[] orgIds, OrgType fromType, OrgType toType) throws BOSException, EASBizException {
        HashMap<String, Object> couMap = new HashMap<String, Object>(orgIds.length);
        HashSet<String> souIdSet = new HashSet<String>(orgIds.length);
        int length = orgIds.length;
        for (int i = 0; i < length && orgIds[i] != null; ++i) {
            couMap.put(orgIds[i].toString(), null);
            souIdSet.add(orgIds[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("toUnit"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fromUnit", souIdSet, CompareType.INCLUDE));
        filter.appendFilterItem("typeRelation.fromType", (Object)new Integer(fromType.getValue()));
        filter.appendFilterItem("typeRelation.toType", (Object)new Integer(toType.getValue()));
        filter.setMaskString("#0 and #1 and #2");
        view.setFilter(filter);
        view.getSelector().add("toUnit.id");
        view.getSelector().add("fromUnit.id");
        OrgUnitRelationCollection ourCol = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx).getOrgUnitRelationCollection(view);
        if (ourCol.size() > 0) {
            HashSet<BOSUuid> couIdSet = new HashSet<BOSUuid>(ourCol.size());
            int size = ourCol.size();
            for (int i = 0; i < size; ++i) {
                OrgUnitRelationInfo ourInfo = ourCol.get(i);
                couMap.put(ourInfo.getFromUnit().getId().toString(), ourInfo.getToUnit().getId());
                couIdSet.add(ourInfo.getToUnit().getId());
            }
            FilterInfo couFilter = new FilterInfo();
            couFilter.getFilterItems().add(new FilterItemInfo("id", couIdSet, CompareType.INCLUDE));
            EntityViewInfo couView = new EntityViewInfo();
            couView.setFilter(couFilter);
            CompanyOrgUnitCollection couCol = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitCollection(couView);
            HashMap<BOSUuid, CompanyOrgUnitInfo> couMap2 = new HashMap<BOSUuid, CompanyOrgUnitInfo>();
            int size2 = couCol.size();
            for (int i = 0; i < size2; ++i) {
                couMap2.put(couCol.get(i).getId(), couCol.get(i));
            }
            for (Object key : couMap.keySet()) {
                if (couMap.get(key) == null) continue;
                couMap.put((String)key, couMap2.get(couMap.get(key)));
            }
        }
        return couMap;
    }

    protected OrgType getMainBizOrgType() {
        return null;
    }

    protected String getBindingProperty(Context ctx) throws BOSException {
        return null;
    }

    protected HashMap getNumberRuleSet(Context ctx, SCMBillBaseInfo aSCMBillBaseInfo, String strCompanyID) throws EASBizException, BOSException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        HashMap<String, Boolean> hs = new HashMap<String, Boolean>();
        boolean isExist = false;
        boolean isNotAddView = false;
        String strBindProp = this.getBindingProperty(ctx);
        if (strBindProp != null && strBindProp.trim().length() > 0) {
            if (iCodingRuleManager.isExist((IObjectValue)aSCMBillBaseInfo, strCompanyID, strBindProp)) {
                isExist = true;
                if (!iCodingRuleManager.isAddView((IObjectValue)aSCMBillBaseInfo, strCompanyID, strBindProp)) {
                    isNotAddView = true;
                }
            }
        } else if (iCodingRuleManager.isExist((IObjectValue)aSCMBillBaseInfo, strCompanyID)) {
            isExist = true;
            if (!iCodingRuleManager.isAddView((IObjectValue)aSCMBillBaseInfo, strCompanyID)) {
                isNotAddView = true;
            }
        }
        hs.put("isExist", isExist);
        hs.put("isNotAddView", isNotAddView);
        return hs;
    }

    public boolean isAutoNum() {
        return true;
    }

    protected Object getBindingPropertyValue(SCMBillBaseInfo aSCMBillBaseInfo) {
        return null;
    }

    protected boolean isCheckCloseAccount() throws EASBizException, BOSException {
        return false;
    }

    protected IORMappingDAO getDAO(Context ctx, Connection cn) throws BOSException {
        return ORMappingDAO.getInstance((BOSObjectType)this.bosType, (Context)ctx, (Connection)cn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean exists(Context ctx, IObjectPK pk) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            boolean bl = this.getDAO(ctx, cn).exists(pk);
            return bl;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean exists(Context ctx, FilterInfo filter) throws BOSException {
        Connection cn = null;
        try {
            cn = this.getConnection(ctx);
            boolean bl = this.getDAO(ctx, cn).exists(filter);
            return bl;
        }
        finally {
            SQLUtils.cleanup((Connection)cn);
        }
    }

    protected Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    protected boolean isAddNew(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        ApplicationContext applicationContext;
        Boolean isadd;
        boolean ret = false;
        ExecuteContext executeContext = this.getExecuteContext();
        if (executeContext != null && (isadd = (Boolean)(applicationContext = executeContext.getApplicationContext()).getData("isAddNew")) != null) {
            return isadd;
        }
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        ret = aSCMBillBaseInfo.getId() == null || aSCMBillBaseInfo.getId().toString().trim().length() == 0 || !this.exists(ctx, (IObjectPK)new ObjectUuidPK(aSCMBillBaseInfo.getId()));
        model.put("isAddNew", (Object)new Boolean(ret));
        if (executeContext != null) {
            ApplicationContext applicationContext2 = executeContext.getApplicationContext();
            applicationContext2.putData("isAddNew", (Object)new Boolean(ret));
        }
        return ret;
    }

    protected String getNewNumber(Context ctx, IObjectValue model, String strCompanyID, String customString) throws BOSException, EASBizException {
        SCMBillBaseInfo info = (SCMBillBaseInfo)model;
        return SCMNumberHelper.getNewNumber((Context)ctx, (IObjectValue)model, (String)strCompanyID, (String)customString, (String)this.getBindingProperty(ctx), (Object)this.getBindingPropertyValue(info));
    }

    protected void checkBizDate4Period(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        int[] period = this.convertBizPeriod(ctx, model);
        SCMBillBaseInfo info = (SCMBillBaseInfo)model;
        int periodYear = period[0];
        int periodMon = period[1];
        if (periodYear != info.getYear() || periodMon != info.getPeriod()) {
            throw new BOSException("bizDate differet period");
        }
    }

    protected boolean isSameNumber(Context ctx, String number) throws EASBizException, BOSException {
        if (number == null || number.length() < 1) {
            return false;
        }
        if (this.numberMap.containsKey(number)) {
            return true;
        }
        this.numberMap.put(number, number);
        return false;
    }

    protected boolean isSameNumber(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        return SCMNumberHelper.isSameNumber((Context)ctx, (IObjectValue)model, (String)this.getBindingProperty(ctx), (Object)this.getBindingPropertyValue((SCMBillBaseInfo)model));
    }

    protected int[] convertBizPeriod(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        SCMBillBaseInfo v = (SCMBillBaseInfo)model;
        if (v.getBizDate() == null) {
            throw new SCMBillException(SCMBillException.BIZDATEISNULL);
        }
        int[] period = new int[]{2199, 1};
        CompanyOrgUnitInfo company = this.getCompanyOrgUnit(ctx, (IObjectValue)v);
        if (company != null && company.getId() != null) {
            PeriodInfo pInfo = PeriodUtils.getPeriodInfo((Context)ctx, (Date)v.getBizDate(), (CompanyOrgUnitInfo)company);
            if (pInfo != null && pInfo.getPeriodYear() > 0 && pInfo.getPeriodNumber() > 0) {
                period[0] = pInfo.getPeriodYear();
                period[1] = pInfo.getPeriodNumber();
            } else {
                InvBillBaseInfo aInvBillBaseInfo;
                boolean isStartBill = false;
                if (v instanceof InvBillBaseInfo && (aInvBillBaseInfo = (InvBillBaseInfo)v).isIsInitBill()) {
                    isStartBill = true;
                }
                if (isStartBill) {
                    PeriodInfo currPeriodInfo = SystemStatusCtrolUtils.getCurrentPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (CompanyOrgUnitInfo)company);
                    if (currPeriodInfo == null) {
                        throw new SCMBillException(SCMBillException.CURRENTPERIODISNULL);
                    }
                    int startYear = currPeriodInfo.getPeriodYear();
                    int startNumber = currPeriodInfo.getPeriodNumber();
                    if (startNumber == 1) {
                        startNumber = 12;
                    }
                    period[0] = --startYear;
                    period[1] = --startNumber;
                } else if (!(model instanceof PurOrderInfo) && !(model instanceof SaleOrderInfo)) {
                    throw new SCMBillException(SCMBillException.GETBIZPERIODFAIL);
                }
            }
        }
        return period;
    }

    protected abstract String getEntryName();

    protected boolean isNeedSepcialParam() {
        return false;
    }

    public Map getMatCompanyInfoCollection(String[] materialIDS, String[] OrgIDs) throws BOSException {
        if (null == materialIDS || null == OrgIDs || materialIDS.length != OrgIDs.length || materialIDS.length == 0) {
            return new HashMap();
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashMap<String, MaterialCompanyInfoInfo> matCompany = new HashMap<String, MaterialCompanyInfoInfo>();
        String key = "";
        MaterialCompanyInfoInfo materialCompanyInfoInfo = null;
        IMaterialCompanyInfo iMaterialCompany = MaterialCompanyInfoFactory.getLocalInstance((Context)this.ctx);
        if (materialIDS != null && OrgIDs != null) {
            int size = materialIDS.length;
            for (int i = 0; i < size; ++i) {
                if (materialIDS[i] == null || OrgIDs[i] == null) continue;
                filter.appendFilterItem("company", (Object)OrgIDs[i]);
                filter.appendFilterItem("mateial", (Object)materialIDS[i]);
                filter.appendFilterItem("status", (Object)new Integer(UsedStatusEnum.APPROVED.getValue()));
            }
            StringBuffer maskString = new StringBuffer(filter.getFilterItems().size() * 13);
            int size2 = filter.getFilterItems().size();
            for (int i = 0; i < size2; i += 3) {
                maskString.append("(#").append(i).append(" and #").append(i + 1).append(" and #");
                maskString.append(i + 2).append(") or ");
            }
            int length = maskString.length();
            maskString = length > 0 ? maskString.delete(length - 4, length) : maskString;
            filter.setMaskString(maskString.toString());
            viewInfo.setFilter(filter);
            MaterialCompanyInfoCollection coll = iMaterialCompany.getMaterialCompanyInfoCollection(viewInfo);
            if (coll != null) {
                for (int j = 0; j < coll.size(); ++j) {
                    materialCompanyInfoInfo = coll.get(j);
                    if (materialCompanyInfoInfo == null || materialCompanyInfoInfo.getMateial() == null || materialCompanyInfoInfo.getCompany() == null) continue;
                    key = materialCompanyInfoInfo.getMateial().getId().toString() + materialCompanyInfoInfo.getCompany().getId().toString();
                    matCompany.put(key, materialCompanyInfoInfo);
                }
            }
        }
        return matCompany;
    }

    protected Map getMaterialInventoryCollection(String[] materialIDS, String[] orgIDs) throws BOSException {
        if (null == materialIDS || null == orgIDs || materialIDS.length != orgIDs.length || materialIDS.length == 0) {
            return new HashMap();
        }
        HashMap<String, MaterialInventoryInfo> matInventory = new HashMap<String, MaterialInventoryInfo>();
        EntityViewInfo view = new EntityViewInfo();
        MaterialInventoryInfo materialInventoryInfo = null;
        String key = "";
        FilterInfo filter = new FilterInfo();
        StringBuffer sb = new StringBuffer();
        IMaterialInventory iMaterialInventory = MaterialInventoryFactory.getLocalInstance((Context)this.ctx);
        if (materialIDS != null && orgIDs != null) {
            int size = materialIDS.length;
            for (int i = 0; i < size; ++i) {
                if (materialIDS[i] == null || orgIDs[i] == null) continue;
                filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialIDS[i], CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)orgIDs[i], CompareType.EQUALS));
                if (sb.length() > 0) {
                    sb.append(" OR ");
                }
                sb.append("(#").append(filter.getFilterItems().size() - 2).append(" AND #").append(filter.getFilterItems().size() - 1).append(")");
            }
            if (sb.length() > 0) {
                filter.setMaskString(sb.toString());
                view.setFilter(filter);
                MaterialInventoryCollection coll = iMaterialInventory.getMaterialInventoryCollection(view);
                if (coll != null) {
                    for (int j = 0; j < coll.size(); ++j) {
                        materialInventoryInfo = coll.get(j);
                        if (materialInventoryInfo == null || materialInventoryInfo.getMaterial() == null || materialInventoryInfo.getOrgUnit() == null) continue;
                        key = materialInventoryInfo.getMaterial().getId().toString() + materialInventoryInfo.getOrgUnit().getId().toString();
                        matInventory.put(key, materialInventoryInfo);
                    }
                }
            }
        }
        return matInventory;
    }

    protected Map getMaterialInventoryCollection(Set materialIDS, String[] orgIDs) throws BOSException {
        if (materialIDS == null) {
            return new HashMap();
        }
        String[] matIDS = new String[materialIDS.size()];
        int i = 0;
        Iterator it = materialIDS.iterator();
        while (it.hasNext()) {
            matIDS[i++] = (String)it.next();
        }
        return this.getMaterialInventoryCollection(matIDS, orgIDs);
    }

    public Map getMaterialPlanCollec(String[] materialIDS, String[] orgIDs) throws BOSException {
        if (null == materialIDS || null == orgIDs || materialIDS.length != orgIDs.length || materialIDS.length == 0) {
            return new HashMap();
        }
        HashMap<String, MaterialPlanInfo> matPlans = new HashMap<String, MaterialPlanInfo>();
        MaterialPlanInfo matPlanInfo = null;
        IMaterialPlan iMatPlan = MaterialPlanFactory.getLocalInstance((Context)this.ctx);
        int size = materialIDS.length;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String mateID = "";
        String orgID = "";
        String mskStr = "";
        String key = "";
        StringBuffer storageId = new StringBuffer();
        StringBuffer materialId = new StringBuffer();
        int reaSize = 0;
        boolean isNeedSelect = false;
        if (materialIDS != null) {
            for (int i = 0; i < size; ++i) {
                mateID = materialIDS[i];
                orgID = orgIDs[i];
                if (mateID == null || orgID == null) continue;
                storageId.append(orgID).append(",");
                materialId.append(mateID).append(",");
                ++reaSize;
                isNeedSelect = true;
            }
            if (storageId != null && storageId.length() > 0) {
                storageId.setLength(storageId.length() - 1);
            }
            if (materialId != null && materialId.length() > 0) {
                materialId.setLength(materialId.length() - 1);
            }
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId.toString(), CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)storageId.toString(), CompareType.INCLUDE));
            view.setFilter(filter);
            if (isNeedSelect) {
                MaterialPlanCollection coll = iMatPlan.getMaterialPlanCollection(view);
                for (int j = 0; j < coll.size(); ++j) {
                    matPlanInfo = coll.get(j);
                    if (matPlanInfo == null || matPlanInfo.getMaterial() == null || matPlanInfo.getOrgUnit() == null) continue;
                    key = matPlanInfo.getMaterial().getId().toString() + matPlanInfo.getOrgUnit().getId().toString();
                    matPlans.put(key, matPlanInfo);
                }
            }
        }
        return matPlans;
    }

    protected IDataCache getDataCacheFromContext() {
        DefaultDataCache result = null;
        ExecuteContext executeContext = this.getExecuteContext();
        if (executeContext != null) {
            ApplicationContext applicationContext = executeContext.getApplicationContext();
            result = (IDataCache)applicationContext.getData("CONTEXT_KEY_DATACACHE");
        }
        if (result == null) {
            result = new DefaultDataCache();
        }
        return result;
    }
}

