/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.master.material.IMaterialCompanyInfo;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMCommonData;
import com.kingdee.eas.scm.common.SCMParamFacadeFactory;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.app.bizprocess.processor.SCMCommonBizMethodProcessor;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class SCMCommonDataLoadorProcessor
extends SCMCommonBizMethodProcessor {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.common.app.bizprocess.processor.SCMCommonDataLoadorProcessor");
    protected SCMCommonData commonData = new SCMCommonData();
    private static String[] keys = new String[]{"isUseProjectTrack", "isCloseInsertLot", "isCloseSerialNum", "isCloseReqPlan", "isCloseCredit", "isCloseInvUpdate", "checkDataBeforeInvUpdate", "isRefreshing"};
    private static boolean isFirstLoad = true;
    private static Map sprcialPamam = null;
    protected String[] orgIds = null;
    protected Set materialIDs = new HashSet();

    public SCMCommonDataLoadorProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public SCMCommonDataLoadorProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    @Override
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection collection = batchResults.getObjCollection();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue vo = collection.getObject(i);
            SCMBillBaseInfo scmBillBaseInfo = (SCMBillBaseInfo)vo;
            IObjectCollection entrys = (IObjectCollection)scmBillBaseInfo.get(this.getEntryName());
            SCMBillEntryBaseInfo entry = null;
            for (int j = 0; j < entrys.size(); ++j) {
                entry = (SCMBillEntryBaseInfo)entrys.getObject(j);
                if (entry == null || entry.getMaterial() == null || entry.getMaterial().getId() == null) continue;
                this.materialIDs.add(entry.getMaterial().getId().toString());
            }
        }
        this.loadParam();
        Map orgInfos = SCMGroupServerUtils.getOrgUnitInfos((Context)this.ctx, (String[])this.orgIds);
        this.commonData.setMainOrgUnits(orgInfos);
        ISCMBillCommonFacade scmc = SCMBillCommonFacadeFactory.getLocalInstance((Context)this.ctx);
        Map companys = scmc.getCompanyInfos(this.orgIds, OrgType.getEnum((int)this.getOrgType()), OrgType.Company);
        this.commonData.setCompanys(companys);
        HashSet<String> companyIDs = new HashSet<String>();
        try {
            Set companyInfos = companys.keySet();
            if (companyInfos != null) {
                Iterator it = companyInfos.iterator();
                CompanyOrgUnitInfo companyInfo = null;
                while (it.hasNext()) {
                    String keyid = (String)it.next();
                    companyInfo = (CompanyOrgUnitInfo)companys.get(keyid);
                    if (companyInfo == null || companyInfo.getId() == null) continue;
                    companyIDs.add(companyInfo.getId().toString());
                }
                Map periods = SCMServerUtils.getPeriod((Context)this.ctx, (int)this.getSystemName(), companyIDs);
                this.commonData.setCurrentperiods(periods);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        Map map = this.getMaterialCompnayInfos(this.ctx, this.getMaterialIDs(collection), companyIDs);
        this.commonData.getFetchData().addMapMaterialCompany(map);
        ExecuteContext executeContext = this.getExecuteContext();
        if (executeContext != null) {
            ApplicationContext applicationContext = executeContext.getApplicationContext();
            applicationContext.putData("commonData", (Object)this.commonData);
        }
    }

    protected IObjectCollection getTodoObjectCollection(BatchActionResults batchResults) {
        IObjectCollection result = batchResults.getObjCollection();
        if (null == result) {
            // empty if block
        }
        return result;
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return ProcessorExecutionMode.ORDINAL;
    }

    public Map getMaterialCompnayInfos(Context ctx, Set mateirlaIDs, Set orgIds) throws BOSException {
        HashMap<String, MaterialCompanyInfoInfo> map = new HashMap<String, MaterialCompanyInfoInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mateial.id", (Object)mateirlaIDs, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)orgIds, CompareType.INCLUDE));
        filter.setMaskString("#0 and #1");
        view.setFilter(filter);
        IMaterialCompanyInfo ie = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx);
        MaterialCompanyInfoCollection coll = ie.getMaterialCompanyInfoCollection(view);
        MaterialCompanyInfoInfo mc = null;
        for (int i = 0; i < coll.size(); ++i) {
            mc = coll.get(i);
            if (mc == null || mc.getMateial() == null || mc.getCompany() == null) continue;
            map.put(mc.getMateial().getId().toString() + mc.getCompany().getId().toString(), mc);
        }
        return map;
    }

    protected void loadParam() throws EASBizException, BOSException {
        HashMap<String, Object> paramCondition = new HashMap<String, Object>();
        paramCondition.put("orgType", this.getOrgType());
        paramCondition.put("orgUnitID", this.getOrgIds());
        paramCondition.put("billGroup", this.getBillTypeGroup());
        paramCondition.put("billType", this.billTypeID);
        paramCondition.put("displayHided", Boolean.TRUE);
        Map params = this.getSCMParams(this.ctx, paramCondition);
        this.commonData.getFetchData().setMapParamValue(params);
        if (isFirstLoad) {
            isFirstLoad = false;
            try {
                sprcialPamam = SCMParamFacadeFactory.getLocalInstance((Context)this.ctx).getScmSpecialParams(keys);
            }
            catch (EASBizException e) {
                logger.error((Object)e);
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        this.commonData.getOtherCommonDatas().put("specialParamMap", sprcialPamam);
    }

    public Map getSCMParams(Context ctx, Map condition) throws BOSException, EASBizException {
        HashMap params = new HashMap();
        return params;
    }

    protected Integer getBillTypeGroup() {
        return new Integer(-1);
    }

    protected Integer getOrgType() {
        return new Integer(-1);
    }

    protected String[] getOrgIds() {
        return this.orgIds;
    }

    protected void setOrgIds(String[] orgIds) {
        this.orgIds = orgIds;
    }

    @Override
    protected CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected String getEntryName() {
        return "entry";
    }

    protected int getSystemName() {
        return 0;
    }

    protected Set<String> getMaterialIDs(IObjectCollection collection) {
        HashSet<String> materialIdSet = new HashSet<String>();
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            SCMBillBaseInfo info = (SCMBillBaseInfo)collection.getObject(i);
            IObjectCollection entryCol = info.getEntries();
            int len = entryCol.size();
            for (int j = 0; j < len; ++j) {
                SCMBillEntryBaseInfo entry = (SCMBillEntryBaseInfo)entryCol.getObject(j);
                if (entry.getMaterial() == null) continue;
                materialIdSet.add(entry.getMaterial().getId().toString());
            }
        }
        return materialIdSet;
    }

    protected void setMaterialIDs(Set<String> materialIDs) {
        this.materialIDs = materialIDs;
    }

    protected void setDataCache2Context(IDataCache dataCache) {
        ExecuteContext executeContext = this.getExecuteContext();
        if (executeContext != null) {
            ApplicationContext applicationContext = executeContext.getApplicationContext();
            applicationContext.putData("CONTEXT_KEY_DATACACHE", (Object)dataCache);
        }
    }
}

