/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.BillTypeUtils;
import com.kingdee.eas.scm.common.app.bizprocess.beans.BeanFactory;
import com.kingdee.eas.scm.common.app.bizprocess.processor.AbstractSCMBusinessProcessor;
import com.kingdee.eas.scm.framework.dataloader.DataLoaderUtils;
import com.kingdee.eas.scm.framework.dataloader.DefaultDataCache;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.dataloader.IDataLoader;
import com.kingdee.eas.util.app.DbUtil;
import java.util.List;

public class SCMDataLoaderProcessor
extends AbstractSCMBusinessProcessor {
    private static final long serialVersionUID = 1251049847597768356L;

    public SCMDataLoaderProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public SCMDataLoaderProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public SCMDataLoaderProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection objCol = batchResults.getObjCollection();
        if (BatchActionEnum.SAVE.equals((Object)this.batchAction) || BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) {
            int size = objCol.size();
            for (int i = 0; i < size; ++i) {
                SCMBillBaseInfo info = (SCMBillBaseInfo)objCol.getObject(i);
                this.lockBill(info);
            }
        }
        List<IDataLoader> dataLoaderList = BeanFactory.getDataLoaderList(this.ctx, this.bosType, this.batchAction);
        DefaultDataCache dataCache = new DefaultDataCache();
        DataLoaderUtils.load((IObjectCollection)objCol, dataLoaderList, (IDataCache)dataCache);
        this.setDataCache2Context((IDataCache)dataCache);
    }

    private void lockBill(SCMBillBaseInfo scmBillInfo) throws EASBizException, BOSException {
        try {
            if (scmBillInfo == null || scmBillInfo.getBillType() == null || "3a3b5446-0106-1000-e000-01bcc0a812e6463ED552".equals(scmBillInfo.getBillType().getId().toString())) {
                return;
            }
            String billTable = BillTypeUtils.getBillHeadTableName((Context)this.ctx, (String)scmBillInfo.getBillType().getId().toString());
            if (billTable != null && billTable.length() > 0 && scmBillInfo.getId() != null) {
                String sqlUpdate = " UPDATE " + billTable + " SET FID = FID  WHERE FID = '" + scmBillInfo.getId().toString() + "'";
                DbUtil.execute((Context)this.ctx, (String)sqlUpdate);
            }
        }
        catch (EASBizException e1) {
            throw e1;
        }
        catch (BOSException e2) {
            throw e2;
        }
    }
}

