/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ApplicationContext;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.bizprocess.processor.SCMCommonBizMethodProcessor;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;

public abstract class SCMDefaultValueProcessor
extends SCMCommonBizMethodProcessor {
    private static final long serialVersionUID = -1070597071833810246L;

    public SCMDefaultValueProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SCMDefaultValueProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public SCMDefaultValueProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    @Override
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        if (batchResults == null) {
            return;
        }
        IObjectCollection collection = batchResults.getObjCollection();
        if (collection == null || collection.size() <= 0) {
            return;
        }
        IObjectValue obj = collection.getObject(0);
        boolean isAddN = this.isAddNew(this.ctx, obj);
        ExecuteContext executeContext = this.getExecuteContext();
        if (executeContext != null) {
            ApplicationContext applicationContext = executeContext.getApplicationContext();
            applicationContext.putData("isAddNew", (Object)new Boolean(isAddN));
        }
        Date item = null;
        for (int i = 0; i < collection.size(); ++i) {
            int[] period;
            boolean isAddNew;
            IObjectValue vo = collection.getObject(i);
            SCMBillBaseInfo info = (SCMBillBaseInfo)vo;
            if (BatchActionEnum.SAVE.equals((Object)this.batchAction)) {
                if (info.getCU() == null) {
                    info.setCU(this.getCU(this.ctx, (ObjectBaseInfo)info));
                }
                isAddNew = this.isAddNew(this.ctx, (IObjectValue)info);
                if (info.getNumber() == null || info.getNumber().trim().length() <= 0) {
                    this.setBillNumber(info, isAddNew);
                }
                if (info.getBizDate() != null) {
                    item = info.getBizDate();
                    info.setBizDate((Date)SCMUtils.getDayStartTime((Date)item));
                }
                if (info.getBillType() != null && info.getBillType().getId() != null && !"XlazxwEREADgAAAJwKgSxUY+1VI=".equals(info.getBillType().getId().toString())) {
                    period = this.convertBizPeriod(this.ctx, (IObjectValue)info);
                    info.setYear(period[0]);
                    info.setPeriod(period[1]);
                }
                if (info.getCreator() == null) {
                    info.setCreator(ContextUtil.getCurrentUserInfo((Context)this.ctx));
                }
                if (info.getCreateTime() == null) {
                    ISCMBillCommonFacade iSCMBillCommonFacade = SCMBillCommonFacadeFactory.getLocalInstance((Context)this.ctx);
                    Timestamp t = iSCMBillCommonFacade.getServerDate();
                    info.setCreateTime(t);
                }
            } else if (BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) {
                if (info.getCU() == null) {
                    info.setCU(this.getCU(this.ctx, (ObjectBaseInfo)info));
                }
                isAddNew = this.isAddNew(this.ctx, (IObjectValue)info);
                if (info.getNumber() == null || info.getNumber().trim().length() <= 0) {
                    this.setBillNumber(info, isAddNew);
                }
                if (info.getBizDate() != null) {
                    item = info.getBizDate();
                    info.setBizDate((Date)SCMUtils.getDayStartTime((Date)item));
                }
                if (info.getBillType() == null) {
                    info.setBillType(this.getBillType());
                }
                if (info.getBillType() != null && info.getBillType().getId() != null && !"XlazxwEREADgAAAJwKgSxUY+1VI=".equals(info.getBillType().getId().toString())) {
                    period = this.convertBizPeriod(this.ctx, (IObjectValue)info);
                    info.setYear(period[0]);
                    info.setPeriod(period[1]);
                }
                if (info.isHasEffected()) {
                    info.setHasEffected(false);
                }
            }
            if (isAddN) continue;
            info.setModifier(ContextUtil.getCurrentUserInfo((Context)this.ctx));
            info.setModificationTime(new Timestamp(new Date().getTime()));
        }
    }

    protected abstract BillTypeInfo getBillType();

    private void setBillNumber(SCMBillBaseInfo info, boolean isAddNew) throws BOSException, EASBizException {
        String strCompanyID;
        boolean isExist = false;
        boolean isNotAddView = false;
        OrgUnitInfo mainOrg = this.getMainBizOrgUnit(this.ctx, (CoreBillBaseInfo)info);
        String string = strCompanyID = mainOrg != null ? mainOrg.getId().toString() : null;
        if (this.isAutoNum() && (info.getNumber() == null || info.getNumber().toString().equals(""))) {
            HashMap hs = this.getNumberRuleSet(this.ctx, info, strCompanyID);
            isExist = (Boolean)hs.get("isExist");
            isNotAddView = (Boolean)hs.get("isNotAddView");
            if (info.isBotpCallSave() && !isExist) {
                this.setNewNumberWhenBotpBill(this.ctx, info);
            } else {
                this.setBillNewNumber(this.ctx, (IObjectValue)info, isAddNew, isNotAddView, strCompanyID);
            }
        }
    }

    protected void setBillNewNumber(Context ctx, IObjectValue model, boolean isAddNew, boolean isRuleAutoNumber, String strCompanyID) throws BOSException, EASBizException {
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        if (isAddNew) {
            if (isRuleAutoNumber || aSCMBillBaseInfo.getId() == null) {
                aSCMBillBaseInfo.setNumber(this.getNewNumber(ctx, (IObjectValue)aSCMBillBaseInfo, strCompanyID, ""));
            } else if (aSCMBillBaseInfo.getId() != null) {
                aSCMBillBaseInfo.setNumber(this.getNewNumber(ctx, (IObjectValue)aSCMBillBaseInfo, strCompanyID, ""));
            }
        }
    }

    protected void setNewNumberWhenBotpBill(Context ctx, SCMBillBaseInfo info) throws BOSException, EASBizException {
        if (info.getNumber() == null || info.getNumber().trim().length() == 0) {
            if (info.getId() != null) {
                info.setNumber("AutoNumberFromBTP_" + info.getId().toString());
            } else {
                info.setNumber("AutoNumberFromBTP_" + BOSUuid.create((BOSObjectType)info.getBOSType()));
            }
        }
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return ProcessorExecutionMode.ORDINAL;
    }

    protected boolean check(BatchActionResults batchResults) throws EASBizException, BOSException {
        boolean isOk = super.check(batchResults);
        if (!isOk) {
            return isOk;
        }
        IObjectCollection objCol = batchResults.getObjCollection();
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            SCMBillBaseInfo info = (SCMBillBaseInfo)objCol.getObject(i);
            if (info.getObjectValue(info.getBizOrgPropertyName()) != null) continue;
            String id = info.getId() == null ? "NEWID" : info.getId().toString();
            throw new SCMBillException(SCMBillException.NOMAINBIZORG);
        }
        return batchResults.getToDoIdsArray().length > 0;
    }

    protected CtrlUnitInfo getCU(Context ctx, ObjectBaseInfo model) {
        OrgUnitInfo mainOrg = this.getMainBizOrgUnit(ctx, (CoreBillBaseInfo)model);
        if (mainOrg != null) {
            if (mainOrg.getCU() == null) {
                try {
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add(new SelectorItemInfo("id"));
                    sic.add(new SelectorItemInfo("name"));
                    sic.add(new SelectorItemInfo("number"));
                    sic.add(new SelectorItemInfo("CU.id"));
                    mainOrg = FullOrgUnitFactory.getLocalInstance((Context)ctx).getOrgUnitInfo((IObjectPK)new ObjectUuidPK(mainOrg.getId().toString()), sic);
                }
                catch (Exception e) {
                    return ContextUtil.getCurrentCtrlUnit((Context)ctx);
                }
            }
            return mainOrg.getCU();
        }
        return ContextUtil.getCurrentCtrlUnit((Context)ctx);
    }
}

