/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.dynbusiness.app.processor.SubmitBusinessProcessor;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import java.util.List;

public class SaveOrSubmitBillProcessor
extends SubmitBusinessProcessor {
    private static final long serialVersionUID = -7141107733649983041L;

    public SaveOrSubmitBillProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public SaveOrSubmitBillProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public SaveOrSubmitBillProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected boolean check(BatchActionResults batchResults) throws EASBizException, BOSException {
        return batchResults.hasToDos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        int i;
        this.ctx.remove((Object)"CONTEXT_KEY_CALLBACK_4_DAO");
        this.ctx.put((Object)"CONTEXT_KEY_CALLBACK_4_DAO", (Object)Boolean.TRUE);
        IObjectCollection objCol = batchResults.getObjCollection();
        IObjectValue obj = null;
        for (i = 0; i < objCol.size(); ++i) {
            obj = objCol.getObject(i);
            obj.put("CONTEXT_KEY_CALLBACK_4_DAO", (Object)true);
        }
        try {
            this.invokeBusinessMethod(batchResults);
        }
        finally {
            this.ctx.put((Object)"CONTEXT_KEY_CALLBACK_4_DAO", null);
            objCol = batchResults.getObjCollection();
            for (i = 0; i < objCol.size(); ++i) {
                obj = objCol.getObject(i);
                obj.remove("CONTEXT_KEY_CALLBACK_4_DAO");
            }
        }
    }

    private void invokeBusinessMethod(BatchActionResults batchResults) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] paramsEntry = batchResults.getParamEntries();
        IBTPManager iBtpManager = BTPManagerFactory.getLocalInstance((Context)this.ctx);
        IObjectCollection collection = batchResults.getObjCollection();
        List toList = batchResults.getToDoIdsList();
        boolean hasRelation = paramsEntry.length > 0 && paramsEntry[0].getParamTypes().length > 1 && BOTRelationCollection.class.equals((Object)paramsEntry[0].getParamTypes()[1]);
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            String id;
            SCMBillBaseInfo info = (SCMBillBaseInfo)collection.getObject(i);
            String string = id = info.getId() == null ? "NEWID" : info.getId().toString();
            if (toList.indexOf(id) <= -1) continue;
            try {
                BOTRelationCollection relations = null;
                if (hasRelation) {
                    relations = (BOTRelationCollection)batchResults.getParamEntries()[i].get(1);
                }
                if (relations == null) {
                    relations = "NEWID".equals(id) ? new BOTRelationCollection() : iBtpManager.getRelationCollection(id);
                }
                IObjectPK pk = null;
                if (BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) {
                    pk = iBtpManager.submitRelations((CoreBillBaseInfo)info, relations);
                } else if (BatchActionEnum.SAVE.equals((Object)this.batchAction)) {
                    pk = iBtpManager.saveRelations((CoreBillBaseInfo)info, relations);
                }
                if (!id.equals("NEWID") || pk == null) continue;
                batchResults.replaceNewId(pk.toString());
                continue;
            }
            catch (EASBizException e) {
                batchResults.addError(id, (Exception)((Object)e));
                throw e;
            }
        }
    }
}

