/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class UpdateBillStatusProcess
extends AbstractBusinessProcessor {
    protected static SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final long serialVersionUID = 3633769885728760074L;
    private static final Map<String, String> bosType2Table = new HashMap<String, String>();

    public UpdateBillStatusProcess(ExecuteContext executeContext) {
        super(executeContext);
    }

    public UpdateBillStatusProcess(ProcessorConstructParam param) {
        super(param);
    }

    public UpdateBillStatusProcess(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection objCol = batchResults.getObjCollection();
        if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            this.updateAuditStatus(this.ctx, objCol);
        } else if (BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            this.updateUnAuditStatus(this.ctx, objCol);
        } else {
            throw new BOSException("not supported ... (" + this.batchAction.getBizAction() + ").");
        }
    }

    protected void updateAuditStatus(Context ctx, IObjectCollection billCol) throws EASBizException, BOSException {
        if (null == billCol || billCol.size() == 0) {
            return;
        }
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = user.getId().toString();
        int status = 4;
        String auditTime = simpleDateFormat.format(new Date());
        StringBuilder idStr = new StringBuilder();
        String tableName = this.getMainTableName(ctx, billCol.getObject(0));
        if (tableName == null) {
            throw new BOSException("table name is null!");
        }
        this.checkBillStatus(ctx, billCol, tableName, true);
        int size = billCol.size();
        for (int i = 0; i < size; ++i) {
            SCMBillBaseInfo scmBillInfo = (SCMBillBaseInfo)billCol.getObject(i);
            scmBillInfo.setAuditor(user);
            scmBillInfo.setAuditTime(new Timestamp(new Date().getTime()));
            scmBillInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
            idStr.append("'").append(scmBillInfo.getId().toString()).append("',");
        }
        idStr.setLength(idStr.length() - 1);
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ").append(tableName).append(" SET FBaseStatus = ").append(status).append(", ").append(" FAuditorID = '").append(userId).append("', ").append(" FAuditTime = {ts '").append(auditTime).append("'} ").append(" WHERE FID IN (").append(idStr.toString()).append(") ");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    protected void updateUnAuditStatus(Context ctx, IObjectCollection billCol) throws EASBizException, BOSException {
        if (null == billCol || billCol.size() == 0) {
            return;
        }
        int status = 1;
        StringBuilder idStr = new StringBuilder();
        String tableName = this.getMainTableName(ctx, billCol.getObject(0));
        if (tableName == null) {
            throw new BOSException("table name is null!");
        }
        this.checkBillStatus(ctx, billCol, tableName, false);
        int size = billCol.size();
        for (int i = 0; i < size; ++i) {
            SCMBillBaseInfo scmBillInfo = (SCMBillBaseInfo)billCol.getObject(i);
            scmBillInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
            scmBillInfo.setAuditor(null);
            scmBillInfo.setAuditTime(null);
            idStr.append("'").append(scmBillInfo.getId().toString()).append("',");
        }
        idStr.setLength(idStr.length() - 1);
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ").append(tableName).append(" SET FBaseStatus = ").append(status).append(", ").append(" FAuditorID = null,").append(" FAuditTime = null ").append(" WHERE FID IN (").append(idStr.toString()).append(") ");
        DbUtil.execute((Context)ctx, (String)sb.toString());
    }

    private String getMainTableName(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            return null;
        }
        String bosType = model.getBOSType().toString();
        if (bosType2Table.containsKey(bosType)) {
            return bosType2Table.get(bosType);
        }
        IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IMetaDataPK pk = imeataLoader.getEntityObjectPK(model.getBOSType());
        EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(pk);
        DataTableInfo tableInfo = entityObjectInfo.getTable();
        String tableName = tableInfo.getName();
        bosType2Table.put(bosType, tableName);
        return tableName;
    }

    private void checkBillStatus(Context ctx, IObjectCollection billCol, String tableName, boolean isAudit) throws BOSException, EASBizException {
        SCMBillBaseInfo scmBillInfo;
        for (int i = 0; i < billCol.size() && (scmBillInfo = (SCMBillBaseInfo)billCol.getObject(i)) instanceof InvBillBaseInfo; ++i) {
            String sql = "select FBaseStatus from " + tableName + " where fid = ?";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{scmBillInfo.getId().toString()});
            try {
                if (!rs.next()) continue;
                if (isAudit && 4 == rs.getInt("FBaseStatus")) {
                    throw new SCMBillException(SCMBillException.CHECKAUDITEDOK);
                }
                if (isAudit || 4 == rs.getInt("FBaseStatus")) continue;
                throw new SCMBillException(SCMBillException.CHECK_UNAUDIT);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
    }
}

