/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import java.util.HashMap;
import java.util.Map;

public class UpdateEntryStatusProcess
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 3967238900388529015L;
    private static final Map<String, String> bosType2Table = new HashMap<String, String>();

    public UpdateEntryStatusProcess(ProcessorConstructParam param) {
        super(param);
    }

    public UpdateEntryStatusProcess(ExecuteContext executeContext) {
        super(executeContext);
    }

    public UpdateEntryStatusProcess(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        EntryBaseStatusEnum entryStatus;
        if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            entryStatus = EntryBaseStatusEnum.AUDITED;
        } else if (BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            entryStatus = EntryBaseStatusEnum.TEMPORARILYSAVED;
        } else if (BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) {
            entryStatus = EntryBaseStatusEnum.SUBMITED;
        } else {
            throw new BOSException("not supported ... (" + this.batchAction.getBizAction() + ").");
        }
        this.updateEntryStatus(batchResults.getObjCollection(), entryStatus);
    }

    private void updateEntryStatus(IObjectCollection billCol, EntryBaseStatusEnum entryBaseStatus) throws EASBizException, BOSException {
        if (billCol == null || billCol.size() == 0 || entryBaseStatus == null) {
            return;
        }
        SCMBillBaseInfo info = (SCMBillBaseInfo)billCol.getObject(0);
        if (info == null || info.getEntries() == null || info.getEntries().size() == 0) {
            return;
        }
        IObjectValue entry = info.getEntries().getObject(0);
        String tableName = this.getMainTableName(this.ctx, entry);
        StringBuilder sb = new StringBuilder();
        int size = billCol.size();
        for (int i = 0; i < size; ++i) {
            info = (SCMBillBaseInfo)billCol.getObject(i);
            sb.append("'").append(info.getId().toString()).append("',");
        }
        sb.setLength(sb.length() - 1);
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ").append(tableName).append(" SET FBaseStatus = ").append(entryBaseStatus.getValue()).append(" WHERE FParentID in ( ").append(sb.toString()).append(" )");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    private String getMainTableName(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            return null;
        }
        String bosType = model.getBOSType().toString();
        if (bosType2Table.containsKey(bosType)) {
            return bosType2Table.get(bosType);
        }
        IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IMetaDataPK pk = imeataLoader.getEntityObjectPK(model.getBOSType());
        EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(pk);
        DataTableInfo tableInfo = entityObjectInfo.getTable();
        String tableName = tableInfo.getName();
        bosType2Table.put(bosType, tableName);
        return tableName;
    }
}

