/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.app.bizprocess.processor;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.data.DataTableInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.IWriteBackHandler;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.WriteBackHandlerFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.InvBillBaseInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class WriteBackHandlerProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -6021714589725257981L;
    private static final Map<String, String> bosType2DetailTableMap = new HashMap<String, String>();

    public WriteBackHandlerProcessor(ProcessorConstructParam param) {
        super(param);
    }

    public WriteBackHandlerProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public WriteBackHandlerProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        BizActionEnum bizAction;
        IObjectCollection objCol = batchResults.getObjCollection();
        if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            bizAction = BizActionEnum.AUDIT;
        } else if (BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            bizAction = BizActionEnum.UNAUDIT;
        } else {
            return;
        }
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            IObjectValue objVal = objCol.getObject(i);
            if (objVal instanceof InvBillBaseInfo) {
                this.writeBack((InvBillBaseInfo)objVal, bizAction);
                continue;
            }
            if (!(objVal instanceof SCMBillBaseInfo)) continue;
            this.writeBack((SCMBillBaseInfo)objVal, bizAction);
        }
    }

    private void writeBack(InvBillBaseInfo model, BizActionEnum action) throws EASBizException, BOSException {
        String tableName = this.getDetailTableName(this.ctx, (IObjectValue)model);
        if (SCMServerUtils.isExistsBizFlowField((Context)this.ctx, (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)this.ctx, (String)tableName, (String)model.getId().toString())) {
            return;
        }
        String sql = this.getSqlByType((IObjectValue)model);
        if (sql.length() == 0) {
            return;
        }
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql, (Object[])new Object[]{model.getId().toString()});
        int rsSize = rs.size();
        String[] srcIdArr = new String[rsSize];
        String[][] idList = new String[rsSize][2];
        try {
            int i = 0;
            while (rs.next()) {
                idList[i][0] = rs.getString(1);
                idList[i][1] = rs.getString(2);
                srcIdArr[i] = idList[i][0];
                ++i;
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        IWriteBackHandler[] handlers = WriteBackHandlerFactory.getInstance((BOSObjectType)model.getBOSType(), (String[])srcIdArr);
        for (int j = 0; j < handlers.length && handlers[j] != null; ++j) {
            handlers[j].handle(this.ctx, action, new String[]{model.get("id").toString()}, idList);
        }
    }

    private void writeBack(SCMBillBaseInfo billInfo, BizActionEnum action) throws EASBizException, BOSException {
        String tableName = this.getDetailTableName(this.ctx, (IObjectValue)billInfo);
        if (SCMServerUtils.isExistsBizFlowField((Context)this.ctx, (String)tableName) && SCMServerUtils.isHasBizFlowValue((Context)this.ctx, (String)tableName, (String)billInfo.getId().toString())) {
            return;
        }
        IWriteBackHandler[] handlers = WriteBackHandlerFactory.getInstance((BOSObjectType)billInfo.getBOSType(), (AbstractObjectCollection)((AbstractObjectCollection)billInfo.getEntries()), (String)"sourceBillId");
        for (int i = 0; i < handlers.length && handlers[i] != null; ++i) {
            handlers[i].handle(this.ctx, action, new String[]{billInfo.getId().toString()}, (String[][])null);
        }
    }

    private String getSqlByType(IObjectValue model) throws EASBizException, BOSException {
        String entryTableName = this.getDetailTableName(this.ctx, model);
        if (null == this.bosType) {
            return "";
        }
        String bosTypeStr = this.bosType.toString();
        StringBuilder sql = new StringBuilder();
        if ("783061E3".equals(bosTypeStr)) {
            sql.append("select FSourceBillId, FPurOrderID from ").append(entryTableName).append(" where FParentID = ? group by FSourceBillId, FPurOrderID");
        } else if ("E3DAFF63".equals(bosTypeStr)) {
            sql.append("select FSourceBillId, FStockTransferBillId from ").append(entryTableName).append(" where FParentID = ? group by FSourceBillId, FStockTransferBillId");
        } else if ("CC3E933B".equals(bosTypeStr)) {
            sql.append("select FSourceBillId, FSaleOrderID from ").append(entryTableName).append(" where FParentID = ? group by FSourceBillId, FSaleOrderID");
        } else if ("71D272F1".equals(bosTypeStr)) {
            sql.append("select FSourceBillId, FStockTransferBillId from ").append(entryTableName).append(" where FParentID = ? group by FSourceBillId, FStockTransferBillId");
        } else if ("0EF94126".equals(bosTypeStr)) {
            sql.append("select FSourceBillId, FSourceBillEntryID,FID from ").append("T_IM_StockReqEntry ").append(" where FParentID = ?");
        } else if ("5C2A1F0C".equals(bosTypeStr)) {
            sql.append("select distinct FSourceBillId,FSourceBillEntryId,FSaleOrderId,FID ").append(" from T_IM_TransferOrderBillEntry ").append(" where FParentID = ? ");
        } else if ("0EF94126".equals(bosTypeStr)) {
            sql.append("select FSourceBillId, FSourceBillEntryID,FID from T_IM_StockReqEntry where FParentID = ?");
        }
        return sql.toString();
    }

    private String getDetailTableName(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            return null;
        }
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        IObjectCollection coll = (IObjectCollection)aSCMBillBaseInfo.get("entry");
        if (coll == null || coll.size() == 0) {
            return null;
        }
        IObjectValue entryValue = coll.getObject(0);
        String bosType = entryValue.getBOSType().toString();
        if (bosType2DetailTableMap.containsKey(bosType)) {
            return bosType2DetailTableMap.get(bosType);
        }
        IMetaDataLoader imeataLoader = MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        IMetaDataPK pk = imeataLoader.getEntityObjectPK(entryValue.getBOSType());
        EntityObjectInfo entityObjectInfo = imeataLoader.getEntity(pk);
        DataTableInfo tableInfo = entityObjectInfo.getTable();
        String tableName = tableInfo.getName();
        bosType2DetailTableMap.put(bosType, tableName);
        return tableName;
    }
}

