/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.common.app.bizprocess.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.ISCMBillBase;
import com.kingdee.eas.scm.common.ISCMBillParam;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.loadmass.PurEntryDataVO;
import com.kingdee.eas.scm.common.loadmass.SCMBizDataVO;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.loadmass.SaleOrderDataVO;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;

public class SCMBizProcessorUtil {
    private static final String ONE = "1";

    public static boolean isAddNew(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (model == null) {
            return false;
        }
        boolean ret = false;
        if (model != null && model.get("isAddNew") != null) {
            return model.getBoolean("isAddNew");
        }
        SCMBillBaseInfo aSCMBillBaseInfo = (SCMBillBaseInfo)model;
        ISCMBillBase iScmBillBase = (ISCMBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)aSCMBillBaseInfo.getBOSType());
        ret = aSCMBillBaseInfo.getId() == null || aSCMBillBaseInfo.getId().toString().trim().length() == 0 || !iScmBillBase.exists((IObjectPK)new ObjectUuidPK(aSCMBillBaseInfo.getId()));
        model.put("isAddNew", (Object)new Boolean(ret));
        return ret;
    }

    public static boolean isBotpBill(SCMBillBaseInfo scmBillBaseInfo) {
        boolean isBotpBill = false;
        if (scmBillBaseInfo != null && scmBillBaseInfo.getSourceBillType() != null) {
            isBotpBill = true;
        }
        return isBotpBill;
    }

    public static boolean isBotpBill(SCMBillBaseInfo scmBillBaseInfo, String sourceBillTypeID) {
        boolean isBotpBill = false;
        if (SCMBizProcessorUtil.isBotpBill(scmBillBaseInfo) && scmBillBaseInfo.getSourceBillType().getId().toString().equals(sourceBillTypeID)) {
            isBotpBill = true;
        }
        return isBotpBill;
    }

    public static Connection getConnection(Context ctx) throws SQLDataException {
        try {
            return EJBFactory.getConnection((Context)ctx);
        }
        catch (SQLException sqle) {
            throw new SQLDataException(sqle);
        }
    }

    public static boolean isControlBudget(Context ctx, SCMBillBaseInfo info, String orgUnitID, int orgType) throws BOSException, EASBizException {
        boolean isControlBudget = false;
        if (info != null && info.getBillType() != null) {
            String billTypeId = info.getBillType().getId().toString();
            ISCMBillParam scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
            String strControlBudget = scmParam.getParamByBillTypeID("IsControlBudget", orgType, orgUnitID, billTypeId);
            if (strControlBudget != null && strControlBudget.trim().length() != 0 && strControlBudget.trim().equalsIgnoreCase(ONE)) {
                isControlBudget = true;
            }
        }
        return isControlBudget;
    }

    public static String convertToString(Object[] objs) {
        if (objs == null || objs.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int count = objs.length;
        for (int i = 0; i < count; ++i) {
            if (objs[i] == null) continue;
            if (i > 0) {
                sb.append(",");
            }
            sb.append("'");
            sb.append(objs[i].toString());
            sb.append("'");
        }
        return sb.toString();
    }

    public static SCMBizDataVO initSCMBizDataVO(Context ctx, SCMBizDataVO scmBizDataVO, AbstractObjectCollection entries, OrgType orgType) {
        Object scmEntryDataVO = scmBizDataVO.getScmEntryDataVO();
        if (scmEntryDataVO == null) {
            scmEntryDataVO = orgType.getValue() == 2 ? new SaleOrderDataVO() : (orgType.getValue() == 3 ? new PurEntryDataVO() : new SCMEntryDataVO());
        }
        int n = entries.size();
        MaterialInfo[] materialInfos = new MaterialInfo[n];
        MeasureUnitInfo[] unitInfos = new MeasureUnitInfo[n];
        MeasureUnitInfo[] baseUnitInfos = new MeasureUnitInfo[n];
        MeasureUnitInfo[] assistUnitInfos = new MeasureUnitInfo[n];
        for (int i = 0; i < n; ++i) {
            SCMBillEntryBaseInfo entryInfo = (SCMBillEntryBaseInfo)entries.getObject(i);
            MaterialInfo materialInfo = entryInfo.getMaterial();
            MeasureUnitInfo unitInfo = entryInfo.getUnit();
            MeasureUnitInfo baseunitInfo = entryInfo.getBaseUnit();
            MeasureUnitInfo assistUnitInfo = entryInfo.getAssistUnit();
            if (materialInfo != null) {
                materialInfos[i] = materialInfo;
            }
            if (materialInfo != null && unitInfo != null) {
                unitInfos[i] = unitInfo;
            }
            if (materialInfo != null && baseunitInfo != null) {
                baseUnitInfos[i] = baseunitInfo;
            }
            if (materialInfo == null || assistUnitInfo == null) continue;
            assistUnitInfos[i] = assistUnitInfo;
        }
        scmEntryDataVO.setMaterialInfos(materialInfos);
        scmEntryDataVO.setMeasureUnitInfos(unitInfos);
        scmEntryDataVO.setBaseMeasureUnitInfos(baseUnitInfos);
        scmEntryDataVO.setAssistMeasureUnitInfos(assistUnitInfos);
        scmBizDataVO.setScmEntryDataVO(scmEntryDataVO);
        return scmBizDataVO;
    }

    public static void formatQtyPrecision(AbstractObjectCollection entries, Method mtdGetQty, Method mtdSetBaseQty, Method mtdSetAssitQty, Method mtdSetAssistUnit, Method mtdGetAssistQty, SCMEntryDataVO vo) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, EASBizException, BOSException {
        if (vo == null || entries == null || entries.size() == 0 || mtdGetQty == null || mtdSetBaseQty == null || mtdSetAssitQty == null) {
            return;
        }
        BigDecimal ZERO = new BigDecimal("0.00");
        for (int i = 0; i < entries.size(); ++i) {
            int precision;
            SCMBillEntryBaseInfo entryInfo = (SCMBillEntryBaseInfo)entries.getObject(i);
            MaterialInfo materialInfo = entryInfo.getMaterial();
            MeasureUnitInfo unitInfo = entryInfo.getUnit();
            MeasureUnitInfo baseunitInfo = entryInfo.getBaseUnit();
            MeasureUnitInfo assistUnitInfo = entryInfo.getAssistUnit();
            BigDecimal qty = (BigDecimal)mtdGetQty.invoke((Object)entryInfo, null);
            if (materialInfo == null) continue;
            if (assistUnitInfo != null && vo.getAssistMeasureUnitInfos() != null) {
                mtdSetAssistUnit.invoke((Object)entryInfo, vo.getAssistMeasureUnitInfos()[i]);
            }
            if (qty == null || qty.compareTo(ZERO) == 0) continue;
            BigDecimal baseUnitQty = null;
            if (qty != null && unitInfo != null && baseunitInfo != null) {
                if (vo.getMmuConvsRate() != null) {
                    String key = materialInfo.getId().toString() + unitInfo.getId().toString();
                    BigDecimal mmuConvsRate = (BigDecimal)vo.getMmuConvsRate().get(key);
                    String key2 = materialInfo.getId().toString() + baseunitInfo.getId().toString();
                    precision = 2;
                    if (vo.getMmuPrecisions() != null) {
                        precision = (Integer)vo.getMmuPrecisions().get(key2);
                    }
                    baseUnitQty = mmuConvsRate == null ? qty.setScale(precision, 4) : qty.multiply(mmuConvsRate).setScale(precision, 4);
                } else {
                    baseUnitQty = qty;
                }
                mtdSetBaseQty.invoke((Object)entryInfo, baseUnitQty);
            }
            BigDecimal assistUnitQty = (BigDecimal)mtdGetAssistQty.invoke((Object)entryInfo, null);
            if (baseUnitQty == null || assistUnitInfo == null || assistUnitQty != null) continue;
            if (vo.getMmuConvsRate() != null) {
                String key = materialInfo.getId().toString() + assistUnitInfo.getId().toString();
                BigDecimal assistConvsRate = (BigDecimal)vo.getMmuConvsRate().get(key);
                precision = 2;
                if (vo.getMmuPrecisions() != null && vo.getMmuPrecisions().get(key) != null) {
                    precision = (Integer)vo.getMmuPrecisions().get(key);
                }
                assistUnitQty = assistConvsRate == null || assistConvsRate.compareTo(ZERO) == 0 ? baseUnitQty.setScale(precision, 4) : baseUnitQty.divide(assistConvsRate, precision, 4);
            } else {
                assistUnitQty = baseUnitQty;
            }
            mtdSetAssitQty.invoke((Object)entryInfo, assistUnitQty);
        }
    }
}

