/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.customize.storeage.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.customize.storeage.app.AbstractKdbBizChanceFacadeControllerBean;
import com.kingdee.eas.scm.customize.storeage.app.constants.KdbBizChanceConstant;
import com.kingdee.eas.scm.customize.storeage.util.WSUtil;
import com.kingdee.eas.scm.im.inv.ws.ImportException;
import com.kingdee.eas.scm.im.inv.ws.util.InfoUtil;
import com.kingdee.eas.scm.im.inv.ws.util.XMLUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.IOException;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class KdbBizChanceFacadeControllerBean
extends AbstractKdbBizChanceFacadeControllerBean {
    private static final long serialVersionUID = -5004022741576853671L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.customize.storeage.app.KdbBizChanceFacadeControllerBean");

    @Override
    protected String[] _importData(Context ctx, String xmlData) throws BOSException {
        String[] msg = new String[2];
        try {
            Document doc = XMLUtil.builderDocument((String)xmlData);
            if (doc != null) {
                Element rootElement = doc.getDocumentElement();
                if (!rootElement.getTagName().equals("KDBizChance")) {
                    throw new ImportException(ImportException.BILLXMLFORMATEXCEPTION);
                }
                HashMap billHeadMap = WSUtil.getBillHeadPropMap((Document)doc, (String[])KdbBizChanceConstant.HEADPROPERTIES);
                this.validateProperty(billHeadMap);
                ctx.put((Object)"disablePermissionForKScript", (Object)Boolean.TRUE);
                msg[0] = "0";
                msg[1] = EASResource.getString((String)"com.kingdee.eas.scm.im.inv.ws.WebserviceResource", (String)"IMPORTSUCCESSMSG");
            }
        }
        catch (EASBizException e) {
            msg[0] = e.getCode();
            msg[1] = e.getMessage();
            logger.error((Object)e);
        }
        catch (SAXException e) {
            ImportException excep = new ImportException(ImportException.PRASERXMLEXCEPTION);
            msg[0] = excep.getCode();
            msg[1] = excep.getMessage();
            logger.error((Object)excep);
        }
        catch (IOException e) {
            ImportException excep = new ImportException(ImportException.READXMLIOEXCEPTION);
            msg[0] = excep.getCode();
            msg[1] = excep.getMessage();
        }
        catch (ParserConfigurationException e) {
            ImportException excep = new ImportException(ImportException.CONVERFORMATEXCEPTION);
            msg[0] = excep.getCode();
            msg[1] = excep.getMessage();
            logger.error((Object)excep);
        }
        return msg;
    }

    private void validateProperty(HashMap billHeadMap) throws ImportException {
        String[] bilHeadProps = KdbBizChanceConstant.mustValidateHeadProperties;
        for (int i = 0; i < bilHeadProps.length; ++i) {
            if (InfoUtil.validateProperty((HashMap)billHeadMap, (String)bilHeadProps[i])) continue;
            NumericExceptionSubItem numberExc = new NumericExceptionSubItem(bilHeadProps[i], bilHeadProps[i] + " must fill!");
            throw new ImportException(numberExc);
        }
    }

    private void buildBillHead(Context ctx, CoreBaseInfo info, HashMap billHeadMap) throws EASBizException {
        WSUtil.setStrProperties((CoreBaseInfo)info, (HashMap)billHeadMap, (String[])KdbBizChanceConstant.headStrProperties);
        WSUtil.setLinkProperties((Context)ctx, (CoreBaseInfo)info, (HashMap)billHeadMap, null, (String[])KdbBizChanceConstant.headLinkProperties, null);
        WSUtil.seTimeStampProperties((CoreBaseInfo)info, (HashMap)billHeadMap, (String[])KdbBizChanceConstant.headTimeStampProperties);
    }
}

